/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.MeshEditorWindow;
import artofillusion.MeshViewer;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.math.BoundingBox;
import artofillusion.math.Mat4;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.MeshEditController;
import artofillusion.ui.MeshEditingTool;
import artofillusion.ui.NinePointManipulator;
import artofillusion.ui.Translate;
import buoy.event.WidgetMouseEvent;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;

public class ScaleMeshTool
extends MeshEditingTool {
    private boolean dragInProgress;
    private boolean scaleX;
    private boolean scaleY;
    private boolean scaleAll;
    private double clickX;
    private double clickY;
    private double centerX;
    private double centerY;
    private Vec3 scaleCenter;
    private Vec3[] baseVertPos;
    private UndoRecord undo;
    private final NinePointManipulator manipulator;
    public static final int HANDLE_SIZE = 5;

    public ScaleMeshTool(EditingWindow fr, MeshEditController controller) {
        super(fr, controller);
        this.initButton("scalePoints");
        this.manipulator = new NinePointManipulator(new Image[]{NinePointManipulator.ARROWS_NW_SE, NinePointManipulator.ARROWS_N_S, NinePointManipulator.ARROWS_NE_SW, NinePointManipulator.ARROWS_E_W, null, NinePointManipulator.ARROWS_E_W, NinePointManipulator.ARROWS_NE_SW, NinePointManipulator.ARROWS_N_S, NinePointManipulator.ARROWS_NW_SE});
        this.manipulator.addEventLink(NinePointManipulator.HandlePressedEvent.class, (Object)this, "handlePressed");
        this.manipulator.addEventLink(NinePointManipulator.HandleDraggedEvent.class, (Object)this, "handleDragged");
        this.manipulator.addEventLink(NinePointManipulator.HandleReleasedEvent.class, (Object)this, "handleReleased");
    }

    public int whichClicks() {
        return 1;
    }

    public boolean allowSelectionChanges() {
        return !this.dragInProgress;
    }

    public String getToolTipText() {
        return Translate.text("scaleMeshTool.tipText");
    }

    public void drawOverlay(ViewerCanvas view) {
        BoundingBox selectionBounds = this.findSelectionBounds(view.getCamera());
        if (!this.dragInProgress) {
            if (selectionBounds != null) {
                this.manipulator.draw(view, selectionBounds);
                this.theWindow.setHelpText(Translate.text("scaleMeshTool.helpText"));
            } else {
                this.theWindow.setHelpText(Translate.text("scaleMeshTool.errorText"));
            }
        }
    }

    public void mousePressed(WidgetMouseEvent e, ViewerCanvas view) {
        BoundingBox selectionBounds = this.findSelectionBounds(view.getCamera());
        this.dragInProgress = false;
        if (selectionBounds != null) {
            this.dragInProgress = this.manipulator.mousePressed(e, view, selectionBounds);
        }
    }

    public void mouseDragged(WidgetMouseEvent e, ViewerCanvas view) {
        this.manipulator.mouseDragged(e, view);
    }

    public void mouseReleased(WidgetMouseEvent e, ViewerCanvas view) {
        this.manipulator.mouseReleased(e, view);
    }

    protected void handlePressed(NinePointManipulator.HandlePressedEvent ev) {
        Point clickPoint = ev.getMouseEvent().getPoint();
        this.clickX = clickPoint.x;
        this.clickY = clickPoint.y;
        BoundingBox bounds = ev.getSelectionBounds();
        Rectangle r = ev.getScreenBounds();
        NinePointManipulator.HandlePosition handle = ev.getHandle();
        this.scaleCenter = new Vec3(0.0, 0.0, (bounds.minz + bounds.maxz) / 2.0);
        if (handle.isWest()) {
            this.scaleX = true;
            this.centerX = r.x + r.width;
            this.scaleCenter.x = bounds.minx;
        } else if (handle.isEast()) {
            this.scaleX = true;
            this.centerX = r.x;
            this.scaleCenter.x = bounds.maxx;
        } else {
            this.scaleX = false;
            this.scaleCenter.x = bounds.minx + bounds.maxx;
        }
        if (handle.isNorth()) {
            this.scaleY = true;
            this.centerY = r.y + r.height;
            this.scaleCenter.y = bounds.miny;
        } else if (handle.isSouth()) {
            this.scaleY = true;
            this.centerY = r.y;
            this.scaleCenter.y = bounds.maxy;
        } else {
            this.scaleY = false;
            this.scaleCenter.y = bounds.miny + bounds.maxy;
        }
        if (ev.getMouseEvent().isControlDown()) {
            this.centerX = r.x + r.width / 2;
            this.centerY = r.y + r.height / 2;
            this.scaleCenter.x = (bounds.minx + bounds.maxx) / 2.0;
            this.scaleCenter.y = (bounds.miny + bounds.maxy) / 2.0;
        }
        this.scaleAll = ev.getMouseEvent().isShiftDown();
        Mesh mesh = (Mesh)((Object)this.controller.getObject().getObject());
        this.baseVertPos = mesh.getVertexPositions();
    }

    protected void handleDragged(NinePointManipulator.HandleDraggedEvent ev) {
        if (this.undo == null) {
            Mesh mesh = (Mesh)((Object)this.controller.getObject().getObject());
            this.undo = new UndoRecord(this.theWindow, false, 13, new Object[]{mesh, mesh.getVertexPositions()});
        }
        Vec3 scale = this.scaleMesh(ev);
        this.theWindow.updateImage();
        if (this.scaleAll) {
            this.theWindow.setHelpText(Translate.text("scaleMeshTool.dragText", Double.toString((double)Math.round(scale.x * 100000.0) / 100000.0)));
        } else if (this.scaleX && !this.scaleY) {
            this.theWindow.setHelpText(Translate.text("scaleMeshTool.dragText", Double.toString((double)Math.round(scale.x * 100000.0) / 100000.0)));
        } else if (this.scaleY && !this.scaleX) {
            this.theWindow.setHelpText(Translate.text("scaleMeshTool.dragText", Double.toString((double)Math.round(scale.y * 100000.0) / 100000.0)));
        } else {
            this.theWindow.setHelpText(Translate.text("scaleMeshTool.dragText", (double)Math.round(scale.x * 100000.0) / 100000.0 + ", " + (double)Math.round(scale.y * 100000.0) / 100000.0));
        }
    }

    protected void handleReleased(NinePointManipulator.HandleReleasedEvent ev) {
        if (this.undo != null) {
            this.theWindow.setUndoRecord(this.undo);
        }
        this.scaleMesh(ev);
        this.theWindow.updateImage();
        this.undo = null;
        this.baseVertPos = null;
        this.dragInProgress = false;
    }

    private Vec3 scaleMesh(NinePointManipulator.HandleEvent ev) {
        double zscale;
        double size;
        double xscale;
        double yscale;
        Point dragPoint = ev.getMouseEvent().getPoint();
        Mesh mesh = (Mesh)((Object)this.controller.getObject().getObject());
        if (this.scaleAll) {
            yscale = 0.0;
            xscale = 0.0;
        } else {
            yscale = 1.0;
            xscale = 1.0;
        }
        if (this.scaleX && (xscale = (size = (double)dragPoint.x - this.centerX) / (this.clickX - this.centerX)) <= 0.0) {
            xscale = Math.abs(1.0 / (this.clickX - this.centerX));
        }
        if (this.scaleY && (yscale = (size = (double)dragPoint.y - this.centerY) / (this.clickY - this.centerY)) <= 0.0) {
            yscale = Math.abs(1.0 / (this.clickY - this.centerY));
        }
        if (this.scaleAll) {
            yscale = zscale = Math.max(xscale, yscale);
            xscale = zscale;
        } else {
            zscale = 1.0;
        }
        Vec3[] v = this.findScaledPositions(this.baseVertPos, xscale, yscale, zscale, (MeshViewer)ev.getView());
        mesh.setVertexPositions(v);
        this.controller.objectChanged();
        return new Vec3(xscale, yscale, zscale);
    }

    private Vec3[] findScaledPositions(Vec3[] vert, double xscale, double yscale, double zscale, MeshViewer view) {
        int i;
        Vec3[] v = new Vec3[vert.length];
        int[] selected = this.controller.getSelectionDistance();
        Camera cam = view.getCamera();
        Mat4 m = cam.getObjectToView();
        m = Mat4.translation(-this.scaleCenter.x, -this.scaleCenter.y, -this.scaleCenter.z).times(m);
        m = Mat4.scale(xscale, yscale, zscale).times(m);
        m = Mat4.translation(this.scaleCenter.x, this.scaleCenter.y, this.scaleCenter.z).times(m);
        m = cam.getViewToWorld().times(m);
        m = view.getDisplayCoordinates().toLocal().times(m);
        for (i = 0; i < vert.length; ++i) {
            v[i] = selected[i] == 0 ? m.times(vert[i]).minus(vert[i]) : new Vec3();
        }
        if (this.theFrame instanceof MeshEditorWindow) {
            ((MeshEditorWindow)this.theFrame).adjustDeltas(v);
        }
        for (i = 0; i < vert.length; ++i) {
            v[i].add(vert[i]);
        }
        return v;
    }
}

