/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.LayoutWindow;
import artofillusion.ListChangeListener;
import artofillusion.MaterialMappingDialog;
import artofillusion.MaterialPreviewer;
import artofillusion.PluginRegistry;
import artofillusion.Scene;
import artofillusion.TextureMappingDialog;
import artofillusion.TextureParameter;
import artofillusion.UndoRecord;
import artofillusion.material.Material;
import artofillusion.material.MaterialMapping;
import artofillusion.material.UniformMaterial;
import artofillusion.object.FacetedMesh;
import artofillusion.object.Mesh;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.ObjectWrapper;
import artofillusion.texture.ConstantParameterValue;
import artofillusion.texture.FaceParameterValue;
import artofillusion.texture.FaceVertexParameterValue;
import artofillusion.texture.LayeredMapping;
import artofillusion.texture.LayeredTexture;
import artofillusion.texture.ParameterValue;
import artofillusion.texture.Texture;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.VertexParameterValue;
import artofillusion.ui.ActionProcessor;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import artofillusion.ui.ValueSelector;
import buoy.event.MouseClickedEvent;
import buoy.event.SelectionChangedEvent;
import buoy.event.ValueChangedEvent;
import buoy.event.WindowClosingEvent;
import buoy.widget.BButton;
import buoy.widget.BComboBox;
import buoy.widget.BDialog;
import buoy.widget.BLabel;
import buoy.widget.BList;
import buoy.widget.BOutline;
import buoy.widget.BScrollPane;
import buoy.widget.BTabbedPane;
import buoy.widget.BorderContainer;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import java.awt.Dimension;
import java.awt.Insets;
import java.lang.reflect.Method;
import java.util.List;

public class ObjectTextureDialog
extends BDialog
implements ListChangeListener {
    private LayoutWindow window;
    private Scene scene;
    private ObjectInfo[] obj;
    private ObjectInfo editObj;
    private BTabbedPane tabs;
    private BList texList;
    private BList matList;
    private BList layerList;
    private BButton texMapButton;
    private BButton matMapButton;
    private BButton addLayerButton;
    private BButton deleteLayerButton;
    private BButton moveUpButton;
    private BButton moveDownButton;
    private BButton editTexturesButton;
    private BComboBox newTextureChoice;
    private BComboBox newMaterialChoice;
    private BorderContainer content;
    private BorderContainer texturesTab;
    private BorderContainer materialsTab;
    private FormContainer texTitlePanel;
    private FormContainer texListPanel;
    private FormContainer matListPanel;
    private FormContainer layerPanel;
    private FormContainer paramsPanel;
    private MaterialPreviewer preview;
    private BComboBox typeChoice;
    private BComboBox blendChoice;
    private BComboBox[] paramTypeChoice;
    private ValueSelector[] paramValueWidget;
    private int[] fieldParamIndex;
    private BScrollPane paramsScroller;
    private Runnable callback;
    private Texture oldTexture;
    private TextureMapping oldTexMapping;
    Material oldMaterial;
    MaterialMapping oldMatMapping;
    private LayeredTexture layeredTex;
    private LayeredMapping layeredMap;
    private ActionProcessor renderProcessor;
    private static final int CONSTANT_PARAM = 0;
    private static final int VERTEX_PARAM = 1;
    private static final int FACE_PARAM = 2;
    private static final int FACE_VERTEX_PARAM = 3;
    private static final int PREVIEW_SIZE = 300;
    private static final String[] PARAM_TYPE_NAME = new String[]{Translate.text("Object"), Translate.text("Vertex"), Translate.text("Face"), Translate.text("Face-Vertex")};

    public ObjectTextureDialog(LayoutWindow parent, ObjectInfo[] objects) {
        this(parent, objects, true, true);
    }

    public ObjectTextureDialog(LayoutWindow parent, ObjectInfo[] objects, boolean includeTextures, boolean includeMaterials) {
        super(parent, Translate.text("objectTextureTitle"), false);
        this.window = parent;
        this.scene = parent.getScene();
        this.obj = objects;
        this.renderProcessor = new ActionProcessor();
        this.editObj = this.obj[0].duplicate();
        this.editObj.setObject(this.editObj.object.duplicate());
        this.oldTexture = this.editObj.getObject().getTexture();
        this.oldTexMapping = this.editObj.getObject().getTextureMapping();
        if (this.oldTexture instanceof LayeredTexture) {
            this.layeredMap = (LayeredMapping)this.oldTexMapping;
            this.layeredTex = (LayeredTexture)this.oldTexture;
        } else {
            this.layeredTex = new LayeredTexture(this.editObj.getObject());
            this.layeredMap = (LayeredMapping)this.layeredTex.getDefaultMapping(this.editObj.getObject());
        }
        this.oldMaterial = this.editObj.getObject().getMaterial();
        this.oldMatMapping = this.oldMaterial == null ? null : this.editObj.getObject().getMaterialMapping().duplicate();
        this.tabs = new BTabbedPane();
        this.texturesTab = new BorderContainer();
        if (includeTextures) {
            this.tabs.add(this.texturesTab, Translate.text("Texture"));
        }
        this.materialsTab = new BorderContainer();
        if (includeMaterials) {
            this.tabs.add(this.materialsTab, Translate.text("Material"));
        }
        this.content = new BorderContainer();
        this.setContent(BOutline.createEmptyBorder(this.content, UIUtilities.getStandardDialogInsets()));
        this.content.add(this.tabs, BorderContainer.CENTER);
        this.texTitlePanel = new FormContainer(1, 2);
        String title = this.obj.length == 1 ? Translate.text("chooseTextureForSingle", this.obj[0].getName()) : Translate.text("chooseTextureForMultiple");
        this.texTitlePanel.add(new BLabel(title), 0, 0);
        RowContainer typeRow = new RowContainer();
        typeRow.add(Translate.label("Type"));
        this.typeChoice = new BComboBox(new String[]{Translate.text("simpleTexture"), Translate.text("layeredTexture")});
        typeRow.add(this.typeChoice);
        this.typeChoice.setSelectedIndex(this.oldTexture instanceof LayeredTexture ? 1 : 0);
        this.typeChoice.addEventLink(ValueChangedEvent.class, (Object)this, "typeChanged");
        if (this.obj.length == 1) {
            this.texTitlePanel.add(typeRow, 0, 1);
        }
        this.texList = new BList();
        this.texList.setMultipleSelectionEnabled(false);
        this.texList.addEventLink(SelectionChangedEvent.class, (Object)this, "textureSelectionChanged");
        this.texList.addEventLink(MouseClickedEvent.class, (Object)this, "textureClicked");
        this.texListPanel = new FormContainer(new double[]{1.0}, new double[]{1.0, 0.0});
        this.texListPanel.add(UIUtilities.createScrollingList(this.texList), 0, 0, new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, null, null));
        RowContainer texButtonRow = new RowContainer();
        this.texMapButton = Translate.button("editMapping", this, "doEditTextureMapping");
        texButtonRow.add(this.texMapButton);
        this.newTextureChoice = new BComboBox();
        texButtonRow.add(this.newTextureChoice);
        this.newTextureChoice.add(Translate.text("button.newTexture"));
        List<Texture> textureTypes = PluginRegistry.getPlugins(Texture.class);
        for (Texture texture : textureTypes) {
            try {
                Method mtd = texture.getClass().getMethod("getTypeName", null);
                this.newTextureChoice.add(mtd.invoke(null, null));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.newTextureChoice.addEventLink(ValueChangedEvent.class, (Object)this, "doNewTexture");
        this.texListPanel.add(texButtonRow, 0, 1);
        this.matList = new BList();
        this.matList.setMultipleSelectionEnabled(false);
        this.matList.addEventLink(SelectionChangedEvent.class, (Object)this, "materialSelectionChanged");
        this.matList.addEventLink(MouseClickedEvent.class, (Object)this, "materialClicked");
        this.matListPanel = new FormContainer(new double[]{1.0}, new double[]{0.0, 1.0, 0.0});
        title = this.obj.length == 1 ? Translate.text("chooseMaterialForSingle", this.obj[0].getName()) : Translate.text("chooseMaterialForMultiple");
        this.matListPanel.add(new BLabel(title), 0, 0);
        this.matListPanel.add(UIUtilities.createScrollingList(this.matList), 0, 1, new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, null, null));
        RowContainer matButtonRow = new RowContainer();
        this.matMapButton = Translate.button("editMapping", this, "doEditMaterialMapping");
        matButtonRow.add(this.matMapButton);
        this.newMaterialChoice = new BComboBox();
        matButtonRow.add(this.newMaterialChoice);
        this.newMaterialChoice.add(Translate.text("button.newMaterial"));
        List<Material> materialTypes = PluginRegistry.getPlugins(Material.class);
        for (Material material : materialTypes) {
            try {
                Method mtd = material.getClass().getMethod("getTypeName", null);
                this.newMaterialChoice.add(mtd.invoke(null, null));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.newMaterialChoice.addEventLink(ValueChangedEvent.class, (Object)this, "doNewMaterial");
        this.matListPanel.add(matButtonRow, 0, 2);
        this.materialsTab.add(this.matListPanel, BorderContainer.CENTER);
        this.layerPanel = new FormContainer(new double[]{1.0, 1.0}, new double[]{0.0, 0.0, 0.0, 0.0, 1.0});
        this.layerPanel.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.HORIZONTAL, new Insets(2, 2, 2, 2), null));
        this.addLayerButton = Translate.button("add", " >>", this, "doAddLayer");
        this.layerPanel.add(this.addLayerButton, 0, 0);
        this.deleteLayerButton = Translate.button("delete", this, "doDeleteLayer");
        this.layerPanel.add(this.deleteLayerButton, 0, 1);
        this.moveUpButton = Translate.button("moveUp", this, "doMoveLayerUp");
        this.layerPanel.add(this.moveUpButton, 0, 2);
        this.moveDownButton = Translate.button("moveDown", this, "doMoveLayerDown");
        this.layerPanel.add(this.moveDownButton, 0, 3);
        this.layerList = new BList(){

            public Dimension getPreferredSize() {
                return new Dimension(((ObjectTextureDialog)ObjectTextureDialog.this).texList.getPreferredSize().width, super.getPreferredSize().height);
            }
        };
        this.layerList.setMultipleSelectionEnabled(false);
        this.layerList.addEventLink(SelectionChangedEvent.class, (Object)this, "textureSelectionChanged");
        for (int i = 0; i < this.layeredMap.getLayers().length; ++i) {
            this.layerList.add(this.layeredMap.getLayers()[i].getName());
        }
        this.layerPanel.add(UIUtilities.createScrollingList(this.layerList), 1, 0, 1, 4, new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, null, null));
        RowContainer blendRow = new RowContainer();
        this.layerPanel.add(blendRow, 0, 4, 2, 1);
        blendRow.add(Translate.label("blendingMode"));
        this.blendChoice = new BComboBox(new String[]{Translate.text("blend"), Translate.text("overlay"), Translate.text("overlayBumpsAdd")});
        this.blendChoice.addEventLink(ValueChangedEvent.class, (Object)this, "blendTypeChanged");
        blendRow.add(this.blendChoice);
        if (this.oldTexture instanceof LayeredTexture) {
            this.preview = new MaterialPreviewer(this.layeredTex, this.editObj.getObject().getMaterial(), 300, 300);
            this.preview.setTexture(this.layeredTex, this.layeredMap);
        } else {
            this.preview = new MaterialPreviewer(this.oldTexture, this.editObj.getObject().getMaterial(), 300, 300);
            this.preview.setTexture(this.oldTexture, this.oldTexMapping);
        }
        this.preview.setMaximumSize(new Dimension(300, 300));
        this.preview.setMaterial(this.editObj.getObject().getMaterial(), this.editObj.getObject().getMaterialMapping());
        this.updatePreviewParameterValues();
        this.content.add(this.preview, BorderContainer.EAST);
        RowContainer buttons = new RowContainer();
        this.content.add(buttons, BorderContainer.SOUTH, new LayoutInfo());
        this.editTexturesButton = Translate.button("texturesAndMaterials", this, "doEditTextures");
        buttons.add(this.editTexturesButton);
        buttons.add(Translate.button("ok", this, "doOk"));
        buttons.add(Translate.button("cancel", this, "doCancel"));
        this.paramsPanel = new FormContainer(1, 2);
        this.paramsPanel.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, null, null));
        this.paramsPanel.add(Translate.label("textureParameters"), 0, 0);
        this.paramsScroller = new BScrollPane();
        this.paramsPanel.add(BOutline.createBevelBorder(this.paramsScroller, false), 0, 1);
        this.paramsScroller.setPreferredViewSize(new Dimension(300, 80));
        this.paramsScroller.getVerticalScrollBar().setUnitIncrement(10);
        this.buildParamList();
        this.buildLists();
        if (this.oldTexture instanceof LayeredTexture) {
            this.layoutLayered();
        } else {
            this.layoutSimple();
        }
        this.pack();
        this.setResizable(false);
        this.addEventLink(WindowClosingEvent.class, (Object)this, "dispose");
        UIUtilities.centerDialog(this, parent);
        this.updateComponents();
        this.scene.addTextureListener(this);
        this.scene.addMaterialListener(this);
        this.setVisible(true);
    }

    private void updatePreviewParameterValues() {
        double[] paramAvgVal = this.editObj.getObject().getAverageParameterValues();
        ParameterValue[] paramValue = new ParameterValue[paramAvgVal.length];
        for (int i = 0; i < paramValue.length; ++i) {
            paramValue[i] = new ConstantParameterValue(paramAvgVal[i]);
        }
        this.preview.getObject().getObject().setParameterValues(paramValue);
    }

    public void dispose() {
        this.scene.removeTextureListener(this);
        this.scene.removeMaterialListener(this);
        this.renderProcessor.stopProcessing();
        super.dispose();
    }

    public void setCallback(Runnable cb) {
        this.callback = cb;
    }

    private void layoutSimple() {
        this.texturesTab.remove(BorderContainer.CENTER);
        FormContainer center = new FormContainer(2, 3);
        center.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, null, null));
        center.add(this.texTitlePanel, 0, 0, 2, 1);
        center.add(this.texListPanel, 0, 1);
        center.add(this.paramsPanel, 0, 2, 2, 1);
        this.texturesTab.add(center, BorderContainer.CENTER);
    }

    private void layoutLayered() {
        this.texturesTab.remove(BorderContainer.CENTER);
        FormContainer center = new FormContainer(new double[]{1.0, 1.0, 0.0}, new double[]{0.0, 1.0, 1.0});
        center.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, null, null));
        center.add(this.texTitlePanel, 0, 0, 3, 1);
        center.add(this.texListPanel, 0, 1);
        center.add(this.layerPanel, 1, 1, 2, 1);
        center.add(this.paramsPanel, 0, 2, 2, 1);
        this.texturesTab.add(center, BorderContainer.CENTER);
    }

    private void buildLists() {
        this.texList.removeAll();
        for (int i = 0; i < this.scene.getNumTextures(); ++i) {
            this.texList.add(this.scene.getTexture(i).getName());
            if (this.editObj.getObject().getTexture() != this.scene.getTexture(i)) continue;
            this.texList.setSelected(i, true);
        }
        this.matList.removeAll();
        this.matList.add(Translate.text("none"));
        boolean foundMaterial = false;
        for (int i = 0; i < this.scene.getNumMaterials(); ++i) {
            this.matList.add(this.scene.getMaterial(i).getName());
            if (this.editObj.getObject().getMaterial() != this.scene.getMaterial(i)) continue;
            this.matList.setSelected(i + 1, true);
            foundMaterial = true;
        }
        if (!foundMaterial) {
            this.matList.setSelected(0, true);
        }
    }

    private void buildParamList() {
        int index;
        Object3D obj = this.editObj.getObject();
        while (obj instanceof ObjectWrapper) {
            obj = ((ObjectWrapper)obj).getWrappedObject();
        }
        TextureParameter[] params = obj.getTexture() instanceof LayeredTexture ? ((index = this.layerList.getSelectedIndex()) == -1 ? new TextureParameter[]{} : ((LayeredMapping)obj.getTextureMapping()).getLayerParameters(index)) : obj.getParameters();
        this.paramTypeChoice = new BComboBox[params.length];
        this.paramValueWidget = new ValueSelector[params.length];
        this.fieldParamIndex = new int[params.length];
        FormContainer paramsContainer = new FormContainer(3, params.length);
        paramsContainer.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.NONE, new Insets(0, 0, 0, 5), null));
        LayoutInfo labelLayout = new LayoutInfo(LayoutInfo.EAST, LayoutInfo.NONE);
        final TextureParameter[] texParam = obj.getParameters();
        final ParameterValue[] paramValue = obj.getParameterValues();
        for (int i = 0; i < params.length; ++i) {
            int j;
            if (params[i].type != 0) continue;
            boolean perObject = true;
            double val = params[i].defaultVal;
            for (j = 0; j < texParam.length; ++j) {
                if (!params[i].equals(texParam[j])) continue;
                val = paramValue[j].getAverageValue();
                perObject = paramValue[j] instanceof ConstantParameterValue;
                break;
            }
            final int whichParam = j;
            final int whichField = i;
            this.fieldParamIndex[i] = j;
            paramsContainer.add(new BLabel(params[i].name), 0, i, labelLayout);
            this.paramTypeChoice[i] = new BComboBox();
            paramsContainer.add(this.paramTypeChoice[i], 1, i);
            this.paramTypeChoice[i].add(PARAM_TYPE_NAME[0]);
            if (obj instanceof Mesh) {
                this.paramTypeChoice[i].add(PARAM_TYPE_NAME[1]);
            }
            if (obj instanceof FacetedMesh) {
                this.paramTypeChoice[i].add(PARAM_TYPE_NAME[2]);
            }
            if (obj instanceof FacetedMesh) {
                this.paramTypeChoice[i].add(PARAM_TYPE_NAME[3]);
            }
            if (whichParam < paramValue.length) {
                this.paramTypeChoice[i].setSelectedValue(PARAM_TYPE_NAME[this.parameterTypeCode(paramValue[whichParam].getClass())]);
            }
            this.paramTypeChoice[i].addEventLink(ValueChangedEvent.class, (Object)this, "paramTypeChanged");
            this.paramValueWidget[i] = new ValueSelector(val, params[i].minVal, params[i].maxVal, 0.005);
            paramsContainer.add(this.paramValueWidget[i], 2, i);
            this.paramValueWidget[i].setEnabled(perObject);
            this.paramValueWidget[i].addEventLink(ValueChangedEvent.class, new Object(){

                void processEvent() {
                    if (whichParam >= paramValue.length) {
                        return;
                    }
                    double value = ObjectTextureDialog.this.paramValueWidget[whichField].getValue();
                    ConstantParameterValue val = new ConstantParameterValue(value);
                    ObjectTextureDialog.this.editObj.getObject().setParameterValue(texParam[whichParam], val);
                    ObjectTextureDialog.this.preview.getObject().getObject().setParameterValue(texParam[whichParam], val);
                    ObjectTextureDialog.this.renderPreview();
                }
            });
        }
        this.paramsScroller.setContent(paramsContainer);
        UIUtilities.applyBackground(paramsContainer, null);
        this.paramsScroller.layoutChildren();
    }

    private int parameterTypeCode(Class type) {
        if (type == VertexParameterValue.class) {
            return 1;
        }
        if (type == FaceParameterValue.class) {
            return 2;
        }
        if (type == FaceVertexParameterValue.class) {
            return 3;
        }
        return 0;
    }

    private void textureClicked(MouseClickedEvent ev) {
        if (ev.getClickCount() == 2) {
            int which = this.texList.getSelectedIndex();
            Texture tex = this.scene.getTexture(which);
            tex.edit(this.window, this.scene);
            this.scene.changeTexture(which);
            this.renderPreview();
        }
    }

    private void materialClicked(MouseClickedEvent ev) {
        int which;
        if (ev.getClickCount() == 2 && (which = this.matList.getSelectedIndex() - 1) > -1) {
            Material mat = this.scene.getMaterial(which);
            mat.edit(this.window, this.scene);
            this.scene.changeMaterial(which);
            this.preview.render();
        }
    }

    private void doEditTextureMapping() {
        int index = this.layerList.getSelectedIndex();
        new TextureMappingDialog(this.window, this.editObj.getObject(), index);
        this.preview.cancelRendering();
        this.editObj.setTexture(this.editObj.getObject().getTexture(), this.editObj.getObject().getTextureMapping());
        this.preview.setTexture(this.editObj.getObject().getTexture(), this.editObj.getObject().getTextureMapping());
        this.updatePreviewParameterValues();
        this.renderPreview();
    }

    private void doEditMaterialMapping() {
        new MaterialMappingDialog(this.window, this.editObj.getObject());
        this.preview.setMaterial(this.editObj.getObject().getMaterial(), this.editObj.getObject().getMaterialMapping());
        this.preview.render();
    }

    private void doNewTexture() {
        int index = this.newTextureChoice.getSelectedIndex();
        if (index == 0) {
            return;
        }
        this.newTextureChoice.setSelectedIndex(0);
        List<Texture> textureTypes = PluginRegistry.getPlugins(Texture.class);
        try {
            boolean layered;
            Texture tex = (Texture)textureTypes.get(index - 1).getClass().newInstance();
            int j = 0;
            String name = "";
            while (this.scene.getTexture(name = "Untitled " + ++j) != null) {
            }
            tex.setName(name);
            this.scene.addTexture(tex);
            tex.edit(this.window, this.scene);
            boolean bl = layered = this.typeChoice.getSelectedIndex() == 1;
            if (!layered) {
                this.texList.setSelected(this.scene.indexOf(tex), true);
                this.textureSelectionChanged(new SelectionChangedEvent(this.texList));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void doNewMaterial() {
        int index = this.newMaterialChoice.getSelectedIndex();
        if (index == 0) {
            return;
        }
        this.newMaterialChoice.setSelectedIndex(0);
        List<Material> materialTypes = PluginRegistry.getPlugins(Material.class);
        try {
            Material mat = (Material)materialTypes.get(index - 1).getClass().newInstance();
            int j = 0;
            String name = "";
            while (this.scene.getMaterial(name = "Untitled " + ++j) != null) {
            }
            mat.setName(name);
            this.scene.addMaterial(mat);
            mat.edit(this.window, this.scene);
            this.matList.setSelected(this.scene.indexOf(mat), true);
            this.materialSelectionChanged();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void doEditTextures() {
        this.scene.showTexturesDialog(this.window);
    }

    private void doAddLayer() {
        this.preview.cancelRendering();
        Texture tex = this.scene.getTexture(this.texList.getSelectedIndex());
        this.layeredMap.addLayer(0, tex, tex.getDefaultMapping(this.editObj.getObject()), 0);
        this.layerList.add(0, tex.getName());
        this.layerList.setSelected(0, true);
        this.resetParameters();
        this.updateComponents();
    }

    private void doDeleteLayer() {
        int index = this.layerList.getSelectedIndex();
        this.preview.cancelRendering();
        this.layeredMap.deleteLayer(index);
        this.layerList.remove(index);
        this.resetParameters();
        this.updateComponents();
    }

    private void doMoveLayerUp() {
        int index = this.layerList.getSelectedIndex();
        this.preview.cancelRendering();
        String label = (String)this.layerList.getItem(index);
        this.layeredMap.moveLayer(index, index - 1);
        this.layerList.remove(index);
        this.layerList.add(index - 1, label);
        this.layerList.setSelected(index - 1, true);
        this.resetParameters();
        this.updateComponents();
    }

    private void doMoveLayerDown() {
        int index = this.layerList.getSelectedIndex();
        this.preview.cancelRendering();
        String label = (String)this.layerList.getItem(index);
        this.layeredMap.moveLayer(index, index + 1);
        this.layerList.remove(index);
        this.layerList.add(index + 1, label);
        this.layerList.setSelected(index + 1, true);
        this.resetParameters();
        this.updateComponents();
    }

    private void doOk() {
        int i;
        TextureParameter[] param = this.editObj.getObject().getParameters();
        ParameterValue[] paramValue = this.editObj.getObject().getParameterValues();
        UndoRecord undo = new UndoRecord(this.window, false);
        for (i = 0; i < this.obj.length; ++i) {
            undo.addCommand(0, new Object[]{this.obj[i].getObject(), this.obj[i].getObject().duplicate()});
            if (this.editObj.getObject().getTexture() instanceof LayeredTexture) {
                LayeredMapping m = (LayeredMapping)this.editObj.getObject().getTextureMapping().duplicate(this.obj[i].getObject(), this.editObj.getObject().getTexture());
                this.obj[i].setTexture(new LayeredTexture(m), m);
            } else {
                this.obj[i].setTexture(this.editObj.getObject().getTexture(), this.editObj.getObject().getTextureMapping().duplicate());
            }
            for (int j = 0; j < param.length; ++j) {
                this.obj[i].getObject().setParameterValue(param[j], paramValue[j].duplicate());
            }
        }
        if (this.editObj.getObject().getMaterial() == null) {
            for (i = 1; i < this.obj.length; ++i) {
                this.obj[i].getObject().setMaterial(null, null);
            }
        } else {
            for (i = 1; i < this.obj.length; ++i) {
                if (!this.obj[i].getObject().canSetMaterial()) continue;
                this.obj[i].getObject().setMaterial(this.editObj.getObject().getMaterial(), this.editObj.getObject().getMaterialMapping().duplicate());
            }
        }
        this.obj[0].getObject().copyObject(this.editObj.getObject());
        this.window.setUndoRecord(undo);
        this.window.updateImage();
        this.window.getScore().tracksModified(false);
        if (this.callback != null) {
            this.callback.run();
        }
        this.dispose();
    }

    private void doCancel() {
        this.dispose();
        if (this.callback != null) {
            this.callback.run();
        }
    }

    private void paramTypeChanged(ValueChangedEvent ev) {
        Widget src = ev.getWidget();
        for (int i = 0; i < this.paramTypeChoice.length; ++i) {
            if (src != this.paramTypeChoice[i]) continue;
            String type = (String)this.paramTypeChoice[i].getSelectedValue();
            int index = this.fieldParamIndex[i];
            if (this.paramValueWidget[i] != null) {
                this.paramValueWidget[i].setEnabled(type == PARAM_TYPE_NAME[0]);
            }
            TextureParameter param = this.editObj.getObject().getParameters()[index];
            Object3D realObject = this.editObj.getObject();
            while (realObject instanceof ObjectWrapper) {
                realObject = ((ObjectWrapper)realObject).getWrappedObject();
            }
            if (type == PARAM_TYPE_NAME[0]) {
                this.editObj.getObject().setParameterValue(param, new ConstantParameterValue(this.editObj.getObject().getParameterValues()[index].getAverageValue()));
            } else if (type == PARAM_TYPE_NAME[1]) {
                this.editObj.getObject().setParameterValue(param, new VertexParameterValue((Mesh)((Object)realObject), param));
            } else if (type == PARAM_TYPE_NAME[2]) {
                this.editObj.getObject().setParameterValue(param, new FaceParameterValue((FacetedMesh)((Object)realObject), param));
            } else if (type == PARAM_TYPE_NAME[3]) {
                this.editObj.getObject().setParameterValue(param, new FaceVertexParameterValue((FacetedMesh)((Object)realObject), param));
            }
            this.renderPreview();
            return;
        }
    }

    private void typeChanged() {
        boolean layered;
        boolean bl = layered = this.typeChoice.getSelectedIndex() == 1;
        if (layered) {
            this.preview.cancelRendering();
            this.editObj.setTexture(this.layeredTex, this.layeredMap);
            this.preview.setTexture(this.layeredTex, this.layeredMap);
            this.updateComponents();
            this.layoutLayered();
            this.pack();
            UIUtilities.centerDialog(this, this.window);
            this.resetParameters();
            return;
        }
        this.texList.setSelected(0, true);
        Texture tex = this.scene.getDefaultTexture();
        this.editObj.setTexture(tex, tex.getDefaultMapping(this.editObj.getObject()));
        this.updateComponents();
        this.layoutSimple();
        this.pack();
        UIUtilities.centerDialog(this, this.window);
        this.resetParameters();
    }

    private void blendTypeChanged() {
        this.layeredMap.setLayerMode(this.layerList.getSelectedIndex(), this.blendChoice.getSelectedIndex());
        this.renderPreview();
    }

    private void textureSelectionChanged(SelectionChangedEvent ev) {
        boolean anyselection;
        boolean layered;
        boolean bl = layered = this.typeChoice.getSelectedIndex() == 1;
        if (layered) {
            anyselection = this.layerList.getSelectedIndex() > -1;
        } else {
            boolean bl2 = anyselection = this.texList.getSelectedIndex() > -1;
        }
        if (!anyselection) {
            this.updateComponents();
            return;
        }
        this.preview.cancelRendering();
        if (ev.getWidget() != this.layerList) {
            Texture tex = layered ? this.layeredMap.getLayer(this.layerList.getSelectedIndex()) : this.scene.getTexture(this.texList.getSelectedIndex());
            if (!layered) {
                if (tex == this.oldTexture) {
                    this.editObj.setTexture(tex, this.oldTexMapping.duplicate());
                } else {
                    this.editObj.setTexture(tex, tex.getDefaultMapping(this.editObj.getObject()));
                }
                this.preview.setTexture(tex, this.editObj.getObject().getTextureMapping());
            }
        }
        this.updateComponents();
        this.renderPreview();
    }

    private void materialSelectionChanged() {
        if (!this.editObj.getObject().canSetMaterial()) {
            return;
        }
        if (this.matList.getSelectedIndex() < 0) {
            this.matList.setSelected(0, true);
        }
        if (this.matList.getSelectedIndex() == 0) {
            this.matMapButton.setEnabled(false);
            this.editObj.getObject().setMaterial(null, null);
            this.preview.setMaterial(null, null);
            this.preview.render();
            return;
        }
        Material mat = this.scene.getMaterial(this.matList.getSelectedIndex() - 1);
        if (mat == this.oldMaterial) {
            this.editObj.getObject().setMaterial(mat, this.oldMatMapping.duplicate());
        } else {
            this.editObj.getObject().setMaterial(mat, mat.getDefaultMapping(this.editObj.getObject()));
        }
        this.matMapButton.setEnabled(!(mat instanceof UniformMaterial));
        this.preview.setMaterial(mat, this.editObj.getObject().getMaterialMapping());
        this.preview.render();
    }

    private void resetParameters() {
        this.preview.cancelRendering();
        this.editObj.setTexture(this.editObj.getObject().getTexture(), this.editObj.getObject().getTextureMapping());
        this.preview.getObject().setTexture(this.preview.getObject().getObject().getTexture(), this.preview.getObject().getObject().getTextureMapping());
        this.renderPreview();
    }

    private void updateComponents() {
        boolean layered = this.typeChoice.getSelectedIndex() == 1;
        boolean anyselection = this.texList.getSelectedIndex() > -1;
        this.buildParamList();
        if (layered) {
            this.addLayerButton.setEnabled(anyselection);
            int index = this.layerList.getSelectedIndex();
            if (index == -1) {
                this.texMapButton.setEnabled(false);
                this.deleteLayerButton.setEnabled(false);
                this.moveUpButton.setEnabled(false);
                this.moveDownButton.setEnabled(false);
                this.blendChoice.setEnabled(false);
                return;
            }
            this.texMapButton.setEnabled(true);
            this.deleteLayerButton.setEnabled(true);
            this.moveUpButton.setEnabled(index > 0);
            this.moveDownButton.setEnabled(index < this.layeredMap.getLayers().length - 1);
            this.blendChoice.setEnabled(true);
            this.blendChoice.setSelectedIndex(this.layeredMap.getLayerMode(index));
        } else if (anyselection) {
            this.texMapButton.setEnabled(true);
        } else {
            this.texMapButton.setEnabled(false);
        }
    }

    public void itemAdded(int index, Object obj) {
        if (obj instanceof Texture) {
            Texture tex = (Texture)obj;
            this.texList.add(index, tex.getName());
        } else {
            Material mat = (Material)obj;
            this.matList.add(index + 1, mat.getName());
        }
    }

    public void itemRemoved(int index, Object obj) {
        if (obj instanceof Texture) {
            Texture tex = (Texture)obj;
            this.texList.remove(index);
            this.preview.cancelRendering();
            if (this.editObj.getObject().getTextureMapping() instanceof LayeredMapping) {
                Texture[] layers = this.layeredMap.getLayers();
                for (int i = layers.length - 1; i >= 0; --i) {
                    if (layers[i] != tex) continue;
                    this.layeredMap.deleteLayer(i);
                    this.layerList.remove(i);
                }
                this.renderPreview();
                this.updateComponents();
            } else if (this.editObj.getObject().getTexture() == tex) {
                this.editObj.setTexture(this.scene.getDefaultTexture(), this.scene.getDefaultTexture().getDefaultMapping(this.editObj.getObject()));
                this.preview.setTexture(this.editObj.getObject().getTexture(), this.editObj.getObject().getTextureMapping());
                this.renderPreview();
                this.updateComponents();
            }
        } else {
            Material mat = (Material)obj;
            this.matList.remove(index + 1);
            if (this.editObj.getObject().getMaterial() == mat) {
                this.editObj.getObject().setMaterial(null, null);
                this.preview.setMaterial(this.editObj.getObject().getMaterial(), this.editObj.getObject().getMaterialMapping());
                this.preview.render();
                this.matMapButton.setEnabled(false);
            }
        }
    }

    public void itemChanged(int index, Object obj) {
        if (obj instanceof Texture) {
            Texture tex = (Texture)obj;
            this.texList.replace(index, tex.getName());
        } else {
            Material mat = (Material)obj;
            this.matList.replace(index + 1, mat.getName());
        }
    }

    private void renderPreview() {
        this.renderProcessor.addEvent(new Runnable(){

            public void run() {
                ObjectTextureDialog.this.preview.render();
            }
        });
    }
}

