/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ObjectViewer;
import artofillusion.TextureParameter;
import artofillusion.animation.Skeleton;
import artofillusion.math.Mat4;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import artofillusion.ui.MeshEditController;
import buoy.widget.RowContainer;
import java.util.Vector;

public abstract class MeshViewer
extends ObjectViewer {
    public static final int HANDLE_SIZE = 5;
    protected boolean showMesh;
    protected boolean showSurface;
    protected boolean showSkeleton;
    protected TextureParameter surfaceColoringParameter;
    private int selectedJoint;
    private boolean detachSkeleton;
    private Vector<Integer> lockedJoints = new Vector();

    public MeshViewer(MeshEditController controller, RowContainer p) {
        super(controller, p);
    }

    public int getSelectedJoint() {
        return this.selectedJoint;
    }

    public void setSelectedJoint(int id) {
        this.selectedJoint = id;
    }

    public boolean[] getLockedJoints() {
        Skeleton s = ((Mesh)((Object)this.getController().getObject().getObject())).getSkeleton();
        if (s == null) {
            return new boolean[0];
        }
        boolean[] b = new boolean[s.getNumJoints()];
        for (int i = 0; i < this.lockedJoints.size(); ++i) {
            int index = s.findJointIndex(this.lockedJoints.elementAt(i));
            if (index <= -1 || index >= b.length) continue;
            b[index] = true;
        }
        return b;
    }

    public boolean isJointLocked(int id) {
        for (int i = 0; i < this.lockedJoints.size(); ++i) {
            if (this.lockedJoints.elementAt(i) != id) continue;
            return true;
        }
        return false;
    }

    public void lockJoint(int id) {
        Integer i = id;
        if (this.lockedJoints.indexOf(i) == -1) {
            this.lockedJoints.addElement(i);
        }
    }

    public void unlockJoint(int id) {
        this.lockedJoints.removeElement(id);
    }

    public boolean getMeshVisible() {
        return this.showMesh;
    }

    public void setMeshVisible(boolean visible) {
        this.showMesh = visible;
    }

    public boolean getSurfaceVisible() {
        return this.showSurface;
    }

    public void setSurfaceVisible(boolean visible) {
        this.showSurface = visible;
    }

    public boolean getSkeletonVisible() {
        return this.showSkeleton;
    }

    public void setSkeletonVisible(boolean visible) {
        this.showSkeleton = visible;
    }

    public boolean getSkeletonDetached() {
        return this.detachSkeleton;
    }

    public void setSkeletonDetached(boolean detached) {
        this.detachSkeleton = detached;
    }

    public TextureParameter getSurfaceTextureParameter() {
        return this.surfaceColoringParameter;
    }

    public void setSurfaceTextureParameter(TextureParameter param) {
        this.surfaceColoringParameter = param;
    }

    public double[] estimateDepthRange() {
        double[] range = super.estimateDepthRange();
        Mat4 toView = this.theCamera.getWorldToView();
        Mat4 fromLocal = this.getDisplayCoordinates().fromLocal();
        for (MeshVertex vertex : ((Mesh)((Object)this.getController().getObject().getObject())).getVertices()) {
            double depth = toView.times((Vec3)fromLocal.times((Vec3)vertex.r)).z;
            range[0] = Math.min(range[0], depth);
            range[1] = Math.max(range[1], depth);
        }
        return range;
    }
}

