/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.TextureParameter;
import artofillusion.TriMeshViewer;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.math.Vec3;
import artofillusion.object.MeshVertex;
import artofillusion.object.Object3D;
import artofillusion.object.TriangleMesh;
import artofillusion.texture.FaceParameterValue;
import artofillusion.texture.FaceVertexParameterValue;
import artofillusion.texture.ParameterValue;
import artofillusion.texture.VertexParameterValue;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.MeshEditController;
import artofillusion.ui.MeshEditingTool;
import artofillusion.ui.Translate;
import buoy.event.WidgetMouseEvent;
import java.awt.Point;

public class CreateVertexTool
extends MeshEditingTool {
    private Point clickPoint;
    private Vec3 clickPos;
    private Vec3 constrainDir;
    private int target;
    private int vertexToMove;

    public CreateVertexTool(EditingWindow fr, MeshEditController controller) {
        super(fr, controller);
        this.initButton("createVertex");
    }

    public void activate() {
        super.activate();
        this.setHelpText();
    }

    private void setHelpText() {
        int mode = this.controller.getSelectionMode();
        if (mode == 0) {
            this.theWindow.setHelpText(Translate.text("createVertexTool.helpText.point"));
        } else if (mode == 1) {
            this.theWindow.setHelpText(Translate.text("createVertexTool.helpText.edge"));
        } else {
            this.theWindow.setHelpText(Translate.text("createVertexTool.helpText.face"));
        }
    }

    public int whichClicks() {
        return 1;
    }

    public String getToolTipText() {
        return Translate.text("createVertexTool.tipText");
    }

    public void mousePressed(WidgetMouseEvent e, ViewerCanvas view) {
        TriMeshViewer tmv = (TriMeshViewer)view;
        TriangleMesh mesh = (TriangleMesh)this.controller.getObject().getObject();
        MeshVertex[] vert = mesh.getVertices();
        int mode = this.controller.getSelectionMode();
        Vec3 uvw = new Vec3();
        this.clickPoint = e.getPoint();
        this.target = tmv.findClickTarget(this.clickPoint, uvw);
        if (this.target == -1) {
            return;
        }
        this.theWindow.setUndoRecord(new UndoRecord(this.theWindow, false, 0, new Object[]{mesh, mesh.duplicate()}));
        if (mode == 0) {
            this.constrainDir = mesh.getNormals()[this.target];
            if (this.createBoundaryVertex(mesh)) {
                this.vertexToMove = mesh.getVertices().length - 1;
                this.controller.setMesh(mesh);
                this.controller.objectChanged();
                this.theWindow.updateImage();
                this.theWindow.updateMenus();
            } else {
                this.vertexToMove = this.target;
            }
            this.clickPos = mesh.getVertices()[this.vertexToMove].r;
        } else {
            TriangleMesh newmesh = null;
            if (mode == 1) {
                TriangleMesh.Edge[] edge = mesh.getEdges();
                Vec3 v1 = vert[edge[this.target].v1].r;
                Vec3 v2 = vert[edge[this.target].v2].r;
                this.clickPos = v1.times(uvw.x).plus(v2.times(uvw.y));
                boolean[] split = new boolean[edge.length];
                split[this.target] = true;
                newmesh = TriangleMesh.subdivideLinear(mesh, split);
                this.constrainDir = v1.minus(v2);
                this.constrainDir.normalize();
            } else if (mode == 2) {
                TriangleMesh.Face[] face = mesh.getFaces();
                Vec3 v1 = vert[face[this.target].v1].r;
                Vec3 v2 = vert[face[this.target].v2].r;
                Vec3 v3 = vert[face[this.target].v3].r;
                this.clickPos = v1.times(uvw.x).plus(v2.times(uvw.y)).plus(v3.times(uvw.z));
                boolean[] split = new boolean[face.length];
                split[this.target] = true;
                newmesh = TriangleMesh.subdivideFaces(mesh, split);
                this.constrainDir = v1.minus(v2).cross(v3.minus(v2));
                this.constrainDir.normalize();
            }
            this.vertexToMove = newmesh.getVertices().length - 1;
            newmesh.getVertices()[this.vertexToMove].r.set(this.clickPos);
            mesh.copyObject(newmesh);
            this.controller.setMesh(mesh);
            this.controller.objectChanged();
            this.theWindow.updateImage();
            this.theWindow.updateMenus();
        }
    }

    public void mouseDragged(WidgetMouseEvent e, ViewerCanvas view) {
        if (this.target == -1) {
            return;
        }
        TriMeshViewer tmv = (TriMeshViewer)view;
        TriangleMesh mesh = (TriangleMesh)this.controller.getObject().getObject();
        Point dragPoint = e.getPoint();
        int dx = dragPoint.x - this.clickPoint.x;
        int dy = dragPoint.y - this.clickPoint.y;
        Vec3 drag = this.findDragVector(dx, dy, tmv, e.isShiftDown());
        Vec3[] v = this.findDraggedPositions(mesh, drag);
        mesh.setVertexPositions(v);
        this.controller.objectChanged();
        this.theWindow.updateImage();
    }

    public void mouseReleased(WidgetMouseEvent e, ViewerCanvas view) {
        if (this.target == -1) {
            return;
        }
        TriMeshViewer tmv = (TriMeshViewer)view;
        Object3D meshobj = this.controller.getObject().getObject();
        TriangleMesh mesh = (TriangleMesh)meshobj;
        Point dragPoint = e.getPoint();
        int dx = dragPoint.x - this.clickPoint.x;
        int dy = dragPoint.y - this.clickPoint.y;
        Vec3 drag = this.findDragVector(dx, dy, tmv, e.isShiftDown());
        Vec3[] v = this.findDraggedPositions(mesh, drag);
        mesh.setVertexPositions(v);
        this.controller.objectChanged();
        this.theWindow.updateImage();
        this.setHelpText();
    }

    private Vec3[] findDraggedPositions(TriangleMesh mesh, Vec3 drag) {
        MeshVertex[] vert = mesh.getVertices();
        Vec3[] pos = new Vec3[vert.length];
        for (int i = 0; i < pos.length; ++i) {
            pos[i] = vert[i].r;
        }
        pos[this.vertexToMove] = this.clickPos.plus(drag);
        return pos;
    }

    private Vec3 findDragVector(int dx, int dy, TriMeshViewer view, boolean constrain) {
        Vec3 drag = view.getCamera().findDragVector(this.clickPos, dx, dy);
        if (constrain) {
            if (this.controller.getSelectionMode() == 1) {
                drag = this.constrainDir.times(drag.dot(this.constrainDir));
            } else {
                drag.subtract(this.constrainDir.times(drag.dot(this.constrainDir)));
            }
        }
        return drag;
    }

    private boolean createBoundaryVertex(TriangleMesh mesh) {
        int i;
        TriangleMesh.Vertex[] vert = (TriangleMesh.Vertex[])mesh.getVertices();
        TriangleMesh.Vertex v = vert[this.target];
        TriangleMesh.Edge[] edge = mesh.getEdges();
        TriangleMesh.Face[] face = mesh.getFaces();
        int[] vertEdge = v.getEdges();
        if (edge[vertEdge[0]].f2 != -1) {
            return false;
        }
        this.theWindow.setUndoRecord(new UndoRecord(this.theWindow, false, 0, new Object[]{mesh, mesh.duplicate()}));
        TriangleMesh.Vertex[] newvert = new TriangleMesh.Vertex[vert.length + 1];
        int[][] newface = new int[face.length + 2][];
        for (i = 0; i < vert.length; ++i) {
            newvert[i] = vert[i];
        }
        int n = vert.length;
        TriangleMesh triangleMesh = mesh;
        triangleMesh.getClass();
        newvert[n] = new TriangleMesh.Vertex(triangleMesh, v);
        for (i = 0; i < face.length; ++i) {
            newface[i] = new int[]{face[i].v1, face[i].v2, face[i].v3};
        }
        TriangleMesh.Edge e = edge[vertEdge[0]];
        TriangleMesh.Face f = face[e.f1];
        int oldFace1 = e.f1;
        newface[face.length] = f.v1 == e.v1 && f.v2 == e.v2 || f.v2 == e.v1 && f.v3 == e.v2 || f.v3 == e.v1 && f.v1 == e.v2 ? new int[]{e.v2, e.v1, vert.length} : new int[]{e.v1, e.v2, vert.length};
        e = edge[vertEdge[vertEdge.length - 1]];
        f = face[e.f1];
        int oldFace2 = e.f1;
        newface[face.length + 1] = f.v1 == e.v1 && f.v2 == e.v2 || f.v2 == e.v1 && f.v3 == e.v2 || f.v3 == e.v1 && f.v1 == e.v2 ? new int[]{e.v2, e.v1, vert.length} : new int[]{e.v1, e.v2, vert.length};
        mesh.setShape(newvert, newface);
        TriangleMesh.Edge[] newedge = mesh.getEdges();
        for (int i2 = 0; i2 < newedge.length; ++i2) {
            for (int j = 0; j < edge.length; ++j) {
                if ((newedge[i2].v1 != edge[j].v1 || newedge[i2].v2 != edge[j].v2) && (newedge[i2].v1 != edge[j].v2 || newedge[i2].v2 != edge[j].v1)) continue;
                newedge[i2].smoothness = edge[j].smoothness;
            }
        }
        TextureParameter[] param = mesh.getParameters();
        ParameterValue[] paramValue = mesh.getParameterValues();
        for (int i3 = 0; i3 < paramValue.length; ++i3) {
            Object newval;
            double[] val;
            if (paramValue[i3] instanceof VertexParameterValue) {
                val = ((VertexParameterValue)paramValue[i3]).getValue();
                newval = new double[newvert.length];
                System.arraycopy(val, 0, newval, 0, val.length);
                newval[val.length] = val[this.target];
                ((VertexParameterValue)paramValue[i3]).setValue((double[])newval);
            }
            if (paramValue[i3] instanceof FaceParameterValue) {
                val = ((FaceParameterValue)paramValue[i3]).getValue();
                newval = new double[newface.length];
                System.arraycopy(val, 0, newval, 0, val.length);
                newval[val.length] = val[oldFace1];
                newval[val.length + 1] = val[oldFace2];
                ((FaceParameterValue)paramValue[i3]).setValue((double[])newval);
            }
            if (!(paramValue[i3] instanceof FaceVertexParameterValue)) continue;
            FaceVertexParameterValue fvpv = (FaceVertexParameterValue)paramValue[i3];
            newval = new double[newface.length][3];
            for (int index = 0; index < ((double[])newval).length; ++index) {
                newval[index][0] = fvpv.getValue(index, 0);
                newval[index][1] = fvpv.getValue(index, 1);
                newval[index][2] = fvpv.getValue(index, 2);
            }
            double d = param[i3].defaultVal;
            newval[face.length][2] = d;
            newval[face.length][1] = d;
            newval[face.length][0] = d;
            double d2 = param[i3].defaultVal;
            newval[face.length + 1][2] = d2;
            newval[face.length + 1][1] = d2;
            newval[face.length + 1][0] = d2;
            fvpv.setValue((double[][])newval);
        }
        return true;
    }
}

