/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ApplicationPreferences;
import artofillusion.LayoutWindow;
import artofillusion.ModellingApp;
import artofillusion.ModellingTool;
import artofillusion.Plugin;
import artofillusion.PluginRegistry;
import artofillusion.RecentFiles;
import artofillusion.Renderer;
import artofillusion.Scene;
import artofillusion.TitleWindow;
import artofillusion.Translator;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.animation.PositionTrack;
import artofillusion.animation.RotationTrack;
import artofillusion.image.ImageMap;
import artofillusion.image.filter.BlurFilter;
import artofillusion.image.filter.BrightnessFilter;
import artofillusion.image.filter.DepthOfFieldFilter;
import artofillusion.image.filter.ExposureFilter;
import artofillusion.image.filter.GlowFilter;
import artofillusion.image.filter.ImageFilter;
import artofillusion.image.filter.NoiseReductionFilter;
import artofillusion.image.filter.OutlineFilter;
import artofillusion.image.filter.SaturationFilter;
import artofillusion.image.filter.TintFilter;
import artofillusion.keystroke.KeystrokeManager;
import artofillusion.material.LinearMaterialMapping;
import artofillusion.material.Material;
import artofillusion.material.MaterialMapping;
import artofillusion.material.ProceduralMaterial3D;
import artofillusion.material.UniformMaterial;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.DirectionalLight;
import artofillusion.object.ObjectInfo;
import artofillusion.object.SceneCamera;
import artofillusion.procedural.Module;
import artofillusion.script.ScriptRunner;
import artofillusion.texture.CylindricalMapping;
import artofillusion.texture.ImageMapTexture;
import artofillusion.texture.LayeredMapping;
import artofillusion.texture.LayeredTexture;
import artofillusion.texture.LinearMapping3D;
import artofillusion.texture.ParameterValue;
import artofillusion.texture.ProceduralTexture2D;
import artofillusion.texture.ProceduralTexture3D;
import artofillusion.texture.ProjectionMapping;
import artofillusion.texture.SphericalMapping;
import artofillusion.texture.Texture;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.UVMapping;
import artofillusion.texture.UniformMapping;
import artofillusion.texture.UniformTexture;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.ThemeManager;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import artofillusion.view.ViewerOrientationControl;
import artofillusion.view.ViewerPerspectiveControl;
import artofillusion.view.ViewerScaleControl;
import buoy.widget.BFileChooser;
import buoy.widget.BFrame;
import buoy.widget.BScrollPane;
import buoy.widget.BStandardDialog;
import buoy.widget.BTextArea;
import buoy.xml.IconResource;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;

public class ArtOfIllusion {
    public static final String APP_DIRECTORY;
    public static final String PLUGIN_DIRECTORY;
    public static final String TOOL_SCRIPT_DIRECTORY;
    public static final String OBJECT_SCRIPT_DIRECTORY;
    public static final String STARTUP_SCRIPT_DIRECTORY;
    public static final ImageIcon APP_ICON;
    public static Font defaultFont;
    public static int standardDialogInsets;
    private static ApplicationPreferences preferences;
    private static ObjectInfo[] clipboardObject;
    private static Texture[] clipboardTexture;
    private static Material[] clipboardMaterial;
    private static ImageMap[] clipboardImage;
    private static ArrayList<EditingWindow> windows;
    private static HashMap<String, String> classTranslations;
    private static int numNewWindows;

    public static void main(String[] args) {
        int i;
        Translate.setLocale(Locale.getDefault());
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            // empty catch block
        }
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        try {
            Class<PopupFactory> popup = PopupFactory.class;
            Field heavyweight = popup.getDeclaredField("HEAVY_WEIGHT_POPUP");
            Method setPopupType = popup.getDeclaredMethod("setPopupType", Integer.TYPE);
            heavyweight.setAccessible(true);
            setPopupType.setAccessible(true);
            setPopupType.invoke((Object)PopupFactory.getSharedInstance(), heavyweight.get(null));
        }
        catch (Exception ex) {
            // empty catch block
        }
        TitleWindow title = new TitleWindow();
        PluginRegistry.addCategory(Plugin.class);
        PluginRegistry.addCategory(Renderer.class);
        PluginRegistry.addCategory(Translator.class);
        PluginRegistry.addCategory(ModellingTool.class);
        PluginRegistry.addCategory(Texture.class);
        PluginRegistry.addCategory(Material.class);
        PluginRegistry.addCategory(TextureMapping.class);
        PluginRegistry.addCategory(MaterialMapping.class);
        PluginRegistry.addCategory(ImageFilter.class);
        PluginRegistry.addCategory(Module.class);
        PluginRegistry.registerPlugin(new UniformTexture());
        PluginRegistry.registerPlugin(new ImageMapTexture());
        PluginRegistry.registerPlugin(new ProceduralTexture2D());
        PluginRegistry.registerPlugin(new ProceduralTexture3D());
        PluginRegistry.registerPlugin(new UniformMaterial());
        PluginRegistry.registerPlugin(new ProceduralMaterial3D());
        PluginRegistry.registerPlugin(new UniformMapping(null, null));
        PluginRegistry.registerPlugin(new ProjectionMapping(null, null));
        PluginRegistry.registerPlugin(new CylindricalMapping(null, null));
        PluginRegistry.registerPlugin(new SphericalMapping(null, null));
        PluginRegistry.registerPlugin(new UVMapping(null, null));
        PluginRegistry.registerPlugin(new LinearMapping3D(null, null));
        PluginRegistry.registerPlugin(new LinearMaterialMapping(null, null));
        PluginRegistry.registerPlugin(new BrightnessFilter());
        PluginRegistry.registerPlugin(new SaturationFilter());
        PluginRegistry.registerPlugin(new ExposureFilter());
        PluginRegistry.registerPlugin(new TintFilter());
        PluginRegistry.registerPlugin(new BlurFilter());
        PluginRegistry.registerPlugin(new GlowFilter());
        PluginRegistry.registerPlugin(new OutlineFilter());
        PluginRegistry.registerPlugin(new NoiseReductionFilter());
        PluginRegistry.registerPlugin(new DepthOfFieldFilter());
        PluginRegistry.registerResource("TranslateBundle", "artofillusion", ArtOfIllusion.class.getClassLoader(), "artofillusion", null);
        PluginRegistry.registerResource("UITheme", "default", ArtOfIllusion.class.getClassLoader(), "artofillusion/Icons/defaultTheme.xml", null);
        PluginRegistry.scanPlugins();
        ThemeManager.initThemes();
        preferences = new ApplicationPreferences();
        KeystrokeManager.loadRecords();
        ViewerCanvas.addViewerControl(new ViewerOrientationControl());
        ViewerCanvas.addViewerControl(new ViewerPerspectiveControl());
        ViewerCanvas.addViewerControl(new ViewerScaleControl());
        List<Plugin> plugins = PluginRegistry.getPlugins(Plugin.class);
        for (i = 0; i < plugins.size(); ++i) {
            try {
                plugins.get(i).processMessage(0, new Object[0]);
                continue;
            }
            catch (Throwable tx) {
                tx.printStackTrace();
                String name = plugins.get(i).getClass().getName();
                name = name.substring(name.lastIndexOf(46) + 1);
                new BStandardDialog("", UIUtilities.breakString(Translate.text("pluginInitError", name)), BStandardDialog.ERROR).showMessageDialog(null);
            }
        }
        for (i = 0; i < args.length; ++i) {
            try {
                ArtOfIllusion.newWindow(new Scene(new File(args[i]), true));
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        ArtOfIllusion.runStartupScripts();
        if (numNewWindows == 0) {
            ArtOfIllusion.newWindow();
        }
        title.dispose();
    }

    public static String getVersion() {
        return ArtOfIllusion.getMajorVersion() + ".2";
    }

    public static String getMajorVersion() {
        return "2.9";
    }

    public static ApplicationPreferences getPreferences() {
        return preferences;
    }

    public static void newWindow() {
        Scene theScene = new Scene();
        CoordinateSystem coords = new CoordinateSystem(new Vec3(0.0, 0.0, 20.0), new Vec3(0.0, 0.0, -1.0), Vec3.vy());
        ObjectInfo info = new ObjectInfo(new SceneCamera(), coords, "Camera 1");
        info.addTrack(new PositionTrack(info), 0);
        info.addTrack(new RotationTrack(info), 1);
        theScene.addObject(info, null);
        info = new ObjectInfo(new DirectionalLight(new RGBColor(1.0f, 1.0f, 1.0f), 0.8f), coords.duplicate(), "Light 1");
        info.addTrack(new PositionTrack(info), 0);
        info.addTrack(new RotationTrack(info), 1);
        theScene.addObject(info, null);
        ArtOfIllusion.newWindow(theScene);
    }

    public static void newWindow(final Scene theScene) {
        ++numNewWindows;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int i;
                LayoutWindow fr = new LayoutWindow(theScene);
                windows.add(fr);
                List<Plugin> plugins = PluginRegistry.getPlugins(Plugin.class);
                for (i = 0; i < plugins.size(); ++i) {
                    try {
                        plugins.get(i).processMessage(2, new Object[]{fr});
                        continue;
                    }
                    catch (Throwable tx) {
                        tx.printStackTrace();
                        String name = plugins.get(i).getClass().getName();
                        name = name.substring(name.lastIndexOf(46) + 1);
                        new BStandardDialog("", UIUtilities.breakString(Translate.text("pluginNotifyError", name)), BStandardDialog.ERROR).showMessageDialog(null);
                    }
                }
                fr.setVisible(true);
                fr.arrangeDockableWidgets();
                for (i = windows.size() - 2; i >= 0; --i) {
                    LayoutWindow win;
                    if (!(windows.get(i) instanceof LayoutWindow) || (win = (LayoutWindow)windows.get(i)).getScene().getName() != null || win.isModified()) continue;
                    ArtOfIllusion.closeWindow(win);
                }
            }
        });
    }

    public static void addWindow(EditingWindow win) {
        windows.add(win);
    }

    public static void closeWindow(EditingWindow win) {
        if (win.confirmClose()) {
            windows.remove(win);
            if (win instanceof LayoutWindow) {
                List<Plugin> plugins = PluginRegistry.getPlugins(Plugin.class);
                for (int i = 0; i < plugins.size(); ++i) {
                    try {
                        plugins.get(i).processMessage(3, new Object[]{win});
                        continue;
                    }
                    catch (Throwable tx) {
                        tx.printStackTrace();
                        String name = plugins.get(i).getClass().getName();
                        name = name.substring(name.lastIndexOf(46) + 1);
                        new BStandardDialog("", UIUtilities.breakString(Translate.text("pluginNotifyError", name)), BStandardDialog.ERROR).showMessageDialog(null);
                    }
                }
            }
        }
        if (windows.size() == 0) {
            ArtOfIllusion.quit();
        }
    }

    public static EditingWindow[] getWindows() {
        return windows.toArray(new EditingWindow[windows.size()]);
    }

    public static void quit() {
        for (int i = windows.size() - 1; i >= 0; --i) {
            EditingWindow win = windows.get(i);
            ArtOfIllusion.closeWindow(win);
            if (!windows.contains(win)) continue;
            return;
        }
        List<Plugin> plugins = PluginRegistry.getPlugins(Plugin.class);
        for (int i = 0; i < plugins.size(); ++i) {
            try {
                plugins.get(i).processMessage(1, new Object[0]);
                continue;
            }
            catch (Throwable tx) {
                tx.printStackTrace();
                String name = plugins.get(i).getClass().getName();
                name = name.substring(name.lastIndexOf(46) + 1);
                new BStandardDialog("", UIUtilities.breakString(Translate.text("pluginNotifyError", name)), BStandardDialog.ERROR).showMessageDialog(null);
            }
        }
        System.exit(0);
    }

    private static void runStartupScripts() {
        String[] files = new File(STARTUP_SCRIPT_DIRECTORY).list();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].endsWith(".bsh")) continue;
                try {
                    String script = ArtOfIllusion.loadFile(new File(STARTUP_SCRIPT_DIRECTORY, files[i]));
                    ScriptRunner.executeScript(script);
                    continue;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public static Class getClass(String name) throws ClassNotFoundException {
        try {
            return ArtOfIllusion.lookupClass(name);
        }
        catch (ClassNotFoundException ex) {
            int i = name.indexOf(36);
            if (i == -1) {
                String newName = classTranslations.get(name);
                if (newName == null) {
                    throw ex;
                }
                return ArtOfIllusion.lookupClass(newName);
            }
            String newName = classTranslations.get(name.substring(0, i));
            if (newName == null) {
                throw ex;
            }
            return ArtOfIllusion.lookupClass(newName + name.substring(i));
        }
    }

    private static Class lookupClass(String name) throws ClassNotFoundException {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException ex) {
            List<ClassLoader> pluginLoaders = PluginRegistry.getPluginClassLoaders();
            for (int i = 0; i < pluginLoaders.size(); ++i) {
                try {
                    return pluginLoaders.get(i).loadClass(name);
                }
                catch (ClassNotFoundException ex2) {
                    if (i != pluginLoaders.size() - 1) continue;
                    throw ex2;
                }
            }
            return null;
        }
    }

    public static String loadFile(File f) throws IOException {
        int c;
        BufferedReader in = new BufferedReader(new FileReader(f));
        StringBuffer buf = new StringBuffer();
        while ((c = in.read()) != -1) {
            buf.append((char)c);
        }
        in.close();
        return buf.toString();
    }

    public static boolean saveScene(Scene sc, LayoutWindow fr) {
        try {
            File f = new File(sc.getDirectory(), sc.getName());
            sc.writeToFile(f);
            List<Plugin> plugins = PluginRegistry.getPlugins(Plugin.class);
            for (int i = 0; i < plugins.size(); ++i) {
                try {
                    plugins.get(i).processMessage(4, new Object[]{f, fr});
                    continue;
                }
                catch (Throwable tx) {
                    tx.printStackTrace();
                    String name = plugins.get(i).getClass().getName();
                    name = name.substring(name.lastIndexOf(46) + 1);
                    new BStandardDialog("", UIUtilities.breakString(Translate.text("pluginNotifyError", name)), BStandardDialog.ERROR).showMessageDialog(null);
                }
            }
            RecentFiles.addRecentFile(f);
        }
        catch (IOException ex) {
            new BStandardDialog("", new String[]{Translate.text("errorSavingScene"), ex.getMessage() == null ? "" : ex.getMessage()}, BStandardDialog.ERROR).showMessageDialog(fr);
            return false;
        }
        return true;
    }

    public static void openScene(BFrame fr) {
        BFileChooser fc = new BFileChooser(BFileChooser.OPEN_FILE, Translate.text("openScene"));
        if (ArtOfIllusion.getCurrentDirectory() != null) {
            fc.setDirectory(new File(ArtOfIllusion.getCurrentDirectory()));
        }
        if (!fc.showDialog(fr)) {
            return;
        }
        ArtOfIllusion.setCurrentDirectory(fc.getDirectory().getAbsolutePath());
        ArtOfIllusion.openScene(fc.getSelectedFile(), fr);
    }

    public static void openScene(File f, BFrame fr) {
        try {
            Scene sc = new Scene(f, true);
            if (sc.errorsOccurredInLoading()) {
                new BStandardDialog("", new Object[]{UIUtilities.breakString(Translate.text("errorLoadingScenePart")), new BScrollPane(new BTextArea(sc.getLoadingErrors()))}, BStandardDialog.ERROR).showMessageDialog(fr);
            }
            ArtOfIllusion.newWindow(sc);
            RecentFiles.addRecentFile(f);
        }
        catch (InvalidObjectException ex) {
            new BStandardDialog("", UIUtilities.breakString(Translate.text("errorLoadingWholeScene")), BStandardDialog.ERROR).showMessageDialog(fr);
        }
        catch (IOException ex) {
            new BStandardDialog("", new String[]{Translate.text("errorLoadingFile"), ex.getMessage() == null ? "" : ex.getMessage()}, BStandardDialog.ERROR).showMessageDialog(fr);
        }
    }

    public static void copyToClipboard(ObjectInfo[] obj, Scene scene) {
        ArrayList<Texture> textures = new ArrayList<Texture>();
        for (int i = 0; i < obj.length; ++i) {
            Texture tex = obj[i].getObject().getTexture();
            if (tex instanceof LayeredTexture) {
                LayeredMapping map = (LayeredMapping)obj[i].getObject().getTextureMapping();
                Texture[] layer = map.getLayers();
                for (int j = 0; j < layer.length; ++j) {
                    Texture dup = layer[j].duplicate();
                    dup.setID(layer[j].getID());
                    textures.add(dup);
                    map.setLayer(j, dup);
                    map.setLayerMapping(j, map.getLayerMapping(j).duplicate(obj[i].getObject(), dup));
                }
                continue;
            }
            if (tex == null) continue;
            Texture dup = tex.duplicate();
            dup.setID(tex.getID());
            textures.add(dup);
            obj[i].getObject().setTexture(dup, obj[i].getObject().getTextureMapping().duplicate(obj[i].getObject(), dup));
        }
        ArrayList<Material> materials = new ArrayList<Material>();
        for (int i = 0; i < obj.length; ++i) {
            Material mat = obj[i].getObject().getMaterial();
            if (mat == null) continue;
            Material dup = mat.duplicate();
            dup.setID(mat.getID());
            materials.add(dup);
            obj[i].getObject().setMaterial(dup, obj[i].getObject().getMaterialMapping().duplicate(obj[i].getObject(), dup));
        }
        ArrayList<ImageMap> images = new ArrayList<ImageMap>();
        for (int i = 0; i < scene.getNumImages(); ++i) {
            int j;
            ImageMap map = scene.getImage(i);
            boolean used = false;
            for (j = 0; j < textures.size() && !used; ++j) {
                used = ((Texture)textures.get(j)).usesImage(map);
            }
            for (j = 0; j < materials.size() && !used; ++j) {
                used = ((Material)materials.get(j)).usesImage(map);
            }
            if (!used) continue;
            images.add(map);
        }
        clipboardObject = obj;
        clipboardTexture = textures.toArray(new Texture[textures.size()]);
        clipboardMaterial = materials.toArray(new Material[materials.size()]);
        clipboardImage = images.toArray(new ImageMap[images.size()]);
    }

    public static void pasteClipboard(LayoutWindow win) {
        Object current;
        int j;
        int i;
        if (clipboardObject == null) {
            return;
        }
        Scene scene = win.getScene();
        UndoRecord undo = new UndoRecord(win, false);
        win.setUndoRecord(undo);
        int[] sel = win.getSelectedIndices();
        for (i = 0; i < clipboardImage.length; ++i) {
            int j2;
            for (j2 = 0; j2 < scene.getNumImages() && clipboardImage[i].getID() != scene.getImage(j2).getID(); ++j2) {
            }
            if (j2 != scene.getNumImages()) continue;
            scene.addImage(clipboardImage[i]);
        }
        for (i = 0; i < clipboardTexture.length; ++i) {
            Texture newtex;
            for (j = 0; j < scene.getNumTextures() && clipboardTexture[i].getID() != scene.getTexture(j).getID(); ++j) {
            }
            if (j == scene.getNumTextures()) {
                newtex = clipboardTexture[i].duplicate();
                newtex.setID(clipboardTexture[i].getID());
                scene.addTexture(newtex);
            } else {
                newtex = scene.getTexture(j);
            }
            for (j = 0; j < clipboardObject.length; ++j) {
                current = clipboardObject[j].getObject().getTexture();
                if (current == null) continue;
                ParameterValue[] oldParamValues = clipboardObject[j].getObject().getParameterValues();
                ParameterValue[] newParamValues = new ParameterValue[oldParamValues.length];
                for (int k = 0; k < newParamValues.length; ++k) {
                    newParamValues[k] = oldParamValues[k].duplicate();
                }
                if (current == clipboardTexture[i]) {
                    clipboardObject[j].setTexture(newtex, clipboardObject[j].getObject().getTextureMapping().duplicate(clipboardObject[j].getObject(), newtex));
                } else if (current instanceof LayeredTexture) {
                    LayeredMapping map = (LayeredMapping)clipboardObject[j].getObject().getTextureMapping();
                    map = (LayeredMapping)map.duplicate();
                    clipboardObject[j].setTexture(new LayeredTexture(map), map);
                    Texture[] layer = map.getLayers();
                    for (int k = 0; k < layer.length; ++k) {
                        if (layer[k] != clipboardTexture[i]) continue;
                        map.setLayer(k, newtex);
                        map.setLayerMapping(k, map.getLayerMapping(k).duplicate(clipboardObject[j].getObject(), newtex));
                    }
                }
                clipboardObject[j].getObject().setParameterValues(newParamValues);
            }
        }
        for (i = 0; i < clipboardMaterial.length; ++i) {
            Material newmat;
            for (j = 0; j < scene.getNumMaterials() && clipboardMaterial[i].getID() != scene.getMaterial(j).getID(); ++j) {
            }
            if (j == scene.getNumMaterials()) {
                newmat = clipboardMaterial[i].duplicate();
                newmat.setID(clipboardMaterial[i].getID());
                scene.addMaterial(newmat);
            } else {
                newmat = scene.getMaterial(j);
            }
            for (j = 0; j < clipboardObject.length; ++j) {
                current = clipboardObject[j].getObject().getMaterial();
                if (current != clipboardMaterial[i]) continue;
                clipboardObject[j].setMaterial(newmat, clipboardObject[j].getObject().getMaterialMapping().duplicate(clipboardObject[j].getObject(), newmat));
            }
        }
        ObjectInfo[] obj = ObjectInfo.duplicateAll(clipboardObject);
        for (int i2 = 0; i2 < obj.length; ++i2) {
            win.addObject(obj[i2], undo);
        }
        undo.addCommand(16, new Object[]{sel});
    }

    public static int getClipboardSize() {
        if (clipboardObject == null) {
            return 0;
        }
        return clipboardObject.length;
    }

    public static String getCurrentDirectory() {
        return ModellingApp.currentDirectory;
    }

    public static void setCurrentDirectory(String currentDirectory) {
        ModellingApp.currentDirectory = currentDirectory;
    }

    static {
        standardDialogInsets = 0;
        windows = new ArrayList();
        classTranslations = new HashMap();
        numNewWindows = 0;
        String dir = System.getProperty("user.dir");
        try {
            URL url = ArtOfIllusion.class.getResource("/artofillusion/ArtOfIllusion.class");
            if (url.toString().startsWith("jar:")) {
                String furl = url.getFile();
                dir = new File(new URL(furl = furl.substring(0, furl.indexOf(33))).getFile()).getParent();
                if (!new File(dir).exists()) {
                    dir = System.getProperty("user.dir");
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        APP_DIRECTORY = dir;
        PLUGIN_DIRECTORY = new File(APP_DIRECTORY, "Plugins").getAbsolutePath();
        File scripts = new File(APP_DIRECTORY, "Scripts");
        TOOL_SCRIPT_DIRECTORY = new File(scripts, "Tools").getAbsolutePath();
        OBJECT_SCRIPT_DIRECTORY = new File(scripts, "Objects").getAbsolutePath();
        STARTUP_SCRIPT_DIRECTORY = new File(scripts, "Startup").getAbsolutePath();
        IconResource icon = new IconResource("artofillusion/Icons/appIcon.png");
        APP_ICON = icon.getIconWidth() == -1 ? null : icon;
        classTranslations.put("artofillusion.tools.CSGObject", "artofillusion.object.CSGObject");
        classTranslations.put("artofillusion.Cube", "artofillusion.object.Cube");
        classTranslations.put("artofillusion.Curve", "artofillusion.object.Curve");
        classTranslations.put("artofillusion.Cylinder", "artofillusion.object.Cylinder");
        classTranslations.put("artofillusion.DirectionalLight", "artofillusion.object.DirectionalLight");
        classTranslations.put("artofillusion.NullObject", "artofillusion.object.NullObject");
        classTranslations.put("artofillusion.PointLight", "artofillusion.object.PointLight");
        classTranslations.put("artofillusion.SceneCamera", "artofillusion.object.SceneCamera");
        classTranslations.put("artofillusion.Sphere", "artofillusion.object.Sphere");
        classTranslations.put("artofillusion.SplineMesh", "artofillusion.object.SplineMesh");
        classTranslations.put("artofillusion.SpotLight", "artofillusion.object.SpotLight");
        classTranslations.put("artofillusion.TriangleMesh", "artofillusion.object.TriangleMesh");
        classTranslations.put("artofillusion.Tube", "artofillusion.object.Tube");
        classTranslations.put("artofillusion.CylindricalMapping", "artofillusion.texture.CylindricalMapping");
        classTranslations.put("artofillusion.ImageMapTexture", "artofillusion.texture.ImageMapTexture");
        classTranslations.put("artofillusion.LayeredMapping", "artofillusion.texture.LayeredMapping");
        classTranslations.put("artofillusion.LayeredTexture", "artofillusion.texture.LayeredTexture");
        classTranslations.put("artofillusion.LinearMapping3D", "artofillusion.texture.LinearMapping3D");
        classTranslations.put("artofillusion.procedural.ProceduralTexture2D", "artofillusion.texture.ProceduralTexture2D");
        classTranslations.put("artofillusion.procedural.ProceduralTexture3D", "artofillusion.texture.ProceduralTexture3D");
        classTranslations.put("artofillusion.ProjectionMapping", "artofillusion.texture.ProjectionMapping");
        classTranslations.put("artofillusion.SphericalMapping", "artofillusion.texture.SphericalMapping");
        classTranslations.put("artofillusion.UniformMapping", "artofillusion.texture.UniformMapping");
        classTranslations.put("artofillusion.UniformTexture", "artofillusion.texture.UniformTexture");
        classTranslations.put("artofillusion.LinearMaterialMapping", "artofillusion.material.LinearMaterialMapping");
        classTranslations.put("artofillusion.procedural.ProceduralMaterial3D", "artofillusion.material.ProceduralMaterial3D");
        classTranslations.put("artofillusion.UniformMaterial", "artofillusion.material.UniformMaterial");
        classTranslations.put("artofillusion.UniformMaterialMapping", "artofillusion.material.UniformMaterialMapping");
        classTranslations.put("artofillusion.tools.tapDesigner.TapDesignerObjectCollection", "artofillusion.tapDesigner.TapDesignerObjectCollection");
        classTranslations.put("artofillusion.tools.tapDesigner.TapTube", "artofillusion.tapDesigner.TapTube");
        classTranslations.put("artofillusion.tools.tapDesigner.TapSplineMesh", "artofillusion.tapDesigner.TapSplineMesh");
        classTranslations.put("artofillusion.tools.tapDesigner.TapObject", "artofillusion.tapDesigner.TapObject");
        classTranslations.put("artofillusion.tools.tapDesigner.TapLeaf", "artofillusion.tapDesigner.TapLeaf");
    }
}

