/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.translators;

import artofillusion.ArtOfIllusion;
import artofillusion.Scene;
import artofillusion.WireframeMesh;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.object.Cube;
import artofillusion.object.Curve;
import artofillusion.object.Cylinder;
import artofillusion.object.DirectionalLight;
import artofillusion.object.FacetedMesh;
import artofillusion.object.Light;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectCollection;
import artofillusion.object.ObjectInfo;
import artofillusion.object.PointLight;
import artofillusion.object.SceneCamera;
import artofillusion.object.Sphere;
import artofillusion.object.SpotLight;
import artofillusion.texture.Mapping2D;
import artofillusion.texture.Texture;
import artofillusion.texture.TextureSpec;
import artofillusion.texture.UVMapping;
import artofillusion.translators.TextureImageExporter;
import artofillusion.translators.TextureImageInfo;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import artofillusion.ui.ValueSlider;
import buoy.event.ValueChangedEvent;
import buoy.widget.BCheckBox;
import buoy.widget.BComboBox;
import buoy.widget.BFileChooser;
import buoy.widget.BFrame;
import buoy.widget.BStandardDialog;
import buoy.widget.Widget;
import buoy.widget.WindowWidget;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.zip.GZIPOutputStream;

public class VRMLExporter {
    public static final String matchId = " \"'#,.\\[]{}\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\t\u000e\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f\u007f";
    public static final String replace = "_______()()";
    public static final String illegalFirst = "+-0123456789";

    public static void exportFile(BFrame parent, Scene theScene) {
        ValueField errorField = new ValueField(0.05, 3);
        final ValueField widthField = new ValueField(200.0, 7);
        final ValueField heightField = new ValueField(200.0, 7);
        final ValueSlider qualitySlider = new ValueSlider(0.0, 1.0, 100, 0.5);
        final BCheckBox texBox = new BCheckBox(Translate.text((String)"createImageFilesForTextures"), false);
        BCheckBox compressBox = new BCheckBox(Translate.text((String)"compressOutputFile"), true);
        BCheckBox smoothBox = new BCheckBox(Translate.text((String)"subdivideSmoothMeshes"), true);
        BComboBox exportChoice = new BComboBox((Object[])new String[]{Translate.text((String)"exportWholeScene"), Translate.text((String)"selectedObjectsOnly")});
        texBox.addEventLink(ValueChangedEvent.class, new Object(){

            void processEvent() {
                widthField.setEnabled(texBox.getState());
                heightField.setEnabled(texBox.getState());
                qualitySlider.setEnabled(texBox.getState());
            }
        });
        texBox.dispatchEvent((Object)new ValueChangedEvent((Widget)texBox));
        ComponentsDialog dlg = theScene.getSelection().length > 0 ? new ComponentsDialog((WindowWidget)parent, Translate.text((String)"exportToVRML"), new Widget[]{exportChoice, errorField, compressBox, smoothBox, texBox, Translate.label((String)"imageSizeForTextures"), widthField, heightField, qualitySlider}, new String[]{null, Translate.text((String)"maxSurfaceError"), null, null, null, null, Translate.text((String)"Width"), Translate.text((String)"Height"), Translate.text((String)"imageQuality")}) : new ComponentsDialog((WindowWidget)parent, Translate.text((String)"exportToVRML"), new Widget[]{errorField, compressBox, smoothBox, texBox, Translate.label((String)"imageSizeForTextures"), widthField, heightField, qualitySlider}, new String[]{Translate.text((String)"maxSurfaceError"), null, null, null, null, Translate.text((String)"Width"), Translate.text((String)"Height"), Translate.text((String)"imageQuality")});
        if (!dlg.clickedOk()) {
            return;
        }
        BFileChooser fc = new BFileChooser(BFileChooser.SAVE_FILE, Translate.text((String)"exportToVRML"));
        if (compressBox.getState()) {
            fc.setSelectedFile(new File("Untitled.wrz"));
        } else {
            fc.setSelectedFile(new File("Untitled.wrl"));
        }
        if (ArtOfIllusion.getCurrentDirectory() != null) {
            fc.setDirectory(new File(ArtOfIllusion.getCurrentDirectory()));
        }
        if (!fc.showDialog((Widget)parent)) {
            return;
        }
        File dir = fc.getDirectory();
        File f = fc.getSelectedFile();
        String name = f.getName();
        String baseName = name.endsWith(".wrl") || name.endsWith(".wrz") ? name.substring(0, name.length() - 4) : name;
        ArtOfIllusion.setCurrentDirectory((String)dir.getAbsolutePath());
        try {
            TextureImageExporter textureExporter = null;
            if (texBox.getState()) {
                textureExporter = new TextureImageExporter(dir, baseName, (int)(100.0 * qualitySlider.getValue()), 1, (int)widthField.getValue(), (int)heightField.getValue());
                boolean wholeScene = exportChoice.getSelectedIndex() == 0;
                for (int i = 0; i < theScene.getNumObjects(); ++i) {
                    ObjectInfo info = theScene.getObject(i);
                    if (!wholeScene && !info.selected) continue;
                    textureExporter.addObject(info);
                }
                textureExporter.saveImages();
            }
            FilterOutputStream out = new BufferedOutputStream(new FileOutputStream(f));
            if (compressBox.getState()) {
                out = new GZIPOutputStream(out);
            }
            VRMLExporter.writeScene(theScene, out, exportChoice.getSelectedIndex() == 0, errorField.getValue(), smoothBox.getState(), textureExporter);
            ((OutputStream)out).close();
        }
        catch (Exception ex) {
            System.out.println("VRMLExporter.exportFile: " + ex);
            ex.printStackTrace(System.out);
            new BStandardDialog("", (Object)new String[]{Translate.text((String)"errorExportingScene"), ex.getMessage() == null ? "" : ex.getMessage()}, BStandardDialog.ERROR).showMessageDialog((Widget)parent);
        }
    }

    private static void writeScene(Scene theScene, OutputStream os, boolean wholeScene, double tol, boolean smooth, TextureImageExporter textureExporter) {
        PrintWriter out = new PrintWriter(os);
        int[] selected = theScene.getSelection();
        VRMLExporter.write("#VRML V2.0 utf8", out, 0);
        VRMLExporter.write("#Produced by Art of Illusion, " + new Date().toString(), out, 0);
        if (wholeScene) {
            VRMLExporter.write("NavigationInfo {", out, 0);
            VRMLExporter.write("headlight FALSE", out, 1);
            VRMLExporter.write("}", out, 0);
            RGBColor color = theScene.getEnvironmentColor();
            VRMLExporter.write("Background {", out, 0);
            VRMLExporter.write("skyColor " + color.getRed() + " " + color.getGreen() + " " + color.getBlue(), out, 1);
            VRMLExporter.write("}", out, 0);
            color = theScene.getAmbientColor();
            VRMLExporter.write("PointLight {", out, 0);
            VRMLExporter.write("color " + color.getRed() + " " + color.getGreen() + " " + color.getBlue(), out, 1);
            VRMLExporter.write("intensity 0", out, 1);
            VRMLExporter.write("ambientIntensity 1", out, 1);
            VRMLExporter.write("radius 1e15", out, 1);
            VRMLExporter.write("}", out, 0);
            if (theScene.getFogState()) {
                color = theScene.getFogColor();
                VRMLExporter.write("Fog {", out, 0);
                VRMLExporter.write("color " + color.getRed() + " " + color.getGreen() + " " + color.getBlue(), out, 1);
                VRMLExporter.write("fogType \"EXPONENTIAL\"", out, 1);
                VRMLExporter.write("visibilityRange " + 2.0 * theScene.getFogDistance(), out, 1);
                VRMLExporter.write("}", out, 0);
            }
        }
        if (wholeScene) {
            for (int i = 0; i < theScene.getNumObjects(); ++i) {
                VRMLExporter.writeObject(theScene.getObject(i), null, out, tol, smooth, 0, theScene, textureExporter);
            }
        } else {
            for (int i = 0; i < selected.length; ++i) {
                VRMLExporter.writeObject(theScene.getObject(selected[i]), null, out, tol, smooth, 0, theScene, textureExporter);
            }
        }
        out.flush();
    }

    private static void write(String str, PrintWriter out, int indent) {
        for (int i = 0; i < indent; ++i) {
            out.print(" ");
        }
        out.print(str);
        out.print("\r\n");
    }

    private static void writeObject(ObjectInfo info, ObjectInfo parent, PrintWriter out, double tol, boolean smooth, int indent, Scene theScene, TextureImageExporter textureExporter) {
        WireframeMesh mesh;
        boolean hasTexture;
        if (info.getParent() != null && info.getParent() != parent) {
            return;
        }
        CoordinateSystem coords = info.getCoords();
        Object3D obj = info.getObject();
        Vec3 orig = coords.getOrigin();
        Vec3 size = info.getBounds().getSize();
        Vec3 axis = new Vec3(0.0, 0.0, 0.0);
        double[] rot = new double[4];
        double ratio = 0.0;
        double[] pos = new double[3];
        double[] scale = new double[3];
        String name = VRMLExporter.translate(info.getName(), 0, 1, matchId, replace) + VRMLExporter.translate(info.getName(), 1, -1, matchId, replace);
        if (name.length() > 0 && illegalFirst.indexOf(name.charAt(0)) > 0) {
            name = '_' + name;
        }
        if (obj instanceof SceneCamera) {
            coords = coords.duplicate();
            coords.setOrientation(info.getCoords().getZDirection().times(-1.0), info.getCoords().getUpDirection().times(1.0));
        }
        rot[3] = coords.getAxisAngleRotation(axis);
        pos[0] = (double)Math.round(orig.x * 1000000.0) / 1000000.0;
        pos[1] = (double)Math.round(orig.y * 1000000.0) / 1000000.0;
        pos[2] = (double)Math.round(orig.z * 1000000.0) / 1000000.0;
        scale[0] = (double)Math.round(size.x * 1000000.0) / 1000000.0;
        scale[1] = (double)Math.round(size.y * 1000000.0) / 1000000.0;
        scale[2] = (double)Math.round(size.z * 1000000.0) / 1000000.0;
        rot[0] = (double)Math.round(axis.x * 1000000.0) / 1000000.0;
        rot[1] = (double)Math.round(axis.y * 1000000.0) / 1000000.0;
        rot[2] = (double)Math.round(axis.z * 1000000.0) / 1000000.0;
        rot[3] = (double)Math.round(rot[3] * 1000000.0) / 1000000.0;
        if (obj instanceof DirectionalLight) {
            RGBColor color = ((Light)obj).getColor();
            boolean ambient = ((Light)obj).getType() == 2;
            Vec3 dir = coords.getZDirection();
            VRMLExporter.write("DirectionalLight {", out, indent);
            VRMLExporter.write("direction " + dir.x + " " + dir.y + " " + dir.z, out, indent + 1);
            VRMLExporter.write("color " + color.getRed() + " " + color.getGreen() + " " + color.getBlue(), out, indent + 1);
            if (ambient) {
                VRMLExporter.write("ambientIntensity " + ((Light)obj).getIntensity(), out, indent + 1);
                VRMLExporter.write("intensity 0", out, indent + 1);
            } else {
                VRMLExporter.write("intensity " + ((Light)obj).getIntensity(), out, indent + 1);
            }
            VRMLExporter.write("}", out, indent);
            return;
        }
        if (obj instanceof SpotLight) {
            RGBColor color = ((Light)obj).getColor();
            float decay = ((Light)obj).getDecayRate();
            boolean ambient = ((Light)obj).getType() == 2;
            Vec3 dir = coords.getZDirection();
            double inner = Math.acos(Math.pow(0.9, 1.0 / ((SpotLight)obj).getExponent()));
            double outer = Math.acos(Math.pow(0.1, 1.0 / ((SpotLight)obj).getExponent()));
            double cutoff = ((SpotLight)obj).getAngle() / 2.0;
            if (cutoff < outer) {
                outer = cutoff;
            }
            VRMLExporter.write("SpotLight {", out, indent);
            VRMLExporter.write("location " + pos[0] + " " + pos[1] + " " + pos[2], out, indent + 1);
            VRMLExporter.write("direction " + dir.x + " " + dir.y + " " + dir.z, out, indent + 1);
            VRMLExporter.write("cutOffAngle " + outer, out, indent + 1);
            if (inner < outer) {
                VRMLExporter.write("beamWidth " + inner, out, indent + 1);
            }
            VRMLExporter.write("color " + color.getRed() + " " + color.getGreen() + " " + color.getBlue(), out, indent + 1);
            if (ambient) {
                VRMLExporter.write("ambientIntensity " + ((Light)obj).getIntensity(), out, indent + 1);
                VRMLExporter.write("intensity 0", out, indent + 1);
            } else {
                VRMLExporter.write("intensity " + ((Light)obj).getIntensity(), out, indent + 1);
            }
            VRMLExporter.write("attenuation 1 " + decay + " " + decay * decay, out, indent + 1);
            VRMLExporter.write("}", out, indent);
            return;
        }
        if (obj instanceof PointLight) {
            RGBColor color = ((Light)obj).getColor();
            float decay = ((Light)obj).getDecayRate();
            boolean ambient = ((Light)obj).getType() == 2;
            VRMLExporter.write("PointLight {", out, indent);
            VRMLExporter.write("location " + pos[0] + " " + pos[1] + " " + pos[2], out, indent + 1);
            VRMLExporter.write("color " + color.getRed() + " " + color.getGreen() + " " + color.getBlue(), out, indent + 1);
            if (ambient) {
                VRMLExporter.write("ambientIntensity " + ((Light)obj).getIntensity(), out, indent + 1);
                VRMLExporter.write("intensity 0", out, indent + 1);
            } else {
                VRMLExporter.write("intensity " + ((Light)obj).getIntensity(), out, indent + 1);
            }
            VRMLExporter.write("attenuation 1 " + decay + " " + decay * decay, out, indent + 1);
            VRMLExporter.write("}", out, indent);
            return;
        }
        if (obj instanceof SceneCamera) {
            VRMLExporter.write("Viewpoint {", out, indent);
            VRMLExporter.write("position " + pos[0] + " " + pos[1] + " " + pos[2], out, indent + 1);
            VRMLExporter.write("orientation " + rot[0] + " " + rot[1] + " " + rot[2] + " " + rot[3], out, indent + 1);
            VRMLExporter.write("fieldOfView " + ((SceneCamera)obj).getFieldOfView() * Math.PI / 180.0, out, indent + 1);
            VRMLExporter.write("description \"" + info.getName() + "\"", out, indent + 1);
            VRMLExporter.write("}", out, indent);
            return;
        }
        if (info.getChildren() != null && info.getChildren().length > 0) {
            VRMLExporter.write("DEF " + name + " Group {", out, indent++);
            VRMLExporter.write("children [", out, indent++);
        }
        VRMLExporter.write("DEF " + name + " Transform {", out, indent);
        VRMLExporter.write("translation " + pos[0] + " " + pos[1] + " " + pos[2], out, indent + 1);
        VRMLExporter.write("rotation " + rot[0] + " " + rot[1] + " " + rot[2] + " " + rot[3], out, indent + 1);
        if (obj instanceof Cylinder) {
            ratio = ((Cylinder)obj).getRatio();
        }
        if (obj instanceof Sphere || obj instanceof Cylinder && (ratio == 0.0 || ratio == 1.0)) {
            VRMLExporter.write("scale " + scale[0] / 2.0 + " " + scale[1] / 2.0 + " " + scale[2] / 2.0, out, indent + 1);
        }
        VRMLExporter.write("children [", out, indent + 1);
        TextureImageInfo ti = textureExporter == null ? null : textureExporter.getTextureInfo(obj.getTexture());
        boolean bl = hasTexture = ti != null && ti.diffuseFilename != null;
        if (obj instanceof Cube && !hasTexture) {
            VRMLExporter.write("Shape {", out, indent + 2);
            VRMLExporter.writeTexture(info, out, indent + 3, theScene, textureExporter);
            VRMLExporter.write("geometry DEF " + name + " Box {", out, indent + 3);
            VRMLExporter.write("size " + scale[0] + " " + scale[1] + " " + scale[2], out, indent + 4);
            VRMLExporter.write("}", out, indent + 3);
            VRMLExporter.write("}", out, indent + 2);
        } else if (obj instanceof Cylinder && ratio == 1.0 && !hasTexture) {
            VRMLExporter.write("Shape {", out, indent + 2);
            VRMLExporter.writeTexture(info, out, indent + 3, theScene, textureExporter);
            VRMLExporter.write("geometry DEF " + name + " Cylinder {}", out, indent + 3);
            VRMLExporter.write("}", out, indent + 2);
        } else if (obj instanceof Cylinder && ratio == 0.0 && !hasTexture) {
            VRMLExporter.write("Shape {", out, indent + 2);
            VRMLExporter.writeTexture(info, out, indent + 3, theScene, textureExporter);
            VRMLExporter.write("geometry DEF " + name + " Cone {}", out, indent + 3);
            VRMLExporter.write("}", out, indent + 2);
        } else if (obj instanceof Sphere && !hasTexture) {
            VRMLExporter.write("Shape {", out, indent + 2);
            VRMLExporter.writeTexture(info, out, indent + 3, theScene, textureExporter);
            VRMLExporter.write("geometry DEF " + name + " Sphere {", out, indent + 3);
            VRMLExporter.write("}", out, indent + 3);
            VRMLExporter.write("}", out, indent + 2);
        } else if (obj instanceof Curve && !obj.canSetTexture()) {
            mesh = obj.getWireframeMesh();
            if (mesh != null) {
                int i;
                Vec3[] vert = mesh.vert;
                VRMLExporter.write("Shape {", out, indent + 2);
                VRMLExporter.write("geometry DEF " + name + " IndexedLineSet {", out, indent + 3);
                VRMLExporter.write("coord Coordinate { point [", out, indent + 4);
                for (i = 0; i < vert.length; ++i) {
                    pos[0] = (double)Math.round(vert[i].x * 1000000.0) / 1000000.0;
                    pos[1] = (double)Math.round(vert[i].y * 1000000.0) / 1000000.0;
                    pos[2] = (double)Math.round(vert[i].z * 1000000.0) / 1000000.0;
                    VRMLExporter.write(pos[0] + " " + pos[1] + " " + pos[2] + ",", out, indent + 5);
                }
                VRMLExporter.write("] }", out, indent + 4);
                VRMLExporter.write("coordIndex [", out, indent + 4);
                for (i = 0; i < vert.length - 1; ++i) {
                    VRMLExporter.write(i + ",", out, indent + 5);
                }
                if (obj.isClosed()) {
                    VRMLExporter.write(vert.length - 1 + ", 0, -1", out, indent + 5);
                } else {
                    VRMLExporter.write(vert.length - 1 + ", -1", out, indent + 5);
                }
                VRMLExporter.write("]", out, indent + 4);
                VRMLExporter.write("}", out, indent + 3);
                VRMLExporter.write("}", out, indent + 2);
            }
        } else if (obj instanceof FacetedMesh && !smooth) {
            VRMLExporter.writeMesh((FacetedMesh)obj, info, out, indent + 2, theScene, textureExporter, false);
        } else if (obj instanceof ObjectCollection) {
            Enumeration e = ((ObjectCollection)obj).getObjects(info, false, theScene);
            while (e.hasMoreElements()) {
                VRMLExporter.writeObject((ObjectInfo)e.nextElement(), info, out, tol, smooth, indent + 2, theScene, textureExporter);
            }
        } else {
            mesh = info.getObject().convertToTriangleMesh(tol);
            if (mesh != null) {
                VRMLExporter.writeMesh((FacetedMesh)mesh, info, out, indent + 2, theScene, textureExporter, true);
            }
        }
        if (info.getChildren() != null && info.getChildren().length > 0) {
            VRMLExporter.write("]", out, indent + 1);
            VRMLExporter.write("}", out, indent);
            indent -= 2;
            int max = info.getChildren().length;
            for (int i = 0; i < max; ++i) {
                VRMLExporter.writeObject(info.getChildren()[i], info, out, tol, smooth, indent + 2, theScene, textureExporter);
            }
        }
        VRMLExporter.write("]", out, indent + 1);
        VRMLExporter.write("}", out, indent);
    }

    private static void writeMesh(FacetedMesh mesh, ObjectInfo info, PrintWriter out, int indent, Scene theScene, TextureImageExporter textureExporter, boolean includeNormals) {
        TextureImageInfo ti;
        int i;
        MeshVertex[] vert = mesh.getVertices();
        double[] pos = new double[3];
        String name = VRMLExporter.translate(info.getName(), 0, 1, matchId, replace) + VRMLExporter.translate(info.getName(), 1, -1, matchId, replace);
        if (name.length() > 0 && illegalFirst.indexOf(name.charAt(0)) > 0) {
            name = '_' + name;
        }
        VRMLExporter.write("Shape {", out, indent);
        VRMLExporter.writeTexture(info, out, indent + 1, theScene, textureExporter);
        VRMLExporter.write("geometry DEF " + name + " IndexedFaceSet {", out, indent + 1);
        if (info.getObject().isClosed()) {
            VRMLExporter.write("solid TRUE", out, indent + 2);
        } else {
            VRMLExporter.write("solid FALSE", out, indent + 2);
        }
        VRMLExporter.write("coord Coordinate { point [", out, indent + 2);
        for (i = 0; i < vert.length; ++i) {
            pos[0] = (double)Math.round(vert[i].r.x * 1000000.0) / 1000000.0;
            pos[1] = (double)Math.round(vert[i].r.y * 1000000.0) / 1000000.0;
            pos[2] = (double)Math.round(vert[i].r.z * 1000000.0) / 1000000.0;
            VRMLExporter.write(pos[0] + " " + pos[1] + " " + pos[2] + ",", out, indent + 3);
        }
        VRMLExporter.write("] }", out, indent + 2);
        VRMLExporter.write("coordIndex [", out, indent + 2);
        for (i = 0; i < mesh.getFaceCount(); ++i) {
            StringBuffer buf = new StringBuffer();
            for (int j = 0; j < mesh.getFaceVertexCount(i); ++j) {
                if (j > 0) {
                    buf.append(", ");
                }
                buf.append(mesh.getFaceVertexIndex(i, j));
            }
            buf.append(", -1,");
            VRMLExporter.write(buf.toString(), out, indent + 3);
        }
        VRMLExporter.write("]", out, indent + 2);
        if (includeNormals) {
            int i2;
            Vec3[] norm = mesh.getNormals();
            VRMLExporter.write("normal Normal { vector [", out, indent + 2);
            for (i2 = 0; i2 < norm.length; ++i2) {
                if (norm[i2] == null) {
                    VRMLExporter.write("1 0 0,", out, indent + 3);
                    continue;
                }
                pos[0] = (double)Math.round(norm[i2].x * 1000000.0) / 1000000.0;
                pos[1] = (double)Math.round(norm[i2].y * 1000000.0) / 1000000.0;
                pos[2] = (double)Math.round(norm[i2].z * 1000000.0) / 1000000.0;
                VRMLExporter.write(pos[0] + " " + pos[1] + " " + pos[2] + ",", out, indent + 3);
            }
            VRMLExporter.write("] }", out, indent + 2);
            VRMLExporter.write("normalIndex [", out, indent + 2);
            for (i2 = 0; i2 < mesh.getFaceCount(); ++i2) {
                StringBuffer buf = new StringBuffer();
                for (int j = 0; j < mesh.getFaceVertexCount(i2); ++j) {
                    if (j > 0) {
                        buf.append(", ");
                    }
                    buf.append(mesh.getFaceVertexIndex(i2, j));
                }
                buf.append(", -1,");
                VRMLExporter.write(buf.toString(), out, indent + 3);
            }
            VRMLExporter.write("]", out, indent + 2);
        }
        TextureImageInfo textureImageInfo = ti = textureExporter == null ? null : textureExporter.getTextureInfo(((Object3D)mesh).getTexture());
        if (ti != null && ((Object3D)mesh).getTextureMapping() instanceof UVMapping && ((UVMapping)((Object3D)mesh).getTextureMapping()).isPerFaceVertex(mesh)) {
            Vec2[][] coords = ((UVMapping)((Object3D)mesh).getTextureMapping()).findFaceTextureCoordinates(mesh);
            double uscale = ti.maxu == ti.minu ? 1.0 : 1.0 / (ti.maxu - ti.minu);
            double vscale = ti.maxv == ti.minv ? 1.0 : 1.0 / (ti.maxv - ti.minv);
            VRMLExporter.write("texCoord TextureCoordinate { point [", out, indent + 2);
            for (int j = 0; j < coords.length; ++j) {
                for (int k = 0; k < coords[j].length; ++k) {
                    pos[0] = (coords[j][k].x - ti.minu) * uscale;
                    pos[1] = (coords[j][k].y - ti.minv) * vscale;
                    pos[0] = (double)Math.round(pos[0] * 1000000.0) / 1000000.0;
                    pos[1] = (double)Math.round(pos[1] * 1000000.0) / 1000000.0;
                    VRMLExporter.write(pos[0] + " " + pos[1] + ",", out, indent + 3);
                }
            }
            VRMLExporter.write("] }", out, indent + 2);
            VRMLExporter.write("texCoordIndex [", out, indent + 2);
            int texVertIndex = 0;
            for (int i3 = 0; i3 < mesh.getFaceCount(); ++i3) {
                StringBuffer buf = new StringBuffer();
                for (int j = 0; j < mesh.getFaceVertexCount(i3); ++j) {
                    if (j > 0) {
                        buf.append(", ");
                    }
                    buf.append(texVertIndex++);
                }
                buf.append(", -1,");
                VRMLExporter.write(buf.toString(), out, indent + 3);
            }
            VRMLExporter.write("]", out, indent + 2);
        } else if (ti != null && ((Object3D)mesh).getTextureMapping() instanceof Mapping2D) {
            int i4;
            Vec2[] coords = ((Mapping2D)((Object3D)mesh).getTextureMapping()).findTextureCoordinates((Mesh)mesh);
            double uscale = ti.maxu == ti.minu ? 1.0 : 1.0 / (ti.maxu - ti.minu);
            double vscale = ti.maxv == ti.minv ? 1.0 : 1.0 / (ti.maxv - ti.minv);
            VRMLExporter.write("texCoord TextureCoordinate { point [", out, indent + 2);
            for (i4 = 0; i4 < coords.length; ++i4) {
                pos[0] = (coords[i4].x - ti.minu) * uscale;
                pos[1] = (coords[i4].y - ti.minv) * vscale;
                pos[0] = (double)Math.round(pos[0] * 1000000.0) / 1000000.0;
                pos[1] = (double)Math.round(pos[1] * 1000000.0) / 1000000.0;
                VRMLExporter.write(pos[0] + " " + pos[1] + ",", out, indent + 3);
            }
            VRMLExporter.write("] }", out, indent + 2);
            VRMLExporter.write("texCoordIndex [", out, indent + 2);
            for (i4 = 0; i4 < mesh.getFaceCount(); ++i4) {
                StringBuffer buf = new StringBuffer();
                for (int j = 0; j < mesh.getFaceVertexCount(i4); ++j) {
                    if (j > 0) {
                        buf.append(", ");
                    }
                    buf.append(mesh.getFaceVertexIndex(i4, j));
                }
                buf.append(", -1,");
                VRMLExporter.write(buf.toString(), out, indent + 3);
            }
            VRMLExporter.write("]", out, indent + 2);
        }
        VRMLExporter.write("}", out, indent + 1);
        VRMLExporter.write("}", out, indent);
    }

    private static void writeTexture(ObjectInfo info, PrintWriter out, int indent, Scene theScene, TextureImageExporter textureExporter) {
        Texture tex = info.getObject().getTexture();
        if (tex == null) {
            return;
        }
        TextureImageInfo ti = textureExporter == null ? null : textureExporter.getTextureInfo(tex);
        boolean hasMap = ti != null && ti.diffuseFilename != null;
        TextureSpec spec = new TextureSpec();
        tex.getAverageSpec(spec, theScene.getTime(), info.getObject().getAverageParameterValues());
        VRMLExporter.write("appearance Appearance {", out, indent);
        VRMLExporter.write("material Material {", out, indent + 1);
        if (hasMap) {
            VRMLExporter.write("diffuseColor 1 1 1", out, indent + 2);
        } else {
            VRMLExporter.write("diffuseColor " + spec.diffuse.getRed() + " " + spec.diffuse.getGreen() + " " + spec.diffuse.getBlue(), out, indent + 2);
        }
        VRMLExporter.write("emissiveColor " + spec.emissive.getRed() + " " + spec.emissive.getGreen() + " " + spec.emissive.getBlue(), out, indent + 2);
        VRMLExporter.write("specularColor " + spec.specular.getRed() + " " + spec.specular.getGreen() + " " + spec.specular.getBlue(), out, indent + 2);
        VRMLExporter.write("shininess " + (1.0 - spec.roughness), out, indent + 2);
        VRMLExporter.write("transparency " + Math.max(spec.transparent.getRed(), Math.max(spec.transparent.getGreen(), spec.transparent.getBlue())), out, indent + 2);
        VRMLExporter.write("ambientIntensity 1", out, indent + 2);
        VRMLExporter.write("}", out, indent + 1);
        if (hasMap) {
            VRMLExporter.write("texture ImageTexture {", out, indent + 1);
            VRMLExporter.write("url \"" + ti.diffuseFilename + "\"", out, indent + 2);
            VRMLExporter.write("}", out, indent + 1);
        }
        VRMLExporter.write("}", out, indent);
    }

    private static String translate(String str, int first, int count, String match, String replace) {
        count = count < 0 ? str.length() - first : Math.min(count, str.length());
        StringBuffer b = new StringBuffer(count);
        int pos = 0;
        char c = '\u0000';
        if (match == null) {
            match = "";
        }
        if (replace == null) {
            replace = "";
        }
        boolean copy = match.length() != 0 && match.length() >= replace.length();
        int max = first + count;
        for (int x = first; x < max; ++x) {
            c = str.charAt(x);
            pos = match.indexOf(c);
            if (pos >= 0) {
                if (pos >= replace.length()) continue;
                b.append(replace.charAt(pos));
                continue;
            }
            if (!copy && replace.indexOf(c) < match.length()) continue;
            b.append(c);
        }
        return b.toString();
    }
}

