/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.translators;

import artofillusion.ArtOfIllusion;
import artofillusion.Scene;
import artofillusion.TextureParameter;
import artofillusion.animation.PositionTrack;
import artofillusion.animation.RotationTrack;
import artofillusion.animation.Track;
import artofillusion.image.ImageMap;
import artofillusion.image.ImageOrColor;
import artofillusion.image.ImageOrValue;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.object.Curve;
import artofillusion.object.DirectionalLight;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.SceneCamera;
import artofillusion.object.TriangleMesh;
import artofillusion.texture.FaceParameterValue;
import artofillusion.texture.ImageMapTexture;
import artofillusion.texture.LayeredMapping;
import artofillusion.texture.LayeredTexture;
import artofillusion.texture.ParameterValue;
import artofillusion.texture.Texture;
import artofillusion.texture.Texture2D;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.UVMapping;
import artofillusion.texture.UniformTexture;
import artofillusion.ui.Translate;
import buoy.widget.BFileChooser;
import buoy.widget.BFrame;
import buoy.widget.BStandardDialog;
import buoy.widget.Widget;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OBJImporter {
    public static void importFile(BFrame parent) {
        BFileChooser bfc = new BFileChooser(BFileChooser.OPEN_FILE, Translate.text((String)"importOBJ"));
        if (ArtOfIllusion.getCurrentDirectory() != null) {
            bfc.setDirectory(new File(ArtOfIllusion.getCurrentDirectory()));
        }
        if (!bfc.showDialog((Widget)parent)) {
            return;
        }
        File f = bfc.getSelectedFile();
        ArtOfIllusion.setCurrentDirectory((String)bfc.getDirectory().getAbsolutePath());
        String objName = f.getName();
        if (objName.lastIndexOf(46) > 0) {
            objName = objName.substring(0, objName.lastIndexOf(46));
        }
        Scene theScene = new Scene();
        CoordinateSystem coords = new CoordinateSystem(new Vec3(0.0, 0.0, 20.0), new Vec3(0.0, 0.0, -1.0), Vec3.vy());
        ObjectInfo info = new ObjectInfo((Object3D)new SceneCamera(), coords, "Camera 1");
        info.addTrack((Track)new PositionTrack(info), 0);
        info.addTrack((Track)new RotationTrack(info), 1);
        theScene.addObject(info, null);
        info = new ObjectInfo((Object3D)new DirectionalLight(new RGBColor(1.0f, 1.0f, 1.0f), 0.8f), coords.duplicate(), "Light 1");
        info.addTrack((Track)new PositionTrack(info), 0);
        info.addTrack((Track)new RotationTrack(info), 1);
        theScene.addObject(info, null);
        Hashtable groupTable = new Hashtable();
        Hashtable<String, TextureInfo> textureTable = new Hashtable<String, TextureInfo>();
        Vector<Vec3> vertex = new Vector<Vec3>();
        Vector<Vec3> normal = new Vector<Vec3>();
        Vector<Vec3> texture = new Vector<Vec3>();
        Vector face = new Vector();
        face.add(new Vector());
        groupTable.put("default", face.get(0));
        int lineno = 0;
        int smoothingGroup = -1;
        String currentTexture = null;
        VertexInfo[] vertIndex = new VertexInfo[3];
        double[] val = new double[3];
        double[] min = new double[]{Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE};
        double[] max = new double[]{-1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308};
        BufferedReader in = null;
        try {
            File defaultMtl;
            String s;
            in = new BufferedReader(new FileReader(f));
            while ((s = in.readLine()) != null) {
                int i;
                String[] fields;
                ++lineno;
                if (s.startsWith("#")) continue;
                if (s.endsWith("\\")) {
                    String s2;
                    while (s.endsWith("\\") && (s2 = in.readLine()) != null) {
                        s = s.substring(0, s.length() - 1) + s2;
                    }
                }
                if ((fields = OBJImporter.breakLine(s)).length == 0) continue;
                if ("v".equals(fields[0]) && (fields.length == 4 || fields.length == 5)) {
                    for (i = 0; i < 3; ++i) {
                        try {
                            val[i] = Double.parseDouble(fields[i + 1]);
                            if (val[i] < min[i]) {
                                min[i] = val[i];
                            }
                            if (!(val[i] > max[i])) continue;
                            max[i] = val[i];
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new Exception("Illegal value '" + fields[i + 1] + "' found in line " + lineno + ".");
                        }
                    }
                    vertex.addElement(new Vec3(val[0], val[1], val[2]));
                    continue;
                }
                if ("vn".equals(fields[0]) && fields.length == 4) {
                    for (i = 0; i < 3; ++i) {
                        try {
                            val[i] = Double.parseDouble(fields[i + 1]);
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new Exception("Illegal value '" + fields[i + 1] + "' found in line " + lineno + ".");
                        }
                    }
                    normal.addElement(new Vec3(val[0], val[1], val[2]));
                    continue;
                }
                if ("vt".equals(fields[0]) && fields.length > 1) {
                    for (i = 0; i < 3; ++i) {
                        try {
                            if (i < fields.length - 1) {
                                val[i] = Double.parseDouble(fields[i + 1]);
                                continue;
                            }
                            val[i] = 0.0;
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new Exception("Illegal value '" + fields[i + 1] + "' found in line " + lineno + ".");
                        }
                    }
                    texture.addElement(new Vec3(val[0], val[1], val[2]));
                    continue;
                }
                if ("f".equals(fields[0])) {
                    if (vertIndex.length != fields.length - 1) {
                        vertIndex = new VertexInfo[fields.length - 1];
                    }
                    for (i = 0; i < vertIndex.length; ++i) {
                        vertIndex[i] = OBJImporter.parseVertexSpec(fields[i + 1], vertex, texture, normal, lineno);
                    }
                    for (i = 0; i < face.size(); ++i) {
                        if (fields.length == 4) {
                            ((Vector)face.get(i)).addElement(new FaceInfo(vertIndex[0], vertIndex[1], vertIndex[2], smoothingGroup, currentTexture));
                            continue;
                        }
                        Vec3[] v = new Vec3[fields.length - 1];
                        for (int j = 0; j < v.length; ++j) {
                            v[j] = (Vec3)vertex.get(vertIndex[j].vert);
                        }
                        Curve c = new Curve(v, new float[v.length], 0, true);
                        TriangleMesh m = c.convertToTriangleMesh(1.0);
                        if (m != null) {
                            for (int j = 0; j < m.getFaceCount(); ++j) {
                                ((Vector)face.get(i)).addElement(new FaceInfo(vertIndex[m.getFaceVertexIndex(j, 0)], vertIndex[m.getFaceVertexIndex(j, 1)], vertIndex[m.getFaceVertexIndex(j, 2)], smoothingGroup, currentTexture));
                            }
                            continue;
                        }
                        int step = 1;
                        while (2 * step < vertIndex.length) {
                            int start = 0;
                            while (start + 2 * step < vertIndex.length) {
                                ((Vector)face.get(i)).addElement(new FaceInfo(vertIndex[start], vertIndex[start + step], vertIndex[start + 2 * step], smoothingGroup, currentTexture));
                                start += 2 * step;
                            }
                            if (start + step < vertIndex.length) {
                                ((Vector)face.get(i)).addElement(new FaceInfo(vertIndex[start], vertIndex[start + step], vertIndex[0], smoothingGroup, currentTexture));
                            }
                            step *= 2;
                        }
                    }
                    continue;
                }
                if ("s".equals(fields[0])) {
                    if (fields.length == 1 || "off".equalsIgnoreCase(fields[1])) {
                        smoothingGroup = 0;
                        continue;
                    }
                    try {
                        smoothingGroup = Integer.parseInt(fields[1]);
                        continue;
                    }
                    catch (NumberFormatException ex) {
                        throw new Exception("Illegal value '" + fields[1] + "' found in line " + lineno + ".");
                    }
                }
                if ("g".equals(fields[0])) {
                    if (fields.length == 1) {
                        fields = new String[]{"g", "default"};
                    }
                    face.setSize(fields.length - 1);
                    for (i = 0; i < face.size(); ++i) {
                        face.set(i, groupTable.get(fields[i + 1]));
                        if (face.get(i) != null) continue;
                        face.set(i, new Vector());
                        groupTable.put(fields[i + 1], face.get(i));
                    }
                    continue;
                }
                if ("usemtl".equals(fields[0]) && fields.length > 1) {
                    currentTexture = fields[1];
                    continue;
                }
                if (!"mtllib".equals(fields[0])) continue;
                for (i = 1; i < fields.length; ++i) {
                    OBJImporter.parseTextures(fields[i], bfc.getDirectory(), textureTable);
                }
            }
            if (textureTable.size() == 0 && (defaultMtl = new File(bfc.getDirectory(), objName + ".mtl")).isFile()) {
                OBJImporter.parseTextures(objName + ".mtl", bfc.getDirectory(), textureTable);
            }
            double maxSize = Math.max(Math.max(max[0] - min[0], max[1] - min[1]), max[2] - min[2]);
            double scale = Math.pow(10.0, -Math.floor(Math.log(maxSize) / Math.log(10.0)));
            for (int i = 0; i < vertex.size(); ++i) {
                ((Vec3)vertex.elementAt(i)).scale(scale);
            }
            Enumeration keys = groupTable.keys();
            Hashtable<String, Texture> realizedTextures = new Hashtable<String, Texture>();
            Hashtable<String, ImageMap> imageMaps = new Hashtable<String, ImageMap>();
            while (keys.hasMoreElements()) {
                int i;
                String group = (String)keys.nextElement();
                Vector groupFaces = (Vector)groupTable.get(group);
                if (groupFaces.size() == 0) continue;
                int[] realIndex = new int[vertex.size()];
                for (int i2 = 0; i2 < realIndex.length; ++i2) {
                    realIndex[i2] = -1;
                }
                int[][] fc = new int[groupFaces.size()][];
                int numVert = 0;
                for (int i3 = 0; i3 < fc.length; ++i3) {
                    FaceInfo fi = (FaceInfo)groupFaces.elementAt(i3);
                    for (int j = 0; j < 3; ++j) {
                        if (realIndex[fi.getVertex((int)j).vert] != -1) continue;
                        realIndex[fi.getVertex((int)j).vert] = numVert++;
                    }
                    fc[i3] = new int[]{realIndex[fi.v1.vert], realIndex[fi.v2.vert], realIndex[fi.v3.vert]};
                }
                Vec3[] vert = new Vec3[numVert];
                Vec3 center = new Vec3();
                for (i = 0; i < realIndex.length; ++i) {
                    if (realIndex[i] <= -1) continue;
                    vert[realIndex[i]] = (Vec3)vertex.elementAt(i);
                    center.add(vert[realIndex[i]]);
                }
                center.scale(1.0 / (double)vert.length);
                for (i = 0; i < vert.length; ++i) {
                    vert[i] = vert[i].minus(center);
                }
                coords = new CoordinateSystem(center, Vec3.vz(), Vec3.vy());
                info = new ObjectInfo((Object3D)new TriangleMesh(vert, (int[][])fc), coords, "default".equals(group) ? objName : group);
                info.addTrack((Track)new PositionTrack(info), 0);
                info.addTrack((Track)new RotationTrack(info), 1);
                TriangleMesh.Edge[] edge = ((TriangleMesh)info.getObject()).getEdges();
                for (int i4 = 0; i4 < edge.length; ++i4) {
                    if (edge[i4].f2 == -1) continue;
                    FaceInfo f1 = (FaceInfo)groupFaces.elementAt(edge[i4].f1);
                    FaceInfo f2 = (FaceInfo)groupFaces.elementAt(edge[i4].f2);
                    if (f1.smoothingGroup == 0 || f1.smoothingGroup != f2.smoothingGroup) {
                        edge[i4].smoothness = 0.0f;
                        continue;
                    }
                    block33: for (int j = 0; j < 3; ++j) {
                        for (int k = 0; k < 3; ++k) {
                            if (f1.getVertex((int)j).vert != f2.getVertex((int)k).vert) continue;
                            int n1 = f1.getVertex((int)j).norm;
                            int n2 = f2.getVertex((int)k).norm;
                            if (n1 == n2 || !(((Vec3)normal.elementAt(n1)).distance((Vec3)normal.elementAt(n2)) > 1.0E-10)) continue block33;
                            edge[i4].smoothness = 0.0f;
                            continue block33;
                        }
                    }
                }
                HashSet<String> texNames = new HashSet<String>();
                for (FaceInfo faceInfo : groupFaces) {
                    if (faceInfo.texture == null) continue;
                    texNames.add(faceInfo.texture);
                }
                LayeredMapping layered = null;
                if (texNames.size() > 1) {
                    LayeredTexture tex = new LayeredTexture(info.getObject());
                    layered = (LayeredMapping)tex.getDefaultMapping(info.getObject());
                    info.setTexture((Texture)tex, (TextureMapping)layered);
                }
                for (String texName : texNames) {
                    Texture tex = (Texture)realizedTextures.get(texName);
                    if (tex == null) {
                        tex = OBJImporter.createTexture(textureTable.get(texName), texName, theScene, bfc.getDirectory(), imageMaps);
                        realizedTextures.put(texName, tex);
                    }
                    if (tex instanceof Texture2D) {
                        UVMapping map = new UVMapping(info.getObject(), tex);
                        if (layered == null) {
                            info.setTexture(tex, (TextureMapping)map);
                        } else {
                            layered.addLayer(0, tex, (TextureMapping)map, 0);
                            info.setTexture(layered.getTexture(), (TextureMapping)layered);
                        }
                        Vec2[] uv = new Vec2[numVert];
                        boolean needPerFace = false;
                        for (int j = 0; j < groupFaces.size() && !needPerFace; ++j) {
                            FaceInfo fi = (FaceInfo)groupFaces.elementAt(j);
                            for (int k = 0; k < 3; ++k) {
                                VertexInfo vi = fi.getVertex(k);
                                Vec3 texCoords = vi.tex < texture.size() ? (Vec3)texture.elementAt(vi.tex) : (Vec3)vertex.elementAt(vi.vert);
                                Vec2 tc = new Vec2(texCoords.x, texCoords.y);
                                if (uv[realIndex[vi.vert]] != null && !uv[realIndex[vi.vert]].equals((Object)tc)) {
                                    needPerFace = true;
                                }
                                uv[realIndex[vi.vert]] = tc;
                            }
                        }
                        TextureParameter uparam = map.getUParameter();
                        TextureParameter vparam = map.getVParameter();
                        if (layered != null) {
                            uparam = layered.getParameterForLayer(uparam, 0);
                            vparam = layered.getParameterForLayer(vparam, 0);
                        }
                        if (needPerFace) {
                            Vec2[][] uvf = new Vec2[groupFaces.size()][3];
                            for (int j = 0; j < groupFaces.size(); ++j) {
                                FaceInfo fi = (FaceInfo)groupFaces.elementAt(j);
                                for (int k = 0; k < 3; ++k) {
                                    VertexInfo vi = fi.getVertex(k);
                                    Vec3 texCoords = vi.tex < texture.size() ? (Vec3)texture.elementAt(vi.tex) : (Vec3)vertex.elementAt(vi.vert);
                                    uvf[j][k] = new Vec2(texCoords.x, texCoords.y);
                                }
                            }
                            map.setFaceTextureCoordinates(info.getObject(), uvf, uparam, vparam);
                        } else {
                            map.setTextureCoordinates(info.getObject(), uv, uparam, vparam);
                        }
                    } else if (layered == null) {
                        info.setTexture(tex, tex.getDefaultMapping(info.getObject()));
                    } else {
                        layered.addLayer(0, tex, tex.getDefaultMapping(info.getObject()), 0);
                        info.setTexture(layered.getTexture(), (TextureMapping)layered);
                    }
                    if (layered == null) continue;
                    double[] paramValue = new double[groupFaces.size()];
                    for (int i5 = 0; i5 < paramValue.length; ++i5) {
                        paramValue[i5] = texName.equals(((FaceInfo)groupFaces.get((int)i5)).texture) ? 1.0 : 0.0;
                    }
                    TextureParameter parameter = layered.getLayerBlendingParameter(0);
                    info.getObject().setParameterValue(parameter, (ParameterValue)new FaceParameterValue(paramValue));
                }
                theScene.addObject(info, null);
            }
        }
        catch (Exception ex) {
            try {
                in.close();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            new BStandardDialog("", (Object)new String[]{Translate.text((String)"errorLoadingFile"), ex.getMessage() == null ? "" : ex.getMessage()}, BStandardDialog.ERROR).showMessageDialog((Widget)parent);
            return;
        }
        ArtOfIllusion.newWindow((Scene)theScene);
    }

    private static String[] breakLine(String line) {
        StringTokenizer st = new StringTokenizer(line);
        Vector<String> v = new Vector<String>();
        while (st.hasMoreTokens()) {
            v.addElement(st.nextToken());
        }
        Object[] result = new String[v.size()];
        v.copyInto(result);
        return result;
    }

    private static VertexInfo parseVertexSpec(String spec, Vector vertex, Vector texture, Vector normal, int lineno) throws Exception {
        VertexInfo info = new VertexInfo();
        StringTokenizer st = new StringTokenizer(spec, "/", true);
        info.norm = Integer.MAX_VALUE;
        info.tex = Integer.MAX_VALUE;
        int i = 0;
        while (st.hasMoreTokens()) {
            String value = st.nextToken();
            if ("/".equals(value)) {
                ++i;
                continue;
            }
            try {
                int index = Integer.parseInt(value);
                int total = i == 0 ? vertex.size() : (i == 1 ? texture.size() : normal.size());
                index = index < 0 ? (index += total) : --index;
                if (i == 0) {
                    info.vert = index;
                    continue;
                }
                if (i == 1) {
                    info.tex = index;
                    continue;
                }
                info.norm = index;
            }
            catch (NumberFormatException ex) {
                throw new Exception("Illegal value '" + spec + "' found in line " + lineno + ".");
            }
        }
        if (info.tex == Integer.MAX_VALUE) {
            info.tex = info.vert;
        }
        if (info.norm == Integer.MAX_VALUE) {
            info.norm = info.vert;
        }
        return info;
    }

    private static void parseTextures(String file, File baseDir, Hashtable<String, TextureInfo> textures) throws Exception {
        String line;
        File f = new File(baseDir, file);
        if (!f.isFile()) {
            f = new File(file);
        }
        if (!f.isFile()) {
            new BStandardDialog("Error Importing File", (Object)("Cannot locate material file '" + file + "'."), BStandardDialog.ERROR).showMessageDialog(null);
            return;
        }
        BufferedReader in = new BufferedReader(new FileReader(f));
        TextureInfo currentTexture = null;
        while ((line = in.readLine()) != null) {
            try {
                String[] fields;
                if (line.startsWith("#") || (fields = OBJImporter.breakLine(line)).length == 0) continue;
                if ("newmtl".equals(fields[0])) {
                    currentTexture = null;
                    if (fields.length == 1 || textures.get(fields[1]) != null) continue;
                    currentTexture = new TextureInfo();
                    textures.put(fields[1], currentTexture);
                }
                if (currentTexture == null || fields.length < 2) continue;
                if ("Kd".equals(fields[0])) {
                    currentTexture.diffuse = OBJImporter.parseColor(fields);
                    continue;
                }
                if ("Ka".equals(fields[0])) {
                    currentTexture.ambient = OBJImporter.parseColor(fields);
                    continue;
                }
                if ("Ks".equals(fields[0])) {
                    currentTexture.specular = OBJImporter.parseColor(fields);
                    continue;
                }
                if ("d".equals(fields[0]) || "Tr".equals(fields[0])) {
                    currentTexture.transparency = 1.0 - Double.parseDouble(fields[1]);
                    continue;
                }
                if ("Ns".equals(fields[0])) {
                    currentTexture.shininess = Double.parseDouble(fields[1]);
                    continue;
                }
                if ("map_Kd".equals(fields[0])) {
                    currentTexture.diffuseMap = fields[1];
                    continue;
                }
                if ("map_Ka".equals(fields[0])) {
                    currentTexture.ambientMap = fields[1];
                    continue;
                }
                if ("map_Ks".equals(fields[0])) {
                    currentTexture.specularMap = fields[1];
                    continue;
                }
                if ("map_d".equals(fields[0])) {
                    currentTexture.transparentMap = fields[1];
                    continue;
                }
                if (!"map_Bump".equals(fields[0])) continue;
                currentTexture.bumpMap = fields[1];
            }
            catch (Exception ex) {
                in.close();
                throw new Exception("Illegal line '" + line + "' found in file '" + file + "'.");
            }
        }
        in.close();
    }

    private static Texture createTexture(TextureInfo info, String name, Scene scene, File baseDir, Hashtable<String, ImageMap> imageMaps) throws Exception {
        if (info == null) {
            ImageMapTexture tex = new ImageMapTexture();
            tex.setName(name);
            scene.addTexture((Texture)tex);
            return tex;
        }
        info.resolveColors();
        ImageMap diffuseMap = OBJImporter.loadMap(info.diffuseMap, scene, baseDir, imageMaps);
        ImageMap specularMap = OBJImporter.loadMap(info.specularMap, scene, baseDir, imageMaps);
        ImageMap transparentMap = OBJImporter.loadMap(info.transparentMap, scene, baseDir, imageMaps);
        ImageMap bumpMap = OBJImporter.loadMap(info.bumpMap, scene, baseDir, imageMaps);
        RGBColor transparentColor = new RGBColor(info.transparency, info.transparency, info.transparency);
        if (diffuseMap == null && specularMap == null && transparentMap == null && bumpMap == null) {
            UniformTexture tex = new UniformTexture();
            tex.diffuseColor = info.diffuse.duplicate();
            tex.specularColor = info.specular.duplicate();
            tex.transparentColor = transparentColor;
            tex.shininess = (float)info.specularity;
            tex.specularity = 0.0f;
            tex.roughness = info.roughness;
            tex.setName(name);
            scene.addTexture((Texture)tex);
            return tex;
        }
        ImageMapTexture tex = new ImageMapTexture();
        tex.diffuseColor = diffuseMap == null ? new ImageOrColor(info.diffuse) : new ImageOrColor(info.diffuse, diffuseMap);
        tex.specularColor = specularMap == null ? new ImageOrColor(info.specular) : new ImageOrColor(info.specular, specularMap);
        ImageOrColor imageOrColor = tex.transparentColor = transparentMap == null ? new ImageOrColor(transparentColor) : new ImageOrColor(transparentColor, transparentMap);
        if (transparentMap == null && info.transparency == 0.0 && diffuseMap != null && diffuseMap.getComponentCount() == 4) {
            tex.transparentColor = new ImageOrColor(new RGBColor(1.0, 1.0, 1.0));
            tex.transparency = new ImageOrValue(1.0f, diffuseMap, 3);
        }
        if (bumpMap != null) {
            tex.bump = new ImageOrValue(1.0f, bumpMap, 0);
        }
        tex.shininess = new ImageOrValue((float)info.specularity);
        tex.specularity = new ImageOrValue(0.0f);
        tex.roughness = new ImageOrValue((float)info.roughness);
        tex.tileY = true;
        tex.tileX = true;
        tex.mirrorY = false;
        tex.mirrorX = false;
        tex.setName(name);
        scene.addTexture((Texture)tex);
        return tex;
    }

    private static ImageMap loadMap(String name, Scene scene, File baseDir, Hashtable<String, ImageMap> imageMaps) throws Exception {
        if (name == null) {
            return null;
        }
        ImageMap map = imageMaps.get(name);
        if (map != null) {
            return map;
        }
        File f = new File(baseDir, name);
        if (!f.isFile()) {
            f = new File(name);
        }
        if (!f.isFile()) {
            throw new Exception("Cannot locate image map file '" + name + "'.");
        }
        try {
            map = ImageMap.loadImage((File)f);
        }
        catch (InterruptedException ex) {
            throw new Exception("Unable to load image map file '" + f.getAbsolutePath() + "'.");
        }
        scene.addImage(map);
        imageMaps.put(name, map);
        return map;
    }

    private static RGBColor parseColor(String[] fields) throws NumberFormatException {
        if (fields.length < 4) {
            return null;
        }
        return new RGBColor(Double.parseDouble(fields[1]), Double.parseDouble(fields[2]), Double.parseDouble(fields[3]));
    }

    private static class TextureInfo {
        public RGBColor ambient;
        public RGBColor diffuse;
        public RGBColor specular;
        public double shininess;
        public double transparency;
        public double specularity;
        public double roughness;
        public String ambientMap;
        public String diffuseMap;
        public String specularMap;
        public String transparentMap;
        public String bumpMap;

        private TextureInfo() {
        }

        public void resolveColors() {
            if (this.diffuse == null) {
                this.diffuse = this.diffuseMap == null ? new RGBColor(0.0, 0.0, 0.0) : new RGBColor(1.0, 1.0, 1.0);
            }
            if (this.ambient == null) {
                this.ambient = new RGBColor(0.0, 0.0, 0.0);
            }
            if (this.specular == null) {
                this.specular = new RGBColor(0.0, 0.0, 0.0);
            } else {
                this.specularity = 1.0;
            }
            this.diffuse.scale(1.0 - this.transparency);
            this.specular.scale(1.0 - this.transparency);
            this.roughness = 1.0 - (this.shininess - 1.0) / 128.0;
            if (this.roughness > 1.0) {
                this.roughness = 1.0;
            }
            this.checkColorRange(this.ambient);
            this.checkColorRange(this.diffuse);
            this.checkColorRange(this.specular);
        }

        private void checkColorRange(RGBColor c) {
            float r = c.getRed();
            float g = c.getGreen();
            float b = c.getBlue();
            if (r < 0.0f) {
                r = 0.0f;
            }
            if (r > 1.0f) {
                r = 1.0f;
            }
            if (g < 0.0f) {
                g = 0.0f;
            }
            if (g > 1.0f) {
                g = 1.0f;
            }
            if (b < 0.0f) {
                b = 0.0f;
            }
            if (b > 1.0f) {
                b = 1.0f;
            }
            c.setRGB(r, g, b);
        }
    }

    private static class FaceInfo {
        public VertexInfo v1;
        public VertexInfo v2;
        public VertexInfo v3;
        public int smoothingGroup;
        public String texture;

        public FaceInfo(VertexInfo v1, VertexInfo v2, VertexInfo v3, int smoothingGroup, String texture) {
            this.v1 = v1;
            this.v2 = v2;
            this.v3 = v3;
            this.smoothingGroup = smoothingGroup;
            this.texture = texture;
        }

        public VertexInfo getVertex(int which) {
            switch (which) {
                case 0: {
                    return this.v1;
                }
                case 1: {
                    return this.v2;
                }
            }
            return this.v3;
        }
    }

    private static class VertexInfo {
        public int vert;
        public int norm;
        public int tex;

        private VertexInfo() {
        }
    }
}

