package rescue.panels;

import rescue.*;
import rescue.spaceobjects.Ship;
import rescue.spaceobjects.ImageObject;

import javax.swing.JPanel;
import java.awt.Graphics;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputListener;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import java.awt.Point;
import javax.swing.JTextField;
import java.io.File;
import java.util.Vector;

public class InterfacePanel extends JPanel implements MouseInputListener {

    private RunRescue rescue;

    private mapButton[] ButtonImages;
    private Vector infoTexts;
    private Vector infoBars;
    private int width;
    private int height;
    private int[][] map;

    private BufferedImage img;
    private BufferedImage imgON;
    private int cc;
    private int pp;
    private int tt;

    private int COMMAND_STOP=-1;
    private int COMMAND_STOP2=-1;

    private int COMMAND_IMPULSE_AUTO=-1;
    private int COMMAND_IMPULSE_MAN=-1;
    private int COMMAND_IMPULSE_START=-1;
    private int COMMAND_IMPULSE_UP=-1;
    private int COMMAND_IMPULSE_DOWN=-1;

    private int COMMAND_WARP_AUTO=-1;
    private int COMMAND_WARP_MAN=-1;
    private int COMMAND_WARP_START=-1;
    private int COMMAND_WARP_UP=-1;
    private int COMMAND_WARP_DOWN=-1;

    private int COMMAND_PHASER_UP=-1;
    private int COMMAND_PHASER_DOWN=-1;
    private int COMMAND_PHASER_FIRE=-1;

    private int COMMAND_TORPEDO_UP=-1;
    private int COMMAND_TORPEDO_DOWN=-1;
    private int COMMAND_TORPEDO_FIRE=-1;

    private int COMMAND_SHIELDS_UP=-1;
    private int COMMAND_SHIELDS_DOWN=-1;

    private int COMMAND_TRACTOR=-1;
    private int COMMAND_TRACTOR_OFF=-1;

    private int COMMAND_ZOOMIN=-1;
    private int COMMAND_ZOOMOUT=-1;

    private int[] COMMAND_SELECT=new int[3];
//    private int COMMAND_SELECT_ALL=-1;
//    private int COMMAND_SELECT_ENEMIES=-1;
//    private int COMMAND_SELECT_NONE=-1;

    private int COMMAND_BEAM_DOWN=-1;
    private int COMMAND_BEAM_UP=-1;

    private int COMMAND_DOCK=-1;
    private int COMMAND_BOARD=-1;

    private int COMMAND_SCAN_UP=-1;
    private int COMMAND_SCAN_DOWN=-1;

    private int COMMAND_SHIPS_UP=-1;
    private int COMMAND_SHIPS_DOWN=-1;
    private int COMMAND_BASE_UP=-1;
    private int COMMAND_BASE_DOWN=-1;

    private int COMMAND_PAUSE=-1;
    private int COMMAND_HEADSUP=-1;

    private int COMMAND_RESERVE=-1;
    private int COMMAND_DIVERT=-1;

    private int COMMAND_EVASIVE_1=-1;
    private int COMMAND_EVASIVE_2=-1;
    private int COMMAND_EVASIVE_3=-1;

    private int COMMAND_ENDGAME=-1;
    private int COMMAND_HELP=-1;
    private int COMMAND_QUIT=-1;

    private int[] COMMAND_TARGET=new int[11];
    private int[] COMMAND_FIX=new int[11];

    private int[] COMMAND_SHIPS_SORT=new int[2];
    private int[] COMMAND_BASE_SORT=new int[2];

    private int[] COMMAND_SHIPS_SHOW=new int[4];
    private int[] COMMAND_BASE_SHOW=new int[4];

    private int[] COMMAND_WARP_SPEED=new int[9];
    private int[] COMMAND_IMPULSE_SPEED=new int[4];
    private int[] COMMAND_PHASER_INTENSITY=new int[3];
    private int[] COMMAND_TORPEDO_SALVO=new int[3];

    private infoText INFOTEXT_MAN_IMPULSE;
    private infoText INFOTEXT_MAN_WARP;

    private infoText INFOTEXT_IMPULSE_SPEED;
    private infoText INFOTEXT_IMPULSE_AUTO;
    private infoText INFOTEXT_WARP_SPEED;
    private infoText INFOTEXT_WARP_AUTO;

    private infoText INFOTEXT_PHASER;
    private infoText INFOTEXT_TORPEDO;

    private infoText INFOTEXT_SHIELDS_UP;
    private infoText INFOTEXT_SHIELDS_POWER;

    private infoText INFOTEXT_TOTAL_POWER;
    private infoText INFOTEXT_PHASER_BANKS;
    private infoText INFOTEXT_TORPEDOS_LEFT;

    private infoText INFOTEXT_SYSTEM_WARPDRIVE;
    private infoText INFOTEXT_SYSTEM_IMPULSEDRIVE;
    private infoText INFOTEXT_SYSTEM_PHASERBANKS;
    private infoText INFOTEXT_SYSTEM_TORPEDOTUBES;
    private infoText INFOTEXT_SYSTEM_LONGRANGESCAN;
    private infoText INFOTEXT_SYSTEM_SENSORSCAN;
    private infoText INFOTEXT_SYSTEM_SHIELDS;
    private infoText INFOTEXT_SYSTEM_COMPUTER;
    private infoText INFOTEXT_SYSTEM_TRANSPORTERS;
    private infoText INFOTEXT_SYSTEM_TRACTORBEAM;

    private infoText INFOTEXT_OUTPOSTS_RESCUED;
    private infoText INFOTEXT_OUTPOSTS_DESTROYED;
    private infoText INFOTEXT_OUTPOSTS_REMAINING;
    private infoText INFOTEXT_OTHERSHIPS_FRIENDLIES;
    private infoText INFOTEXT_OTHERSHIPS_ENEMIES;
    private infoText INFOTEXT_OTHERSHIPS_DESTROYED;

    private infoText INFOTEXT_COLONIES_ONBOARD;
    private infoText INFOTEXT_NUMBER_AWAY_TEAMS;

    private infoText INFOTEXT_SCAN;
    private infoText INFOTEXT_CONDITION;

    private infoBar INFOBAR_TOTAL_POWER;
    private infoBar INFOBAR_PHASER_BANKS;
    private infoBar INFOBAR_TORPEDOS_LEFT;
    private infoBar INFOBAR_TRACTOR_BEAM;
    private infoBar INFOBAR_SHIELD_POWER;

    public InterfacePanel(RunRescue rr,int w,int h) {
	this(rr);

	width = w;
	height = h;

    }

    public InterfacePanel(RunRescue rr) {

	rescue=rr;

	width = -1;
	height = -1;

	setLayout(null);

	//javax.swing.JLabel test = new javax.swing.JLabel("TEST");
	//test.setBounds(35,85,50,20);
	//add(test);

	cc=255;
	pp=255;
	tt=255;

	infoTexts = new Vector();
	infoBars = new Vector();

	for (int c=0; c<COMMAND_SELECT.length; c++) {
	    COMMAND_SELECT[c]=-1;
	}

	for (int c=0; c<COMMAND_TARGET.length; c++) {
	    COMMAND_TARGET[c]=-1;
	}
	for (int c=0; c<COMMAND_FIX.length; c++) {
	    COMMAND_FIX[c]=-1;
	}

	for (int c=0; c<COMMAND_SHIPS_SORT.length; c++) {
	    COMMAND_SHIPS_SORT[c]=-1;
	}
	for (int c=0; c<COMMAND_SHIPS_SHOW.length; c++) {
	    COMMAND_SHIPS_SHOW[c]=-1;
	}

	for (int c=0; c<COMMAND_BASE_SORT.length; c++) {
	    COMMAND_BASE_SORT[c]=-1;
	}
	for (int c=0; c<COMMAND_BASE_SHOW.length; c++) {
	    COMMAND_BASE_SHOW[c]=-1;
	}

	for (int c=0; c<COMMAND_WARP_SPEED.length; c++) {
	    COMMAND_WARP_SPEED[c]=-1;
	}
	for (int c=0; c<COMMAND_IMPULSE_SPEED.length; c++) {
	    COMMAND_IMPULSE_SPEED[c]=-1;
	}
	for (int c=0; c<COMMAND_PHASER_INTENSITY.length; c++) {
	    COMMAND_PHASER_INTENSITY[c]=-1;
	}
	for (int c=0; c<COMMAND_TORPEDO_SALVO.length; c++) {
	    COMMAND_TORPEDO_SALVO[c]=-1;
	}

	map=null;

    }

/*
    public void setupImage(String i) {

	try {
	    backImage = ImageIO.read( new File(i) );
	}
	catch (Exception e) { }


	impulseMan = new JTextField("0");
	impulseMan.setBounds(64,29,25,13);
	impulseMan.setBorder(null);
	impulseMan.setOpaque(false);

	warpMan = new JTextField("0");
	warpMan.setBounds(164,29,25,13);
	warpMan.setBorder(null);
	warpMan.setOpaque(false);

	add(impulseMan);
	add(warpMan);

    }

    public int insideButton(Point p) {


	if ( map[p.x][p.y] != 255 ) { return map[p.x][p.y]; }

	Rectangle cr;

	for (int i = 0; i < Rectangles.size() ; i++) {

	    if ( ((Rectangle)Rectangles.elementAt(i)).contains(p) ) {
		return i;
	    }

	}

	return 0;

    }

    public void setManImpulse(double a) {

	impulseMan.setText( (int)( Math.toDegrees(a) )+""); // Math.round

    }


	if (cc < ButtonImages.length ) {

	    if (pressed) { g.drawImage(ButtonImages[cc].getDownImage() ,ButtonImages[cc].getX1() ,ButtonImages[cc].getY1() ,this); }
	    else { g.drawImage(ButtonImages[cc].getUpImage() ,ButtonImages[cc].getX1() ,ButtonImages[cc].getY1() ,this); }

	}

	if (presseddown!=null) {
	    if (presseddown==highlight) { g.drawImage(presseddown.getDownImage() ,presseddown.getX1() ,presseddown.getY1() ,this); }
	}
	else if (highlight!=null) {
	    g.drawImage(highlight.getUpImage() ,highlight.getX1() ,highlight.getY1() ,this);
	}

*/

    public void setupImages(String sin_on,String sin_off,String sin_up,String sin_down,String sin_map, int nob) throws Exception {

	BufferedImage in_on = ImageIO.read( new File(sin_on) );

	if ((width != -1 && in_on.getWidth() != width) || (height != -1 && in_on.getHeight() != height)) {
	    throw new Exception("image \""+sin_on+"\" does not mach panel size");
	}


	width = in_on.getWidth();
	height = in_on.getHeight();

	Dimension size = new Dimension( width, height );

	setPreferredSize(size);
	setMinimumSize(size);
	setMaximumSize(size);


	BufferedImage in_off = ImageIO.read( new File(sin_off) );

	img = in_off;
	imgON = in_on; // needed for infoBars

	if (nob > 0) {

	  addMouseListener(this);
	  addMouseMotionListener(this);

	  BufferedImage in_up = ImageIO.read( new File(sin_up) );
	  BufferedImage in_down = ImageIO.read( new File(sin_down) );
	  BufferedImage in_map = ImageIO.read( new File(sin_map) );

	  //create map

	  int none = new Color(0, 0, 0, 0).getRGB();

	  //int noc = 6; // YURA: this number is unknown (10 means buttons go from 0-9)

	  int ppX = in_map.getWidth();
	  int ppY = in_map.getHeight();

	  map = new int[ppX][ppY];

	  ButtonImages = new mapButton[nob];
	  for (int c=0; c < nob; c++) {
	      ButtonImages[c] = new mapButton(ppX,ppY);
	  }

	  // create a very big 2d array with all the data from the image map
	  for(int y=0; y < ppY; y++) {

	    for(int x=0; x < ppX; x++) {

		int num= (in_map.getRGB(x,y))&0xff;

		// if ( num >= noc && num !=255 ) System.out.print("map error: "+x+" "+y+"\n"); // testing map

		if ( num < nob ) {

		    map[x][y]=num;

		    if (x < ButtonImages[num].getX1() ) { ButtonImages[num].setX1(x); }
		    if (x > ButtonImages[num].getX2() ) { ButtonImages[num].setX2(x); }

		    if (y < ButtonImages[num].getY1() ) { ButtonImages[num].setY1(y); }
		    if (y > ButtonImages[num].getY2() ) { ButtonImages[num].setY2(y); }
		}
		else {

		    map[x][y]=255;

		}

	    }
	  }

	  // create the bufferd image for each country
	  for (int c=0; c < ButtonImages.length ; c++) {

	    int x1=ButtonImages[c].getX1();
	    int x2=ButtonImages[c].getX2();
	    int y1=ButtonImages[c].getY1();
	    int y2=ButtonImages[c].getY2();
	    int w=ButtonImages[c].getWidth();
	    int h=ButtonImages[c].getHeight();

	    //System.out.print( "Country: "+ c +" X1: "+ x1 +" Y1: "+y1 +" X2: "+x2 +" Y2: "+y2 +" Width: "+ w +" Height: "+ h +"\n");

	    BufferedImage i_off = new BufferedImage(w, h, java.awt.image.BufferedImage.TYPE_INT_ARGB );
	    i_off.getGraphics().drawImage( in_off.getSubimage(x1, y1, w, h) ,0,0,this);

	    BufferedImage i_on = new BufferedImage(w, h, java.awt.image.BufferedImage.TYPE_INT_ARGB );
	    i_on.getGraphics().drawImage( in_on.getSubimage(x1, y1, w, h) ,0,0,this);

	    BufferedImage i_up = new BufferedImage(w, h, java.awt.image.BufferedImage.TYPE_INT_ARGB );
	    i_up.getGraphics().drawImage( in_up.getSubimage(x1, y1, w, h) ,0,0,this);

	    BufferedImage i_down = new BufferedImage(w, h, java.awt.image.BufferedImage.TYPE_INT_ARGB );
	    i_down.getGraphics().drawImage( in_down.getSubimage(x1, y1, w, h) ,0,0,this);

	    ButtonImages[c].setOffImage(i_off);
	    ButtonImages[c].setOnImage(i_on);
	    ButtonImages[c].setUpImage(i_up);
	    ButtonImages[c].setDownImage(i_down);

	    for(int y=y1; y <= y2; y++) {
		for(int x=0; x <= w-1; x++) {
		    if (map[x+x1][y] != (c) ) {
			i_off.setRGB( x, (y-y1), none); // clear the un-needed area!
			i_on.setRGB( x, (y-y1), none); // clear the un-needed area!
			i_up.setRGB( x, (y-y1), none); // clear the un-needed area!
			i_down.setRGB( x, (y-y1), none); // clear the un-needed area!
		    }
		}
	    }

	  }

	}

    }

    public void setCommandValue(String c,int v,String t) throws Exception {

	if (c.equals("impulse_auto")) {
	    COMMAND_IMPULSE_AUTO=v;
	}
	else if (c.equals("impulse_man")) {
	    COMMAND_IMPULSE_MAN=v;
	}
	else if (c.equals("impulse_start")) {
	    COMMAND_IMPULSE_START=v;
	}
	else if (c.equals("stop")) {
	    COMMAND_STOP=v;
	}
	else if (c.equals("stop2")) {
	    COMMAND_STOP2=v;
	}
	else if (c.equals("impulse_up")) {
	    COMMAND_IMPULSE_UP=v;
	}
	else if (c.equals("impulse_down")) {
	    COMMAND_IMPULSE_DOWN=v;
	}
	else if (c.equals("warp_auto")) {
	    COMMAND_WARP_AUTO=v;
	}
	else if (c.equals("warp_man")) {
	    COMMAND_WARP_MAN=v;
	}
	else if (c.equals("warp_start")) {
	    COMMAND_WARP_START=v;
	}
	else if (c.equals("warp_up")) {
	    COMMAND_WARP_UP=v;
	}
	else if (c.equals("warp_down")) {
	    COMMAND_WARP_DOWN=v;
	}
	else if (c.equals("phaser_up")) {
	    COMMAND_PHASER_UP=v;
	}
	else if (c.equals("phaser_down")) {
	    COMMAND_PHASER_DOWN=v;
	}
	else if (c.equals("phaser_fire")) {
	    COMMAND_PHASER_FIRE=v;
	}
	else if (c.equals("torpedo_up")) {
	    COMMAND_TORPEDO_UP=v;
	}
	else if (c.equals("torpedo_down")) {
	    COMMAND_TORPEDO_DOWN=v;
	}
	else if (c.equals("torpedo_fire")) {
	    COMMAND_TORPEDO_FIRE=v;
	}
	else if (c.equals("shields_up")) {
	    COMMAND_SHIELDS_UP=v;
	}
	else if (c.equals("shields_down")) {
	    COMMAND_SHIELDS_DOWN=v;
	}
	else if (c.equals("tractor")) {
	    COMMAND_TRACTOR=v;
	}
	else if (c.equals("tractor_off")) {
	    COMMAND_TRACTOR_OFF=v;
	}
	else if (c.equals("zoomin")) {
	    COMMAND_ZOOMIN=v;
	}
	else if (c.equals("zoomout")) {
	    COMMAND_ZOOMOUT=v;
	}
	else if (c.equals("select_all")) {
	    COMMAND_SELECT[ RunRescue.SELECT_ALL ]=v;
	}
	else if (c.equals("select_enemies")) {
	    COMMAND_SELECT[ RunRescue.SELECT_ENEMIES ]=v;
	}
	else if (c.equals("select_manual")) {
	    COMMAND_SELECT[ RunRescue.SELECT_MANUAL ]=v;
	}
	else if (c.equals("beam_down")) {
	    COMMAND_BEAM_DOWN=v;
	}
	else if (c.equals("beam_up")) {
	    COMMAND_BEAM_UP=v;
	}
	else if (c.equals("dock")) {
	    COMMAND_DOCK=v;
	}
	else if (c.equals("board")) {
	    COMMAND_BOARD=v;
	}
	else if (c.equals("scan_up")) {
	    COMMAND_SCAN_UP=v;
	}
	else if (c.equals("scan_down")) {
	    COMMAND_SCAN_DOWN=v;
	}
	else if (c.equals("ships_up")) {
	    COMMAND_SHIPS_UP=v;
	}
	else if (c.equals("ships_down")) {
	    COMMAND_SHIPS_DOWN=v;
	}
	else if (c.equals("base_up")) {
	    COMMAND_BASE_UP=v;
	}
	else if (c.equals("base_down")) {
	    COMMAND_BASE_DOWN=v;
	}
	else if (c.equals("pause")) {
	    COMMAND_PAUSE=v;
	}
	else if (c.equals("headsup")) {
	    COMMAND_HEADSUP=v;
	}
	else if (c.equals("reserve")) {
	    COMMAND_RESERVE=v;
	}
	else if (c.equals("divert")) {
	    COMMAND_DIVERT=v;
	}
	else if (c.equals("evasive 1")) {
	    COMMAND_EVASIVE_1=v;
	}
	else if (c.equals("evasive 2")) {
	    COMMAND_EVASIVE_2=v;
	}
	else if (c.equals("evasive 3")) {
	    COMMAND_EVASIVE_3=v;
	}

	else if (c.equals("endgame")) {
	    COMMAND_ENDGAME=v;
	}
	else if (c.equals("quit")) {
	    COMMAND_QUIT=v;
	}
	else if (c.equals("help")) {
	    COMMAND_HELP=v;
	}

	else if (c.startsWith("ships_sort")) {
	    COMMAND_SHIPS_SORT[ Integer.parseInt( c.substring(11) ) ]=v;
	}
	else if (c.startsWith("base_sort")) {
	    COMMAND_BASE_SORT[ Integer.parseInt( c.substring(10) ) ]=v;
	}

	else if (c.startsWith("ships_show")) {
	    COMMAND_SHIPS_SHOW[ Integer.parseInt( c.substring(11) ) ]=v;
	}
	else if (c.startsWith("base_show")) {
	    COMMAND_BASE_SHOW[ Integer.parseInt( c.substring(10) ) ]=v;
	}
	else if (c.startsWith("target")) {
	    COMMAND_TARGET[ Integer.parseInt( c.substring(7) ) ]=v;
	}
	else if (c.startsWith("fix")) {
	    COMMAND_FIX[ Integer.parseInt( c.substring(4) ) ]=v;
	}

	else if (c.startsWith("warp_speed")) {
	    COMMAND_WARP_SPEED[ Integer.parseInt( c.substring(11) )-1 ]=v;
	}
	else if (c.startsWith("impulse_speed")) {
	    COMMAND_IMPULSE_SPEED[ Integer.parseInt( c.substring(14) )-1 ]=v;
	}
	else if (c.startsWith("phaser_intensity")) {
	    COMMAND_PHASER_INTENSITY[ Integer.parseInt( c.substring(17) )-1 ]=v;
	}
	else if (c.startsWith("torpedo_salvo")) {
	    COMMAND_TORPEDO_SALVO[ Integer.parseInt( c.substring(14) )-1 ]=v;
	}

	else {
	    throw new Exception("unknown command "+c);
	}

	ButtonImages[v].setToolTip(t);

    }

    public void setInfoText(String c,int x,int y,int w,int h,int textX,int textY,Color z) throws Exception {

	BufferedImage back = img.getSubimage(x,y,w,h);
	infoText v = new infoText(back,x,y,textX,textY,z);
	infoTexts.add(v);

	if (c.equals("impulse_speed")) {
	    INFOTEXT_IMPULSE_SPEED=v;
	}
	else if (c.equals("impulse_auto")) {
	    INFOTEXT_IMPULSE_AUTO=v;
	}
	else if (c.equals("warp_speed")) {
	    INFOTEXT_WARP_SPEED=v;
	}
	else if (c.equals("warp_auto")) {
	    INFOTEXT_WARP_AUTO=v;
	}
	else if (c.equals("phaser")) {
	    INFOTEXT_PHASER=v;
	}
	else if (c.equals("torpedo")) {
	    INFOTEXT_TORPEDO=v;
	}
	else if (c.equals("shields_up")) {
	    INFOTEXT_SHIELDS_UP=v;
	}
	else if (c.equals("shields_power")) {
	    INFOTEXT_SHIELDS_POWER=v;
	}
	else if (c.equals("total_energy")) {
	    INFOTEXT_TOTAL_POWER=v;
	}
	else if (c.equals("phaser_banks")) {
	    INFOTEXT_PHASER_BANKS=v;
	}
	else if (c.equals("torpedos_left")) {
	    INFOTEXT_TORPEDOS_LEFT=v;
	}
	else if (c.equals("system_warpdrive")) {
	    INFOTEXT_SYSTEM_WARPDRIVE=v;
	}
	else if (c.equals("system_impulsedrive")) {
	    INFOTEXT_SYSTEM_IMPULSEDRIVE=v;
	}
	else if (c.equals("system_phaserbanks")) {
	    INFOTEXT_SYSTEM_PHASERBANKS=v;
	}
	else if (c.equals("system_torpedotubes")) {
	    INFOTEXT_SYSTEM_TORPEDOTUBES=v;
	}
	else if (c.equals("system_longrangescan")) {
	    INFOTEXT_SYSTEM_LONGRANGESCAN=v;
	}
	else if (c.equals("system_sencorscan")) {
	    INFOTEXT_SYSTEM_SENSORSCAN=v;
	}
	else if (c.equals("system_shields")) {
	    INFOTEXT_SYSTEM_SHIELDS=v;
	}
	else if (c.equals("system_computer")) {
	    INFOTEXT_SYSTEM_COMPUTER=v;
	}
	else if (c.equals("system_transporters")) {
	    INFOTEXT_SYSTEM_TRANSPORTERS=v;
	}
	else if (c.equals("system_tractorbeam")) {
	    INFOTEXT_SYSTEM_TRACTORBEAM=v;
	}
	else if (c.equals("outposts_rescued")) {
	    INFOTEXT_OUTPOSTS_RESCUED=v;
	}
	else if (c.equals("outposts_destroyed")) {
	    INFOTEXT_OUTPOSTS_DESTROYED=v;
	}
	else if (c.equals("outposts_remaining")) {
	    INFOTEXT_OUTPOSTS_REMAINING=v;
	}
	else if (c.equals("otherships_friendlies")) {
	    INFOTEXT_OTHERSHIPS_FRIENDLIES=v;
	}
	else if (c.equals("otherships_enemies")) {
	    INFOTEXT_OTHERSHIPS_ENEMIES=v;
	}
	else if (c.equals("otherships_destroyed")) {
	    INFOTEXT_OTHERSHIPS_DESTROYED=v;
	}
	else if (c.equals("colonies_onboard")) {
	    INFOTEXT_COLONIES_ONBOARD=v;
	}
	else if (c.equals("number_away_teams")) {
	    INFOTEXT_NUMBER_AWAY_TEAMS=v;
	}
	else if (c.equals("scan")) {
	    INFOTEXT_SCAN=v;
	}
	else if (c.equals("condition")) {
	    INFOTEXT_CONDITION=v;
	}
	else if (c.equals("man_impulse")) {
	    INFOTEXT_MAN_IMPULSE=v;
	}
	else if (c.equals("man_warp")) {
	    INFOTEXT_MAN_WARP=v;
	}
	else {
	    throw new Exception("unknown infotext "+c);
	}

    }

    public void setInfoBar(String c,int x,int y,int w,int h,String d) throws Exception {

	BufferedImage i1 = img.getSubimage(x,y,w,h);
	BufferedImage i2 = imgON.getSubimage(x,y,w,h);
	infoBar v = new infoBar(i1,i2,x,y,d);
	infoBars.add(v);

	if (c.equals("total_energy")) {
	    INFOBAR_TOTAL_POWER=v;
	}
	else if (c.equals("phaser_banks")) {
	    INFOBAR_PHASER_BANKS=v;
	}
	else if (c.equals("torpedos_left")) {
	    INFOBAR_TORPEDOS_LEFT=v;
	}
	else if (c.equals("tractor_beam")) {
	    INFOBAR_TRACTOR_BEAM=v;
	}
	else if (c.equals("shield_power")) {
	    INFOBAR_SHIELD_POWER=v;
	}
	else {
	    throw new Exception("unknown infobar "+c);
	}


    }

    public void list() {

	Ship ship = rescue.getShip();
	Graphics g = getGraphics();


	if (COMMAND_IMPULSE_AUTO!=-1 && ButtonImages[COMMAND_IMPULSE_AUTO].checkOn( ship.getAutoImpulseOn() ) ) {

	    ButtonImages[COMMAND_IMPULSE_MAN].checkOn( !ButtonImages[COMMAND_IMPULSE_AUTO].getOn() );
	    g.drawImage(ButtonImages[COMMAND_IMPULSE_AUTO].getOffImage() ,ButtonImages[COMMAND_IMPULSE_AUTO].getX1() ,ButtonImages[COMMAND_IMPULSE_AUTO].getY1() ,this);
	    g.drawImage(ButtonImages[COMMAND_IMPULSE_MAN].getOffImage() ,ButtonImages[COMMAND_IMPULSE_MAN].getX1() ,ButtonImages[COMMAND_IMPULSE_MAN].getY1() ,this);

	}

	if (COMMAND_WARP_AUTO!=-1 && ButtonImages[COMMAND_WARP_AUTO].checkOn( ship.getAutoWarpOn() ) ) {

	    ButtonImages[COMMAND_WARP_MAN].checkOn( !ButtonImages[COMMAND_WARP_AUTO].getOn() );
	    g.drawImage(ButtonImages[COMMAND_WARP_AUTO].getOffImage() ,ButtonImages[COMMAND_WARP_AUTO].getX1() ,ButtonImages[COMMAND_WARP_AUTO].getY1() ,this);
	    g.drawImage(ButtonImages[COMMAND_WARP_MAN].getOffImage() ,ButtonImages[COMMAND_WARP_MAN].getX1() ,ButtonImages[COMMAND_WARP_MAN].getY1() ,this);

	}

	// this is ok as it always starts of OFF
	if (COMMAND_TRACTOR_OFF!=-1 && ButtonImages[COMMAND_TRACTOR_OFF].checkOn( ship.getTractoredShip()==null ) ) {

	    ButtonImages[COMMAND_TRACTOR].checkOn( !ButtonImages[COMMAND_TRACTOR_OFF].getOn() );
	    g.drawImage(ButtonImages[COMMAND_TRACTOR_OFF].getOffImage() ,ButtonImages[COMMAND_TRACTOR_OFF].getX1() ,ButtonImages[COMMAND_TRACTOR_OFF].getY1() ,this);
	    g.drawImage(ButtonImages[COMMAND_TRACTOR].getOffImage() ,ButtonImages[COMMAND_TRACTOR].getX1() ,ButtonImages[COMMAND_TRACTOR].getY1() ,this);

	}

	if (COMMAND_SHIELDS_UP!=-1 && ButtonImages[COMMAND_SHIELDS_UP].checkOn( ship.getShieldsUp() ) ) {

	    g.drawImage(ButtonImages[COMMAND_SHIELDS_UP].getOffImage() ,ButtonImages[COMMAND_SHIELDS_UP].getX1() ,ButtonImages[COMMAND_SHIELDS_UP].getY1() ,this);

	}

	if (COMMAND_SHIELDS_DOWN!=-1 && ButtonImages[COMMAND_SHIELDS_DOWN].checkOn( !ship.getShieldsUp() ) ) {

	    g.drawImage(ButtonImages[COMMAND_SHIELDS_DOWN].getOffImage() ,ButtonImages[COMMAND_SHIELDS_DOWN].getX1() ,ButtonImages[COMMAND_SHIELDS_DOWN].getY1() ,this);

	}








	if (COMMAND_IMPULSE_START!=-1 && ButtonImages[COMMAND_IMPULSE_START].checkOn( ship.getImpulseOn() ) ) {

	    g.drawImage(ButtonImages[COMMAND_IMPULSE_START].getOffImage() ,ButtonImages[COMMAND_IMPULSE_START].getX1() ,ButtonImages[COMMAND_IMPULSE_START].getY1() ,this);

	}

	if (COMMAND_WARP_START!=-1 && ButtonImages[COMMAND_WARP_START].checkOn( ship.getWarpOn() ) ) {

	    g.drawImage(ButtonImages[COMMAND_WARP_START].getOffImage() ,ButtonImages[COMMAND_WARP_START].getX1() ,ButtonImages[COMMAND_WARP_START].getY1() ,this);

	}

	if (COMMAND_ZOOMIN!=-1 && ButtonImages[COMMAND_ZOOMIN].checkOn( !rescue.canZoom(true) ) ) {

	    g.drawImage(ButtonImages[COMMAND_ZOOMIN].getOffImage() ,ButtonImages[COMMAND_ZOOMIN].getX1() ,ButtonImages[COMMAND_ZOOMIN].getY1() ,this);

	}

	if (COMMAND_ZOOMOUT!=-1 && ButtonImages[COMMAND_ZOOMOUT].checkOn( !rescue.canZoom(false) ) ) {

	    g.drawImage(ButtonImages[COMMAND_ZOOMOUT].getOffImage() ,ButtonImages[COMMAND_ZOOMOUT].getX1() ,ButtonImages[COMMAND_ZOOMOUT].getY1() ,this);

	}








	if (COMMAND_SHIPS_UP!=-1 && ButtonImages[COMMAND_SHIPS_UP].checkOn( !rescue.canScrollShips(true,true) ) ) {

	    g.drawImage(ButtonImages[COMMAND_SHIPS_UP].getOffImage() ,ButtonImages[COMMAND_SHIPS_UP].getX1() ,ButtonImages[COMMAND_SHIPS_UP].getY1() ,this);

	}

	if (COMMAND_SHIPS_DOWN!=-1 && ButtonImages[COMMAND_SHIPS_DOWN].checkOn( !rescue.canScrollShips(true,false) ) ) {

	    g.drawImage(ButtonImages[COMMAND_SHIPS_DOWN].getOffImage() ,ButtonImages[COMMAND_SHIPS_DOWN].getX1() ,ButtonImages[COMMAND_SHIPS_DOWN].getY1() ,this);

	}

	if (COMMAND_BASE_UP!=-1 && ButtonImages[COMMAND_BASE_UP].checkOn( !rescue.canScrollShips(false,true) ) ) {

	    g.drawImage(ButtonImages[COMMAND_BASE_UP].getOffImage() ,ButtonImages[COMMAND_BASE_UP].getX1() ,ButtonImages[COMMAND_BASE_UP].getY1() ,this);

	}

	if (COMMAND_BASE_DOWN!=-1 && ButtonImages[COMMAND_BASE_DOWN].checkOn( !rescue.canScrollShips(false,false) ) ) {

	    g.drawImage(ButtonImages[COMMAND_BASE_DOWN].getOffImage() ,ButtonImages[COMMAND_BASE_DOWN].getX1() ,ButtonImages[COMMAND_BASE_DOWN].getY1() ,this);

	}






	// this asumed that all the targer options are on the same panel
	if (COMMAND_SELECT[0]!=-1) {

	  int t = rescue.getSelect();

	  if (ButtonImages [ COMMAND_SELECT[t] ].checkOn( true )) {

	    g.drawImage(ButtonImages[ COMMAND_SELECT[t] ].getOffImage() ,ButtonImages[ COMMAND_SELECT[t] ].getX1() ,ButtonImages[ COMMAND_SELECT[t] ].getY1() ,this);

	    for (int c=0;c< COMMAND_SELECT.length; c++) {

		if (c!=t && ButtonImages[ COMMAND_SELECT[c] ].checkOn( false ) ) {

		    g.drawImage(ButtonImages[ COMMAND_SELECT[c] ].getOffImage() ,ButtonImages[ COMMAND_SELECT[c] ].getX1() ,ButtonImages[ COMMAND_SELECT[c] ].getY1() ,this);
		    break;

		}

	    }

	  }

	}


	// this asumed that all the targer options are on the same panel
	if (COMMAND_SHIPS_SORT[0]!=-1) {

	  int t = rescue.getShipsSort();

	  if (ButtonImages [ COMMAND_SHIPS_SORT[t] ].checkOn( true )) {

	    g.drawImage(ButtonImages[ COMMAND_SHIPS_SORT[t] ].getOffImage() ,ButtonImages[ COMMAND_SHIPS_SORT[t] ].getX1() ,ButtonImages[ COMMAND_SHIPS_SORT[t] ].getY1() ,this);

	    for (int c=0;c< COMMAND_SHIPS_SORT.length; c++) {

		if (c!=t && ButtonImages[ COMMAND_SHIPS_SORT[c] ].checkOn( false ) ) {

		    g.drawImage(ButtonImages[ COMMAND_SHIPS_SORT[c] ].getOffImage() ,ButtonImages[ COMMAND_SHIPS_SORT[c] ].getX1() ,ButtonImages[ COMMAND_SHIPS_SORT[c] ].getY1() ,this);
		    break;

		}

	    }

	  }

	}

	// this asumed that all the targer options are on the same panel
	if (COMMAND_BASE_SORT[0]!=-1) {

	  int t = rescue.getBaseSort();

	  if (ButtonImages [ COMMAND_BASE_SORT[t] ].checkOn( true )) {

	    g.drawImage(ButtonImages[ COMMAND_BASE_SORT[t] ].getOffImage() ,ButtonImages[ COMMAND_BASE_SORT[t] ].getX1() ,ButtonImages[ COMMAND_BASE_SORT[t] ].getY1() ,this);

	    for (int c=0;c< COMMAND_BASE_SORT.length; c++) {

		if (c!=t && ButtonImages[ COMMAND_BASE_SORT[c] ].checkOn( false ) ) {

		    g.drawImage(ButtonImages[ COMMAND_BASE_SORT[c] ].getOffImage() ,ButtonImages[ COMMAND_BASE_SORT[c] ].getX1() ,ButtonImages[ COMMAND_BASE_SORT[c] ].getY1() ,this);
		    break;

		}

	    }

	  }

	}

	// this asumed that all the targer options are on the same panel
	if (COMMAND_SHIPS_SHOW[0]!=-1) {

	  int t = rescue.getShipsShow();

	  if (ButtonImages [ COMMAND_SHIPS_SHOW[t] ].checkOn( true )) {

	    g.drawImage(ButtonImages[ COMMAND_SHIPS_SHOW[t] ].getOffImage() ,ButtonImages[ COMMAND_SHIPS_SHOW[t] ].getX1() ,ButtonImages[ COMMAND_SHIPS_SHOW[t] ].getY1() ,this);

	    for (int c=0;c< COMMAND_SHIPS_SHOW.length; c++) {

		if (c!=t && ButtonImages[ COMMAND_SHIPS_SHOW[c] ].checkOn( false ) ) {

		    g.drawImage(ButtonImages[ COMMAND_SHIPS_SHOW[c] ].getOffImage() ,ButtonImages[ COMMAND_SHIPS_SHOW[c] ].getX1() ,ButtonImages[ COMMAND_SHIPS_SHOW[c] ].getY1() ,this);
		    break;

		}

	    }

	  }

	}

	// this asumed that all the targer options are on the same panel
	if (COMMAND_BASE_SHOW[0]!=-1) {

	  int t = rescue.getBaseShow();

	  if (ButtonImages [ COMMAND_BASE_SHOW[t] ].checkOn( true )) {

	    g.drawImage(ButtonImages[ COMMAND_BASE_SHOW[t] ].getOffImage() ,ButtonImages[ COMMAND_BASE_SHOW[t] ].getX1() ,ButtonImages[ COMMAND_BASE_SHOW[t] ].getY1() ,this);

	    for (int c=0;c< COMMAND_BASE_SHOW.length; c++) {

		if (c!=t && ButtonImages[ COMMAND_BASE_SHOW[c] ].checkOn( false ) ) {

		    g.drawImage(ButtonImages[ COMMAND_BASE_SHOW[c] ].getOffImage() ,ButtonImages[ COMMAND_BASE_SHOW[c] ].getX1() ,ButtonImages[ COMMAND_BASE_SHOW[c] ].getY1() ,this);
		    break;

		}

	    }

	  }

	}

	// this asumed that all the targer options are on the same panel
	if (COMMAND_TARGET[0]!=-1) {

	  int t = ship.getTarget();

	  if (ButtonImages [ COMMAND_TARGET[t] ].checkOn( true )) {

	    g.drawImage(ButtonImages[ COMMAND_TARGET[t] ].getOffImage() ,ButtonImages[ COMMAND_TARGET[t] ].getX1() ,ButtonImages[ COMMAND_TARGET[t] ].getY1() ,this);

	    for (int c=0;c< COMMAND_TARGET.length; c++) {

		if (c!=t && ButtonImages[ COMMAND_TARGET[c] ].checkOn( false ) ) {

		    g.drawImage(ButtonImages[ COMMAND_TARGET[c] ].getOffImage() ,ButtonImages[ COMMAND_TARGET[c] ].getX1() ,ButtonImages[ COMMAND_TARGET[c] ].getY1() ,this);
		    break;

		}

	    }

	  }

	}

	// this asumed that all the targer options are on the same panel
	if (COMMAND_FIX[0]!=-1) {

	  int t = ship.getFixPriority();

	  if (ButtonImages [ COMMAND_FIX[t] ].checkOn( true )) {

	    g.drawImage(ButtonImages[ COMMAND_FIX[t] ].getOffImage() ,ButtonImages[ COMMAND_FIX[t] ].getX1() ,ButtonImages[ COMMAND_FIX[t] ].getY1() ,this);

	    for (int c=0;c< COMMAND_FIX.length; c++) {

		if (c!=t && ButtonImages[ COMMAND_FIX[c] ].checkOn( false ) ) {

		    g.drawImage(ButtonImages[ COMMAND_FIX[c] ].getOffImage() ,ButtonImages[ COMMAND_FIX[c] ].getX1() ,ButtonImages[ COMMAND_FIX[c] ].getY1() ,this);
		    break;

		}

	    }

	  }

	}



	// this asumed that all the targer options are on the same panel
	if (COMMAND_WARP_SPEED[0]!=-1) {

	  int t = ship.getWarpFactor()-1;

	  if (ButtonImages [ COMMAND_WARP_SPEED[t] ].checkOn( true )) {

	    g.drawImage(ButtonImages[ COMMAND_WARP_SPEED[t] ].getOffImage() ,ButtonImages[ COMMAND_WARP_SPEED[t] ].getX1() ,ButtonImages[ COMMAND_WARP_SPEED[t] ].getY1() ,this);

	    for (int c=0;c< COMMAND_WARP_SPEED.length; c++) {

		if (c!=t && ButtonImages[ COMMAND_WARP_SPEED[c] ].checkOn( false ) ) {

		    g.drawImage(ButtonImages[ COMMAND_WARP_SPEED[c] ].getOffImage() ,ButtonImages[ COMMAND_WARP_SPEED[c] ].getX1() ,ButtonImages[ COMMAND_WARP_SPEED[c] ].getY1() ,this);
		    break;

		}

	    }

	  }

	}




	// this asumed that all the targer options are on the same panel
	if (COMMAND_IMPULSE_SPEED[0]!=-1) {

	  int t = (int)(ship.getImpulseFactor()*4)-1;

	  if (ButtonImages [ COMMAND_IMPULSE_SPEED[t] ].checkOn( true )) {

	    g.drawImage(ButtonImages[ COMMAND_IMPULSE_SPEED[t] ].getOffImage() ,ButtonImages[ COMMAND_IMPULSE_SPEED[t] ].getX1() ,ButtonImages[ COMMAND_IMPULSE_SPEED[t] ].getY1() ,this);

	    for (int c=0;c< COMMAND_IMPULSE_SPEED.length; c++) {

		if (c!=t && ButtonImages[ COMMAND_IMPULSE_SPEED[c] ].checkOn( false ) ) {

		    g.drawImage(ButtonImages[ COMMAND_IMPULSE_SPEED[c] ].getOffImage() ,ButtonImages[ COMMAND_IMPULSE_SPEED[c] ].getX1() ,ButtonImages[ COMMAND_IMPULSE_SPEED[c] ].getY1() ,this);
		    break;

		}

	    }

	  }

	}





	// this asumed that all the targer options are on the same panel
	if (COMMAND_PHASER_INTENSITY[0]!=-1) {

	  int t = ship.getPhaserIntensityInt()-1;

	  if (ButtonImages [ COMMAND_PHASER_INTENSITY[t] ].checkOn( true )) {

	    g.drawImage(ButtonImages[ COMMAND_PHASER_INTENSITY[t] ].getOffImage() ,ButtonImages[ COMMAND_PHASER_INTENSITY[t] ].getX1() ,ButtonImages[ COMMAND_PHASER_INTENSITY[t] ].getY1() ,this);

	    for (int c=0;c< COMMAND_PHASER_INTENSITY.length; c++) {

		if (c!=t && ButtonImages[ COMMAND_PHASER_INTENSITY[c] ].checkOn( false ) ) {

		    g.drawImage(ButtonImages[ COMMAND_PHASER_INTENSITY[c] ].getOffImage() ,ButtonImages[ COMMAND_PHASER_INTENSITY[c] ].getX1() ,ButtonImages[ COMMAND_PHASER_INTENSITY[c] ].getY1() ,this);
		    break;

		}

	    }

	  }

	}





	// this asumed that all the targer options are on the same panel
	if (COMMAND_TORPEDO_SALVO[0]!=-1) {

	  int t = ship.getTorpedoSalvoInt()-1;

	  if (ButtonImages [ COMMAND_TORPEDO_SALVO[t] ].checkOn( true )) {

	    g.drawImage(ButtonImages[ COMMAND_TORPEDO_SALVO[t] ].getOffImage() ,ButtonImages[ COMMAND_TORPEDO_SALVO[t] ].getX1() ,ButtonImages[ COMMAND_TORPEDO_SALVO[t] ].getY1() ,this);

	    for (int c=0;c< COMMAND_TORPEDO_SALVO.length; c++) {

		if (c!=t && ButtonImages[ COMMAND_TORPEDO_SALVO[c] ].checkOn( false ) ) {

		    g.drawImage(ButtonImages[ COMMAND_TORPEDO_SALVO[c] ].getOffImage() ,ButtonImages[ COMMAND_TORPEDO_SALVO[c] ].getX1() ,ButtonImages[ COMMAND_TORPEDO_SALVO[c] ].getY1() ,this);
		    break;

		}

	    }

	  }

	}


	// ############################# INFO TEXT




	if (INFOTEXT_IMPULSE_SPEED!=null && INFOTEXT_IMPULSE_SPEED.checkOn( ship.getImpulseSpeed() ) ) {

	    INFOTEXT_IMPULSE_SPEED.draw(g,true);

	}

	if (INFOTEXT_IMPULSE_AUTO!=null ) {

	    Point i = ship.getAutoImpulse();
	    String impulse;

	    if (i==null) {
		impulse = "  -- NOT SET --";
	    }
	    else if (i instanceof ImageObject) {
		impulse = ((ImageObject)i).getName();
		if (impulse.length() > 13) { impulse = impulse.substring(0,11) + "..."; }
	    }
	    else {
		impulse = i.x+","+i.y;
	    }

	    if ( INFOTEXT_IMPULSE_AUTO.checkOn( impulse ) ) {

		INFOTEXT_IMPULSE_AUTO.draw(g,true);
	    }

	}

	if (INFOTEXT_WARP_SPEED!=null && INFOTEXT_WARP_SPEED.checkOn( ship.getWarpSpeed() ) ) {

	    INFOTEXT_WARP_SPEED.draw(g,true);

	}

	if (INFOTEXT_WARP_AUTO!=null) {

	    Point w = ship.getAutoWarp();
	    String warp;

	    if (w==null) {
		warp = "  -- NOT SET --";
	    }
	    else if (w instanceof ImageObject) {
		warp = ((ImageObject)w).getName();
		if (warp.length() > 13) { warp = warp.substring(0,11) + "..."; }
	    }
	    else {
		warp = w.x+","+w.y;
	    }

	    if ( INFOTEXT_WARP_AUTO.checkOn( warp ) ) {

		INFOTEXT_WARP_AUTO.draw(g,true);

	    }

	}

	if (INFOTEXT_PHASER!=null && INFOTEXT_PHASER.checkOn( ship.getPhaserIntensity() ) ) {

	    INFOTEXT_PHASER.draw(g,true);

	}

	if (INFOTEXT_TORPEDO!=null && INFOTEXT_TORPEDO.checkOn( ship.getTorpedoSalvo() ) ) {

	    INFOTEXT_TORPEDO.draw(g,true);

	}

	if (INFOTEXT_SHIELDS_UP!=null && INFOTEXT_SHIELDS_UP.checkOn( (ship.getShieldsUp())?("ON"):("OFF") ) ) {

	    INFOTEXT_SHIELDS_UP.draw(g,true);

	}

	if (INFOTEXT_SHIELDS_POWER!=null && INFOTEXT_SHIELDS_POWER.checkOn( ((int)((ship.getShieldPower()/(double)ship.getMaxshieldpower())*100))+"" ) ) {

	    INFOTEXT_SHIELDS_POWER.draw(g,true);

	}

	if (INFOTEXT_TOTAL_POWER!=null && INFOTEXT_TOTAL_POWER.checkOn( ship.getTotalEnergy()+"" ) ) {

	    INFOTEXT_TOTAL_POWER.draw(g,true);

	}

	if (INFOTEXT_PHASER_BANKS!=null && INFOTEXT_PHASER_BANKS.checkOn( ship.getPhaserBanks()+"" ) ) {

	    INFOTEXT_PHASER_BANKS.draw(g,true);

	}

	if (INFOTEXT_TORPEDOS_LEFT!=null && INFOTEXT_TORPEDOS_LEFT.checkOn( ship.getTorpedosLeft()+"" ) ) {

	    INFOTEXT_TORPEDOS_LEFT.draw(g,true);

	}

	if (INFOTEXT_SYSTEM_WARPDRIVE!=null && INFOTEXT_SYSTEM_WARPDRIVE.checkOn( ship.getSystemText(1) ) ) {

	    INFOTEXT_SYSTEM_WARPDRIVE.draw(g,true);

	}
	if (INFOTEXT_SYSTEM_IMPULSEDRIVE!=null && INFOTEXT_SYSTEM_IMPULSEDRIVE.checkOn( ship.getSystemText(2) ) ) {

	    INFOTEXT_SYSTEM_IMPULSEDRIVE.draw(g,true);

	}
	if (INFOTEXT_SYSTEM_PHASERBANKS!=null && INFOTEXT_SYSTEM_PHASERBANKS.checkOn( ship.getSystemText(3) ) ) {

	    INFOTEXT_SYSTEM_PHASERBANKS.draw(g,true);

	}
	if (INFOTEXT_SYSTEM_TORPEDOTUBES!=null && INFOTEXT_SYSTEM_TORPEDOTUBES.checkOn( ship.getSystemText(4) ) ) {

	    INFOTEXT_SYSTEM_TORPEDOTUBES.draw(g,true);

	}
	if (INFOTEXT_SYSTEM_LONGRANGESCAN!=null && INFOTEXT_SYSTEM_LONGRANGESCAN.checkOn( ship.getSystemText(5) ) ) {

	    INFOTEXT_SYSTEM_LONGRANGESCAN.draw(g,true);

	}
	if (INFOTEXT_SYSTEM_SENSORSCAN!=null && INFOTEXT_SYSTEM_SENSORSCAN.checkOn( ship.getSystemText(6) ) ) {

	    INFOTEXT_SYSTEM_SENSORSCAN.draw(g,true);

	}
	if (INFOTEXT_SYSTEM_SHIELDS!=null && INFOTEXT_SYSTEM_SHIELDS.checkOn( ship.getSystemText(7) ) ) {

	    INFOTEXT_SYSTEM_SHIELDS.draw(g,true);

	}
	if (INFOTEXT_SYSTEM_COMPUTER!=null && INFOTEXT_SYSTEM_COMPUTER.checkOn( ship.getSystemText(8) ) ) {

	    INFOTEXT_SYSTEM_COMPUTER.draw(g,true);

	}
	if (INFOTEXT_SYSTEM_TRANSPORTERS!=null && INFOTEXT_SYSTEM_TRANSPORTERS.checkOn( ship.getSystemText(9) ) ) {

	    INFOTEXT_SYSTEM_TRANSPORTERS.draw(g,true);

	}
	if (INFOTEXT_SYSTEM_TRACTORBEAM!=null && INFOTEXT_SYSTEM_TRACTORBEAM.checkOn( ship.getSystemText(10) ) ) {

	    INFOTEXT_SYSTEM_TRACTORBEAM.draw(g,true);

	}

	if (INFOTEXT_OUTPOSTS_RESCUED!=null && INFOTEXT_OUTPOSTS_RESCUED.checkOn( rescue.getBaseNumbers(1)+"" ) ) {

	    INFOTEXT_OUTPOSTS_RESCUED.draw(g,true);

	}
	if (INFOTEXT_OUTPOSTS_DESTROYED!=null && INFOTEXT_OUTPOSTS_DESTROYED.checkOn( rescue.getBaseNumbers(2)+"" ) ) {

	    INFOTEXT_OUTPOSTS_DESTROYED.draw(g,true);

	}
	if (INFOTEXT_OUTPOSTS_REMAINING!=null && INFOTEXT_OUTPOSTS_REMAINING.checkOn( rescue.getBaseNumbers(3)+"" ) ) {

	    INFOTEXT_OUTPOSTS_REMAINING.draw(g,true);

	}
	if (INFOTEXT_OTHERSHIPS_FRIENDLIES!=null && INFOTEXT_OTHERSHIPS_FRIENDLIES.checkOn( rescue.getShipNumbers(1)+"" ) ) {

	    INFOTEXT_OTHERSHIPS_FRIENDLIES.draw(g,true);

	}
	if (INFOTEXT_OTHERSHIPS_ENEMIES!=null && INFOTEXT_OTHERSHIPS_ENEMIES.checkOn( rescue.getShipNumbers(2)+"" ) ) {

	    INFOTEXT_OTHERSHIPS_ENEMIES.draw(g,true);

	}
	if (INFOTEXT_OTHERSHIPS_DESTROYED!=null && INFOTEXT_OTHERSHIPS_DESTROYED.checkOn( rescue.getShipNumbers(3)+"" ) ) {

	    INFOTEXT_OTHERSHIPS_DESTROYED.draw(g,true);

	}

	if (INFOTEXT_COLONIES_ONBOARD!=null && INFOTEXT_COLONIES_ONBOARD.checkOn( ship.getNoColonies()+"" ) ) {

	    INFOTEXT_COLONIES_ONBOARD.draw(g,true);

	}
	if (INFOTEXT_NUMBER_AWAY_TEAMS!=null && INFOTEXT_NUMBER_AWAY_TEAMS.checkOn( ship.getNoAwayTeams()+"" ) ) {

	    INFOTEXT_NUMBER_AWAY_TEAMS.draw(g,true);

	}
	if (INFOTEXT_SCAN!=null && INFOTEXT_SCAN.checkOn( ship.getScan() ) ) {

	    INFOTEXT_SCAN.draw(g,true);

	}

	if (INFOTEXT_MAN_IMPULSE!=null && INFOTEXT_MAN_IMPULSE.checkOn( ship.getManImpulse()+"" ) ) {

	    INFOTEXT_MAN_IMPULSE.draw(g,true);

	}
	if (INFOTEXT_MAN_WARP!=null && INFOTEXT_MAN_WARP.checkOn( ship.getManWarp()+"" ) ) {

	    INFOTEXT_MAN_WARP.draw(g,true);

	}

	if (INFOTEXT_CONDITION!=null) {

	    int con = ship.getCondition();

	    String condition;
	    Color conColor;

	    if (con==1) {
		condition = " Green";
		conColor = Color.GREEN.darker().darker();
	    }
	    else if (con==2) {
		condition = " Yellow";
		conColor = Color.YELLOW;
	    }
	    else {
		condition = "* RED *";
		conColor = Color.RED.darker().darker();
	    }
	    

	    if (INFOTEXT_CONDITION.checkOn( condition ) ) {

		INFOTEXT_CONDITION.setColor( conColor );

		INFOTEXT_CONDITION.draw(g,true);
	    }

	}

	// ################### INFO BARS

	if (INFOBAR_TOTAL_POWER!=null && INFOBAR_TOTAL_POWER.checkOn( ship.getTotalEnergy(), ship.getMaxtotalenergy() ) ) {

	    INFOBAR_TOTAL_POWER.draw(g,true);

	}

	if (INFOBAR_PHASER_BANKS!=null && INFOBAR_PHASER_BANKS.checkOn( ship.getPhaserBanks(), ship.getMaxphaserbanks() ) ) {

	    INFOBAR_PHASER_BANKS.draw(g,true);

	}

	if (INFOBAR_TORPEDOS_LEFT!=null && INFOBAR_TORPEDOS_LEFT.checkOn( ship.getTorpedosLeft(), ship.getMaxtorpedosleft() ) ) {

	    INFOBAR_TORPEDOS_LEFT.draw(g,true);

	}

	if (INFOBAR_TRACTOR_BEAM!=null && INFOBAR_TRACTOR_BEAM.checkOn( ship.getTractorBeamPower(), ship.getTractorBeamMaxPower() ) ) {

	    INFOBAR_TRACTOR_BEAM.draw(g,true);

	}

	if (INFOBAR_SHIELD_POWER!=null && INFOBAR_SHIELD_POWER.checkOn( ship.getShieldPower(), ship.getMaxshieldpower() ) ) {

	    INFOBAR_SHIELD_POWER.draw(g,true);

	}

    }

    public void paintComponent(Graphics g) {

	// if something is on it should not highlight

	g.drawImage(img,0,0,this.getWidth(),this.getHeight(),this);

	if (map!=null) {

	  if (pp != 255) {

	    g.drawImage(ButtonImages[pp].getDownImage() ,ButtonImages[pp].getX1() ,ButtonImages[pp].getY1() ,this);

	  }
	  else if (cc != 255) {

	    g.drawImage(ButtonImages[cc].getUpImage() ,ButtonImages[cc].getX1() ,ButtonImages[cc].getY1() ,this);

	  }

	  for (int i = 0; i < ButtonImages.length ; i++) {

	    if ( ButtonImages[i].getOn() ) {

		g.drawImage(ButtonImages[i].getOffImage() ,ButtonImages[i].getX1() ,ButtonImages[i].getY1() ,this);

	    }

	  }

	}

	for (int i = 0; i < infoTexts.size() ; i++) {
	    ((infoText)infoTexts.elementAt(i)).draw(g,false);
	}

	for (int i = 0; i < infoBars.size() ; i++) {
	    ((infoBar)infoBars.elementAt(i)).draw(g,false);
	}

    }

    public void command(int a) {

	Ship ship = rescue.getShip();
	boolean done=true;

	if (a==COMMAND_IMPULSE_AUTO) {

		ship.setAutoImpulseOn(true);

	}
	else if (a==COMMAND_IMPULSE_MAN) {

		ship.setAutoImpulseOn(false);

	}
	else if (a==COMMAND_IMPULSE_START) {

		ship.setImpulseOn(true);

	}
	else if (a==COMMAND_STOP || a==COMMAND_STOP2) {

		ship.stop();

	}
	else if (a==COMMAND_IMPULSE_UP) {

		ship.setImpulseUpDown(true);

	}
	else if (a==COMMAND_IMPULSE_DOWN) {

		ship.setImpulseUpDown(false);

	}
	else if (a==COMMAND_WARP_AUTO) {

		ship.setAutoWarpOn(true);

	}
	else if (a==COMMAND_WARP_MAN) {

		ship.setAutoWarpOn(false);

	}
	else if (a==COMMAND_WARP_START) {

		ship.setWarpOn(true);

	}
	else if (a==COMMAND_WARP_UP) {

		ship.setWarpUpDown(true);

	}
	else if (a==COMMAND_WARP_DOWN) {

		ship.setWarpUpDown(false);

	}
	else if (a==COMMAND_PHASER_UP) {

		ship.setPhaserIntensityUpDown(true);

	}
	else if (a==COMMAND_PHASER_DOWN) {

		ship.setPhaserIntensityUpDown(false);

	}
	else if (a==COMMAND_PHASER_FIRE) {

		rescue.shipFirePhaser();

	}
	else if (a==COMMAND_TORPEDO_UP) {

		ship.setTorpedoSalvoUpDown(true);

	}
	else if (a==COMMAND_TORPEDO_DOWN) {

		ship.setTorpedoSalvoUpDown(false);

	}
	else if (a==COMMAND_TORPEDO_FIRE) {

		rescue.shipFireTorpedo();

	}
	else if (a==COMMAND_SHIELDS_UP || a==COMMAND_SHIELDS_DOWN) {

		ship.changeShields();

	}
	else if (a==COMMAND_TRACTOR || a==COMMAND_TRACTOR_OFF) {

		rescue.shipTractorShip();

	}
	else if (a==COMMAND_ZOOMIN) {

		rescue.zoom(true);

	}
	else if (a==COMMAND_ZOOMOUT) {

		rescue.zoom(false);

	}
	else if (a==COMMAND_BEAM_DOWN) {

		rescue.shipBeamDown();

	}
	else if (a==COMMAND_BEAM_UP) {

		rescue.shipBeamUp();

	}
	else if (a==COMMAND_DOCK) {

		rescue.shipDock();

	}
	else if (a==COMMAND_BOARD) {

		rescue.shipBoard();

	}
	else if (a==COMMAND_SCAN_UP) {

		ship.setScan(true);
		rescue.updateGUI();

	}
	else if (a==COMMAND_SCAN_DOWN) {

		ship.setScan(false);
		rescue.updateGUI();

	}
	else if (a==COMMAND_SHIPS_UP) {

		rescue.scrollShips(true,true);

	}
	else if (a==COMMAND_SHIPS_DOWN) {

		rescue.scrollShips(true,false);

	}
	else if (a==COMMAND_BASE_UP) {

		rescue.scrollShips(false,true);

	}
	else if (a==COMMAND_BASE_DOWN) {

		rescue.scrollShips(false,false);

	}
	else if (a==COMMAND_PAUSE) {

		rescue.pause();

	}
	else if (a==COMMAND_HEADSUP) {

		rescue.headsUpDisplay();

	}
	else if (a==COMMAND_RESERVE) {

		ship.useReserve();

	}
	else if (a==COMMAND_DIVERT) {

		ship.divertPhaser();

	}
	else if (a==COMMAND_EVASIVE_1) {

		ship.setEvasive(1);

	}
	else if (a==COMMAND_EVASIVE_2) {

		ship.setEvasive(2);

	}
	else if (a==COMMAND_EVASIVE_3) {

		ship.setEvasive(3);

	}
	else if (a==COMMAND_ENDGAME) {

		//removeMouseListener(this);
		//removeMouseMotionListener(this);

		rescue.closeCurrentMission();
		cc=255;
		pp=255;
		tt=255;
		return;

	}
	else if (a==COMMAND_HELP) {

		 rescue.help();

	}
	else if (a==COMMAND_QUIT) {

		 System.exit(0);

	}
	else {

	    done=false;


	  if (COMMAND_SELECT[0]!=-1) {
	    for(int c=0; c<COMMAND_SELECT.length; c++) {
		if (a==COMMAND_SELECT[c]) {
		    rescue.setSelect(c);
		    done=true;
		    break;
		}
	    }
	  }

	  if (done==false && COMMAND_TARGET[0]!=-1) {
	    for(int c=0; c<COMMAND_TARGET.length; c++) {
		if (a==COMMAND_TARGET[c]) {
		    ship.setTarget(c);
		    done=true;
		    break;
		}
	    }
	  }

	  if (done==false && COMMAND_FIX[0]!=-1) {
	    for(int c=0; c<COMMAND_FIX.length; c++) {
		if (a==COMMAND_FIX[c]) {
		    ship.setFixPriority(c);
		    done=true;
		    break;
		}
	    }
	  }

	  if (done==false && COMMAND_SHIPS_SORT[0]!=-1) {
	    for(int c=0; c<COMMAND_SHIPS_SORT.length; c++) {
		if (a==COMMAND_SHIPS_SORT[c]) {
		    rescue.setShipsSort(c);
		    done=true;
		    break;
		}
	    }
	  }

	  if (done==false && COMMAND_BASE_SORT[0]!=-1) {
	    for(int c=0; c<COMMAND_BASE_SORT.length; c++) {
		if (a==COMMAND_BASE_SORT[c]) {
		    rescue.setBaseSort(c);
		    done=true;
		    break;
		}
	    }
	  }

	  if (done==false && COMMAND_SHIPS_SHOW[0]!=-1) {
	    for(int c=0; c<COMMAND_SHIPS_SHOW.length; c++) {
		if (a==COMMAND_SHIPS_SHOW[c]) {
		    rescue.setShipsShow(c);
		    done=true;
		    break;
		}
	    }
	  }

	  if (done==false && COMMAND_BASE_SHOW[0]!=-1) {
	    for(int c=0; c<COMMAND_BASE_SHOW.length; c++) {
		if (a==COMMAND_BASE_SHOW[c]) {
		    rescue.setBaseShow(c);
		    done=true;
		    break;
		}
	    }
	  }


	  if (done==false && COMMAND_WARP_SPEED[0]!=-1) {
	    for(int c=0; c<COMMAND_WARP_SPEED.length; c++) {
		if (a==COMMAND_WARP_SPEED[c]) {
		    ship.setWarpFactor(c+1);
		    done=true;
		    break;
		}
	    }
	  }

	  if (done==false && COMMAND_IMPULSE_SPEED[0]!=-1) {
	    for(int c=0; c<COMMAND_IMPULSE_SPEED.length; c++) {
		if (a==COMMAND_IMPULSE_SPEED[c]) {
		    ship.setImpulseFactor(c+1);
		    done=true;
		    break;
		}
	    }
	  }

	  if (done==false && COMMAND_PHASER_INTENSITY[0]!=-1) {
	    for(int c=0; c<COMMAND_PHASER_INTENSITY.length; c++) {
		if (a==COMMAND_PHASER_INTENSITY[c]) {
		    ship.setPhaserIntensity(c+1);
		    done=true;
		    break;
		}
	    }
	  }

	  if (done==false && COMMAND_TORPEDO_SALVO[0]!=-1) {
	    for(int c=0; c<COMMAND_TORPEDO_SALVO.length; c++) {
		if (a==COMMAND_TORPEDO_SALVO[c]) {
		    ship.setTorpedoSalvo(c+1);
		    done=true;
		    break;
		}
	    }
	  }
	}

	if (done) { JukeBox.play(JukeBox.MOUSE_CLICK); list(); return; }

	System.out.print("action not set for color "+a+"\n");

    }

    //**********************************************************************
    //                     MouseListener Interface
    //**********************************************************************

    public void mouseMoved(MouseEvent e) {

	int a = map[e.getX()][e.getY()];

	if (a != cc) {

	    Graphics g = getGraphics();

	    // cover up the old highlighted button
	    if (cc < ButtonImages.length ) { g.drawImage(ButtonImages[cc].getOffImage() ,ButtonImages[cc].getX1() ,ButtonImages[cc].getY1() ,this); }

	    cc=a;

	    // draw the new highlighted button
	    if (cc < ButtonImages.length) { g.drawImage(ButtonImages[cc].getUpImage() ,ButtonImages[cc].getX1() ,ButtonImages[cc].getY1() ,this); }

	}

    }

    public void mousePressed(MouseEvent e) {

	int a = map[e.getX()][e.getY()];

	if (a < ButtonImages.length) {

	    Graphics g = getGraphics();

	    g.drawImage(ButtonImages[a].getDownImage() ,ButtonImages[a].getX1() ,ButtonImages[a].getY1() ,this);

	    if (a < ButtonImages.length) { pp=a; }
	}


    }

    public void mouseDragged(MouseEvent e) {

	int x=e.getX();
	int y=e.getY();

	if (x<0 || x>=img.getWidth() || y<0 || y>=img.getHeight() ) { return; }

	int a = map[x][y];

	if (a!=cc && pp!=255) {

	    Graphics g = getGraphics();

	    if (a!=pp) {
		g.drawImage(ButtonImages[pp].getOffImage() ,ButtonImages[pp].getX1() ,ButtonImages[pp].getY1() ,this);
	    }
	    else {
		g.drawImage(ButtonImages[pp].getDownImage() ,ButtonImages[pp].getX1() ,ButtonImages[pp].getY1() ,this);
	    }

	    cc=a;

	}

    }

    public void mouseReleased(MouseEvent e) {

	int x=e.getX();
	int y=e.getY();

	if (x<0 || x>=img.getWidth() || y<0 || y>=img.getHeight() ) { pp=255; return; }

	int a = map[x][y];

	if (a < ButtonImages.length) {

	    if (a==pp) {

		command(a);
	    }

	    // this is needed for the close game command where this couses a nullpointer exception
	    if ( rescue.getShip() !=null ) { Graphics g = getGraphics(); g.drawImage(ButtonImages[a].getUpImage() ,ButtonImages[a].getX1() ,ButtonImages[a].getY1() ,this); }

	}

	pp=255;

    }

    public void mouseExited(MouseEvent e) {

	if (cc!=255) {

	    Graphics g = getGraphics();

	    g.drawImage(ButtonImages[cc].getOffImage() ,ButtonImages[cc].getX1() ,ButtonImages[cc].getY1() ,this);

	    cc=255;

	}

    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public boolean contains(int x, int y) {

      if (map!=null) {

	if (x<0 || x>=img.getWidth() || y<0 || y>=img.getHeight() ) { tt=255; return false; }
	int a = map[x][y];
	if (a==255) { tt=255; return false; }

	if (a!=tt) {
	    setToolTipText( ButtonImages[a].getToolTip() );
	    tt=a;
	}

        return true;

      }

      return false;

    }

    class infoBar {

	private int x;
	private int y;
	private int value;
	private int direction;
	//private int outof;
	private BufferedImage on;
	private BufferedImage off;

	private int nx;
	private int ny;
	private int nw;
	private int nh;

	public infoBar(BufferedImage i1,BufferedImage i2,int ix,int iy,String d) throws Exception {

	    x=ix;
	    y=iy;
	    value=0;

	    if (d.equals("right")) { direction=1; }
	    else if (d.equals("left")) { direction=2; }
	    else if (d.equals("up")) { direction=3; }
	    else if (d.equals("down")) { direction=4; }
	    else { throw new Exception("unknows direction "+d); }

	    on=i2;
	    off=i1;

	}

	// public void setOutOf(int a) { outof=a; }

	public boolean checkOn(int a, int outof) {

	    if (value==a) {
		return false;
	    }
	    else {
		value=a;

		nx=0;
		ny=0;
		nw=on.getWidth();
		nh=on.getHeight();

		if (direction==1) {

		    nw = (int)(nw*((double)value/outof));

		}
		else if (direction==2) {

		    nw = (int)(nw*((double)value/outof));
		    nx = nx+(on.getWidth()-nw);

		}
		else if (direction==3) {

		    nh = (int)(nh*((double)value/outof));
		    ny = ny+(on.getHeight()-nh);

		}
		else if (direction==4) {

		    nh = (int)(nh*((double)value/outof));

		}

		return true;
	    }

	}

	public void draw(Graphics g, boolean clean) {

	    if (clean) { g.drawImage(off,x,y,InterfacePanel.this); }

	    if (nw!=0 && nh!=0) {
		g.drawImage(on.getSubimage(nx,ny,nw,nh),x+nx,y+ny,InterfacePanel.this);
	    }

	}

    }

    class infoText {

	private int x;
	private int y;

	private int textX;
	private int textY;

	private BufferedImage back;
	private String text;
	private Color color;

	public infoText(BufferedImage b,int i,int j,int ti,int tj,Color z) {

	    back=b;
	    text="";

	    x=i;
	    y=j;

	    textX=ti;
	    textY=tj;

	    color=z;

	}

	public boolean checkOn(String a) {

	    if (text.equals(a)) {
		return false;
	    }
	    else {
		text=a;
		return true;
	    }

	}

	public void draw(Graphics g, boolean a) {

	    if (a) { g.drawImage(back,x,y,InterfacePanel.this); }

	    g.setColor( color );

	    g.drawString( text ,textX, textY);

	}

	public void setColor(Color a) {

	    color=a;

	}

    }

    class mapButton {

	private int x1;
	private int y1;
	private int x2;
	private int y2;
	private BufferedImage offImage;
	private BufferedImage onImage;
	private BufferedImage HighLightImage;
	private BufferedImage PressDownImage;

	private boolean on;
	private String tooltip;

	public mapButton(int a,int b) {
	    x1=a;
	    y1=b;
	    x2=0;
	    y2=0;
	    onImage=null;
	    HighLightImage=null;
	    PressDownImage=null;

	}

	public String getToolTip() {

	    return tooltip;

	}

	public void setToolTip(String a) {

	    tooltip=a;

	}

	public boolean checkOn(boolean a) {

	    if (a!=on) {
		on=a;
		return true;
	    }
	    return false;

	}

	public boolean getOn() {
	    return on;
	}

	public void setOffImage(BufferedImage a) {
	    offImage=a;
	}

	public void setOnImage(BufferedImage a) {
	    onImage=a;
	}

	public void setUpImage(BufferedImage a) {
	    HighLightImage=a;
	}

	public void setDownImage(BufferedImage a) {
	    PressDownImage=a;
	}

	public void setX1(int a) {
	    x1=a;
	}

	public void setY1(int a) {
	    y1=a;
	}

	public void setX2(int a) {
	    x2=a;
	}

	public void setY2(int a) {
	    y2=a;
	}

	public BufferedImage getOffImage() {
	    if (on) { return onImage; }
	    return offImage;
	}

	public BufferedImage getUpImage() {
	    if (on) { return onImage; }
	    return HighLightImage;
	}

	public BufferedImage getDownImage() {
	    if (on) { return onImage; }
	    return PressDownImage;
	}

	public int getX1() {
	    return x1;
	}

	public int getY1() {
	    return y1;
	}

	public int getX2() {
	    return x2;
	}

	public int getY2() {
	    return y2;
	}

	public int getWidth() {
	    return (x2-x1+1);
	}

	public int getHeight() {
	    return (y2-y1+1);
	}


    }


}
