/*
 * Decompiled with CFR 0.152.
 */
package rescue.spaceobjects;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.Vector;
import rescue.spaceobjects.ImageObject;
import rescue.spaceobjects.ParticleEffect;
import rescue.spaceobjects.Ship;
import rescue.spaceobjects.Torpedo;

public abstract class MannedObject
extends ImageObject {
    protected int systemPhaserBanks = 0;
    protected int systemTorpedoTubes = 0;
    protected int systemShields = 0;
    protected int systemComputer = 0;
    protected int systemTransporters = 0;
    protected int systemTractorBeam = 0;
    protected int INFOmax_phaserIntensity;
    protected int INFOmax_phaserbanks;
    protected int INFOmax_torpedoSalvo;
    protected int INFOmax_torpedosleft;
    protected int INFOmax_shieldsPower;
    protected int INFOmax_tractorPower;
    protected int INFOmax_totalenergy;
    protected int INFOmax_cloakPower;
    protected String type;
    protected int number;
    protected int[] SpaceObjectsLikes;
    protected int firingPhaser;
    protected MannedObject phaserTarget;
    protected int phaserIntensity;
    protected int TorpedoSalvo;
    protected int target;
    protected int shieldPower;
    protected boolean ShieldsUp;
    protected int teams;
    protected int people;
    protected int totalEnergy;
    protected int phaserBanks;
    protected int torpedosLeft;
    protected Ship tractoredShip;
    protected int tractorBeamPower;
    protected boolean cloaked;
    protected int cloakPower;
    protected boolean alive;
    protected int reserve;
    protected int reserveMAX = 1000;
    private int counter = 0;

    public MannedObject(int n, String string, String string2, int n2, int n3, ImageObject[] imageObjectArray, BufferedImage bufferedImage, BufferedImage bufferedImage2, BufferedImage bufferedImage3, BufferedImage bufferedImage4, Vector vector) {
        super(n2, n3, imageObjectArray, vector, bufferedImage, bufferedImage2, bufferedImage3, bufferedImage4, string2);
        this.number = n;
        this.type = string;
        this.x = n2;
        this.y = n3;
        this.SpaceObjects = imageObjectArray;
        this.phaserTarget = null;
        this.firingPhaser = 0;
        this.target = 0;
        this.alive = true;
        this.torpedos = vector;
        this.teams = n != -1 && n == imageObjectArray.length - 1 ? 10 : 0;
        this.reserve = this.reserveMAX;
    }

    public void setInfo(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.INFOmax_phaserIntensity = n;
        this.INFOmax_torpedoSalvo = n2;
        this.INFOmax_tractorPower = n3;
        this.INFOmax_cloakPower = n4;
        this.INFOmax_totalenergy = n5;
        this.INFOmax_phaserbanks = n6;
        this.INFOmax_torpedosleft = n7;
        this.INFOmax_shieldsPower = n8;
        if (this.INFOmax_cloakPower > 0) {
            this.cloakPower = this.INFOmax_cloakPower;
            this.cloaked = true;
        }
        if (this.INFOmax_shieldsPower > 0) {
            this.shieldPower = this.INFOmax_shieldsPower;
            this.ShieldsUp = true;
        }
        this.totalEnergy = this.INFOmax_totalenergy;
        this.phaserBanks = this.INFOmax_phaserbanks;
        this.torpedosLeft = this.INFOmax_torpedosleft;
        this.tractorBeamPower = this.INFOmax_tractorPower;
        this.TorpedoSalvo = this.INFOmax_torpedoSalvo;
        this.phaserIntensity = this.INFOmax_phaserIntensity;
    }

    public int getShieldPower() {
        return this.shieldPower;
    }

    public int getTotalEnergy() {
        return this.totalEnergy;
    }

    public int getPhaserBanks() {
        return this.phaserBanks;
    }

    public int getTorpedosLeft() {
        return this.torpedosLeft;
    }

    public void setNoAwayTeams(int n) {
        this.teams = n;
    }

    public int getNoAwayTeams() {
        return this.teams;
    }

    public boolean doYouLike(MannedObject mannedObject) {
        return this.SpaceObjectsLikes[mannedObject.getNumber()] > 0;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int n) {
        this.number = n;
    }

    public int getPeople() {
        return this.people;
    }

    public void addPeople(int n) {
        this.people += n;
    }

    public void beamTeamFrom(MannedObject mannedObject) {
        if (mannedObject.beamTeamUp()) {
            ++this.teams;
            if (this instanceof Ship && mannedObject instanceof Ship && this.SpaceObjectsLikes[this.SpaceObjectsLikes.length - 1] < 1) {
                this.SpaceObjectsLikes = mannedObject.copyLikeInfo();
                for (int i = 0; i < this.SpaceObjects.length; ++i) {
                    if (!(this.SpaceObjects[i] instanceof MannedObject)) continue;
                    ((MannedObject)this.SpaceObjects[i]).setLike(this.number, mannedObject.getNumber());
                }
            }
        }
    }

    public boolean beamTeamUp() {
        if (this.teams > 0) {
            --this.teams;
            return true;
        }
        return false;
    }

    public int[] copyLikeInfo() {
        int[] nArray = new int[this.SpaceObjectsLikes.length];
        System.arraycopy(this.SpaceObjectsLikes, 0, nArray, 0, nArray.length);
        return nArray;
    }

    public void setLike(int n, int n2) {
        this.SpaceObjectsLikes[n] = this.SpaceObjectsLikes[n2];
    }

    public void TractorShip(Ship ship) {
        if (ship != null && this.systemTractorBeam == 0) {
            ship.setOwner(this);
            this.tractoredShip = ship;
        } else if (this.tractoredShip != null) {
            this.tractoredShip.setOwner(null);
            this.tractoredShip = null;
        }
    }

    public void TorpedoHit(MannedObject mannedObject) {
        this.gotHit(mannedObject, 6, 0);
    }

    public void PhaserHit(MannedObject mannedObject, int n, int n2) {
        this.gotHit(mannedObject, n, n2);
    }

    public void gotHit(MannedObject mannedObject, int n, int n2) {
        int n3 = mannedObject.getNumber();
        int n4 = this.number;
        for (int i = 0; i < this.SpaceObjectsLikes.length; ++i) {
            if (!(this.SpaceObjects[i] instanceof MannedObject)) continue;
            ((MannedObject)this.SpaceObjects[i]).youShouldLike(n3, n4);
        }
        double d = (double)Math.max(this.shieldPower, 1) / 100.0;
        int n5 = n * 5;
        if (this.ShieldsUp) {
            int n6 = (int)((double)n5 * d);
            this.shieldPower -= n5;
            n5 -= n6;
            if (this.shieldPower < 5) {
                this.shieldPower = 0;
            }
        }
        while (n5 != 0) {
            if (n2 == 0) {
                while (this.getSystem(n2 = (int)Math.round(Math.random() * 9.0) + 1) == 10) {
                }
            }
            if (n2 == 1 || n2 == 2 || n2 == 5 || n2 == 6) {
                if (this instanceof Ship) {
                    n5 = ((Ship)this).shipDamage(n2, n5);
                }
            } else if (n2 == 3) {
                this.systemPhaserBanks -= n5;
                if (this.systemPhaserBanks < -10) {
                    n5 -= this.systemPhaserBanks + 10;
                    this.systemPhaserBanks = -10;
                }
            } else if (n2 == 4) {
                this.systemTorpedoTubes -= n5;
                if (this.systemTorpedoTubes < -10) {
                    n5 -= this.systemTorpedoTubes + 10;
                    this.systemTorpedoTubes = -10;
                }
            } else if (n2 == 7) {
                this.systemShields -= n5;
                if (this.systemShields < -10) {
                    n5 -= this.systemShields + 10;
                    this.systemShields = -10;
                }
            } else if (n2 == 8) {
                this.systemComputer -= n5;
                if (this.systemComputer < -10) {
                    n5 -= this.systemComputer + 10;
                    this.systemComputer = -10;
                }
            } else if (n2 == 9) {
                this.systemTransporters -= n5;
                if (this.systemTransporters < -10) {
                    n5 -= this.systemTransporters + 10;
                    this.systemTransporters = -10;
                }
            } else if (n2 == 10) {
                this.systemTractorBeam -= n5;
                if (this.systemTractorBeam < -10) {
                    n5 -= this.systemTractorBeam + 10;
                    this.systemTractorBeam = -10;
                }
            }
            n5 /= 4;
            n2 = (int)Math.round(Math.random() * 10.0);
        }
        this.checkdead();
        if (this.ShieldsUp && this.shieldPower > 0) {
            this.torpedos.add(new ParticleEffect(this.x, this.y, this.SpaceObjects, this.torpedos, 20, Color.YELLOW, 0.0, 3.0, 0.0, this.getSize() / 2, false, 5));
        } else if (!this.alive) {
            this.torpedos.add(new ParticleEffect(this.x, this.y, this.SpaceObjects, this.torpedos, 50, Color.RED, 0.0, 3.0, 0.0, this.getSize(), false, 5));
        } else {
            this.torpedos.add(new ParticleEffect(this.x, this.y, this.SpaceObjects, this.torpedos, 20, Color.RED, 0.0, 3.0, 0.0, this.getSize() / 2, false, 5));
        }
    }

    public void checkdead() {
        int n = this.getLifeInfo();
        if (n <= -60) {
            this.alive = false;
        }
    }

    public int getLifeInfo() {
        int n = this.systemPhaserBanks + this.systemTorpedoTubes + this.systemShields + this.systemComputer + this.systemTransporters + this.systemTractorBeam;
        if (this instanceof Ship) {
            n += ((Ship)this).shipGetLifeInfo();
        }
        return n;
    }

    public boolean checkFixNeeded() {
        int n = this.systemPhaserBanks + this.systemTorpedoTubes + this.systemShields + this.systemComputer + this.systemTransporters + this.systemTractorBeam;
        if (this instanceof Ship) {
            n += ((Ship)this).shipGetLifeInfo();
        }
        return n != 0;
    }

    public void youShouldLike(int n, int n2) {
        if (this.SpaceObjectsLikes[n2] < 0) {
            this.SpaceObjectsLikes[n] = this.SpaceObjectsLikes[n] + 1;
        } else if (this.SpaceObjectsLikes[n2] > 0) {
            this.SpaceObjectsLikes[n] = this.SpaceObjectsLikes[n] - 1;
        }
    }

    public boolean enemyOf(int n) {
        return this.SpaceObjectsLikes[n] < 0;
    }

    public boolean friendOf(int n) {
        return this.SpaceObjectsLikes[n] > 0;
    }

    public String getType() {
        return this.type;
    }

    public void setLikes(int[] nArray) {
        this.SpaceObjectsLikes = nArray;
    }

    public boolean isAlive() {
        return this.alive;
    }

    public void drawBigShape(Graphics graphics, boolean bl) {
        if (this.firingPhaser != 0) {
            graphics.setColor(Color.RED);
            graphics.drawLine(this.x, this.y, this.phaserTarget.x, this.phaserTarget.y);
        }
        if (this.tractoredShip != null) {
            graphics.setColor(Color.LIGHT_GRAY);
            graphics.drawLine(this.x, this.y, this.tractoredShip.x, this.tractoredShip.y);
        }
        if (bl) {
            int n = this.getSize();
            graphics.setColor(new Color(255, 0, 0));
            graphics.drawOval(this.x - n, this.y - n, n * 2, n * 2);
        }
    }

    public void drawSmallShape(Graphics graphics, double d, double d2, int n) {
        if (this.alive && (!this.cloaked || n >= this.cloakPower)) {
            super.drawSmallShape(graphics, d, d2, n);
        }
    }

    public int getCloakPower() {
        return this.cloakPower;
    }

    public boolean hasSelected(Point point) {
        return this.alive && super.hasSelected(point);
    }

    public void FireTorpedo(MannedObject mannedObject) {
        if (this.torpedosLeft > 0 && this.systemTorpedoTubes == 0) {
            if (this.TorpedoSalvo > this.torpedosLeft) {
                this.TorpedoSalvo = this.torpedosLeft;
            }
            this.torpedosLeft -= this.TorpedoSalvo;
            if (this.TorpedoSalvo == 1) {
                this.FireTorpedo(mannedObject, this.getAngle(mannedObject));
            } else if (this.TorpedoSalvo == 2) {
                double d = this.getAngle(mannedObject);
                this.FireTorpedo(mannedObject, Math.toDegrees(d) < 350.0 ? d + Math.toRadians(10.0) : d - Math.toRadians(350.0));
                this.FireTorpedo(mannedObject, Math.toDegrees(d) >= 10.0 ? d - Math.toRadians(10.0) : d + Math.toRadians(350.0));
            } else {
                double d = this.getAngle(mannedObject);
                this.FireTorpedo(mannedObject, Math.toDegrees(d) < 350.0 ? d + Math.toRadians(10.0) : d - Math.toRadians(350.0));
                this.FireTorpedo(mannedObject, d);
                this.FireTorpedo(mannedObject, Math.toDegrees(d) >= 10.0 ? d - Math.toRadians(10.0) : d + Math.toRadians(350.0));
            }
        }
    }

    public void FireTorpedo(MannedObject mannedObject, double d) {
        this.torpedos.add(new Torpedo(this.x, this.y, this.SpaceObjects, this.torpedos, mannedObject, this, d));
    }

    public void FirePhaser(MannedObject mannedObject) {
        if (this.phaserBanks >= 50 && this.systemPhaserBanks == 0) {
            if (this.phaserIntensity * 50 > this.phaserBanks) {
                this.phaserIntensity = this.phaserBanks / 50;
            }
            this.phaserBanks -= this.phaserIntensity * 50;
            this.phaserTarget = mannedObject;
            this.firingPhaser = 10;
            this.phaserTarget.PhaserHit(this, this.phaserIntensity, this.target);
        }
    }

    public int getTractorBeamPower() {
        if (this.tractoredShip != null) {
            return this.tractorBeamPower;
        }
        return 0;
    }

    public int getTractorBeamMaxPower() {
        return this.INFOmax_tractorPower;
    }

    public int getMaxtotalenergy() {
        return this.INFOmax_totalenergy;
    }

    public int getMaxphaserbanks() {
        return this.INFOmax_phaserbanks;
    }

    public int getMaxtorpedosleft() {
        return this.INFOmax_torpedosleft;
    }

    public int getMaxshieldpower() {
        return this.INFOmax_shieldsPower;
    }

    public int getEnergy(int n) {
        if (this.totalEnergy > n) {
            this.totalEnergy -= n;
            return n;
        }
        int n2 = this.totalEnergy;
        this.totalEnergy = 0;
        return n2;
    }

    public int getPhaser(int n) {
        if (this.phaserBanks > n) {
            this.phaserBanks -= n;
            return n;
        }
        int n2 = this.phaserBanks;
        this.phaserBanks = 0;
        return n2;
    }

    public int getTorpedos(int n) {
        if (this.torpedosLeft > n) {
            this.torpedosLeft -= n;
            return n;
        }
        int n2 = this.torpedosLeft;
        this.torpedosLeft = 0;
        return n2;
    }

    public void fixSystems() {
        if (this.systemPhaserBanks < 0) {
            ++this.systemPhaserBanks;
            return;
        }
        if (this.systemTorpedoTubes < 0) {
            ++this.systemTorpedoTubes;
            return;
        }
        if (this.systemShields < 0) {
            ++this.systemShields;
            return;
        }
        if (this.systemComputer < 0) {
            ++this.systemComputer;
            return;
        }
        if (this.systemTransporters < 0) {
            ++this.systemTransporters;
            return;
        }
        if (this.systemTractorBeam < 0) {
            ++this.systemTractorBeam;
            return;
        }
    }

    public int getSystem(int n) {
        if (n == 3) {
            return this.systemPhaserBanks;
        }
        if (n == 4) {
            return this.systemTorpedoTubes;
        }
        if (n == 7) {
            return this.systemShields;
        }
        if (n == 8) {
            return this.systemComputer;
        }
        if (n == 9) {
            return this.systemTransporters;
        }
        if (n == 10) {
            return this.systemTractorBeam;
        }
        if (this instanceof Ship) {
            return ((Ship)this).shipGetSystem(n);
        }
        return 0;
    }

    public void advance() {
        if (this.alive) {
            if (this.counter < 50) {
                ++this.counter;
            } else if (this.counter == 50) {
                this.counter = 0;
            }
            if (this.phaserBanks < this.INFOmax_phaserbanks && this.totalEnergy > 1) {
                --this.totalEnergy;
                ++this.phaserBanks;
            }
            if (this.ShieldsUp) {
                if (this.totalEnergy > 5) {
                    this.totalEnergy -= 5;
                } else {
                    this.ShieldsUp = false;
                }
            }
            if (this.counter == 0 && this.shieldPower < this.INFOmax_shieldsPower && this.totalEnergy > 20) {
                ++this.shieldPower;
                this.totalEnergy -= 20;
            }
            if (this.tractoredShip != null) {
                int n = this.tractoredShip.tractorEnergyUsed(this.INFOmax_tractorPower);
                if (this.totalEnergy > n) {
                    this.totalEnergy -= n;
                    this.tractorBeamPower = n;
                } else {
                    this.TractorShip(null);
                }
            }
            if (this.counter == 0 && this.checkFixNeeded() && this.totalEnergy > 300) {
                this.fixSystems();
                this.totalEnergy -= 300;
            }
            if (this.reserve < this.reserveMAX && this.totalEnergy > 1) {
                --this.totalEnergy;
                ++this.reserve;
            }
            if (this.totalEnergy < this.INFOmax_totalenergy) {
                this.totalEnergy += 10;
            }
            if (this.totalEnergy > this.INFOmax_totalenergy) {
                this.totalEnergy = this.INFOmax_totalenergy;
            }
        }
        if (this.firingPhaser != 0) {
            --this.firingPhaser;
        }
    }
}

