/*
 * Decompiled with CFR 0.152.
 */
package rescue.panels;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;
import rescue.RunRescue;
import rescue.spaceobjects.ImageObject;
import rescue.spaceobjects.MannedObject;
import rescue.spaceobjects.Planet;
import rescue.spaceobjects.Wormhole;

public class ShipInfoPanel
extends JPanel {
    private ImageObject mySO;
    private RunRescue rescue;

    public ShipInfoPanel(int n, int n2, RunRescue runRescue) {
        this.rescue = runRescue;
        Dimension dimension = new Dimension(n, n2);
        this.setMinimumSize(dimension);
        this.setMaximumSize(dimension);
        this.setPreferredSize(dimension);
    }

    public void paintComponent(Graphics graphics) {
        graphics.setColor(Color.BLACK);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.setColor(Color.WHITE);
        int n = this.rescue.getScan();
        if (this.mySO != null && (this.mySO instanceof Wormhole || n >= ((MannedObject)this.mySO).getCloakPower()) && this.rescue.getShip().getSystem(5) == 0) {
            graphics.drawImage(this.mySO.getInfoImage(), this.getWidth() - 150, this.getHeight() - 150, this);
            graphics.drawString("Name: " + this.mySO.getName(), 4, 14);
            graphics.drawString("Location: " + this.mySO.x + " " + this.mySO.y, 4, 29);
            graphics.drawString("Distance: " + this.mySO.getDistanceToPlayer(), 4, 44);
            if (!(this.mySO instanceof Wormhole) && n > 0) {
                int n2 = ((MannedObject)this.mySO).getTotalEnergy();
                int n3 = ((MannedObject)this.mySO).getShieldPower();
                graphics.drawRect(2, 48, 9, 124);
                graphics.drawRect(14, 48, 9, 124);
                graphics.drawString("Energy: " + n2 + " Shields: " + n3, 27, 170);
                int n4 = (int)(123.0 * ((double)n2 / (double)((MannedObject)this.mySO).getMaxtotalenergy()));
                int n5 = (int)(123.0 * ((double)n3 / (double)((MannedObject)this.mySO).getMaxshieldpower()));
                if (n > 1) {
                    graphics.drawString("Tpdos: " + ((MannedObject)this.mySO).getTorpedosLeft() + " Phase: " + ((MannedObject)this.mySO).getPhaserBanks(), 27, 155);
                }
                graphics.setColor(Color.GREEN.darker());
                graphics.fillRect(3, 49 + (123 - n4), 8, n4);
                graphics.setColor(Color.YELLOW.darker());
                graphics.fillRect(15, 49 + (123 - n5), 8, n5);
            }
        } else {
            graphics.drawString("-- NO OBJECT --", this.getWidth() / 2 - 40, this.getHeight() / 2 + 3);
        }
    }

    public void setSpaceObject(ImageObject imageObject) {
        this.mySO = imageObject;
    }

    public void list() {
        if (!(this.mySO == null || this.mySO instanceof Wormhole || ((MannedObject)this.mySO).isAlive() || this.mySO instanceof Planet)) {
            this.mySO = null;
        }
        this.repaint();
    }
}

