/*
 * Decompiled with CFR 0.152.
 */
package rescue.panels;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JPanel;
import rescue.RunRescue;

public class BigMapPanel
extends JPanel
implements MouseListener,
MouseWheelListener {
    private RunRescue rescue;
    private int posX;
    private int posY;

    public BigMapPanel(RunRescue runRescue, int n, int n2) {
        this.rescue = runRescue;
        this.addMouseListener(this);
        this.addMouseWheelListener(this);
        this.posX = 0;
        this.posY = 0;
        Dimension dimension = new Dimension(n, n2);
        this.setPreferredSize(dimension);
    }

    public void paintComponent(Graphics graphics) {
        if (this.rescue.mapUpdating()) {
            int n = this.getWidth();
            int n2 = this.getHeight();
            graphics.setColor(Color.BLACK);
            graphics.fillRect(0, 0, n, n2);
            this.rescue.drawStars(graphics);
            this.rescue.drawShipsBig(graphics);
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.rescue.setPanelSize(n3, n4);
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (mouseWheelEvent.getWheelRotation() < 0) {
            this.rescue.zoom(true);
        } else {
            this.rescue.zoom(false);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        boolean bl;
        boolean bl2 = mouseEvent.getModifiers() == 16;
        boolean bl3 = mouseEvent.getModifiers() == 8;
        boolean bl4 = bl = mouseEvent.getModifiers() == 4;
        if (bl2 || bl) {
            this.rescue.shipImpulse(mouseEvent.getX(), mouseEvent.getY());
        }
        if (bl2) {
            this.rescue.selectShips(mouseEvent.getX(), mouseEvent.getY());
        } else if (bl) {
            this.rescue.shipImpulseOn();
        } else if (bl3) {
            double d = Math.atan((double)(mouseEvent.getX() - this.getWidth() / 2) / (double)(this.getHeight() / 2 - mouseEvent.getY()));
            if (mouseEvent.getY() > this.getHeight() / 2) {
                d += Math.toRadians(180.0);
            }
            if (d < 0.0) {
                d += Math.toRadians(360.0);
            }
            this.rescue.shipManImpulse(d);
        }
    }
}

