/*
 * Decompiled with CFR 0.152.
 */
package rescue.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import rescue.MissionLoader;
import rescue.RescueListener;
import rescue.RunRescue;
import rescue.SimplePrintStream;
import rescue.gui.AboutDialog;
import rescue.gui.MissionSetup;
import rescue.gui.PrefDialog;
import rescue.gui.SFrame;
import rescue.gui.SplashScreen;
import rescue.panels.ContainerPanel;

public class RescueGUI
extends JFrame
implements ActionListener,
RescueListener,
Runnable {
    private static final String NAME = "Rescue! Max";
    private RunRescue rescue;
    private Component bigmap;
    private Vector panels;
    private Component[] inGameMenus;
    private Component[] outGameMenus;
    private Vector Windows;
    private JDesktopPane desktop;
    private JMenu windowsMenu;
    private int counter = 0;

    public RescueGUI(RunRescue runRescue) {
        super(NAME);
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("icon.png")));
        this.rescue = runRescue;
        this.inGameMenus = new Component[9];
        this.outGameMenus = new Component[6];
        this.desktop = new JDesktopPane();
        this.desktop.setDragMode(JDesktopPane.LIVE_DRAG_MODE);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setRollover(true);
        JButton jButton = new JButton("New Game");
        jButton.setActionCommand("new");
        jButton.addActionListener(this);
        jToolBar.add(jButton);
        this.outGameMenus[2] = jButton;
        jButton = new JButton("Pause ON/OFF");
        jButton.setActionCommand("pause");
        jButton.addActionListener(this);
        jToolBar.add(jButton);
        this.inGameMenus[8] = jButton;
        jButton = new JButton("End Game");
        jButton.setActionCommand("end");
        jButton.addActionListener(this);
        jToolBar.add(jButton);
        this.inGameMenus[2] = jButton;
        jToolBar.addSeparator();
        jButton = new JButton("Preferences...");
        jButton.setActionCommand("preferences");
        jButton.addActionListener(this);
        jToolBar.add(jButton);
        this.outGameMenus[3] = jButton;
        jButton = new JButton("Mission Setup...");
        jButton.setActionCommand("mission");
        jButton.addActionListener(this);
        jToolBar.add(jButton);
        this.outGameMenus[4] = jButton;
        jToolBar.addSeparator();
        jButton = new JButton("Quit");
        jButton.setActionCommand("quit");
        jButton.addActionListener(this);
        jToolBar.add(jButton);
        jButton = new JButton("Help");
        jButton.setActionCommand("help");
        jButton.addActionListener(this);
        jToolBar.add(jButton);
        jButton = new JButton("About");
        jButton.setActionCommand("about");
        jButton.addActionListener(this);
        jToolBar.add(jButton);
        this.setJMenuBar(this.createMenuBar());
        this.getContentPane().add((Component)jToolBar, "North");
        this.getContentPane().add((Component)this.desktop, "Center");
        for (int i = 0; i < this.inGameMenus.length; ++i) {
            this.inGameMenus[i].setEnabled(false);
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                RescueGUI.this.exitForm(windowEvent);
            }
        });
    }

    public void newGame(MissionLoader missionLoader) {
        JMenuItem jMenuItem;
        int n;
        Vector vector = missionLoader.getWindows();
        this.bigmap = missionLoader.getBigMap();
        this.panels = missionLoader.getPanels();
        this.Windows = new Vector();
        JFrame jFrame = null;
        for (n = 0; n < vector.size(); ++n) {
            Container container;
            String string = ((ContainerPanel)vector.elementAt(n)).getName();
            if (this.rescue.getMode()) {
                if (n == 0) {
                    jFrame = new JFrame(string);
                    jFrame.setResizable(false);
                    jFrame.setIconImage(this.getIconImage());
                    container = jFrame;
                    jFrame.setContentPane((ContainerPanel)vector.elementAt(n));
                } else {
                    container = new JDialog((Frame)jFrame, string);
                    ((Dialog)container).setResizable(false);
                    ((JDialog)container).setContentPane((ContainerPanel)vector.elementAt(n));
                }
                ((Window)container).setLocation(((ContainerPanel)vector.elementAt(n)).getPreferredLocation());
                ((Window)container).pack();
                ((Window)container).addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        RescueGUI.this.rescue.closeCurrentMission();
                    }
                });
                this.Windows.add(container);
                continue;
            }
            container = new SFrame(string, (ContainerPanel)vector.elementAt(n));
            ((JInternalFrame)container).pack();
            ((JInternalFrame)container).setResizable(false);
            ((JInternalFrame)container).setDefaultCloseOperation(1);
            ((JInternalFrame)container).setFrameIcon(new ImageIcon(this.getIconImage()));
            this.Windows.add(container);
            this.desktop.add(container);
            jMenuItem = new JMenuItem(string);
            jMenuItem.setActionCommand("window " + n);
            jMenuItem.addActionListener(this);
            this.windowsMenu.add(jMenuItem);
        }
        if (this.rescue.getMode()) {
            for (int i = 0; i < this.Windows.size(); ++i) {
                Window window = (Window)this.Windows.elementAt(i);
                window.setVisible(true);
            }
            this.setVisible(false);
        } else {
            this.windowsMenu.addSeparator();
            jMenuItem = new JMenuItem("Use Default Positions");
            jMenuItem.setMnemonic(85);
            jMenuItem.setActionCommand("w default");
            jMenuItem.addActionListener(this);
            this.windowsMenu.add(jMenuItem);
            this.defaultWindowPositions();
            for (n = 0; n < this.inGameMenus.length; ++n) {
                this.inGameMenus[n].setEnabled(true);
            }
            for (n = 0; n < this.outGameMenus.length; ++n) {
                this.outGameMenus[n].setEnabled(false);
            }
        }
        this.repaint();
    }

    public void closeGame() {
        if (this.rescue.getMode()) {
            for (int i = 0; i < this.Windows.size(); ++i) {
                ((Window)this.Windows.elementAt(i)).setVisible(false);
                ((Window)this.Windows.elementAt(i)).dispose();
            }
            this.setVisible(true);
        } else {
            int n;
            for (n = 0; n < this.Windows.size(); ++n) {
                ((SFrame)this.Windows.elementAt(n)).dispose();
                this.desktop.remove((SFrame)this.Windows.elementAt(n));
            }
            this.windowsMenu.removeAll();
            for (n = 0; n < this.inGameMenus.length; ++n) {
                this.inGameMenus[n].setEnabled(false);
            }
            for (n = 0; n < this.outGameMenus.length; ++n) {
                this.outGameMenus[n].setEnabled(true);
            }
        }
        this.Windows = null;
        this.bigmap = null;
    }

    public void dead() {
        new Thread(this).start();
    }

    public void run() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        JFrame jFrame = this;
        if (this.rescue.getMode()) {
            jFrame = (JFrame)this.Windows.elementAt(0);
        }
        JOptionPane.showMessageDialog(jFrame, "You are dead!", "Dead", -1);
        this.rescue.closeCurrentMission();
    }

    public void defaultWindowPositions() {
        for (int i = 0; i < this.Windows.size(); ++i) {
            SFrame sFrame = (SFrame)this.Windows.elementAt(i);
            sFrame.setLocation(sFrame.getPreferredLocation());
            sFrame.setSize(sFrame.getPreferredSize());
            sFrame.setVisible(true);
            try {
                sFrame.setIcon(false);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("Game");
        jMenu.setMnemonic(71);
        JMenuItem jMenuItem = new JMenuItem("New");
        jMenuItem.setMnemonic(78);
        jMenuItem.setActionCommand("new");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        this.outGameMenus[0] = jMenuItem;
        jMenuItem = new JMenuItem("Pause");
        jMenuItem.setMnemonic(80);
        jMenuItem.setActionCommand("pause");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        this.inGameMenus[6] = jMenuItem;
        jMenuItem = new JMenuItem("End");
        jMenuItem.setMnemonic(69);
        jMenuItem.setActionCommand("end");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        this.inGameMenus[7] = jMenuItem;
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Preferences...");
        jMenuItem.setMnemonic(80);
        jMenuItem.setActionCommand("preferences");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        this.outGameMenus[5] = jMenuItem;
        jMenuItem = new JMenuItem("Mission Setup...");
        jMenuItem.setMnemonic(77);
        jMenuItem.setActionCommand("mission");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        this.outGameMenus[1] = jMenuItem;
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Quit");
        jMenuItem.setMnemonic(81);
        jMenuItem.setActionCommand("quit");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        jMenu = new JMenu("Select");
        jMenu.setMnemonic(83);
        jMenuItem = new JMenuItem("All");
        jMenuItem.setMnemonic(65);
        jMenuItem.setActionCommand("s all");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Enemies");
        jMenuItem.setMnemonic(69);
        jMenuItem.setActionCommand("s enemies");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Manual");
        jMenuItem.setMnemonic(77);
        jMenuItem.setActionCommand("s manual");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        this.inGameMenus[0] = jMenu;
        jMenu = new JMenu("Options");
        jMenu.setMnemonic(79);
        jMenuItem = new JMenu("Sound");
        jMenuItem.setMnemonic(83);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Heads Up Display");
        jMenuItem.setMnemonic(85);
        jMenuItem.setActionCommand("heads");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        this.inGameMenus[1] = jMenu;
        jMenu = new JMenu("Starfleet");
        jMenu.setMnemonic(83);
        jMenuItem = new JMenuItem("Dock With Starbase");
        jMenuItem.setMnemonic(87);
        jMenuItem.setActionCommand("dock");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Board Ship");
        jMenuItem.setMnemonic(66);
        jMenuItem.setActionCommand("board");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Beam Team Down");
        jMenuItem.setMnemonic(68);
        jMenuItem.setActionCommand("down");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Beam Team Up");
        jMenuItem.setMnemonic(85);
        jMenuItem.setActionCommand("up");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenu("Evasive Maneuvers");
        jMenuItem.setMnemonic(69);
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Sequence Alpha 7");
        jMenuItem2.setMnemonic(55);
        jMenuItem2.setActionCommand("evasive 1");
        jMenuItem2.addActionListener(this);
        jMenuItem.add(jMenuItem2);
        jMenuItem2 = new JMenuItem("Sequence Omega 8");
        jMenuItem2.setMnemonic(56);
        jMenuItem2.setActionCommand("evasive 2");
        jMenuItem2.addActionListener(this);
        jMenuItem.add(jMenuItem2);
        jMenuItem2 = new JMenuItem("Sequence Delta 9");
        jMenuItem2.setMnemonic(57);
        jMenuItem2.setActionCommand("evasive 3");
        jMenuItem2.addActionListener(this);
        jMenuItem.add(jMenuItem2);
        jMenuBar.add(jMenu);
        this.inGameMenus[3] = jMenu;
        jMenu = new JMenu("Engineering");
        jMenu.setMnemonic(69);
        jMenuItem = new JMenuItem("Divert Phaser Energy");
        jMenuItem.setMnemonic(68);
        jMenuItem.setActionCommand("divert");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Use Reserve Energy");
        jMenuItem.setMnemonic(85);
        jMenuItem.setActionCommand("reserve");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        this.inGameMenus[4] = jMenu;
        jMenu = new JMenu("Window");
        jMenu.setMnemonic(87);
        this.windowsMenu = jMenu;
        jMenuBar.add(jMenu);
        this.inGameMenus[5] = jMenu;
        jMenu = new JMenu("Help");
        jMenu.setMnemonic(72);
        jMenuItem = new JMenuItem("Help...");
        jMenuItem.setMnemonic(72);
        jMenuItem.setActionCommand("help");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("About Rescue!");
        jMenuItem.setMnemonic(82);
        jMenuItem.setActionCommand("aboutr");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("About Rescue! Max");
        jMenuItem.setMnemonic(65);
        jMenuItem.setActionCommand("about");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        return jMenuBar;
    }

    private void exitForm(WindowEvent windowEvent) {
        System.exit(0);
    }

    public void update() {
        try {
            this.bigmap.repaint();
            ++this.counter;
            if (this.counter >= 10 || this.rescue.getPause()) {
                for (int i = 0; i < this.panels.size(); ++i) {
                    ((Component)this.panels.elementAt(i)).list();
                }
                this.counter = 0;
            }
        }
        catch (Exception exception) {
            System.out.print("error updating gui: " + exception.getMessage() + "\n");
            this.counter = 0;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("new")) {
            this.rescue.loadCurrentMission();
            return;
        }
        if (actionEvent.getActionCommand().equals("end")) {
            this.rescue.closeCurrentMission();
            return;
        }
        if (actionEvent.getActionCommand().equals("pause")) {
            this.rescue.pause();
            return;
        }
        if (actionEvent.getActionCommand().equals("quit")) {
            System.exit(0);
        } else if (actionEvent.getActionCommand().equals("zoomin")) {
            this.rescue.zoom(true);
        } else if (actionEvent.getActionCommand().equals("zoomout")) {
            this.rescue.zoom(false);
        } else if (actionEvent.getActionCommand().equals("s all")) {
            this.rescue.setSelect(0);
        } else if (actionEvent.getActionCommand().equals("s enemies")) {
            this.rescue.setSelect(1);
        } else if (actionEvent.getActionCommand().equals("s manual")) {
            this.rescue.setSelect(2);
        } else if (actionEvent.getActionCommand().equals("heads")) {
            this.rescue.headsUpDisplay();
        } else if (actionEvent.getActionCommand().equals("dock")) {
            this.rescue.shipDock();
        } else if (actionEvent.getActionCommand().equals("board")) {
            this.rescue.shipBoard();
        } else if (actionEvent.getActionCommand().equals("down")) {
            this.rescue.shipBeamDown();
        } else if (actionEvent.getActionCommand().equals("up")) {
            this.rescue.shipBeamUp();
        } else {
            if (actionEvent.getActionCommand().equals("w default")) {
                this.defaultWindowPositions();
                return;
            }
            if (actionEvent.getActionCommand().equals("mission")) {
                MissionSetup missionSetup = new MissionSetup((Frame)this, true, this.rescue);
                missionSetup.setVisible(true);
                return;
            }
            if (actionEvent.getActionCommand().equals("preferences")) {
                PrefDialog prefDialog = new PrefDialog((Frame)this, true, this.rescue, this);
                Dimension dimension = this.getSize();
                Dimension dimension2 = prefDialog.getPreferredSize();
                int n = this.getLocation().x + (dimension.width - dimension2.width) / 2;
                int n2 = this.getLocation().y + (dimension.height - dimension2.height) / 2;
                if (n < 0) {
                    n = 0;
                }
                if (n2 < 0) {
                    n2 = 0;
                }
                prefDialog.setLocation(n, n2);
                prefDialog.setVisible(true);
                return;
            }
            if (actionEvent.getActionCommand().equals("about")) {
                AboutDialog aboutDialog = new AboutDialog((Frame)this, true, NAME, "1.0.0.2");
                Dimension dimension = this.getSize();
                Dimension dimension3 = aboutDialog.getPreferredSize();
                int n = this.getLocation().x + (dimension.width - dimension3.width) / 2;
                int n3 = this.getLocation().y + (dimension.height - dimension3.height) / 2;
                if (n < 0) {
                    n = 0;
                }
                if (n3 < 0) {
                    n3 = 0;
                }
                aboutDialog.setLocation(n, n3);
                aboutDialog.setVisible(true);
                return;
            }
            if (actionEvent.getActionCommand().equals("aboutr")) {
                JDialog jDialog = new JDialog(this, "Rescue!", true);
                jDialog.getContentPane().add(new JLabel(new ImageIcon(this.getClass().getResource("credits.png"))));
                jDialog.setResizable(false);
                jDialog.pack();
                Dimension dimension = this.getSize();
                Dimension dimension4 = jDialog.getPreferredSize();
                int n = this.getLocation().x + (dimension.width - dimension4.width) / 2;
                int n4 = this.getLocation().y + (dimension.height - dimension4.height) / 2;
                if (n < 0) {
                    n = 0;
                }
                if (n4 < 0) {
                    n4 = 0;
                }
                jDialog.setLocation(n, n4);
                jDialog.setVisible(true);
                return;
            }
            if (actionEvent.getActionCommand().equals("divert")) {
                this.rescue.getShip().divertPhaser();
            } else if (actionEvent.getActionCommand().equals("reserve")) {
                this.rescue.getShip().useReserve();
            } else {
                if (actionEvent.getActionCommand().equals("help")) {
                    this.rescue.help();
                    return;
                }
                if (actionEvent.getActionCommand().startsWith("evasive ")) {
                    int n = Integer.parseInt(actionEvent.getActionCommand().substring(8));
                    this.rescue.getShip().setEvasive(n);
                } else {
                    if (actionEvent.getActionCommand().startsWith("window ")) {
                        int n = Integer.parseInt(actionEvent.getActionCommand().substring(7));
                        ((SFrame)this.Windows.elementAt(n)).setVisible(true);
                        try {
                            ((SFrame)this.Windows.elementAt(n)).setIcon(false);
                            ((SFrame)this.Windows.elementAt(n)).setSelected(true);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return;
                    }
                    System.out.print("unknown command " + actionEvent.getActionCommand() + "\n");
                    return;
                }
            }
        }
        this.rescue.updateGUI();
    }

    public static void main(String[] stringArray) {
        Object object;
        SimplePrintStream.catchErrors();
        SplashScreen splashScreen = new SplashScreen();
        splashScreen.setVisible(true);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        RunRescue runRescue = null;
        try {
            runRescue = new RunRescue();
        }
        catch (Exception exception) {
            object = exception.getStackTrace();
            String string = "";
            for (int i = 0; i < ((StackTraceElement[])object).length; ++i) {
                string = string + object[i] + "\n";
            }
            JOptionPane.showMessageDialog(null, "Error Loading default config file: " + exception.getMessage() + "\n\n" + exception.toString() + "\n" + string, "Load error!", 0);
            System.exit(0);
        }
        if (runRescue != null) {
            RescueGUI rescueGUI = new RescueGUI(runRescue);
            rescueGUI.setExtendedState(6);
            rescueGUI.setVisible(true);
            object = rescueGUI.getSize();
            rescueGUI.setExtendedState(0);
            rescueGUI.setSize((Dimension)object);
            runRescue.addRescueListener(rescueGUI);
            splashScreen.setVisible(false);
            splashScreen.dispose();
            runRescue.run();
        }
    }
}

