/*
 * Decompiled with CFR 0.152.
 */
package rescue.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import rescue.MissionLoader;
import rescue.MissionObject;
import rescue.RunRescue;
import rescue.qdxml.XMLFileFilter;

public class MissionSetup
extends JDialog
implements ActionListener {
    private RunRescue rescue;
    private MissionLoader currentMission;
    private JLabel missionName;
    private GridBagConstraints gbc;
    private JRadioButton custom;
    private Box thebox;
    private JCheckBox clusterSimilarTypes;
    private Vector changlings;
    private JLabel missionRank;

    public MissionSetup(Frame frame, boolean bl, RunRescue runRescue) {
        super(frame, "Mission Setup", bl);
        this.rescue = runRescue;
        this.initGUI();
        this.loadMission(this.rescue.getMission());
    }

    private void initGUI() {
        this.setResizable(false);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        JButton jButton = new JButton("Load Mission");
        jButton.setActionCommand("load");
        jButton.addActionListener(this);
        jPanel.add(jButton);
        jPanel.add(new JLabel("Current Mission Name:"));
        this.missionName = new JLabel();
        jPanel.add(this.missionName);
        JLabel jLabel = new JLabel("Mission Setup", 0);
        jLabel.setFont(new Font(null, 2, 20));
        this.clusterSimilarTypes = new JCheckBox("Cluster Similar Types");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Select a mission preset", 4, 2, new Font("SansSerif", 0, 11), new Color(60, 60, 60)));
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButton jRadioButton = new JRadioButton("The Cadet's Game", true);
        jRadioButton.setActionCommand("cadet");
        jRadioButton.addActionListener(this);
        JRadioButton jRadioButton2 = new JRadioButton("The Lieutenant's Game");
        jRadioButton2.setActionCommand("lieutenant");
        jRadioButton2.addActionListener(this);
        JRadioButton jRadioButton3 = new JRadioButton("The Captain's Game");
        jRadioButton3.setActionCommand("captain");
        jRadioButton3.addActionListener(this);
        JRadioButton jRadioButton4 = new JRadioButton("The Admiral's Game");
        jRadioButton4.setActionCommand("admiral");
        jRadioButton4.addActionListener(this);
        this.custom = new JRadioButton("Custom");
        this.custom.addActionListener(this);
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton4);
        buttonGroup.add(this.custom);
        jPanel2.add(jRadioButton);
        jPanel2.add(jRadioButton2);
        jPanel2.add(jRadioButton3);
        jPanel2.add(jRadioButton4);
        jPanel2.add(Box.createVerticalStrut(10));
        jPanel2.add(this.custom);
        this.missionRank = new JLabel("Mission Rank:", 0);
        JSeparator jSeparator = new JSeparator();
        JButton jButton2 = new JButton(" Cancel ");
        jButton2.setActionCommand("cancel");
        jButton2.addActionListener(this);
        JButton jButton3 = new JButton("OK");
        jButton3.setActionCommand("ok");
        jButton3.addActionListener(this);
        this.getContentPane().setLayout(new GridBagLayout());
        this.gbc = new GridBagConstraints();
        this.gbc.insets = new Insets(5, 5, 5, 5);
        this.gbc.fill = 1;
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.gridwidth = 2;
        this.gbc.gridheight = 1;
        this.getContentPane().add((Component)jPanel, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 1;
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        this.getContentPane().add((Component)jLabel, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 3;
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        this.getContentPane().add((Component)this.clusterSimilarTypes, this.gbc);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        jPanel3.add((Component)jPanel2, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 1;
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        jPanel3.add((Component)this.missionRank, this.gbc);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        jPanel4.add((Component)new JPanel(), this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 1;
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        jPanel4.add((Component)jButton2, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 2;
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        jPanel4.add((Component)jButton3, this.gbc);
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.add((Component)jSeparator, "South");
        JPanel jPanel6 = new JPanel(new BorderLayout());
        jPanel6.add((Component)jPanel3, "North");
        jPanel6.add(jPanel5);
        jPanel6.add((Component)jPanel4, "South");
        this.gbc.gridx = 1;
        this.gbc.gridy = 1;
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 3;
        this.getContentPane().add((Component)jPanel6, this.gbc);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                MissionSetup.this.closeDialog(windowEvent);
            }
        });
        this.gbc.gridx = 0;
        this.gbc.gridy = 2;
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
    }

    public void loadMission(MissionLoader missionLoader) {
        this.currentMission = missionLoader;
        this.clusterSimilarTypes.setSelected(this.currentMission.getCluster());
        this.missionName.setText(this.currentMission.getMissionName());
        Vector vector = this.currentMission.getMissionObjects();
        Vector<missionObjectPanel> vector2 = new Vector<missionObjectPanel>();
        Vector<missionObjectPanel> vector3 = new Vector<missionObjectPanel>();
        Vector<missionObjectPanel> vector4 = new Vector<missionObjectPanel>();
        String string = this.currentMission.getPlayerObject().getName();
        for (int i = 0; i < vector.size(); ++i) {
            MissionObject missionObject = (MissionObject)vector.elementAt(i);
            if (missionObject.getMin() == missionObject.getMax()) continue;
            missionObjectPanel missionObjectPanel2 = new missionObjectPanel(missionObject);
            if (missionObject.isAllies(string)) {
                vector2.add(missionObjectPanel2);
                continue;
            }
            if (missionObject.isEnemies(string)) {
                vector3.add(missionObjectPanel2);
                continue;
            }
            vector4.add(missionObjectPanel2);
        }
        Box box = new Box(1);
        if (vector2.size() > 0) {
            this.addLabel("ALLIES", box);
            for (int i = 0; i < vector2.size(); ++i) {
                box.add((JPanel)vector2.elementAt(i));
            }
        }
        if (vector3.size() > 0) {
            this.addLabel("ENEMIES", box);
            for (int i = 0; i < vector3.size(); ++i) {
                box.add((JPanel)vector3.elementAt(i));
            }
        }
        if (vector4.size() > 0) {
            this.addLabel("NEUTRAL", box);
            for (int i = 0; i < vector4.size(); ++i) {
                box.add((JPanel)vector4.elementAt(i));
            }
        }
        this.custom.setSelected(true);
        if (this.thebox != null) {
            this.getContentPane().remove(this.thebox);
        }
        this.getContentPane().add((Component)box, this.gbc);
        this.validate();
        this.pack();
        this.repaint();
        this.thebox = box;
        Dimension dimension = this.getOwner().getSize();
        Dimension dimension2 = this.getPreferredSize();
        int n = this.getOwner().getLocation().x + (dimension.width - dimension2.width) / 2;
        int n2 = this.getOwner().getLocation().y + (dimension.height - dimension2.height) / 2;
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        this.setLocation(n, n2);
        this.changlings = vector2;
        this.changlings.addAll(vector3);
        this.changlings.addAll(vector4);
        this.checkMissionRank();
    }

    public void addLabel(String string, Box box) {
        FlowLayout flowLayout = new FlowLayout(3);
        flowLayout.setHgap(20);
        JPanel jPanel = new JPanel(flowLayout);
        jPanel.add(new JLabel("<html><u>" + string + "</u></html>"));
        box.add(jPanel);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("load")) {
            JFileChooser jFileChooser = new JFileChooser("missions");
            XMLFileFilter xMLFileFilter = new XMLFileFilter();
            jFileChooser.setFileFilter(xMLFileFilter);
            int n = jFileChooser.showOpenDialog(this);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                try {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.loadMission(new MissionLoader(file.getPath(), this.rescue));
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, "Error Loading Mission File: " + file.getName() + ".\n" + exception.getMessage(), "Load error!", 0);
                }
            }
        } else if (actionEvent.getActionCommand().equals("cancel")) {
            this.closeDialog(null);
        } else if (actionEvent.getActionCommand().equals("ok")) {
            for (int i = 0; i < this.changlings.size(); ++i) {
                ((missionObjectPanel)this.changlings.elementAt(i)).ok();
            }
            this.currentMission.setCluster(this.clusterSimilarTypes.isSelected());
            this.rescue.setMission(this.currentMission);
            this.closeDialog(null);
        } else if (actionEvent.getActionCommand().equals("cadet")) {
            for (int i = 0; i < this.changlings.size(); ++i) {
                ((missionObjectPanel)this.changlings.elementAt(i)).setCurrentPreset(1);
            }
            this.repaint();
        } else if (actionEvent.getActionCommand().equals("lieutenant")) {
            for (int i = 0; i < this.changlings.size(); ++i) {
                ((missionObjectPanel)this.changlings.elementAt(i)).setCurrentPreset(2);
            }
            this.repaint();
        } else if (actionEvent.getActionCommand().equals("captain")) {
            for (int i = 0; i < this.changlings.size(); ++i) {
                ((missionObjectPanel)this.changlings.elementAt(i)).setCurrentPreset(3);
            }
            this.repaint();
        } else if (actionEvent.getActionCommand().equals("admiral")) {
            for (int i = 0; i < this.changlings.size(); ++i) {
                ((missionObjectPanel)this.changlings.elementAt(i)).setCurrentPreset(4);
            }
            this.repaint();
        }
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    public void checkMissionRank() {
        String string = this.currentMission.getPlayerObject().getName();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.changlings.size(); ++i) {
            int n4 = ((missionObjectPanel)this.changlings.elementAt(i)).getCurrentRank(string);
            if (n4 == -1) continue;
            if (n4 == 8) {
                n3 += n4;
                continue;
            }
            n3 += n4;
            ++n2;
        }
        n = n3 / n2;
        if (n <= 1) {
            this.missionRank.setText("Mission Rank: Cadet");
        } else if (n <= 2) {
            this.missionRank.setText("Mission Rank: Lieutenant");
        } else if (n <= 3) {
            this.missionRank.setText("Mission Rank: Captain");
        } else {
            this.missionRank.setText("Mission Rank: Admiral");
        }
    }

    static /* synthetic */ JRadioButton access$400(MissionSetup missionSetup) {
        return missionSetup.custom;
    }

    class missionObjectPanel
    extends JPanel {
        private MissionObject myMO;
        private JSlider slider;
        private BufferedImage icon;
        private int value;

        public missionObjectPanel(MissionObject missionObject) {
            this.myMO = missionObject;
            Dimension dimension = new Dimension(200, 30);
            this.setMaximumSize(dimension);
            this.setMinimumSize(dimension);
            this.setPreferredSize(dimension);
            this.setLayout(null);
            this.value = missionObject.getNumber();
            this.slider = new JSlider(missionObject.getMin(), missionObject.getMax(), this.value);
            this.slider.setBounds(80, 0, 100, 30);
            this.slider.setMajorTickSpacing(1);
            this.slider.setSnapToTicks(true);
            this.slider.addChangeListener(new ChangeListener(this){
                private final /* synthetic */ missionObjectPanel this$1;
                {
                    this.this$1 = missionObjectPanel2;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    if (missionObjectPanel.access$100(this.this$1) != missionObjectPanel.access$200(this.this$1).getValue()) {
                        MissionSetup.access$400(missionObjectPanel.access$300(this.this$1)).setSelected(true);
                    }
                    missionObjectPanel.access$102(this.this$1, missionObjectPanel.access$200(this.this$1).getValue());
                    missionObjectPanel.access$300(this.this$1).checkMissionRank();
                    this.this$1.repaint();
                }
            });
            this.add(this.slider);
            this.icon = this.myMO.getIcon();
            String string = this.myMO.getName();
            JTextArea jTextArea = new JTextArea(string);
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setOpaque(false);
            jTextArea.setFont(new JLabel().getFont().deriveFont(10.0f));
            jTextArea.setEditable(false);
            if (string.length() > 10) {
                jTextArea.setBounds(25, 2, 55, 30);
            } else {
                jTextArea.setBounds(25, 11, 55, 30);
            }
            Dimension dimension2 = new Dimension(55, 30);
            jTextArea.setPreferredSize(dimension2);
            jTextArea.setMinimumSize(dimension2);
            jTextArea.setMaximumSize(dimension2);
            jTextArea.setFocusable(false);
            this.add(jTextArea);
        }

        public void paintComponent(Graphics graphics) {
            if (this.value != this.slider.getValue()) {
                this.slider.setValue(this.value);
            }
            super.paintComponent(graphics);
            graphics.setColor(Color.BLACK);
            graphics.drawString(this.value + "", 185, 20);
            graphics.drawImage(this.icon, 0, 5, this);
        }

        public void ok() {
            this.myMO.setNumber(this.value);
        }

        public void setCurrentPreset(int n) {
            this.value = this.myMO.getCurrentPreset(n);
        }

        public int getCurrentRank(String string) {
            return this.myMO.getCurrentRank(string, this.value);
        }

        static /* synthetic */ int access$100(missionObjectPanel missionObjectPanel2) {
            return missionObjectPanel2.value;
        }

        static /* synthetic */ JSlider access$200(missionObjectPanel missionObjectPanel2) {
            return missionObjectPanel2.slider;
        }

        static /* synthetic */ MissionSetup access$300(missionObjectPanel missionObjectPanel2) {
            return missionObjectPanel2.MissionSetup.this;
        }

        static /* synthetic */ int access$102(missionObjectPanel missionObjectPanel2, int n) {
            missionObjectPanel2.value = n;
            return missionObjectPanel2.value;
        }
    }
}

