/*
 * Decompiled with CFR 0.152.
 */
package rescue;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.File;
import java.util.Vector;
import rescue.BrowserLauncher;
import rescue.JukeBox;
import rescue.MissionLoader;
import rescue.RescueListener;
import rescue.panels.ShipInfoPanel;
import rescue.panels.ShipsPanel;
import rescue.spaceobjects.Base;
import rescue.spaceobjects.ImageObject;
import rescue.spaceobjects.MannedObject;
import rescue.spaceobjects.Planet;
import rescue.spaceobjects.Ship;
import rescue.spaceobjects.SpaceObject;

public class RunRescue {
    public static final String DEFAULT_MISSION = "missions/rescuemax.xml";
    public static final String VERSION = "1.0.0.2";
    public static final int WIDTH = 1000000;
    public static final int HEIGHT = 1000000;
    public static int DELAY = 20;
    public static final int FAKE_SPEED_OF_LIGHT = 10;
    public static final int DISTANCE_TRACTOR = 250;
    public static final int DISTANCE_PHASERS = 250;
    public static final int DISTANCE_TORPEDO = 500;
    public static final int SELECT_ALL = 0;
    public static final int SELECT_ENEMIES = 1;
    public static final int SELECT_MANUAL = 2;
    public ImageObject[] SpaceObjects;
    public Vector torpedos;
    private RescueListener gui;
    private boolean pause = true;
    private boolean heads = true;
    private Ship playerShip;
    private Vector selectedObjects;
    private int select;
    private Point2D.Double[] sky;
    private double zoom = 1.0;
    private int windowWidth = 1000;
    private int windowHeight = 1000;
    private int panelWidth;
    private int panelHeight;
    private boolean loadgameonstartup = false;
    private MissionLoader currentMission;
    private double fps;
    private long oldtime;
    private double timetotal;
    private int counter;
    private ShipsPanel shiplist;
    private ShipsPanel baselist;
    private ShipInfoPanel shipinfo;
    int shifts = 0;

    public RunRescue() throws Exception {
        this.setMission(new MissionLoader(DEFAULT_MISSION, this));
        this.fps = 1000.0 / (double)DELAY;
        this.oldtime = System.currentTimeMillis();
        this.timetotal = 0.0;
        this.counter = 0;
    }

    public void setDelay(int n) {
        DELAY = n;
    }

    public int getDelay() {
        return DELAY;
    }

    public int getSelect() {
        return this.select;
    }

    public void addRescueListener(RescueListener rescueListener) {
        this.gui = rescueListener;
        if (this.loadgameonstartup) {
            this.loadCurrentMission();
            this.pause = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            if (!this.pause) {
                long l = System.currentTimeMillis();
                this.updateGame();
                this.gui.update();
                try {
                    int n = (int)Math.max(0L, (long)DELAY - (System.currentTimeMillis() - l));
                    Thread.sleep(n);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            try {
                RunRescue runRescue = this;
                synchronized (runRescue) {
                    this.wait();
                    this.pause = false;
                    continue;
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public void updateGUI() {
        if (this.pause) {
            this.gui.update();
        }
    }

    public void setMission(MissionLoader missionLoader) {
        this.currentMission = missionLoader;
    }

    public MissionLoader getMission() {
        return this.currentMission;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCurrentMission() {
        try {
            this.torpedos = new Vector();
            this.SpaceObjects = this.currentMission.getSpaceObjects(this.torpedos);
            this.playerShip = (Ship)this.SpaceObjects[this.SpaceObjects.length - 1];
            this.playerShip.setPlayer(true);
            this.selectedObjects = new Vector();
            this.shiplist = this.currentMission.getShipList();
            this.baselist = this.currentMission.getBaseList();
            this.shipinfo = this.currentMission.getShipInfoPanel();
            this.shiplist.newGame();
            this.baselist.newGame();
            this.shipinfo.setSpaceObject(null);
            this.select = 1;
            this.gui.newGame(this.currentMission);
            RunRescue runRescue = this;
            synchronized (runRescue) {
                this.notify();
            }
            JukeBox.play(101);
            JukeBox.play(1);
        }
        catch (Exception exception) {
            System.out.print("error creating game\n");
            exception.printStackTrace();
        }
    }

    public void closeCurrentMission() {
        this.pause = true;
        this.playerShip = null;
        this.SpaceObjects = null;
        this.gui.closeGame();
        JukeBox.stop(102);
        JukeBox.stop(101);
    }

    public boolean getMode() {
        return this.currentMission.getExternal();
    }

    public void setMode(boolean bl) {
        this.currentMission.setExternal(bl);
    }

    public void setShipsSort(int n) {
        this.shiplist.setSort(n);
        this.updateGUI();
    }

    public void setBaseSort(int n) {
        this.baselist.setSort(n);
        this.updateGUI();
    }

    public void setShipsShow(int n) {
        this.shiplist.setShow(n);
        this.updateGUI();
    }

    public void setBaseShow(int n) {
        this.baselist.setShow(n);
        this.updateGUI();
    }

    public int getShipsSort() {
        return this.shiplist.getSort();
    }

    public int getBaseSort() {
        return this.baselist.getSort();
    }

    public int getShipsShow() {
        return this.shiplist.getShow();
    }

    public int getBaseShow() {
        return this.baselist.getShow();
    }

    public void scrollShips(boolean bl, boolean bl2) {
        if (bl) {
            this.shiplist.scroll(bl2);
        } else {
            this.baselist.scroll(bl2);
        }
        this.updateGUI();
    }

    public boolean canScrollShips(boolean bl, boolean bl2) {
        if (bl) {
            return this.shiplist.canScroll(bl2);
        }
        return this.baselist.canScroll(bl2);
    }

    public void headsUpDisplay() {
        this.heads = !this.heads;
        this.updateGUI();
    }

    public boolean mapUpdating() {
        long l = System.currentTimeMillis();
        this.timetotal += (double)(l - this.oldtime);
        ++this.counter;
        if ((long)this.counter >= Math.max(Math.round(this.fps), 1L)) {
            this.fps = (double)Math.round(1000.0 / (this.timetotal / (double)this.counter) * 100.0) / 100.0;
            if (this.fps > 100.0) {
                this.fps = 100.0;
            }
            this.timetotal = 0.0;
            this.counter = 0;
        }
        this.oldtime = l;
        return this.playerShip != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        if (this.pause && this.SpaceObjects != null) {
            this.oldtime = System.currentTimeMillis();
            RunRescue runRescue = this;
            synchronized (runRescue) {
                this.notify();
            }
        } else {
            this.pause = true;
        }
        this.gui.update();
    }

    public boolean getPause() {
        return this.pause;
    }

    public void zoom(boolean bl) {
        if (bl && this.canZoom(true)) {
            this.zoom *= 2.0;
        } else if (!bl && this.canZoom(false)) {
            this.zoom /= 2.0;
        } else {
            return;
        }
        this.makeSky();
        this.updateGUI();
    }

    public boolean canZoom(boolean bl) {
        if (bl) {
            return !(this.zoom >= 8.0);
        }
        return !(this.zoom <= 0.0625);
    }

    public void setPanelSize(int n, int n2) {
        this.panelWidth = n;
        this.panelHeight = n2;
        this.makeSky();
    }

    public void makeSky() {
        this.sky = new Point2D.Double[(int)Math.round(30.0 / this.zoom)];
        for (int i = 0; i < this.sky.length; ++i) {
            this.sky[i] = new Point2D.Double(Math.random() * (double)this.panelWidth, Math.random() * (double)this.panelHeight);
        }
    }

    public void drawStars(Graphics graphics) {
        Point point = new Point(0, 0);
        if (this.sky == null) {
            this.makeSky();
        } else if (this.playerShip.getImpulseOn() || this.playerShip.getWarpOn()) {
            point = this.playerShip.moveTo();
            point.x = (int)((double)point.x * ((double)this.panelWidth / ((double)this.windowHeight / this.zoom)));
            point.y = (int)((double)point.y * ((double)this.panelHeight / ((double)this.windowHeight / this.zoom)));
        }
        int n = Math.abs(point.x) + Math.abs(point.y);
        if (this.shifts > this.panelWidth && n < this.panelWidth) {
            this.makeSky();
        }
        this.shifts = n;
        graphics.setColor(Color.WHITE);
        for (int i = 0; i < this.sky.length; ++i) {
            graphics.drawLine((int)this.sky[i].x - point.x / 2, (int)this.sky[i].y - point.y / 2, (int)(this.sky[i].x + (double)point.x), (int)(this.sky[i].y + (double)point.y));
        }
    }

    public void drawShipsBig(Graphics graphics) {
        int n;
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        int n2 = (int)((double)this.windowWidth / this.zoom);
        int n3 = (int)((double)this.windowHeight / this.zoom);
        graphics2D.scale((double)this.panelWidth / (double)n2, (double)this.panelHeight / (double)n3);
        int n4 = (int)this.playerShip.getX() - n2 / 2;
        int n5 = (int)this.playerShip.getY() - n3 / 2;
        graphics2D.translate(-n4, -n5);
        Rectangle rectangle = new Rectangle(n4 - 1000, n5 - 1000, n2 + 2000, n3 + 2000);
        for (n = 0; n < this.SpaceObjects.length; ++n) {
            if (!rectangle.contains(this.SpaceObjects[n])) continue;
            if (this.selectedObjects.contains(this.SpaceObjects[n])) {
                this.SpaceObjects[n].drawBigShape(graphics2D, true);
                continue;
            }
            this.SpaceObjects[n].drawBigShape(graphics2D, false);
        }
        for (n = 0; n < this.torpedos.size(); ++n) {
            SpaceObject spaceObject = (SpaceObject)this.torpedos.elementAt(n);
            if (!rectangle.contains(spaceObject)) continue;
            spaceObject.drawBigShape(graphics2D, false);
        }
        graphics2D.setColor(Color.DARK_GRAY);
        graphics2D.drawOval(n4 + n2 / 2 - 250, n5 + n3 / 2 - 250, 500, 500);
        if (this.heads) {
            graphics.setColor(Color.WHITE);
            graphics.drawString("Zoom: x" + this.zoom, 10, 20);
            graphics.drawString("Speed: " + this.playerShip.getSpeedMofC() + " x c", 10, 32);
            graphics.drawString("Direction: " + (int)Math.toDegrees(this.playerShip.getDirection()), 10, 44);
            graphics.drawString("Location: x=" + this.playerShip.x + " y=" + this.playerShip.y, 10, 56);
            if (this.playerShip.getEvasive() != 0) {
                graphics.drawString("Evasive Maneuver: " + this.playerShip.getEvasive(), 10, 68);
            } else if (this.playerShip.getImpulseOn() && this.playerShip.getAutoImpulseOn()) {
                graphics.drawString("Distance to impulse target: " + (int)this.playerShip.distance(this.playerShip.getAutoImpulse()), 10, 68);
            } else if (this.playerShip.getWarpOn() && this.playerShip.getAutoWarpOn()) {
                graphics.drawString("Distance to warp target: " + (int)this.playerShip.distance(this.playerShip.getAutoWarp()), 10, 68);
            }
        }
        if (this.pause) {
            graphics.drawString("Pause", this.panelWidth - 40, 20);
        } else {
            String string = String.valueOf(this.fps);
            while (string.length() < 5) {
                string = string + "0";
            }
            graphics.drawString("fps: " + string, this.panelWidth - 55, 20);
        }
    }

    public void drawShipsSmall(Graphics graphics, int n, int n2) {
        int n3 = 0;
        if (this.playerShip.getSystem(6) == 0) {
            n3 = this.playerShip.getSensorScan();
        }
        for (int i = 0; i < this.SpaceObjects.length; ++i) {
            this.SpaceObjects[i].drawSmallShape(graphics, (double)n / 1000000.0, (double)n2 / 1000000.0, n3);
        }
    }

    public int getScan() {
        return this.playerShip.getSensorScan();
    }

    public void updateGame() {
        Point point;
        int n;
        boolean bl = this.playerShip.isAlive();
        int n2 = this.SpaceObjects.length - 1;
        for (n = 0; n < this.SpaceObjects.length; ++n) {
            point = this.SpaceObjects[n];
            point.advance();
            if (point.x < 0) {
                point.x = 1000000 + point.x;
            }
            if (point.y < 0) {
                point.y = 1000000 + point.y;
            }
            if (point.x > 1000000) {
                point.x -= 1000000;
            }
            if (point.y > 1000000) {
                point.y -= 1000000;
            }
            if (this.select != 1 || !(point instanceof MannedObject) || !((MannedObject)point).enemyOf(n2) || this.selectedObjects.contains(point) || n == n2) continue;
            this.selectedObjects.add(point);
        }
        for (n = 0; n < this.torpedos.size(); ++n) {
            ((SpaceObject)this.torpedos.elementAt(n)).advance();
        }
        for (n = 0; n < this.selectedObjects.size(); ++n) {
            if (!((MannedObject)this.selectedObjects.elementAt(n)).isAlive()) {
                this.selectedObjects.removeElementAt(n);
                --n;
                continue;
            }
            if (this.select != 1 || ((MannedObject)this.selectedObjects.elementAt(n)).enemyOf(n2)) continue;
            this.selectedObjects.removeElementAt(n);
            --n;
        }
        Point point2 = this.playerShip.getAutoImpulse();
        point = this.playerShip.getAutoWarp();
        if (point2 instanceof MannedObject && !((MannedObject)point2).isAlive()) {
            this.playerShip.setAutoImpulse(new Point(point2.x, point2.y));
        }
        if (point instanceof MannedObject && !((MannedObject)point).isAlive()) {
            this.playerShip.setAutoWarp(new Point(point.x, point.y));
        }
        if (this.sky != null && (this.playerShip.getImpulseOn() || this.playerShip.getWarpOn())) {
            Point point3 = this.playerShip.moveTo();
            for (int i = 0; i < this.sky.length; ++i) {
                Point2D.Double double_ = this.sky[i];
                try {
                    double_.x -= (double)point3.x * ((double)this.panelWidth / ((double)this.windowHeight / this.zoom));
                    double_.y -= (double)point3.y * ((double)this.panelHeight / ((double)this.windowHeight / this.zoom));
                    if (double_.x < 0.0 || double_.x > (double)this.panelWidth) {
                        double_.x = point3.x < 0 ? Math.random() * (double)point3.x : (double)this.panelWidth - Math.random() * (double)point3.x;
                        double_.y = Math.random() * (double)this.panelHeight;
                        continue;
                    }
                    if (!(double_.y < 0.0) && !(double_.y > (double)this.panelHeight)) continue;
                    double_.x = Math.random() * (double)this.panelWidth;
                    double_.y = point3.y < 0 ? Math.random() * (double)point3.y : (double)this.panelHeight - Math.random() * (double)point3.y;
                    continue;
                }
                catch (Exception exception) {
                    System.out.print("A star is lost! This should not happen ever!\n");
                }
            }
        }
        if (bl && !this.playerShip.isAlive()) {
            this.gui.dead();
        }
    }

    public Ship getShip() {
        return this.playerShip;
    }

    public ImageObject[] getSpaceObjects() {
        return this.SpaceObjects;
    }

    public int getShipNumbers(int n) {
        int n2;
        block4: {
            block5: {
                int n3;
                block3: {
                    n2 = 0;
                    n3 = this.SpaceObjects.length - 1;
                    if (n != 1) break block3;
                    for (int i = 0; i < this.SpaceObjects.length - 1; ++i) {
                        if (!(this.SpaceObjects[i] instanceof Ship) || !((Ship)this.SpaceObjects[i]).isAlive() || !((Ship)this.SpaceObjects[i]).friendOf(n3)) continue;
                        ++n2;
                    }
                    break block4;
                }
                if (n != 2) break block5;
                for (int i = 0; i < this.SpaceObjects.length - 1; ++i) {
                    if (!(this.SpaceObjects[i] instanceof Ship) || !((Ship)this.SpaceObjects[i]).isAlive() || !((Ship)this.SpaceObjects[i]).enemyOf(n3)) continue;
                    ++n2;
                }
                break block4;
            }
            if (n != 3) break block4;
            for (int i = 0; i < this.SpaceObjects.length - 1; ++i) {
                if (!(this.SpaceObjects[i] instanceof Ship) || ((Ship)this.SpaceObjects[i]).isAlive()) continue;
                ++n2;
            }
        }
        return n2;
    }

    public int getBaseNumbers(int n) {
        int n2;
        block4: {
            block5: {
                block3: {
                    n2 = 0;
                    if (n != 1) break block3;
                    for (int i = 0; i < this.SpaceObjects.length - 1; ++i) {
                        if (!(this.SpaceObjects[i] instanceof Base) || !((Base)this.SpaceObjects[i]).isAlive()) continue;
                        n2 += ((Base)this.SpaceObjects[i]).getPeople();
                    }
                    break block4;
                }
                if (n != 2) break block5;
                for (int i = 0; i < this.SpaceObjects.length - 1; ++i) {
                    if (!(this.SpaceObjects[i] instanceof Planet) || ((Planet)this.SpaceObjects[i]).isAlive() || ((Planet)this.SpaceObjects[i]).getPeople() == 0) continue;
                    ++n2;
                }
                break block4;
            }
            if (n != 3) break block4;
            for (int i = 0; i < this.SpaceObjects.length - 1; ++i) {
                if (!(this.SpaceObjects[i] instanceof Planet) || !((Planet)this.SpaceObjects[i]).isAlive() || ((Planet)this.SpaceObjects[i]).getPeople() == 0) continue;
                ++n2;
            }
        }
        return n2;
    }

    public void newSelection(int n, ImageObject imageObject) {
        if (n == 1) {
            this.baselist.clearSelection();
        } else {
            this.shiplist.clearSelection();
        }
        this.playerShip.setAutoWarp(imageObject);
        this.playerShip.setAutoImpulse(imageObject);
        this.shipinfo.setSpaceObject(imageObject);
        this.updateGUI();
    }

    public void shipDock() {
        if (!this.playerShip.getShieldsUp()) {
            for (int i = 0; i < this.SpaceObjects.length - 1; ++i) {
                if (!this.SpaceObjects[i].hasSelected(this.playerShip) || !(this.SpaceObjects[i] instanceof Base) && !(this.SpaceObjects[i] instanceof Ship) || !((MannedObject)this.SpaceObjects[i]).doYouLike(this.playerShip)) continue;
                this.playerShip.shipDockWith((MannedObject)this.SpaceObjects[i]);
                return;
            }
        }
    }

    public void shipBoard() {
        if (!this.playerShip.getShieldsUp()) {
            for (int i = 0; i < this.SpaceObjects.length - 1; ++i) {
                if (!this.SpaceObjects[i].hasSelected(this.playerShip) || !(this.SpaceObjects[i] instanceof Ship) || !((Ship)this.SpaceObjects[i]).doYouLike(this.playerShip)) continue;
                int n = this.playerShip.getNoAwayTeams();
                int n2 = ((Ship)this.SpaceObjects[i]).getNoAwayTeams();
                this.playerShip.TractorShip(null);
                int n3 = this.SpaceObjects.length - 1;
                Ship ship = this.playerShip;
                this.playerShip.setPlayer(false);
                this.playerShip = (Ship)this.SpaceObjects[i];
                this.playerShip.setPlayer(true);
                ship.sendPeople(this.playerShip);
                ship.changeShields();
                this.SpaceObjects[i] = ship;
                ship.setNumber(i);
                this.SpaceObjects[n3] = this.playerShip;
                this.playerShip.setNumber(n3);
                this.selectedObjects.remove(this.playerShip);
                this.playerShip.TractorShip(ship);
                this.playerShip.setNoAwayTeams(n);
                ((Ship)this.SpaceObjects[i]).setNoAwayTeams(n2);
                this.shiplist.setShow(this.shiplist.getShow());
                this.shipinfo.setSpaceObject(null);
                return;
            }
        }
    }

    public void shipBeamDown() {
        if (!this.playerShip.getShieldsUp() && this.playerShip.getSystem(9) == 0) {
            for (int i = 0; i < this.SpaceObjects.length - 1; ++i) {
                if (!(this.SpaceObjects[i] instanceof MannedObject) || !((MannedObject)this.SpaceObjects[i]).hasSelected(this.playerShip)) continue;
                ((MannedObject)this.SpaceObjects[i]).beamTeamFrom(this.playerShip);
                return;
            }
        }
    }

    public void shipBeamUp() {
        if (!this.playerShip.getShieldsUp() && this.playerShip.getSystem(9) == 0) {
            for (int i = 0; i < this.SpaceObjects.length - 1; ++i) {
                if (!(this.SpaceObjects[i] instanceof MannedObject) || !((MannedObject)this.SpaceObjects[i]).hasSelected(this.playerShip)) continue;
                this.playerShip.beamTeamFrom((MannedObject)this.SpaceObjects[i]);
                return;
            }
        }
    }

    public void shipFireTorpedo() {
        MannedObject mannedObject = this.getClosestSelectedObject();
        if (mannedObject != null && this.playerShip.distance(mannedObject) <= 500.0) {
            this.playerShip.FireTorpedo(mannedObject);
        }
    }

    public void shipFirePhaser() {
        MannedObject mannedObject = this.getClosestSelectedObject();
        if (mannedObject != null && this.playerShip.distance(mannedObject) <= 250.0) {
            this.playerShip.FirePhaser(mannedObject);
        }
    }

    public void shipTractorShip() {
        if (this.playerShip.getTractoredShip() == null) {
            MannedObject mannedObject = this.getClosestSelectedObject();
            if (mannedObject != null && mannedObject instanceof Ship && this.playerShip.distance(mannedObject) <= 250.0) {
                this.playerShip.TractorShip((Ship)mannedObject);
            }
        } else {
            this.playerShip.TractorShip(null);
        }
    }

    public MannedObject getClosestSelectedObject() {
        int n = 0;
        int n2 = 1000000;
        MannedObject mannedObject = null;
        for (int i = 0; i < this.selectedObjects.size(); ++i) {
            n = (int)((MannedObject)this.selectedObjects.elementAt(i)).distance(this.playerShip) - ((MannedObject)this.selectedObjects.elementAt(i)).getSize();
            if (n >= n2) continue;
            n2 = n;
            mannedObject = (MannedObject)this.selectedObjects.elementAt(i);
        }
        return mannedObject;
    }

    public void setSelect(int n) {
        block3: {
            block2: {
                this.select = n;
                this.selectedObjects.removeAllElements();
                if (this.select != 0) break block2;
                for (int i = 0; i < this.SpaceObjects.length - 1; ++i) {
                    if (!(this.SpaceObjects[i] instanceof MannedObject) || !((MannedObject)this.SpaceObjects[i]).isAlive()) continue;
                    this.selectedObjects.add(this.SpaceObjects[i]);
                }
                break block3;
            }
            if (this.select != 1) break block3;
            int n2 = this.SpaceObjects.length - 1;
            for (int i = 0; i < this.SpaceObjects.length - 1; ++i) {
                if (!(this.SpaceObjects[i] instanceof MannedObject) || !((MannedObject)this.SpaceObjects[i]).isAlive() || !((MannedObject)this.SpaceObjects[i]).enemyOf(n2)) continue;
                this.selectedObjects.add(this.SpaceObjects[i]);
            }
        }
    }

    public void selectShips(int n, int n2) {
        Point point = new Point(this.playerShip.x + (int)((double)(n - this.panelWidth / 2) * ((double)this.windowWidth / (double)this.panelWidth) / this.zoom), this.playerShip.y + (int)((double)(n2 - this.panelHeight / 2) * ((double)this.windowHeight / (double)this.panelHeight) / this.zoom));
        for (int i = this.SpaceObjects.length - 2; i >= 0; --i) {
            if (!this.SpaceObjects[i].hasSelected(point) || !(this.SpaceObjects[i] instanceof MannedObject)) continue;
            if (this.select != 2 || !this.selectedObjects.contains(this.SpaceObjects[i])) {
                this.selectedObjects.removeAllElements();
                this.selectedObjects.add(this.SpaceObjects[i]);
            } else {
                this.selectedObjects.removeAllElements();
            }
            this.select = 2;
            break;
        }
        this.updateGUI();
    }

    public void shipManImpulse(double d) {
        this.playerShip.setAutoImpulseOn(false);
        this.playerShip.setManImpulse(d);
        this.playerShip.setImpulseOn(true);
    }

    public void shipManWarp(double d) {
        this.playerShip.setAutoWarpOn(false);
        this.playerShip.setManWarp(d);
        this.playerShip.setWarpOn(true);
    }

    public void shipWarp(int n, int n2, int n3, int n4) {
        this.playerShip.setAutoWarp(new Point((int)((double)n / (double)n3 * 1000000.0), (int)((double)n2 / (double)n4 * 1000000.0)));
        this.updateGUI();
    }

    public void shipImpulse(int n, int n2) {
        Point point = new Point(this.playerShip.x + (int)((double)(n - this.panelWidth / 2) * ((double)this.windowWidth / (double)this.panelWidth) / this.zoom), this.playerShip.y + (int)((double)(n2 - this.panelHeight / 2) * ((double)this.windowHeight / (double)this.panelHeight) / this.zoom));
        this.playerShip.setAutoImpulse(point);
        this.updateGUI();
    }

    public void shipWarpOn() {
        this.playerShip.setWarpOn(true);
    }

    public void shipImpulseOn() {
        this.playerShip.setImpulseOn(true);
    }

    public void help() {
        try {
            File file = new File("help/index.htm");
            BrowserLauncher.openURL("file://" + file.getAbsolutePath());
        }
        catch (Exception exception) {
            System.out.print("cant open help: " + exception.getMessage() + "\n");
        }
    }

    public static double getTurn(double d, double d2) {
        double d3 = Math.abs(d2 - d) > Math.toRadians(180.0) ? (d > d2 ? -(Math.toRadians(360.0) - d) : Math.toRadians(360.0) + d) : d;
        return d3 - d2;
    }
}

