/*
 * Decompiled with CFR 0.152.
 */
package rescue;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.imageio.ImageIO;
import rescue.spaceobjects.Base;
import rescue.spaceobjects.ImageObject;
import rescue.spaceobjects.MannedObject;
import rescue.spaceobjects.Planet;
import rescue.spaceobjects.Ship;
import rescue.spaceobjects.Wormhole;

public class MissionObject {
    private String type;
    private String name;
    private int number;
    public static final int infoImageSize = 150;
    private Vector myObjects;
    private Vector names;
    private Hashtable images;
    private Hashtable icons;
    private Vector types;
    private Vector amounts;
    private int min;
    private int max;
    private int presetCadet;
    private int presetLieutenant;
    private int presetCaptain;
    private int presetAdmiral;
    private int INFOwarp;
    private double INFOimpulse;
    private int INFOjump;
    private int INFOturn;
    private int INFOphaser;
    private int INFOtorpedos;
    private int INFOtractor;
    private int INFOcloak;
    private int INFOmaxtotalenergy;
    private int INFOmaxphaserbanks;
    private int INFOmaxtorpedosleft;
    private int INFOmaxshieldpower;
    BufferedImage imageA;
    BufferedImage imageB;
    BufferedImage imageC;
    BufferedImage imageD;

    public MissionObject(String string, String string2, String string3, String string4, String string5, String string6) throws Exception {
        this.name = string;
        this.number = Integer.parseInt(string5);
        this.type = string6;
        this.names = new Vector();
        this.types = new Vector();
        this.amounts = new Vector();
        this.imageA = ImageIO.read(new File(string2));
        this.imageB = ImageIO.read(new File(string3));
        this.imageC = new BufferedImage(20, 20, 2);
        Graphics graphics = this.imageC.getGraphics();
        graphics.drawImage(this.imageA, 0, 0, 20, 20, null);
        graphics.drawImage(this.imageB, 20 - this.imageB.getWidth(), 20 - this.imageB.getHeight(), null);
        if (string4 != null) {
            this.imageD = ImageIO.read(new File(string4));
        } else {
            this.imageD = new BufferedImage(150, 150, 4);
            graphics = this.imageD.getGraphics();
            graphics.drawImage(this.imageA, 0, 0, 150, 150, null);
        }
        this.images = new Hashtable();
        this.icons = new Hashtable();
        this.INFOwarp = 0;
        this.INFOimpulse = 0.0;
        this.INFOjump = 1;
        this.INFOturn = 1;
        this.INFOphaser = 0;
        this.INFOtorpedos = 0;
        this.INFOtractor = 0;
        this.INFOcloak = 0;
        this.INFOmaxtotalenergy = 0;
        this.INFOmaxphaserbanks = 0;
        this.INFOmaxtorpedosleft = 0;
        this.INFOmaxshieldpower = 0;
    }

    public BufferedImage getIcon() {
        return this.imageC;
    }

    public void setMinMax(String string, String string2) {
        this.min = Integer.parseInt(string);
        this.max = Integer.parseInt(string2);
    }

    public void setPreset(String string, String string2) {
        if (string.equals("cadet")) {
            this.presetCadet = Integer.parseInt(string2);
        } else if (string.equals("lieutenant")) {
            this.presetLieutenant = Integer.parseInt(string2);
        } else if (string.equals("captain")) {
            this.presetCaptain = Integer.parseInt(string2);
        } else if (string.equals("admiral")) {
            this.presetAdmiral = Integer.parseInt(string2);
        }
    }

    public int getCurrentPreset(int n) {
        if (n == 1) {
            return this.presetCadet;
        }
        if (n == 2) {
            return this.presetLieutenant;
        }
        if (n == 3) {
            return this.presetCaptain;
        }
        return this.presetAdmiral;
    }

    public void setNumber(int n) {
        this.number = n;
    }

    public int getNumber() {
        return this.number;
    }

    public void addLike(String string, String string2) {
        this.types.add(string);
        this.amounts.add(new Integer(string2));
    }

    public void addName(String string, String string2) throws Exception {
        this.names.add(string);
        if (string2 != null) {
            BufferedImage bufferedImage = ImageIO.read(new File(string2));
            BufferedImage bufferedImage2 = new BufferedImage(20, 20, 2);
            Graphics graphics = bufferedImage2.getGraphics();
            graphics.drawImage(bufferedImage, 0, 0, 20, 20, null);
            graphics.drawImage(this.imageB, 20 - this.imageB.getWidth(), 20 - this.imageB.getHeight(), null);
            this.images.put(string, bufferedImage);
            this.icons.put(string, bufferedImage2);
        }
    }

    public void setInfoWarp(String string) {
        this.INFOwarp = Integer.parseInt(string);
    }

    public void setInfoImpulse(String string) {
        this.INFOimpulse = Double.parseDouble(string);
    }

    public void setInfoJump(String string) {
        this.INFOjump = Integer.parseInt(string);
    }

    public void setInfoTurn(String string) {
        this.INFOturn = Integer.parseInt(string);
    }

    public void setInfoPhaser(String string) {
        this.INFOphaser = Integer.parseInt(string);
    }

    public void setInfoTorpedos(String string) {
        this.INFOtorpedos = Integer.parseInt(string);
    }

    public void setInfoTractor(String string) {
        this.INFOtractor = Integer.parseInt(string);
    }

    public void setInfoCloak(String string) {
        this.INFOcloak = Integer.parseInt(string);
    }

    public void setInfoMaxTotalEnergy(String string) {
        this.INFOmaxtotalenergy = Integer.parseInt(string);
    }

    public void setInfoMaxPhaserBanks(String string) {
        this.INFOmaxphaserbanks = Integer.parseInt(string);
    }

    public void setInfoMaxTorpedosLeft(String string) {
        this.INFOmaxtorpedosleft = Integer.parseInt(string);
    }

    public void setInfoMaxShieldPower(String string) {
        this.INFOmaxshieldpower = Integer.parseInt(string);
    }

    public int makeSpaceObjects(ImageObject[] imageObjectArray, boolean bl, int n, Vector vector) {
        this.myObjects = new Vector();
        Enumeration enumeration = this.names.elements();
        String string = "";
        int n2 = (int)(Math.random() * 1000000.0);
        int n3 = (int)(Math.random() * 1000000.0);
        for (int i = 0; i < this.number; ++i) {
            ImageObject imageObject = null;
            if (bl && this.type.equals("ship")) {
                n2 = n2 + (int)(Math.random() * 1000000.0 / 10.0) - 50000;
                n3 = n3 + (int)(Math.random() * 1000000.0 / 10.0) - 50000;
            } else {
                n2 = (int)(Math.random() * 1000000.0);
                n3 = (int)(Math.random() * 1000000.0);
            }
            BufferedImage bufferedImage = this.imageA;
            BufferedImage bufferedImage2 = this.imageB;
            BufferedImage bufferedImage3 = this.imageC;
            BufferedImage bufferedImage4 = this.imageD;
            if (this.number == 1) {
                string = this.name;
            } else if (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                BufferedImage bufferedImage5 = (BufferedImage)this.images.get(string);
                if (bufferedImage5 != null) {
                    bufferedImage = bufferedImage5;
                    bufferedImage3 = (BufferedImage)this.icons.get(string);
                    bufferedImage4 = new BufferedImage(150, 150, 4);
                    Graphics graphics = bufferedImage4.getGraphics();
                    graphics.drawImage(bufferedImage, 0, 0, 150, 150, null);
                }
            } else {
                string = this.name + " " + (i + 1);
            }
            if (this.type.equals("ship")) {
                imageObject = new Ship(n, this.name, string, n2, n3, imageObjectArray, bufferedImage, bufferedImage2, bufferedImage3, bufferedImage4, vector);
                imageObject.setInfo(this.INFOwarp, this.INFOimpulse, this.INFOjump, this.INFOturn);
            } else if (this.type.equals("base")) {
                imageObject = new Base(n, this.name, string, n2, n3, imageObjectArray, bufferedImage, bufferedImage2, bufferedImage3, bufferedImage4, vector);
            } else if (this.type.equals("planet")) {
                imageObject = new Planet(n, this.name, string, n2, n3, imageObjectArray, bufferedImage, bufferedImage2, bufferedImage3, bufferedImage4, vector);
            } else if (this.type.equals("wormhole")) {
                imageObject = new Wormhole(n, this.name, string, n2, n3, imageObjectArray, bufferedImage, bufferedImage2, bufferedImage3, bufferedImage4, vector);
            }
            if (imageObject instanceof MannedObject) {
                ((MannedObject)imageObject).setInfo(this.INFOphaser, this.INFOtorpedos, this.INFOtractor, this.INFOcloak, this.INFOmaxtotalenergy, this.INFOmaxphaserbanks, this.INFOmaxtorpedosleft, this.INFOmaxshieldpower);
            }
            imageObjectArray[n] = imageObject;
            ++n;
            this.myObjects.add(imageObject);
        }
        return n;
    }

    public void setLikes(ImageObject[] imageObjectArray) {
        int n;
        int[] nArray = new int[imageObjectArray.length];
        for (n = 0; n < this.types.size(); ++n) {
            String string = (String)this.types.elementAt(n);
            int n2 = (Integer)this.amounts.elementAt(n);
            for (int i = 0; i < imageObjectArray.length; ++i) {
                if (!(imageObjectArray[i] instanceof MannedObject) || !((MannedObject)imageObjectArray[i]).getType().equals(string)) continue;
                nArray[i] = n2;
            }
        }
        for (n = 0; n < this.myObjects.size(); ++n) {
            if (!(this.myObjects.elementAt(n) instanceof MannedObject)) continue;
            ((MannedObject)this.myObjects.elementAt(n)).setLikes(nArray);
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isAllies(String string) {
        for (int i = 0; i < this.types.size(); ++i) {
            if (!((String)this.types.elementAt(i)).equals(string)) continue;
            return (Integer)this.amounts.elementAt(i) > 0;
        }
        return false;
    }

    public boolean isEnemies(String string) {
        for (int i = 0; i < this.types.size(); ++i) {
            if (!((String)this.types.elementAt(i)).equals(string)) continue;
            return (Integer)this.amounts.elementAt(i) < 0;
        }
        return false;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public int getCurrentRank(String string, int n) {
        if (this.isEnemies(string)) {
            if (this.presetAdmiral == 0 && n > 0) {
                return 8;
            }
            if (this.presetAdmiral == 0 && n == 0) {
                return -1;
            }
            if (n >= this.presetAdmiral) {
                return 4;
            }
            if (n >= this.presetCaptain) {
                return 3;
            }
            if (n >= this.presetLieutenant) {
                return 2;
            }
            if (n >= this.presetCadet) {
                return 1;
            }
            return 0;
        }
        return -1;
    }
}

