
define(["resource.dataSource.jdbc", "text!templates/resource.dataSource.jdbc.htm"], function(JdbcDataSourceEditor, editorHtml) {
    describe("jdbcDataSourceEditor", function() {

        var jdbcDriver = {
            "mysql":{"defaultValues":{"dbHost":"localhost","dbPort":"3306"},"jdbcDriverClass":"com.mysql.jdbc.Driver","label":"MySQL","available":true,"jdbcUrl":"jdbc:mysql://$[dbHost]:$[dbPort]/$[dbName]"},
            "postgresql":{"default":"true","defaultValues":{"dbHost":"localhost","dbPort":"5432"},"jdbcDriverClass":"org.postgresql.Driver","label":"PostgreSQL","available":true,"jdbcUrl":"jdbc:postgresql://$[dbHost]:$[dbPort]/$[dbName]"},
            "ingres":{"defaultValues":{"dbHost":"localhost","dbPort":"117"},"jdbcDriverClass":"com.ingres.jdbc.IngresDriver","label":"Ingres","available":false,"jdbcUrl":"jdbc:ingres://$[dbHost]:$[dbPort]/$[dbName]"},
            "oracle":{"defaultValues":{"dbHost":"localhost","dbPort":"1521"},"jdbcDriverClass":"oracle.jdbc.OracleDriver","label":"Oracle","available":false,"jdbcUrl":"jdbc:oracle:thin:@//$[dbHost]:$[dbPort]/$[sName]"},
            "sqlserver":{"defaultValues":{"dbHost":"localhost","dbPort":"1433"},"jdbcDriverClass":"com.microsoft.sqlserver.jdbc.SQLServerDriver","label":"MS SQLServer (2005)","available":false,"jdbcUrl":"jdbc:sqlserver://$[dbHost]:$[dbPort];databaseName=$[dbName]"},
            "sqlserver2000":{"defaultValues":{"dbHost":"localhost","dbPort":"1433"},"jdbcDriverClass":"com.microsoft.jdbc.sqlserver.SQLServerDriver","label":"MS SQLServer (2000)","available":false,"jdbcUrl":"jdbc:microsoft:sqlserver://$[dbHost]:$[dbPort];DatabaseName=$[dbName]"},
            "db2":{"defaultValues":{"dbHost":"localhost","dbPort":"50000","driverType":"4"},"jdbcDriverClass":"com.ibm.db2.jcc.DB2Driver","label":"IBM DB2","available":true,"jdbcUrl":"jdbc:db2://$[dbHost]:$[dbPort]/$[dbName]:driverType=$[driverType];currentSchema=$[schemaName];"},
            "vertica":{"defaultValues":{"dbHost":"localhost","dbPort":"5433"},"jdbcDriverClass":"com.vertica.Driver","label":"Vertica","available":false,"jdbcUrl":"jdbc:vertica://$[dbHost]:$[dbPort]/$[dbName]"},
            "informix":{"defaultValues":{"dbHost":"localhost","dbPort":"1526","dbName":"db"},"jdbcDriverClass":"com.informix.jdbc.IfxDriver","label":"Informix","available":false,"jdbcUrl":"jdbc:informix-sqli://$[dbHost]:$[dbPort]/$[dbName]:INFORMIXSERVER="},
            "SYBASE":{"defaultValues":{"dbHost":"localhost","dbPort":"5433"},"jdbcDriverClass":"com.sybase.jdbc4.jdbc.SybDriver","label":"SYBASE","available":false,"jdbcUrl":"jdbc:sybase:Tds:$[dbHost]:$[dbPort]?ServiceName=$[sName]"}};

        var allData = {
            "mysql":{"name":"mysql","defaultValues":{"dbHost":"localhost","dbPort":"3306"},"jdbcDriverClass":"com.mysql.jdbc.Driver","label":"MySQL","available":true,"jdbcUrl":"jdbc:mysql://$[dbHost]:$[dbPort]/$[dbName]"},
            "postgresql":{"name":"postgresql","default":"true","defaultValues":{"dbHost":"localhost","dbPort":"5432"},"jdbcDriverClass":"org.postgresql.Driver","label":"PostgreSQL","available":true,"jdbcUrl":"jdbc:postgresql://$[dbHost]:$[dbPort]/$[dbName]"},
            "ingres":{"name":"ingres","defaultValues":{"dbHost":"localhost","dbPort":"117"},"jdbcDriverClass":"com.ingres.jdbc.IngresDriver","label":"Ingres","available":false,"jdbcUrl":"jdbc:ingres://$[dbHost]:$[dbPort]/$[dbName]"},
            "oracle":{"name":"oracle","defaultValues":{"dbHost":"localhost","dbPort":"1521"},"jdbcDriverClass":"oracle.jdbc.OracleDriver","label":"Oracle","available":false,"jdbcUrl":"jdbc:oracle:thin:@//$[dbHost]:$[dbPort]/$[sName]"},
            "sqlserver":{"name":"sqlserver","defaultValues":{"dbHost":"localhost","dbPort":"1433"},"jdbcDriverClass":"com.microsoft.sqlserver.jdbc.SQLServerDriver","label":"MS SQLServer (2005)","available":false,"jdbcUrl":"jdbc:sqlserver://$[dbHost]:$[dbPort];databaseName=$[dbName]"},
            "sqlserver2000":{"name":"sqlserver2000","defaultValues":{"dbHost":"localhost","dbPort":"1433"},"jdbcDriverClass":"com.microsoft.jdbc.sqlserver.SQLServerDriver","label":"MS SQLServer (2000)","available":false,"jdbcUrl":"jdbc:microsoft:sqlserver://$[dbHost]:$[dbPort];DatabaseName=$[dbName]"},
            "db2":{"name":"db2","defaultValues":{"dbHost":"localhost","dbPort":"50000","driverType":"4"},"jdbcDriverClass":"com.ibm.db2.jcc.DB2Driver","label":"IBM DB2","available":true,"jdbcUrl":"jdbc:db2://$[dbHost]:$[dbPort]/$[dbName]:driverType=$[driverType];currentSchema=$[schemaName];"},
            "vertica":{"name":"vertica","defaultValues":{"dbHost":"localhost","dbPort":"5433"},"jdbcDriverClass":"com.vertica.Driver","label":"Vertica","available":false,"jdbcUrl":"jdbc:vertica://$[dbHost]:$[dbPort]/$[dbName]"},
            "informix":{"name":"informix","defaultValues":{"dbHost":"localhost","dbPort":"1526","dbName":"db"},"jdbcDriverClass":"com.informix.jdbc.IfxDriver","label":"Informix","available":false,"jdbcUrl":"jdbc:informix-sqli://$[dbHost]:$[dbPort]/$[dbName]:INFORMIXSERVER="},
            "SYBASE":{"name":"SYBASE","defaultValues":{"dbHost":"localhost","dbPort":"5433"},"jdbcDriverClass":"com.sybase.jdbc4.jdbc.SybDriver","label":"SYBASE","available":false,"jdbcUrl":"jdbc:sybase:Tds:$[dbHost]:$[dbPort]?ServiceName=$[sName]"},
            "com.jaspersoft.jasperserver.api.common.service.impl.TestJdbcDriver":{"name":"com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.TestJdbcDriver","label":"com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.TestJdbcDriver","jdbcDriverClass":"com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.TestJdbcDriver","available":true,"isCustom":true}}

        var jdbcDataSourceEditor;
        it("should be defined",function(){
            expect(JdbcDataSourceEditor).toBeDefined();
        });

        var jQStubVal = function(val) {
            this.value = val;
        };

        jQStubVal.prototype.val = function() {
            return this.value;
        };

        var stubVal = function(method, value) {
            sinon.stub(jdbcDataSourceEditor, method, function() {
                return new jQStubVal(value)
            });
        };

        beforeEach(function() {
            setTemplates(editorHtml);
            sinon.stub(resourceLocator, "initialize");

            jdbcDataSourceEditor = new JdbcDataSourceEditor({isEditMode : false});
        });

        afterEach(function() {
            resourceLocator.initialize.restore();
        });

        var restore  = function() {
            jdbcDataSourceEditor.getDriverClassNameInput.restore();
            jdbcDataSourceEditor.getUrlInput.restore();
            jdbcDataSourceEditor.getDriverDataByClassName.restore();
            jdbcDataSourceEditor.isUrlParsable.restore();
        };

        it("Can set existing data, new", function() {
            stubVal("getDriverClassNameInput", "");

            jdbcDataSourceEditor.setExistingDriverData();

            expect(jdbcDataSourceEditor.getExistingDriverData().state).toEqual(jdbcDataSourceEditor.NEW);

            jdbcDataSourceEditor.getDriverClassNameInput.restore();
        });

        it("Can set existing data, pre-defined", function() {
            stubVal("getDriverClassNameInput", "postgresql");
            stubVal("getUrlInput", "jdbc:postgresql://localhost:5432/mydb");
            sinon.stub(jdbcDataSourceEditor, "getDriverDataByClassName", function() {
                return allData.postgresql;
            });
            sinon.stub(jdbcDataSourceEditor, "isUrlParsable", function() {
                return true;
            });

            jdbcDataSourceEditor.setExistingDriverData();

            expect(jdbcDataSourceEditor.getExistingDriverData().state).toEqual(jdbcDataSourceEditor.PRE_DEFINED);

            restore();
        });

        it("Can set existing data, pre-defined wrong", function() {
            stubVal("getDriverClassNameInput", "postgresql");
            stubVal("getUrlInput", "jdbc:postgresql://localhost:5432/mydb");
            sinon.stub(jdbcDataSourceEditor, "getDriverDataByClassName", function() {
                return allData.postgresql;
            });
            sinon.stub(jdbcDataSourceEditor, "isUrlParsable", function() {
                return false;
            });

            jdbcDataSourceEditor.setExistingDriverData();

            expect(jdbcDataSourceEditor.getExistingDriverData().state).toEqual(jdbcDataSourceEditor.PRE_DEFINED_WRONG_URL);

            restore();
        });

        it("Can set existing data, uploaded", function() {
            stubVal("getDriverClassNameInput", "com.jaspersoft.jasperserver.api.common.service.impl.TestJdbcDriver");
            stubVal("getUrlInput", "ANYURL");
            sinon.stub(jdbcDataSourceEditor, "getDriverDataByClassName", function() {
                return allData["com.jaspersoft.jasperserver.api.common.service.impl.TestJdbcDriver"];
            });
            sinon.stub(jdbcDataSourceEditor, "isUrlParsable", function() {
                return false;
            });

            jdbcDataSourceEditor.setExistingDriverData();

            expect(jdbcDataSourceEditor.getExistingDriverData().state).toEqual(jdbcDataSourceEditor.UPLOADED);

            restore();
        });

        it("Can set existing data, uploaded missing", function() {
            stubVal("getDriverClassNameInput", "com.jaspersoft.jasperserver.api.common.service.impl.TestMultipleJarsJdbcDriver");
            stubVal("getUrlInput", "ANYURL");
            sinon.stub(jdbcDataSourceEditor, "getDriverDataByClassName", function() {
                return undefined;
            });
            sinon.stub(jdbcDataSourceEditor, "isUrlParsable", function() {
                return false;
            });

            jdbcDataSourceEditor.setExistingDriverData();

            expect(jdbcDataSourceEditor.getExistingDriverData().state).toEqual(jdbcDataSourceEditor.UPLOADED_MISSING);

            restore();
        });
    });



});