define(["jquery",
        "actionModel.modelGenerator",
        "components.toolbar",
        "text!templates/toolbutton.htm"],
        function(jQuery, actionModel, toolbar, toolbuttonText) {

        describe("components toolbar buttons", function() {
            var actionMap = jasmine.createSpyObj('toolbarActionMap', ['normal', 'disabled']);

            beforeEach(function() {
                setTemplates(toolbuttonText);
                spyOn(actionModel, 'showDynamicMenu');
                spyOn(actionModel, 'hideMenu');

                actionMap.normal.reset();
                actionMap.disabled.reset();
                toolbarButtonModule.initialize(actionMap);
            });

            it("should show menu on mouse enter", function() {
                jQuery('#withMenu').simulate('mouseover');

                expect(actionModel.showDynamicMenu).toHaveBeenCalled();
            });

            it("should not show menu on mouse enter if button disabled", function() {
                jQuery('#withMenuDisabled').simulate('mouseover');
                expect(actionModel.showDynamicMenu).not.toHaveBeenCalled();
            });

            it("should not show menu on mouse enter if button has not mutton pattern", function() {
                jQuery('#normal').simulate('mouseover');
                expect(actionModel.showDynamicMenu).not.toHaveBeenCalled();
            });

            it("should run corresponding action", function() {
                jQuery('#normal').simulate('mouseup');
                expect(actionMap.normal).toHaveBeenCalled();
            });
            it("should not run corresponding action if button is disabled", function() {
                jQuery('#disabled').attr('disabled', true);
                jQuery('#normal').simulate('mouseup');

                expect(actionMap.disabled).not.toHaveBeenCalled();
            });

            it("should determine, if element is tool button or not", function() {
                expect(toolbarButtonModule.isToolBarButton(jQuery('#normal')[0])).toBeTruthy();
                expect(toolbarButtonModule.isToolBarButton(jQuery('#disabled')[0])).toBeTruthy();
                expect(toolbarButtonModule.isToolBarButton(jQuery('#withMenu')[0])).toBeTruthy();
                expect(toolbarButtonModule.isToolBarButton(jQuery('#withMenuDisabled')[0])).toBeTruthy();

                expect(toolbarButtonModule.isToolBarButton(jQuery('#frame')[0])).toBeFalsy();
                expect(toolbarButtonModule.isToolBarButton(jQuery('#menu')[0])).toBeFalsy();
            });

            it("should be able to enable and disable", function() {
                var enabledButton = jQuery('#normal')[0];

                toolbarButtonModule.disable(enabledButton);
                expect(enabledButton).toBeDisabled();

                toolbarButtonModule.enable(enabledButton);
                expect(enabledButton).not.toBeDisabled();
            });

            it("should be able to set button state", function() {
                var enabledButton = jQuery('#normal')[0];

                toolbarButtonModule.setButtonState(enabledButton, false);
                expect(enabledButton).toBeDisabled();

                toolbarButtonModule.setButtonState(enabledButton, true);
                expect(enabledButton).not.toBeDisabled();
            });
        });

    });