//TODO: remove export oriented code
define(["jquery", "underscore", "components.dialog", "components.dialogs", "text!templates/export.htm"],
    function ($, _, Dialog, dialogs, exportText) {

    describe("Dialog", function(){

        var dialog, popupMock;

        beforeEach(function(){
            popupMock = sinon.mock(dialogs.popup);
            dialog = new Dialog();
            setTemplates(exportText,"<div></div>");
        });

        afterEach(function(){
            popupMock.restore();
            $("#exportDialog").remove();
        });

        it("should hide by click on cancel", function(){
            dialog.render($("#"+ jasmine.getFixtures().containerId));
            popupMock.expects("hide").once().withArgs(dialog.el);
            $("#cancelExportButton").trigger("click");
            popupMock.verify();
        });

        xit("can be shown", function(){
            popupMock.expects("show").once().withArgs(dialog.el);
            dialog.show();
            popupMock.verify();
        });

        it("can be hidden", function(){
            popupMock.expects("hide").once().withArgs(dialog.el);
            dialog.hide();
            popupMock.verify();
        });

        describe("Rendering", function(){

            beforeEach(function(){
                dialog.render($("#"+ jasmine.getFixtures().containerId));
            });

            it("chainable render", function(){
                 expect(dialog.render()).toEqual(dialog);
            });

            it("should be rendered", function(){
                expect($("#exportDialog")).toExist();
                expect($("#cancelExportButton")).toExist();
                expect($("#dialogExportButton")).toExist();
            });

        });

    });

    // TODO : finish confirm dialog tests
    xdescribe("Confirm Dialog", function(){

        var dialog, popupMock, dialogDomMock = $(templateEngine.getTemplateText("standardConfirmTemplate")).closest("div"),
            messageText = "confirm dialog message";

        beforeEach(function(){
            popupMock = sinon.mock(dialogs.popup);

            dialog = new ConfirmDialog({el : dialogDomMock});

            sinon.spy(dialog, "render");

            jasmine.getFixtures().set("<div></div>");
        });

        afterEach(function(){
            popupMock.restore();
            dialog.render.restore();
        });

        it("should hide by click on cancel", function(){
            dialog.render($("#"+ jasmine.getFixtures().containerId));
            popupMock.expects("hide").once().withArgs(dialog.el);
            $("button.cancel").trigger("click");
            popupMock.verify();
        });

        it("can be shown", function(){
            sinon.stub(templateEngine, "getTemplateText").
                withArgs("standardConfirmTemplate").
                returns(dialogDomMock);

            popupMock.expects("show").once().withArgs(dialog.el);
            dialog.show();
            expect(dialog.render.calledOnce).toBe(true);
            popupMock.verify();
            templateEngine.getTemplateText.restore();
        });

        it("can be shown with default message", function(){
            sinon.stub(templateEngine, "getTemplateText").
                withArgs("standardConfirmTemplate").
                returns(dialogDomMock);

            popupMock.expects("show").once().withArgs(dialog.el);
            dialog.show();
            expect(dialog.render.calledOnce).toBe(true);
            popupMock.verify();
            templateEngine.getTemplateText.restore();
        });

        it("can be shown with overridden message", function(){
            sinon.stub(templateEngine, "getTemplateText").
                withArgs("standardConfirmTemplate").
                returns(dialogDomMock);

            popupMock.expects("show").once().withArgs(dialog.el);
            dialog.show();
            expect(dialog.render.calledOnce).toBe(true);
            popupMock.verify();
            templateEngine.getTemplateText.restore();
        });

        it("can be hidden", function(){
            popupMock.expects("hide").once().withArgs(dialog.el);
            dialog.hide();
            popupMock.verify();
        });

        describe("Rendering", function(){

            beforeEach(function(){
                dialog.render($("#"+ jasmine.getFixtures().containerId));
            });

            it("chainable render", function(){
                expect(dialog.render()).toEqual(dialog);
            });

            it("should be rendered", function(){
                expect($("#exportDialog")).toExist();
                expect($("button.ok")).toExist();
                expect($("button.cancel")).toExist();
            });

        });

    });

});
