define(["components.about",
        "text!templates/aboutBox.htm",
        "text!templates/about.htm"],
    function(about, aboutBoxText, aboutText) {

        describe("AboutBox Component", function() {
            var aboutBoxDom, closeButton, aboutLink;

            beforeEach(function() {
                about.initialize();

                setTemplates(aboutBoxText, aboutText);

                aboutBoxDom = jQuery("#aboutBox");
                closeButton = jQuery("button");

                aboutLink = jQuery("#about");
            });

            it("should be defined", function() {
                expect(aboutBoxDom).toBeDefined();
            });

            it("should be hidden by default", function() {
                expect(aboutBoxDom).toBeHidden();
            });

            it("should be shown when show() method is called", function() {
                about.aboutBox.show();

                expect(aboutBoxDom).not.toBeHidden();
            });

            it("should be shown 'about' link clicked", function() {
                sinon.spy(about.aboutBox, "show");

                aboutLink.trigger("click");

                expect(about.aboutBox.show.called).toBeTruthy();

                about.aboutBox.show.restore();
            });

            it("should be hidden when user click close button", function() {
                about.aboutBox.show();

                expect(aboutBoxDom).not.toBeHidden();

                closeButton.trigger('click');

                expect(aboutBoxDom).toBeHidden();
            });
        });
    });

