/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * @author inesterenko
 */

define(["jquery", "app.conf.aliases"], function (jQuery, pathsAndAliases) {
    //merge paths and aliases with base configs
    return jQuery.extend(pathsAndAliases, {

        "tests":testPath,
        "templates":testTemplatePath,
        "lib":testLibPath,

        //Plugins aliases
        "text":testLibPath + "/text",
        "domReady":testLibPath + "/domReady",

        //Tests aliases
        "main":testPath + "../main",
        "jasmine":testLibPath + "/jasmine",
        "html.jasmine.reporter":testLibPath + "/html.jasmine.reporter",
        "custom.matchers":testLibPath + "/custom.matchers",
        "jasmine.ext":testLibPath + "/jasmine.ext",
        "junitxml.jasmine.reporter":testLibPath + "/junitxml.jasmine.reporter",
        "console.jasmine.reporter":testLibPath + "/console.jasmine.reporter",
        "jasmine-sinon":testLibPath + "/jasmine-sinon",
        "jquery.simulate" : testLibPath + "/jquery/jquery.simulate",

        "sinon":testLibPath + "/sinon-1.5.2",
        "sinon-ie":testLibPath + "/sinon-ie-1.5.2",
        "sinon-timers-ie":testLibPath + "/sinon-timers-ie-1.5.2"

    });
});