/*
 * Copyright (C) 2005 - 2012 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.jaspersoft.jasperserver.war.common;

import com.jaspersoft.jasperserver.api.engine.jasperreports.util.AwsEc2MetadataClient;
import org.apache.commons.httpclient.methods.PostMethod;


/**
 *
 * @author vsabadosh
 */
public class HeartbeatAwsEc2Contributor implements HeartbeatContributor {

    protected AwsEc2MetadataClient awsEc2MetadataClient;
    private String ceProductCode;
    public static String CE = "CE";
    public static String NOT_EC2 = "NOT_EC2";
    public static String AMI = "AMI";
    public static String EC2 = "EC2";


    @Override
    public void contributeToHttpCall(PostMethod post) {
        String awsEc2InstanceType;
        String awsEc2Instance;
        if (awsEc2MetadataClient.isEc2Instance()) {
            awsEc2InstanceType = awsEc2MetadataClient.getEc2InstanceMetadataItem(AwsEc2MetadataClient.INSTANCE_TYPE_RESOURCE);
            awsEc2Instance = generateAwsInstanceInfo(true);
            post.addParameter("ec2InstanceType", awsEc2InstanceType);
        } else {
            awsEc2Instance = generateAwsInstanceInfo(false);
        }
        post.addParameter("ec2Instance", awsEc2Instance);
    }
    
    protected String generateAwsInstanceInfo(Boolean isEc2Instance) {
        if (isEc2Instance) {
            if (hasJSAwsProductCode()) {
                return AMI + "_" + getServerEdition();
            } else {
                return EC2;
            }
        } else {
            return NOT_EC2;
        }
    }

    protected String getServerEdition() {
        return CE;
    }

    protected Boolean hasJSAwsProductCode() {
        return awsEc2MetadataClient.hasAwsProductCode(ceProductCode);
    }
    
    public void setAwsEc2MetadataClient(AwsEc2MetadataClient awsEc2MetadataClient) {
        this.awsEc2MetadataClient = awsEc2MetadataClient;
    }

    public void setCeProductCode(String ceProductCode) {
        this.ceProductCode = ceProductCode;
    }

}
