/*
* Copyright (C) 2005 - 2009 Jaspersoft Corporation. All rights  reserved.
* http://www.jaspersoft.com.
*
* Unless you have purchased  a commercial license agreement from Jaspersoft,
* the following license terms  apply:
*
* This program is free software: you can redistribute it and/or  modify
* it under the terms of the GNU Affero General Public License  as
* published by the Free Software Foundation, either version 3 of  the
* License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU Affero  General Public License for more details.
*
* You should have received a copy of the GNU Affero General Public  License
* along with this program.&nbsp; If not, see <http://www.gnu.org/licenses/>.
*/
package com.jaspersoft.jasperserver.remote.resources.converters;

import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.BeanReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.client.BeanReportDataSourceImpl;
import com.jaspersoft.jasperserver.dto.resources.ClientBeanDataSource;
import com.jaspersoft.jasperserver.remote.exception.IllegalParameterValueException;
import com.jaspersoft.jasperserver.remote.resources.GenericParametersReflectionHelper;
import org.testng.annotations.Test;

import static org.testng.Assert.assertEquals;
import static org.testng.Assert.assertSame;

/**
 * <p></p>
 *
 * @author Yaroslav.Kovalchyk
 * @version $Id: BeanDataSourceResourceConverterTest.java 29489 2013-03-11 15:59:46Z ztomchenco $
 */
public class BeanDataSourceResourceConverterTest {
    private BeanDataSourceResourceConverter converter = new BeanDataSourceResourceConverter();

    @Test
    public void correctClientServerResourceType(){
        assertEquals(converter.getClientResourceType(), GenericParametersReflectionHelper.extractClientType(ClientBeanDataSource.class));
        assertEquals(converter.getServerResourceType(), BeanReportDataSource.class.getName());
    }

    @Test
    public void resourceSpecificFieldsToServer() throws Exception {
        final String expectedBeanName = "testBeanName";
        final String expectedBeanMethod = "testBeanMethod";
        ClientBeanDataSource clientObject = new ClientBeanDataSource();
        BeanReportDataSource serverObject = new BeanReportDataSourceImpl();
        clientObject.setBeanMethod(expectedBeanMethod);
        clientObject.setBeanName(expectedBeanName);
        final BeanReportDataSource result = converter.resourceSpecificFieldsToServer(clientObject, serverObject);
        assertSame(result, serverObject);
        assertEquals(result.getBeanMethod(), expectedBeanMethod);
        assertEquals(result.getBeanName(), expectedBeanName);
    }

    @Test
    public void resourceSpecificFieldsToClient(){
        final String expectedBeanName = "testBeanName";
        final String expectedBeanMethod = "testBeanMethod";
        ClientBeanDataSource clientObject = new ClientBeanDataSource();
        BeanReportDataSource serverObject = new BeanReportDataSourceImpl();
        serverObject.setBeanMethod(expectedBeanMethod);
        serverObject.setBeanName(expectedBeanName);
        final ClientBeanDataSource result = converter.resourceSpecificFieldsToClient(clientObject, serverObject);
        assertSame(result, clientObject);
        assertEquals(result.getBeanMethod(), expectedBeanMethod);
        assertEquals(result.getBeanName(), expectedBeanName);
    }
}
