/*
* Copyright (C) 2005 - 2009 Jaspersoft Corporation. All rights  reserved.
* http://www.jaspersoft.com.
*
* Unless you have purchased  a commercial license agreement from Jaspersoft,
* the following license terms  apply:
*
* This program is free software: you can redistribute it and/or  modify
* it under the terms of the GNU Affero General Public License  as
* published by the Free Software Foundation, either version 3 of  the
* License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU Affero  General Public License for more details.
*
* You should have received a copy of the GNU Affero General Public  License
* along with this program.&nbsp; If not, see <http://www.gnu.org/licenses/>.
*/
package com.jaspersoft.jasperserver.jaxrs.resources;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.dto.resources.ClientAwsDataSource;
import com.jaspersoft.jasperserver.dto.resources.ClientBeanDataSource;
import com.jaspersoft.jasperserver.dto.resources.ClientCustomDataSource;
import com.jaspersoft.jasperserver.dto.resources.ClientDataType;
import com.jaspersoft.jasperserver.dto.resources.ClientFolder;
import com.jaspersoft.jasperserver.dto.resources.ClientInputControl;
import com.jaspersoft.jasperserver.dto.resources.ClientJdbcDataSource;
import com.jaspersoft.jasperserver.dto.resources.ClientJndiJdbcDataSource;
import com.jaspersoft.jasperserver.dto.resources.ClientListOfValues;
import com.jaspersoft.jasperserver.dto.resources.ClientOlapUnit;
import com.jaspersoft.jasperserver.dto.resources.ClientQuery;
import com.jaspersoft.jasperserver.dto.resources.ClientResourceLookup;
import com.jaspersoft.jasperserver.dto.resources.ClientVirtualDataSource;
import com.jaspersoft.jasperserver.dto.resources.ClientXmlaConnection;
import com.jaspersoft.jasperserver.dto.resources.ResourceMediaType;
import com.jaspersoft.jasperserver.remote.exception.RemoteException;
import com.jaspersoft.jasperserver.remote.resources.converters.ResourceConverterProvider;
import com.jaspersoft.jasperserver.remote.resources.converters.ToClientConverter;
import com.jaspersoft.jasperserver.remote.services.SingleRepositoryService;
import org.springframework.stereotype.Service;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

/**
 * <p></p>
 *
 * @author Yaroslav.Kovalchyk
 * @version $Id: ResourceDetailsJaxrsService.java 29489 2013-03-11 15:59:46Z ztomchenco $
 */
@Service
@Path("/resources/{uri: .+}")
public class ResourceDetailsJaxrsService {
    @javax.annotation.Resource
    private ResourceConverterProvider resourceConverterProvider;
    @javax.annotation.Resource(name = "singleRepositoryService")
    private SingleRepositoryService singleRepositoryService;

    @GET
    @Produces({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
    public Response getResourceDetails(@PathParam("uri")String uri, @HeaderParam(HttpHeaders.ACCEPT)String accept) throws RemoteException {
        Resource resource = singleRepositoryService.getResource(Folder.SEPARATOR + uri);

        final ToClientConverter<? super Resource, ? extends ClientResourceLookup> toClientConverter =
                resourceConverterProvider.getToClientConverter(resource);
        final ClientResourceLookup clientResourceLookup = toClientConverter.toClient(resource);
        String contentTypeTemplate = accept != null && accept.endsWith("json") ? ResourceMediaType.RESOURCE_JSON_TEMPLATE : ResourceMediaType.RESOURCE_XML_TEMPLATE;
        return Response.ok(clientResourceLookup)
                .header(HttpHeaders.CONTENT_TYPE,
                        contentTypeTemplate.replace(ResourceMediaType.RESOURCE_TYPE_PLACEHOLDER,
                                toClientConverter.getClientResourceType()))
                .build();
    }

    @DELETE
    public Response deleteResource(@PathParam("uri") String uri) throws RemoteException {
        singleRepositoryService.deleteResource(Folder.SEPARATOR + uri);
        return Response.noContent().build();
    }

    @POST
    @Consumes({ResourceMediaType.AWS_DATA_SOURCE_XML, ResourceMediaType.AWS_DATA_SOURCE_JSON})
    @Produces({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
    public Response createResource(ClientAwsDataSource resourceLookup,
            @PathParam("uri") String parentUri,
            @HeaderParam(HttpHeaders.ACCEPT) String accept,
            @QueryParam("createFolders")@DefaultValue("true") Boolean createFolders) throws RemoteException {
        return createResourceInternal(resourceLookup, Folder.SEPARATOR + parentUri, accept, createFolders);
    }

    @POST
    @Consumes({ResourceMediaType.BEAN_DATA_SOURCE_XML, ResourceMediaType.BEAN_DATA_SOURCE_JSON})
    @Produces({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
    public Response createResource(ClientBeanDataSource resourceLookup,
            @PathParam("uri")String parentUri,
            @HeaderParam(HttpHeaders.ACCEPT)String accept,
            @QueryParam("createFolders")@DefaultValue("true") Boolean createFolders) throws RemoteException {
        return createResourceInternal(resourceLookup, Folder.SEPARATOR + parentUri, accept, createFolders);
    }

    @POST
    @Consumes({ResourceMediaType.CUSTOM_DATA_SOURCE_XML, ResourceMediaType.CUSTOM_DATA_SOURCE_JSON})
    @Produces({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
    public Response createResource(ClientCustomDataSource resourceLookup,
            @PathParam("uri")String parentUri,
            @HeaderParam(HttpHeaders.ACCEPT)String accept,
            @QueryParam("createFolders")@DefaultValue("true") Boolean createFolders) throws RemoteException {
        return createResourceInternal(resourceLookup, Folder.SEPARATOR + parentUri, accept, createFolders);
    }

    @POST
    @Consumes({ResourceMediaType.DATA_TYPE_XML, ResourceMediaType.DATA_TYPE_JSON})
    @Produces({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
    public Response createResource(ClientDataType resourceLookup,
            @PathParam("uri")String parentUri,
            @HeaderParam(HttpHeaders.ACCEPT)String accept,
            @QueryParam("createFolders")@DefaultValue("true") Boolean createFolders) throws RemoteException {
        return createResourceInternal(resourceLookup, Folder.SEPARATOR + parentUri, accept, createFolders);
    }

    @POST
    @Consumes({ResourceMediaType.FOLDER_XML, ResourceMediaType.FOLDER_JSON})
    @Produces({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
    public Response createResource(ClientFolder resourceLookup,
            @PathParam("uri")String parentUri,
            @HeaderParam(HttpHeaders.ACCEPT)String accept,
            @QueryParam("createFolders")@DefaultValue("true") Boolean createFolders) throws RemoteException {
        return createResourceInternal(resourceLookup, Folder.SEPARATOR + parentUri, accept, createFolders);
    }

    @POST
    @Consumes({ResourceMediaType.JDBC_DATA_SOURCE_XML, ResourceMediaType.JDBC_DATA_SOURCE_JSON})
    @Produces({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
    public Response createResource(ClientJdbcDataSource resourceLookup,
            @PathParam("uri")String parentUri,
            @HeaderParam(HttpHeaders.ACCEPT)String accept,
            @QueryParam("createFolders")@DefaultValue("true") Boolean createFolders) throws RemoteException {
       return createResourceInternal(resourceLookup, Folder.SEPARATOR + parentUri, accept, createFolders);
    }

    @POST
    @Consumes({ResourceMediaType.JNDI_JDBC_DATA_SOURCE_XML, ResourceMediaType.JNDI_JDBC_DATA_SOURCE_JSON})
    @Produces({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
    public Response createResource(ClientJndiJdbcDataSource resourceLookup,
            @PathParam("uri") String parentUri,
            @HeaderParam(HttpHeaders.ACCEPT) String accept,
            @QueryParam("createFolders")@DefaultValue("true") Boolean createFolders) throws RemoteException {
        return createResourceInternal(resourceLookup, Folder.SEPARATOR + parentUri, accept, createFolders);
    }

    @POST
    @Consumes({ResourceMediaType.LIST_OF_VALUES_XML, ResourceMediaType.LIST_OF_VALUES_JSON})
    @Produces({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
    public Response createResource(ClientListOfValues resourceLookup,
            @PathParam("uri")String parentUri,
            @HeaderParam(HttpHeaders.ACCEPT)String accept,
            @QueryParam("createFolders")@DefaultValue("true") Boolean createFolders) throws RemoteException {
        return createResourceInternal(resourceLookup, Folder.SEPARATOR + parentUri, accept, createFolders);
    }

    @POST
    @Consumes({ResourceMediaType.OLAP_UNIT_XML, ResourceMediaType.OLAP_UNIT_JSON})
    @Produces({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
    public Response createResource(ClientOlapUnit resourceLookup,
            @PathParam("uri")String parentUri,
            @HeaderParam(HttpHeaders.ACCEPT)String accept,
            @QueryParam("createFolders")@DefaultValue("true") Boolean createFolders) throws RemoteException {
        return createResourceInternal(resourceLookup, Folder.SEPARATOR + parentUri, accept, createFolders);
    }

    @POST
    @Consumes({ResourceMediaType.QUERY_XML, ResourceMediaType.QUERY_JSON})
    @Produces({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
    public Response createResource(ClientQuery resourceLookup,
            @PathParam("uri")String parentUri,
            @HeaderParam(HttpHeaders.ACCEPT)String accept,
            @QueryParam("createFolders")@DefaultValue("true") Boolean createFolders) throws RemoteException {
        return createResourceInternal(resourceLookup, Folder.SEPARATOR + parentUri, accept, createFolders);
    }

    @POST
    @Consumes({ResourceMediaType.VIRTUAL_DATA_SOURCE_XML, ResourceMediaType.VIRTUAL_DATA_SOURCE_JSON})
    @Produces({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
    public Response createResource(ClientVirtualDataSource resourceLookup,
            @PathParam("uri")String parentUri,
            @HeaderParam(HttpHeaders.ACCEPT)String accept,
            @QueryParam("createFolders")@DefaultValue("true") Boolean createFolders) throws RemoteException {
       return createResourceInternal(resourceLookup, Folder.SEPARATOR + parentUri, accept, createFolders);
    }

    @POST
    @Consumes({ResourceMediaType.XMLA_CONNECTION_XML, ResourceMediaType.XMLA_CONNECTION_JSON})
    @Produces({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
    public Response createResource(ClientXmlaConnection resourceLookup,
            @PathParam("uri")String parentUri,
            @HeaderParam(HttpHeaders.ACCEPT)String accept,
            @QueryParam("createFolders")@DefaultValue("true") Boolean createFolders) throws RemoteException {
        return createResourceInternal(resourceLookup, Folder.SEPARATOR + parentUri, accept, createFolders);
    }

    @POST
    @Consumes({ResourceMediaType.INPUT_CONTROL_XML, ResourceMediaType.INPUT_CONTROL_JSON})
    @Produces({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
    public Response createResource(ClientInputControl resourceLookup,
            @PathParam("uri")String parentUri,
            @HeaderParam(HttpHeaders.ACCEPT)String accept,
            @QueryParam("createFolders")@DefaultValue("true") Boolean createFolders) throws RemoteException {
        return createResourceInternal(resourceLookup, Folder.SEPARATOR + parentUri, accept, createFolders);
    }

    @POST
    public Response copyResource(@PathParam("uri") String uri,
            @HeaderParam(HttpHeaders.CONTENT_LOCATION) String sourceUri,
            @QueryParam("createFolders")@DefaultValue("true")Boolean createFolders,
            @QueryParam("overwrite")@DefaultValue("false")Boolean overwrite) throws RemoteException{
        singleRepositoryService.copyResource(sourceUri, Folder.SEPARATOR + uri, createFolders, overwrite);
        return Response.noContent().build();
    }

    @PUT
    public Response moveResource(@PathParam("uri")String uri,
            @HeaderParam(HttpHeaders.CONTENT_LOCATION) String sourceUri,
            @QueryParam("createFolders")@DefaultValue("true") Boolean createFolders,
            @QueryParam("overwrite")@DefaultValue("false") Boolean overwrite) throws RemoteException{
        singleRepositoryService.moveResource(sourceUri, Folder.SEPARATOR + uri, createFolders, overwrite);
        return Response.noContent().build();
    }

    Response createResourceInternal(ClientResourceLookup resourceLookup, String parentUri, String accept, boolean createFolders) throws RemoteException{
        Resource serverResource = resourceConverterProvider.getToServerConverter(resourceLookup).toServer(resourceLookup);
        serverResource = singleRepositoryService.createResource(serverResource, parentUri, accept, createFolders);
        resourceLookup = resourceConverterProvider.getToClientConverter(serverResource).toClient(serverResource);
        return Response.status(Response.Status.CREATED).entity(resourceLookup).build();
    }
}
