package com.jaspersoft.jasperserver.dto.authority;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import java.util.Date;
import java.util.Set;

/**
 * @author: Zakhar.Tomchenco
 */

@XmlRootElement(name = "user")
public class ClientUser {
    private Set<ClientRole> roleSet;
    private String fullName;
    private String password;
    private String emailAddress;
    private Boolean externallyDefined;
    private Boolean enabled;
    private Date previousPasswordChangeTime;
    private String tenantId;
    private String username;

    @XmlElementWrapper(name = "roles")
    @XmlElement(name = "role")
    public Set<ClientRole> getRoleSet() {
        return roleSet;
    }

    public void setRoleSet(Set<ClientRole> roleSet) {
        this.roleSet = roleSet;
    }

    @XmlElement(name = "fullName")
    public String getFullName() {
        return fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    @XmlElement(name = "password")
    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @XmlElement(name = "emailAddress")
    public String getEmailAddress() {
        return emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    @XmlElement(name = "externallyDefined")
    public Boolean isExternallyDefined() {
        return externallyDefined;
    }

    public void setExternallyDefined(Boolean externallyDefined) {
        this.externallyDefined = externallyDefined;
    }

    @XmlElement(name = "enabled")
    public Boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @XmlElement(name = "previousPasswordChangeTime")
    public Date getPreviousPasswordChangeTime() {
        return previousPasswordChangeTime;
    }

    public void setPreviousPasswordChangeTime(Date previousPasswordChangeTime) {
        this.previousPasswordChangeTime = previousPasswordChangeTime;
    }

    @XmlElement(name = "tenantId")
    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @XmlElement(name = "username")
    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }
}
