/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.jaspersoft.jasperserver.api.engine.common.util.impl;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.common.util.FTPService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTP;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.FTPSClient;
import java.io.InputStream;


public class FTPUtil implements FTPService {

    private static final Log log = LogFactory.getLog(FTPUtil.class);


    public FTPServiceClient connect(String host, String userName, String password) throws Exception {
        return new FTPServiceClientImpl(host, userName, password);
    }

    public class FTPServiceClientImpl implements FTPServiceClient {

        private FTPSClient ftpClient = null;

        public FTPServiceClientImpl(String host, String userName, String password) throws Exception {
            ftpClient = new FTPSClient(false);
            ftpClient.connect(host);
            if (!ftpClient.login(userName, password)) {
                ftpClient.logout();
            }
            if (log.isDebugEnabled()) log.debug("FTP:  connected to " + host + " LOGIN OK.");

            // After connection attempt, you should check the reply code to verify
            // success.
            int reply = ftpClient.getReplyCode();

            if (!FTPReply.isPositiveCompletion(reply)) {
                ftpClient.disconnect();
                throw new JSException("FTP:  unable to connect to " + host);
            }
            if (log.isDebugEnabled()) log.debug("Connected to " + host + " REPLY OK.");
            ftpClient.execPBSZ(0);
            ftpClient.execPROT("P");
            ftpClient.enterLocalPassiveMode();
        }

        public void disconnect() throws Exception {
            try {
                if ((ftpClient != null) && (ftpClient.isConnected())) ftpClient.disconnect();
            } catch (Exception ex) {
                throw ex;
            } finally {
                ftpClient = null;
            }
        }

        public void changeDirectory(String directoryPath) throws Exception {
            if (log.isDebugEnabled()) log.debug("Original Working directory = " + ftpClient.printWorkingDirectory());
            if (ftpClient == null) throw new JSException("Please connect to FTP server first before changing directory!");
            ftpClient.changeWorkingDirectory(directoryPath);
            if (log.isDebugEnabled()) log.debug("NEW Working directory = " + ftpClient.printWorkingDirectory());
        }


        public InputStream getFile(String fileName) throws Exception {
            if (ftpClient == null) throw new JSException("Please connect to FTP server first before changing directory!");
            return ftpClient.retrieveFileStream(fileName);
        }

        public void putFile(String fileName, InputStream inputData) throws Exception {
            if (ftpClient == null) throw new JSException("Please connect to FTP server first before changing directory!");
            ftpClient.setFileType(FTP.BINARY_FILE_TYPE);
            boolean state = ftpClient.storeFile(ftpClient.printWorkingDirectory() + "/" + fileName, inputData);
            if (!state) {
               throw new JSException("Fail to upload file " + fileName);
            }
        }

        public boolean exists(String fileName) throws Exception {
            if (ftpClient == null) throw new JSException("Please connect to FTP server first before changing directory!");
            try {
                if (log.isDebugEnabled()) log.debug("FTP Working directory = " + ftpClient.printWorkingDirectory());
                FTPFile[] files = ftpClient.listFiles(ftpClient.printWorkingDirectory());

                if (log.isDebugEnabled()) log.debug("FTP:  number of files - " + (files == null ? "NULL" : files.length));

                if (files == null) return false;
                for (FTPFile ftpFile : files) {
                    if (ftpFile.getName().equalsIgnoreCase(fileName)) return true;
                }
                return false;
            } catch (Exception ex) {
                ex.printStackTrace();
                return false;
            }
        }

    }
}
