/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.install;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.apache.maven.plugins:maven-install-plugin:2.3", 0);
        this.append(sb, "", 0);
        this.append(sb, "Maven Install Plugin 2.3", 0);
        this.append(sb, "Copies the project artifacts to the user's local repository.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 3 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "install:help", 0);
            this.append(sb, "Display help information on maven-install-plugin.\nCall\n\u00a0\u00a0mvn\u00a0install:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "install".equals(this.goal)) {
            this.append(sb, "install:install", 0);
            this.append(sb, "Installs the project's main artifact in the local repository.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "createChecksum (Default: false)", 2);
                this.append(sb, "Flag whether to create checksums (MD5, SHA-1) or not.", 3);
                this.append(sb, "", 0);
                this.append(sb, "updateReleaseInfo (Default: false)", 2);
                this.append(sb, "Whether to update the metadata to make the artifact a release version.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "install-file".equals(this.goal)) {
            this.append(sb, "install:install-file", 0);
            this.append(sb, "Installs a file in the local repository.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "artifactId", 2);
                this.append(sb, "ArtifactId of the artifact to be installed. Retrieved from POM file if one is specified.", 3);
                this.append(sb, "", 0);
                this.append(sb, "classifier", 2);
                this.append(sb, "Classifier type of the artifact to be installed. For example, 'sources' or 'javadoc'. Defaults to none which means this is the project's main artifact.", 3);
                this.append(sb, "", 0);
                this.append(sb, "createChecksum (Default: false)", 2);
                this.append(sb, "Flag whether to create checksums (MD5, SHA-1) or not.", 3);
                this.append(sb, "", 0);
                this.append(sb, "file", 2);
                this.append(sb, "The file to be installed in the local repository.", 3);
                this.append(sb, "", 0);
                this.append(sb, "generatePom", 2);
                this.append(sb, "Generate a minimal POM for the artifact if none is supplied via the parameter pomFile. Defaults to true if there is no existing POM in the local repository yet.", 3);
                this.append(sb, "", 0);
                this.append(sb, "groupId", 2);
                this.append(sb, "GroupId of the artifact to be installed. Retrieved from POM file if one is specified.", 3);
                this.append(sb, "", 0);
                this.append(sb, "javadoc", 2);
                this.append(sb, "The bundled API docs for the artifact.", 3);
                this.append(sb, "", 0);
                this.append(sb, "localRepositoryPath", 2);
                this.append(sb, "The path for a specific local repository directory. If not specified the local repository path configured in the Maven settings will be used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "packaging", 2);
                this.append(sb, "Packaging type of the artifact to be installed. Retrieved from POM file if one is specified.", 3);
                this.append(sb, "", 0);
                this.append(sb, "pomFile", 2);
                this.append(sb, "Location of an existing POM file to be installed alongside the main artifact, given by the file parameter.", 3);
                this.append(sb, "", 0);
                this.append(sb, "repositoryLayout (Default: default)", 2);
                this.append(sb, "The type of remote repository layout to install to. Try legacy for a Maven 1.x-style repository layout.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sources", 2);
                this.append(sb, "The bundled sources for the artifact.", 3);
                this.append(sb, "", 0);
                this.append(sb, "updateReleaseInfo (Default: false)", 2);
                this.append(sb, "Whether to update the metadata to make the artifact a release version.", 3);
                this.append(sb, "", 0);
                this.append(sb, "version", 2);
                this.append(sb, "Version of the artifact to be installed. Retrieved from POM file if one is specified.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

