/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.surefire.util.DirectoryScanner;
import org.apache.maven.surefire.util.NestedRuntimeException;
import org.apache.maven.surefire.util.RunOrder;
import org.apache.maven.surefire.util.ScannerFilter;
import org.apache.maven.surefire.util.TestsToRun;

public class DefaultDirectoryScanner
implements DirectoryScanner {
    private static final String FS = System.getProperty("file.separator");
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String JAVA_SOURCE_FILE_EXTENSION = ".java";
    private static final String JAVA_CLASS_FILE_EXTENSION = ".class";
    private final File basedir;
    private final List includes;
    private final List excludes;
    private final List classesSkippedByValidation = new ArrayList();
    private final Comparator sortOrder;
    private final RunOrder runOrder;

    public DefaultDirectoryScanner(File basedir, List includes, List excludes, RunOrder runOrder) {
        this.basedir = basedir;
        this.includes = includes;
        this.excludes = excludes;
        this.runOrder = runOrder;
        this.sortOrder = this.getSortOrderComparator();
    }

    public TestsToRun locateTestClasses(ClassLoader classLoader, ScannerFilter scannerFilter) {
        String[] testClassNames = this.collectTests();
        ArrayList<Class> result = new ArrayList<Class>();
        for (int i = 0; i < testClassNames.length; ++i) {
            String className = testClassNames[i];
            Class testClass = DefaultDirectoryScanner.loadClass(classLoader, className);
            if (scannerFilter == null || scannerFilter.accept(testClass)) {
                result.add(testClass);
                continue;
            }
            this.classesSkippedByValidation.add(testClass);
        }
        this.orderTestClasses(result);
        return new TestsToRun(result);
    }

    private static Class loadClass(ClassLoader classLoader, String className) {
        Class<?> testClass;
        try {
            testClass = classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new NestedRuntimeException("Unable to create test class '" + className + "'", e);
        }
        return testClass;
    }

    String[] collectTests() {
        String[] tests = EMPTY_STRING_ARRAY;
        if (this.basedir.exists()) {
            org.apache.maven.surefire.shade.org.codehaus.plexus.util.DirectoryScanner scanner = new org.apache.maven.surefire.shade.org.codehaus.plexus.util.DirectoryScanner();
            scanner.setBasedir(this.basedir);
            if (this.includes != null) {
                scanner.setIncludes(DefaultDirectoryScanner.processIncludesExcludes(this.includes));
            }
            if (this.excludes != null) {
                scanner.setExcludes(DefaultDirectoryScanner.processIncludesExcludes(this.excludes));
            }
            scanner.scan();
            tests = scanner.getIncludedFiles();
            for (int i = 0; i < tests.length; ++i) {
                String test = tests[i];
                test = test.substring(0, test.indexOf("."));
                tests[i] = test.replace(FS.charAt(0), '.');
            }
        }
        return tests;
    }

    private static String[] processIncludesExcludes(List list) {
        ArrayList<String> newList = new ArrayList<String>();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            String include = (String)iter.next();
            String[] includes = include.split(",");
            for (int i = 0; i < includes.length; ++i) {
                newList.add(includes[i]);
            }
        }
        String[] incs = new String[newList.size()];
        for (int i = 0; i < incs.length; ++i) {
            String inc = (String)newList.get(i);
            if (inc.endsWith(JAVA_SOURCE_FILE_EXTENSION)) {
                inc = new StringBuffer(inc.length() - JAVA_SOURCE_FILE_EXTENSION.length() + JAVA_CLASS_FILE_EXTENSION.length()).append(inc.substring(0, inc.lastIndexOf(JAVA_SOURCE_FILE_EXTENSION))).append(JAVA_CLASS_FILE_EXTENSION).toString();
            }
            incs[i] = inc;
        }
        return incs;
    }

    public List getClassesSkippedByValidation() {
        return this.classesSkippedByValidation;
    }

    private void orderTestClasses(List testClasses) {
        if (RunOrder.RANDOM.equals(this.runOrder)) {
            Collections.shuffle(testClasses);
        } else if (this.sortOrder != null) {
            Collections.sort(testClasses, this.sortOrder);
        }
    }

    private Comparator getSortOrderComparator() {
        if (RunOrder.ALPHABETICAL.equals(this.runOrder)) {
            return this.getAlphabeticalComparator();
        }
        if (RunOrder.REVERSE_ALPHABETICAL.equals(this.runOrder)) {
            return this.getReverseAlphabeticalComparator();
        }
        if (RunOrder.HOURLY.equals(this.runOrder)) {
            int hour = Calendar.getInstance().get(11);
            return hour % 2 == 0 ? this.getAlphabeticalComparator() : this.getReverseAlphabeticalComparator();
        }
        return null;
    }

    private Comparator getReverseAlphabeticalComparator() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Class)o2).getName().compareTo(((Class)o1).getName());
            }
        };
    }

    private Comparator getAlphabeticalComparator() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Class)o1).getName().compareTo(((Class)o2).getName());
            }
        };
    }
}

