/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.wrapper;

import javax.servlet.http.HttpServletRequest;
import junit.framework.TestCase;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.security.Authentication;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.providers.TestingAuthenticationToken;
import org.springframework.security.userdetails.User;
import org.springframework.security.util.PortResolver;
import org.springframework.security.util.PortResolverImpl;
import org.springframework.security.wrapper.SecurityContextHolderAwareRequestWrapper;

public class SecurityContextHolderAwareRequestWrapperTests
extends TestCase {
    public SecurityContextHolderAwareRequestWrapperTests() {
    }

    public SecurityContextHolderAwareRequestWrapperTests(String arg0) {
        super(arg0);
    }

    protected void tearDown() throws Exception {
        SecurityContextHolder.clearContext();
    }

    public void testCorrectOperationWithStringBasedPrincipal() throws Exception {
        TestingAuthenticationToken auth = new TestingAuthenticationToken((Object)"rod", (Object)"koala", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_FOO")});
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/");
        SecurityContextHolderAwareRequestWrapper wrapper = new SecurityContextHolderAwareRequestWrapper((HttpServletRequest)request, (PortResolver)new PortResolverImpl(), "");
        SecurityContextHolderAwareRequestWrapperTests.assertEquals((String)"rod", (String)wrapper.getRemoteUser());
        SecurityContextHolderAwareRequestWrapperTests.assertTrue((boolean)wrapper.isUserInRole("ROLE_FOO"));
        SecurityContextHolderAwareRequestWrapperTests.assertFalse((boolean)wrapper.isUserInRole("ROLE_NOT_GRANTED"));
        SecurityContextHolderAwareRequestWrapperTests.assertEquals((Object)((Object)auth), (Object)wrapper.getUserPrincipal());
    }

    public void testUseOfRolePrefixMeansItIsntNeededWhenCallngIsUserInRole() {
        TestingAuthenticationToken auth = new TestingAuthenticationToken((Object)"rod", (Object)"koala", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_FOO")});
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/");
        SecurityContextHolderAwareRequestWrapper wrapper = new SecurityContextHolderAwareRequestWrapper((HttpServletRequest)request, (PortResolver)new PortResolverImpl(), "ROLE_");
        SecurityContextHolderAwareRequestWrapperTests.assertTrue((boolean)wrapper.isUserInRole("FOO"));
    }

    public void testCorrectOperationWithUserDetailsBasedPrincipal() throws Exception {
        TestingAuthenticationToken auth = new TestingAuthenticationToken((Object)new User("rodAsUserDetails", "koala", true, true, true, true, new GrantedAuthority[0]), (Object)"koala", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_HELLO"), new GrantedAuthorityImpl("ROLE_FOOBAR")});
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/");
        SecurityContextHolderAwareRequestWrapper wrapper = new SecurityContextHolderAwareRequestWrapper((HttpServletRequest)request, (PortResolver)new PortResolverImpl(), "");
        SecurityContextHolderAwareRequestWrapperTests.assertEquals((String)"rodAsUserDetails", (String)wrapper.getRemoteUser());
        SecurityContextHolderAwareRequestWrapperTests.assertFalse((boolean)wrapper.isUserInRole("ROLE_FOO"));
        SecurityContextHolderAwareRequestWrapperTests.assertFalse((boolean)wrapper.isUserInRole("ROLE_NOT_GRANTED"));
        SecurityContextHolderAwareRequestWrapperTests.assertTrue((boolean)wrapper.isUserInRole("ROLE_FOOBAR"));
        SecurityContextHolderAwareRequestWrapperTests.assertTrue((boolean)wrapper.isUserInRole("ROLE_HELLO"));
        SecurityContextHolderAwareRequestWrapperTests.assertEquals((Object)((Object)auth), (Object)wrapper.getUserPrincipal());
    }

    public void testRoleIsntHeldIfAuthenticationIsNull() throws Exception {
        SecurityContextHolder.getContext().setAuthentication(null);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/");
        SecurityContextHolderAwareRequestWrapper wrapper = new SecurityContextHolderAwareRequestWrapper((HttpServletRequest)request, (PortResolver)new PortResolverImpl(), "");
        SecurityContextHolderAwareRequestWrapperTests.assertNull((Object)wrapper.getRemoteUser());
        SecurityContextHolderAwareRequestWrapperTests.assertFalse((boolean)wrapper.isUserInRole("ROLE_ANY"));
        SecurityContextHolderAwareRequestWrapperTests.assertNull((Object)wrapper.getUserPrincipal());
    }

    public void testRolesArentHeldIfAuthenticationPrincipalIsNull() throws Exception {
        TestingAuthenticationToken auth = new TestingAuthenticationToken(null, (Object)"koala", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_HELLO"), new GrantedAuthorityImpl("ROLE_FOOBAR")});
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/");
        SecurityContextHolderAwareRequestWrapper wrapper = new SecurityContextHolderAwareRequestWrapper((HttpServletRequest)request, (PortResolver)new PortResolverImpl(), "");
        SecurityContextHolderAwareRequestWrapperTests.assertNull((Object)wrapper.getRemoteUser());
        SecurityContextHolderAwareRequestWrapperTests.assertFalse((boolean)wrapper.isUserInRole("ROLE_HELLO"));
        SecurityContextHolderAwareRequestWrapperTests.assertFalse((boolean)wrapper.isUserInRole("ROLE_FOOBAR"));
        SecurityContextHolderAwareRequestWrapperTests.assertNull((Object)wrapper.getUserPrincipal());
    }
}

