/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.userdetails.ldap;

import javax.naming.Name;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import junit.framework.TestCase;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.userdetails.ldap.LdapUserDetailsImpl;
import org.springframework.security.userdetails.ldap.LdapUserDetailsMapper;

public class LdapUserDetailsMapperTests
extends TestCase {
    public void testMultipleRoleAttributeValuesAreMappedToAuthorities() throws Exception {
        LdapUserDetailsMapper mapper = new LdapUserDetailsMapper();
        mapper.setConvertToUpperCase(false);
        mapper.setRolePrefix("");
        mapper.setRoleAttributes(new String[]{"userRole"});
        DirContextAdapter ctx = new DirContextAdapter();
        ctx.setAttributeValues("userRole", (Object[])new String[]{"X", "Y", "Z"});
        ctx.setAttributeValue("uid", (Object)"ani");
        LdapUserDetailsImpl user = (LdapUserDetailsImpl)mapper.mapUserFromContext((DirContextOperations)ctx, "ani", new GrantedAuthority[0]);
        LdapUserDetailsMapperTests.assertEquals((int)3, (int)user.getAuthorities().length);
    }

    public void testNonRetrievedRoleAttributeIsIgnored() throws Exception {
        LdapUserDetailsMapper mapper = new LdapUserDetailsMapper();
        mapper.setRoleAttributes(new String[]{"userRole", "nonRetrievedAttribute"});
        BasicAttributes attrs = new BasicAttributes();
        attrs.put(new BasicAttribute("userRole", "x"));
        DirContextAdapter ctx = new DirContextAdapter((Attributes)attrs, (Name)new DistinguishedName("cn=someName"));
        ctx.setAttributeValue("uid", (Object)"ani");
        LdapUserDetailsImpl user = (LdapUserDetailsImpl)mapper.mapUserFromContext((DirContextOperations)ctx, "ani", new GrantedAuthority[0]);
        LdapUserDetailsMapperTests.assertEquals((int)1, (int)user.getAuthorities().length);
        LdapUserDetailsMapperTests.assertEquals((String)"ROLE_X", (String)user.getAuthorities()[0].getAuthority());
    }

    public void testPasswordAttributeIsMappedCorrectly() throws Exception {
        LdapUserDetailsMapper mapper = new LdapUserDetailsMapper();
        mapper.setPasswordAttributeName("myappsPassword");
        BasicAttributes attrs = new BasicAttributes();
        attrs.put(new BasicAttribute("myappsPassword", "mypassword".getBytes()));
        DirContextAdapter ctx = new DirContextAdapter((Attributes)attrs, (Name)new DistinguishedName("cn=someName"));
        ctx.setAttributeValue("uid", (Object)"ani");
        LdapUserDetailsImpl user = (LdapUserDetailsImpl)mapper.mapUserFromContext((DirContextOperations)ctx, "ani", new GrantedAuthority[0]);
        LdapUserDetailsMapperTests.assertEquals((String)"mypassword", (String)user.getPassword());
    }
}

