/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.providers.x509.populator;

import java.security.cert.X509Certificate;
import junit.framework.TestCase;
import org.springframework.dao.DataAccessException;
import org.springframework.security.BadCredentialsException;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.providers.x509.X509TestUtils;
import org.springframework.security.providers.x509.populator.DaoX509AuthoritiesPopulator;
import org.springframework.security.userdetails.User;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.UserDetailsService;
import org.springframework.security.userdetails.UsernameNotFoundException;

public class DaoX509AuthoritiesPopulatorTests
extends TestCase {
    public DaoX509AuthoritiesPopulatorTests() {
    }

    public DaoX509AuthoritiesPopulatorTests(String arg0) {
        super(arg0);
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testDefaultCNPatternMatch() throws Exception {
        X509Certificate cert = X509TestUtils.buildTestCertificate();
        DaoX509AuthoritiesPopulator populator = new DaoX509AuthoritiesPopulator();
        populator.setUserDetailsService((UserDetailsService)new MockAuthenticationDaoMatchesNameOrEmail());
        populator.afterPropertiesSet();
        populator.getUserDetails(cert);
    }

    public void testEmailPatternMatch() throws Exception {
        X509Certificate cert = X509TestUtils.buildTestCertificate();
        DaoX509AuthoritiesPopulator populator = new DaoX509AuthoritiesPopulator();
        populator.setUserDetailsService((UserDetailsService)new MockAuthenticationDaoMatchesNameOrEmail());
        populator.setSubjectDNRegex("emailAddress=(.*?),");
        populator.afterPropertiesSet();
        populator.getUserDetails(cert);
    }

    public void testInvalidRegexFails() throws Exception {
        DaoX509AuthoritiesPopulator populator = new DaoX509AuthoritiesPopulator();
        populator.setUserDetailsService((UserDetailsService)new MockAuthenticationDaoMatchesNameOrEmail());
        populator.setSubjectDNRegex("CN=(.*?,");
        try {
            populator.afterPropertiesSet();
            DaoX509AuthoritiesPopulatorTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMatchOnShoeSizeFieldInDNFails() throws Exception {
        X509Certificate cert = X509TestUtils.buildTestCertificate();
        DaoX509AuthoritiesPopulator populator = new DaoX509AuthoritiesPopulator();
        populator.setUserDetailsService((UserDetailsService)new MockAuthenticationDaoMatchesNameOrEmail());
        populator.setSubjectDNRegex("shoeSize=(.*?),");
        populator.afterPropertiesSet();
        try {
            populator.getUserDetails(cert);
            DaoX509AuthoritiesPopulatorTests.fail((String)"Should have thrown BadCredentialsException.");
        }
        catch (BadCredentialsException badCredentialsException) {
            // empty catch block
        }
    }

    public void testPatternWithNoGroupFails() throws Exception {
        X509Certificate cert = X509TestUtils.buildTestCertificate();
        DaoX509AuthoritiesPopulator populator = new DaoX509AuthoritiesPopulator();
        populator.setUserDetailsService((UserDetailsService)new MockAuthenticationDaoMatchesNameOrEmail());
        populator.setSubjectDNRegex("CN=.*?,");
        populator.afterPropertiesSet();
        try {
            populator.getUserDetails(cert);
            DaoX509AuthoritiesPopulatorTests.fail((String)"Should have thrown IllegalArgumentException for regexp without group");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testRequiresDao() throws Exception {
        DaoX509AuthoritiesPopulator populator = new DaoX509AuthoritiesPopulator();
        try {
            populator.afterPropertiesSet();
            DaoX509AuthoritiesPopulatorTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private class MockAuthenticationDaoMatchesNameOrEmail
    implements UserDetailsService {
        private MockAuthenticationDaoMatchesNameOrEmail() {
        }

        public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
            if ("Luke Taylor".equals(username) || "luke@monkeymachine".equals(username)) {
                return new User("luke", "monkey", true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE")});
            }
            throw new UsernameNotFoundException("Could not find: " + username);
        }
    }
}

