/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ldap;

import javax.naming.Binding;
import javax.naming.ContextNotEmptyException;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.protocol.shared.store.LdifFileLoader;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.security.ldap.DefaultInitialDirContextFactory;
import org.springframework.security.ldap.SpringSecurityContextSource;

public abstract class AbstractLdapIntegrationTests {
    private static ClassPathXmlApplicationContext appContext;

    protected AbstractLdapIntegrationTests() {
    }

    @BeforeClass
    public static void loadContext() throws NamingException {
        AbstractLdapIntegrationTests.shutdownRunningServers();
        appContext = new ClassPathXmlApplicationContext("/org/springframework/security/ldap/ldapIntegrationTestContext.xml");
    }

    @AfterClass
    public static void closeContext() throws Exception {
        if (appContext != null) {
            appContext.close();
        }
        AbstractLdapIntegrationTests.shutdownRunningServers();
    }

    private static void shutdownRunningServers() throws NamingException {
        DirectoryService ds = DirectoryService.getInstance();
        if (ds.isStarted()) {
            System.out.println("WARNING: Discovered running DirectoryService with configuration: " + ds.getConfiguration().getStartupConfiguration().toString());
            System.out.println("Shutting it down...");
            ds.shutdown();
        }
    }

    @Before
    public void onSetUp() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public final void reloadServerDataIfDirty() throws Exception {
        ClassPathResource ldifs = new ClassPathResource("test-server.ldif");
        if (!ldifs.getFile().exists()) {
            throw new IllegalStateException("Ldif file not found: " + ldifs.getFile().getAbsolutePath());
        }
        DirContext ctx = this.getContextSource().getReadWriteContext();
        DistinguishedName startingPoint = new DistinguishedName("dc=springframework,dc=org");
        try {
            this.clearSubContexts(ctx, (Name)startingPoint);
            LdifFileLoader loader = new LdifFileLoader(ctx, ldifs.getFile().getAbsolutePath());
            loader.execute();
        }
        finally {
            ctx.close();
        }
    }

    public SpringSecurityContextSource getContextSource() {
        return (SpringSecurityContextSource)appContext.getBean("_securityContextSource");
    }

    protected DefaultInitialDirContextFactory getInitialDirContextFactory() {
        return (DefaultInitialDirContextFactory)appContext.getBean("initialDirContextFactory");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearSubContexts(DirContext ctx, Name name) throws NamingException {
        NamingEnumeration<Binding> enumeration = null;
        try {
            enumeration = ctx.listBindings(name);
            while (enumeration.hasMore()) {
                Binding element = enumeration.next();
                DistinguishedName childName = new DistinguishedName(element.getName());
                childName.prepend((DistinguishedName)name);
                try {
                    ctx.destroySubcontext((Name)childName);
                }
                catch (ContextNotEmptyException e) {
                    this.clearSubContexts(ctx, (Name)childName);
                    ctx.destroySubcontext((Name)childName);
                }
            }
        }
        catch (NameNotFoundException ignored) {
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        finally {
            try {
                enumeration.close();
            }
            catch (Exception ignored) {}
        }
    }
}

