/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.intercept.web;

import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import junit.textui.TestRunner;
import org.jmock.MockObjectTestCase;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.MockFilterChain;
import org.springframework.security.intercept.web.FilterInvocation;

public class FilterInvocationTests
extends MockObjectTestCase {
    public FilterInvocationTests() {
    }

    public FilterInvocationTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run(FilterInvocationTests.class);
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testGettersAndStringMethods() {
        MockHttpServletRequest request = new MockHttpServletRequest(null, null);
        request.setServletPath("/HelloWorld");
        request.setPathInfo("/some/more/segments.html");
        request.setServerName("www.example.com");
        request.setScheme("http");
        request.setServerPort(80);
        request.setContextPath("/mycontext");
        request.setRequestURI("/mycontext/HelloWorld/some/more/segments.html");
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        FilterInvocation fi = new FilterInvocation((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        FilterInvocationTests.assertEquals((Object)request, (Object)fi.getRequest());
        FilterInvocationTests.assertEquals((Object)request, (Object)fi.getHttpRequest());
        FilterInvocationTests.assertEquals((Object)response, (Object)fi.getResponse());
        FilterInvocationTests.assertEquals((Object)response, (Object)fi.getHttpResponse());
        FilterInvocationTests.assertEquals((Object)chain, (Object)fi.getChain());
        FilterInvocationTests.assertEquals((String)"/HelloWorld/some/more/segments.html", (String)fi.getRequestUrl());
        FilterInvocationTests.assertEquals((String)"FilterInvocation: URL: /HelloWorld/some/more/segments.html", (String)fi.toString());
        FilterInvocationTests.assertEquals((String)"http://www.example.com/mycontext/HelloWorld/some/more/segments.html", (String)fi.getFullRequestUrl());
    }

    public void testNoArgConstructorDoesntExist() {
        Class<FilterInvocation> clazz = FilterInvocation.class;
        try {
            clazz.getDeclaredConstructor(null);
            FilterInvocationTests.fail((String)"Should have thrown NoSuchMethodException");
        }
        catch (NoSuchMethodException expected) {
            FilterInvocationTests.assertTrue((boolean)true);
        }
    }

    public void testRejectsNullFilterChain() {
        MockHttpServletRequest request = new MockHttpServletRequest(null, null);
        MockHttpServletResponse response = new MockHttpServletResponse();
        try {
            new FilterInvocation((ServletRequest)request, (ServletResponse)response, null);
            FilterInvocationTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            FilterInvocationTests.assertTrue((boolean)true);
        }
    }

    public void testRejectsNullServletRequest() {
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        try {
            new FilterInvocation(null, (ServletResponse)response, (FilterChain)chain);
            FilterInvocationTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            FilterInvocationTests.assertTrue((boolean)true);
        }
    }

    public void testRejectsNullServletResponse() {
        MockHttpServletRequest request = new MockHttpServletRequest(null, null);
        MockFilterChain chain = new MockFilterChain();
        try {
            new FilterInvocation((ServletRequest)request, null, (FilterChain)chain);
            FilterInvocationTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            FilterInvocationTests.assertTrue((boolean)true);
        }
    }

    public void testRejectsServletRequestWhichIsNotHttpServletRequest() {
        ServletRequest request = (ServletRequest)this.newDummy(ServletRequest.class);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        try {
            new FilterInvocation(request, (ServletResponse)response, (FilterChain)chain);
            FilterInvocationTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            FilterInvocationTests.assertEquals((String)"Can only process HttpServletRequest", (String)expected.getMessage());
        }
    }

    public void testRejectsServletResponseWhichIsNotHttpServletResponse() {
        MockHttpServletRequest request = new MockHttpServletRequest(null, null);
        ServletResponse response = (ServletResponse)this.newDummy(ServletResponse.class);
        MockFilterChain chain = new MockFilterChain();
        try {
            new FilterInvocation((ServletRequest)request, response, (FilterChain)chain);
            FilterInvocationTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            FilterInvocationTests.assertEquals((String)"Can only process HttpServletResponse", (String)expected.getMessage());
        }
    }

    public void testStringMethodsWithAQueryString() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setQueryString("foo=bar");
        request.setServletPath("/HelloWorld");
        request.setServerName("www.example.com");
        request.setScheme("http");
        request.setServerPort(80);
        request.setContextPath("/mycontext");
        request.setRequestURI("/mycontext/HelloWorld");
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        FilterInvocation fi = new FilterInvocation((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        FilterInvocationTests.assertEquals((String)"/HelloWorld?foo=bar", (String)fi.getRequestUrl());
        FilterInvocationTests.assertEquals((String)"FilterInvocation: URL: /HelloWorld?foo=bar", (String)fi.toString());
        FilterInvocationTests.assertEquals((String)"http://www.example.com/mycontext/HelloWorld?foo=bar", (String)fi.getFullRequestUrl());
    }

    public void testStringMethodsWithoutAnyQueryString() {
        MockHttpServletRequest request = new MockHttpServletRequest(null, null);
        request.setServletPath("/HelloWorld");
        request.setServerName("www.example.com");
        request.setScheme("http");
        request.setServerPort(80);
        request.setContextPath("/mycontext");
        request.setRequestURI("/mycontext/HelloWorld");
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        FilterInvocation fi = new FilterInvocation((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        FilterInvocationTests.assertEquals((String)"/HelloWorld", (String)fi.getRequestUrl());
        FilterInvocationTests.assertEquals((String)"FilterInvocation: URL: /HelloWorld", (String)fi.toString());
        FilterInvocationTests.assertEquals((String)"http://www.example.com/mycontext/HelloWorld", (String)fi.getFullRequestUrl());
    }
}

