/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.event.authentication;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationException;
import org.springframework.security.DisabledException;
import org.springframework.security.event.authentication.AuthenticationFailureDisabledEvent;
import org.springframework.security.event.authentication.AuthenticationSuccessEvent;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;

public class AuthenticationEventTests
extends TestCase {
    private Authentication getAuthentication() {
        UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)"Principal", (Object)"Credentials");
        authentication.setDetails((Object)"127.0.0.1");
        return authentication;
    }

    public static void main(String[] args) {
        TestRunner.run(AuthenticationEventTests.class);
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testAbstractAuthenticationEvent() {
        Authentication auth = this.getAuthentication();
        AuthenticationSuccessEvent event = new AuthenticationSuccessEvent(auth);
        AuthenticationEventTests.assertEquals((Object)auth, (Object)event.getAuthentication());
    }

    public void testAbstractAuthenticationFailureEvent() {
        Authentication auth = this.getAuthentication();
        DisabledException exception = new DisabledException("TEST");
        AuthenticationFailureDisabledEvent event = new AuthenticationFailureDisabledEvent(auth, (AuthenticationException)exception);
        AuthenticationEventTests.assertEquals((Object)auth, (Object)event.getAuthentication());
        AuthenticationEventTests.assertEquals((Object)exception, (Object)event.getException());
    }

    public void testRejectsNullAuthentication() {
        DisabledException exception = new DisabledException("TEST");
        try {
            AuthenticationFailureDisabledEvent event = new AuthenticationFailureDisabledEvent(null, (AuthenticationException)exception);
            AuthenticationEventTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AuthenticationEventTests.assertTrue((boolean)true);
        }
    }

    public void testRejectsNullAuthenticationException() {
        try {
            new AuthenticationFailureDisabledEvent(this.getAuthentication(), null);
            AuthenticationEventTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AuthenticationEventTests.assertTrue((boolean)true);
        }
    }
}

