/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.mock.web.MockFilterChain;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.ConfigAttribute;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.SecurityConfig;
import org.springframework.security.intercept.web.DefaultFilterInvocationDefinitionSource;
import org.springframework.security.intercept.web.FilterInvocation;
import org.springframework.security.util.InMemoryXmlApplicationContext;

public class FilterInvocationDefinitionSourceParserTests {
    private AbstractXmlApplicationContext appContext;

    @After
    public void closeAppContext() {
        if (this.appContext != null) {
            this.appContext.close();
            this.appContext = null;
        }
    }

    private void setContext(String context) {
        this.appContext = new InMemoryXmlApplicationContext(context);
    }

    @Test
    public void parsingMinimalConfigurationIsSuccessful() {
        this.setContext("<filter-invocation-definition-source id='fids'>   <intercept-url pattern='/**' access='ROLE_A'/></filter-invocation-definition-source>");
        DefaultFilterInvocationDefinitionSource fids = (DefaultFilterInvocationDefinitionSource)this.appContext.getBean("fids");
        ConfigAttributeDefinition cad = fids.getAttributes((Object)this.createFilterInvocation("/anything", "GET"));
        Assert.assertTrue((boolean)cad.contains((ConfigAttribute)new SecurityConfig("ROLE_A")));
    }

    @Test
    public void parsingWithinFilterSecurityInterceptorIsSuccessful() {
        this.setContext("<http auto-config='true'/><b:bean id='fsi' class='org.springframework.security.intercept.web.FilterSecurityInterceptor' autowire='byType'>   <b:property name='objectDefinitionSource'>       <filter-invocation-definition-source>           <intercept-url pattern='/secure/extreme/**' access='ROLE_SUPERVISOR'/>           <intercept-url pattern='/secure/**' access='ROLE_USER'/>           <intercept-url pattern='/**' access='ROLE_USER'/>       </filter-invocation-definition-source>   </b:property></b:bean>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider>");
    }

    private FilterInvocation createFilterInvocation(String path, String method) {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI(null);
        request.setMethod(method);
        request.setServletPath(path);
        return new FilterInvocation((ServletRequest)request, (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain());
    }
}

