/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import org.junit.Assert;
import org.junit.Test;
import org.springframework.security.providers.ProviderManager;
import org.springframework.security.util.InMemoryXmlApplicationContext;

public class CustomAuthenticationProviderBeanDefinitionDecoratorTests {
    @Test
    public void decoratedProviderParsesSuccessfully() {
        InMemoryXmlApplicationContext ctx = new InMemoryXmlApplicationContext("<b:bean class='org.springframework.security.providers.dao.DaoAuthenticationProvider'>  <custom-authentication-provider />  <b:property name='userDetailsService' ref='us'/></b:bean><user-service id='us'> <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' /></user-service>");
        ProviderManager authMgr = (ProviderManager)ctx.getBean("_authenticationManager");
        Assert.assertEquals((long)1L, (long)authMgr.getProviders().size());
    }

    @Test
    public void decoratedBeanAndRegisteredProviderAreTheSameObject() {
        InMemoryXmlApplicationContext ctx = new InMemoryXmlApplicationContext("<b:bean id='myProvider' class='org.springframework.security.providers.dao.DaoAuthenticationProvider'>  <custom-authentication-provider />  <b:property name='userDetailsService' ref='us'/></b:bean><user-service id='us'> <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' /></user-service>");
        ProviderManager authMgr = (ProviderManager)ctx.getBean("_authenticationManager");
        Assert.assertEquals((long)1L, (long)authMgr.getProviders().size());
        Assert.assertSame((Object)ctx.getBean("myProvider"), authMgr.getProviders().get(0));
    }
}

