/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.FieldDescriptor;
import org.exolab.castor.mapping.FieldHandler;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.loader.AbstractFieldDescriptor;
import org.exolab.castor.mapping.loader.FieldHandlerImpl;
import org.exolab.castor.xml.FieldValidator;
import org.exolab.castor.xml.NodeType;
import org.exolab.castor.xml.XMLClassDescriptor;
import org.exolab.castor.xml.XMLFieldDescriptor;
import org.exolab.castor.xml.descriptors.CoreDescriptors;
import org.exolab.castor.xml.handlers.DateFieldHandler;
import org.exolab.castor.xml.util.XMLClassDescriptorAdapter;

public class XMLFieldDescriptorImpl
extends AbstractFieldDescriptor
implements XMLFieldDescriptor {
    private static final String WILD_CARD = "*";
    private static final String NULL_CLASS_ERR = "The 'type' argument passed to the constructor of XMLFieldDescriptorImpl may not be null.";
    private static final String NULL_NAME_ERR = "The 'fieldName' argument passed to the constructor of XMLFieldDescriptorImpl may not be null.";
    private int _argIndex = -1;
    private boolean _container = false;
    private boolean _incremental = false;
    public boolean _isReference = false;
    private boolean _isWild = false;
    private boolean _mapped = false;
    private String[] _matches = new String[0];
    private boolean _nillable = false;
    private NodeType _nodeType = null;
    private String _nsPrefix = null;
    private String _nsURI = null;
    private Properties _properties = null;
    private String _schemaType = null;
    private String _componentType = null;
    private String _qNamePrefix = null;
    private boolean _useParentClassNamespace = false;
    private FieldValidator _validator = null;
    private String _xmlName = null;
    private String _xmlPath = null;
    private List _substitutes;
    private boolean _derivedFromXSList;
    static /* synthetic */ Class class$org$exolab$castor$types$AnyNode;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$org$exolab$castor$mapping$MapItem;

    public XMLFieldDescriptorImpl(Class fieldType, String fieldName, String xmlName, NodeType nodeType) {
        if (fieldName == null) {
            throw new IllegalArgumentException(NULL_NAME_ERR);
        }
        if (fieldType == null) {
            throw new IllegalArgumentException(NULL_CLASS_ERR);
        }
        this.setFieldName(fieldName);
        if (fieldType == (class$org$exolab$castor$types$AnyNode == null ? (class$org$exolab$castor$types$AnyNode = XMLFieldDescriptorImpl.class$("org.exolab.castor.types.AnyNode")) : class$org$exolab$castor$types$AnyNode)) {
            this.setFieldType(class$java$lang$Object == null ? (class$java$lang$Object = XMLFieldDescriptorImpl.class$("java.lang.Object")) : class$java$lang$Object);
        } else {
            this.setFieldType(fieldType);
        }
        this._nodeType = nodeType == null ? NodeType.Attribute : nodeType;
        this.setXMLName(xmlName);
    }

    public XMLFieldDescriptorImpl(FieldDescriptor fieldDesc, String xmlName, NodeType nodeType, NodeType primitiveNodeType) throws MappingException {
        if (fieldDesc instanceof XMLFieldDescriptor) {
            this.setContainingClassDescriptor(fieldDesc.getContainingClassDescriptor());
        }
        this.setFieldName(fieldDesc.getFieldName());
        if (fieldDesc.getFieldType() == (class$org$exolab$castor$types$AnyNode == null ? (class$org$exolab$castor$types$AnyNode = XMLFieldDescriptorImpl.class$("org.exolab.castor.types.AnyNode")) : class$org$exolab$castor$types$AnyNode)) {
            this.setFieldType(class$java$lang$Object == null ? (class$java$lang$Object = XMLFieldDescriptorImpl.class$("java.lang.Object")) : class$java$lang$Object);
        } else {
            this.setFieldType(fieldDesc.getFieldType());
        }
        ClassDescriptor cd = fieldDesc.getClassDescriptor();
        if (cd != null) {
            if (cd instanceof XMLClassDescriptor) {
                this.setClassDescriptor(cd);
            } else {
                this.setClassDescriptor(new XMLClassDescriptorAdapter(cd, null, primitiveNodeType));
            }
        }
        this.setHandler(fieldDesc.getHandler());
        if (this.getFieldType() != null && (class$java$util$Date == null ? (class$java$util$Date = XMLFieldDescriptorImpl.class$("java.util.Date")) : class$java$util$Date).isAssignableFrom(this.getFieldType()) && this.getHandler() instanceof FieldHandlerImpl) {
            this.setHandler(new DateFieldHandler(this.getHandler()));
        }
        this.setTransient(fieldDesc.isTransient());
        this.setImmutable(fieldDesc.isImmutable());
        this.setRequired(fieldDesc.isRequired());
        this.setMultivalued(fieldDesc.isMultivalued());
        if (xmlName == null) {
            this.setXMLName(this.getFieldName());
        } else {
            this.setXMLName(xmlName);
        }
        this._nodeType = nodeType == null ? (this.isMultivalued() ? NodeType.Element : NodeType.Attribute) : nodeType;
        if (this.isRequired()) {
            this._validator = new FieldValidator();
            this._validator.setMinOccurs(1);
            this._validator.setDescriptor(this);
        }
    }

    public void setConstructorArgumentIndex(int index) {
        if (this._nodeType != NodeType.Attribute) {
            String err = "constructor arguments only valid for attribute mapped fields.";
            throw new IllegalStateException(err);
        }
        this._argIndex = index;
    }

    public int getConstructorArgumentIndex() {
        return this._argIndex;
    }

    public boolean isConstructorArgument() {
        return this._argIndex >= 0;
    }

    public void setLocationPath(String path) {
        this._xmlPath = path;
    }

    public String getLocationPath() {
        return this._xmlPath;
    }

    public void setNameSpacePrefix(String nsPrefix) {
        this._nsPrefix = nsPrefix;
    }

    public String getNameSpacePrefix() {
        return this._nsPrefix;
    }

    public void setUseParentsNamespace(boolean useParentsNamespace) {
        this._useParentClassNamespace = useParentsNamespace;
    }

    public void setNameSpaceURI(String nsURI) {
        this._nsURI = nsURI;
    }

    public String getNameSpaceURI() {
        ClassDescriptor parent = this.getContainingClassDescriptor();
        if (this._nsURI == null && parent != null && this._useParentClassNamespace) {
            boolean test;
            Class type = this.getFieldType();
            boolean bl = test = XMLFieldDescriptorImpl.isPrimitive(type) || XMLFieldDescriptorImpl.isBuiltInType(type) || XMLFieldDescriptorImpl.isMappedItem(type);
            if (this._nodeType == NodeType.Element && test && parent instanceof XMLClassDescriptor) {
                return ((XMLClassDescriptor)parent).getNameSpaceURI();
            }
        }
        return this._nsURI;
    }

    public void setNodeType(NodeType nodeType) {
        this._nodeType = nodeType == null ? NodeType.Attribute : nodeType;
    }

    public NodeType getNodeType() {
        return this._nodeType;
    }

    public void setProperty(String propertyName, String value) {
        if (propertyName == null) {
            String err = "The argument 'propertyName' must not be null.";
            throw new IllegalArgumentException(err);
        }
        if (this._properties == null) {
            this._properties = new Properties();
        }
        if (value == null) {
            this._properties.remove(propertyName);
        } else {
            this._properties.put(propertyName, value);
        }
    }

    public String getProperty(String propertyName) {
        if (this._properties == null || propertyName == null) {
            return null;
        }
        return this._properties.getProperty(propertyName);
    }

    public void setSchemaType(String schemaType) {
        this._schemaType = schemaType;
    }

    public void setComponentType(String componentType) {
        this._componentType = componentType;
    }

    public String getSchemaType() {
        return this._schemaType;
    }

    public String getComponentType() {
        return this._componentType;
    }

    public void setValidator(FieldValidator validator) {
        if (this._validator != null) {
            this._validator.setDescriptor(null);
        }
        this._validator = validator;
        if (this._validator != null) {
            this._validator.setDescriptor(this);
        }
    }

    public FieldValidator getValidator() {
        return this._validator;
    }

    public void setXMLName(String xmlName) {
        this._xmlName = xmlName;
    }

    public String getXMLName() {
        return this._xmlName;
    }

    public void setContainer(boolean isContainer) {
        this._container = isContainer;
    }

    public boolean isContainer() {
        return this._container;
    }

    public void setIncremental(boolean incremental) {
        this._incremental = incremental;
    }

    public boolean isIncremental() {
        return this._incremental;
    }

    public void setMapped(boolean mapped) {
        this._mapped = mapped;
    }

    public boolean isMapped() {
        return this._mapped;
    }

    public void setNillable(boolean nillable) {
        this._nillable = nillable;
    }

    public boolean isNillable() {
        return this._nillable;
    }

    public void setReference(boolean isReference) {
        this._isReference = isReference;
    }

    public boolean isReference() {
        return this._isReference;
    }

    public void setQNamePrefix(String qNamePrefix) {
        this._qNamePrefix = qNamePrefix;
    }

    public String getQNamePrefix() {
        return this._qNamePrefix;
    }

    public void setMatches(String matchExpr) {
        this._isWild = false;
        if (matchExpr == null || matchExpr.length() == 0) {
            return;
        }
        StringTokenizer st = new StringTokenizer(matchExpr);
        ArrayList<String> names = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (WILD_CARD.equals(token)) {
                this._isWild = true;
                break;
            }
            names.add(token);
        }
        this._matches = new String[names.size()];
        names.toArray(this._matches);
    }

    public boolean matches(String xmlName) {
        if (xmlName != null) {
            if (this._isWild) {
                return true;
            }
            if (this._matches.length > 0) {
                for (int i = 0; i < this._matches.length; ++i) {
                    if (!xmlName.equals(this._matches[i])) continue;
                    return true;
                }
            } else {
                return xmlName.equals(this._xmlName);
            }
        }
        return false;
    }

    public boolean matches(String xmlName, String namespace) {
        if (namespace == null ? this._nsURI != null && this._nsURI.length() > 0 : (this._nsURI == null ? namespace.length() > 0 && !this._isWild : !this._nsURI.equals(namespace))) {
            return false;
        }
        return this.matches(xmlName);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof XMLFieldDescriptor)) {
            return false;
        }
        XMLFieldDescriptor descriptor = (XMLFieldDescriptor)obj;
        if (!this.getFieldName().equals(descriptor.getFieldName())) {
            return false;
        }
        if (!this.getFieldType().equals(descriptor.getFieldType())) {
            return false;
        }
        FieldHandler tmpHandler = descriptor.getHandler();
        if (this.getHandler() == null) {
            return tmpHandler == null;
        }
        if (tmpHandler == null) {
            return false;
        }
        return this.getHandler().getClass().isInstance(tmpHandler);
    }

    public int hashCode() {
        int hash = 17;
        hash = 17 * this.getFieldName().hashCode();
        hash = hash * 17 * this.getFieldType().hashCode();
        if (this.getHandler() != null) {
            hash = hash * 17 * this.getHandler().hashCode();
        }
        return hash;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(32);
        buffer.append("XMLFieldDesciptor: ");
        buffer.append(this.getFieldName());
        buffer.append(" AS ");
        buffer.append(this._xmlName);
        if (this.getNameSpaceURI() != null) {
            buffer.append("{" + this.getNameSpaceURI() + "}");
        }
        return buffer.toString();
    }

    private static boolean isPrimitive(Class type) {
        if (type == null) {
            return false;
        }
        if (type.isPrimitive()) {
            return true;
        }
        if (type == (class$java$lang$String == null ? (class$java$lang$String = XMLFieldDescriptorImpl.class$("java.lang.String")) : class$java$lang$String)) {
            return true;
        }
        if (type == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = XMLFieldDescriptorImpl.class$("java.lang.Boolean")) : class$java$lang$Boolean) || type == (class$java$lang$Character == null ? (class$java$lang$Character = XMLFieldDescriptorImpl.class$("java.lang.Character")) : class$java$lang$Character)) {
            return true;
        }
        return type.getSuperclass() == (class$java$lang$Number == null ? (class$java$lang$Number = XMLFieldDescriptorImpl.class$("java.lang.Number")) : class$java$lang$Number);
    }

    private static boolean isBuiltInType(Class type) {
        if (type == null) {
            return false;
        }
        return CoreDescriptors.getDescriptor(type) != null;
    }

    private static boolean isMappedItem(Class fieldType) {
        return fieldType == (class$org$exolab$castor$mapping$MapItem == null ? (class$org$exolab$castor$mapping$MapItem = XMLFieldDescriptorImpl.class$("org.exolab.castor.mapping.MapItem")) : class$org$exolab$castor$mapping$MapItem);
    }

    public List getSubstitutes() {
        return this._substitutes;
    }

    public void setSubstitutes(List substitutes) {
        this._substitutes = substitutes;
    }

    public void setDerivedFromXSList(boolean derivedFromXSList) {
        this._derivedFromXSList = derivedFromXSList;
    }

    public boolean isDerivedFromXSList() {
        return this._derivedFromXSList;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

