/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types.basic;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.Transform;
import org.teiid.core.types.TransformationException;

public class StringToBooleanTransform
extends Transform {
    private static final Set<String> FALSE = new HashSet<String>(Arrays.asList("0", "false"));

    @Override
    public Object transformDirect(Object value) throws TransformationException {
        String str = ((String)value).trim().toLowerCase();
        if (FALSE.contains(str)) {
            return Boolean.FALSE;
        }
        if ("unknown".equals(str)) {
            return null;
        }
        return Boolean.TRUE;
    }

    @Override
    public Class<?> getSourceType() {
        return DataTypeManager.DefaultDataClasses.STRING;
    }

    @Override
    public Class<?> getTargetType() {
        return DataTypeManager.DefaultDataClasses.BOOLEAN;
    }

    @Override
    public boolean isExplicit() {
        return true;
    }
}

