/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.crypto;

import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SealedObject;
import org.teiid.core.BundleUtil;
import org.teiid.core.CorePlugin;
import org.teiid.core.crypto.CryptoException;
import org.teiid.core.crypto.Cryptor;
import org.teiid.core.util.Base64;

public class BasicCryptor
implements Cryptor {
    protected Key decryptKey;
    private Cipher decryptCipher;
    private Key encryptKey;
    protected Cipher encryptCipher;
    protected String cipherAlgorithm;
    public static final String OLD_ENCRYPT_PREFIX = "{mm-encrypt}";
    public static final String ENCRYPT_PREFIX = "{teiid-encrypt}";

    public BasicCryptor(Key encryptKey, Key decryptKey, String algorithm) throws CryptoException {
        this.encryptKey = encryptKey;
        this.cipherAlgorithm = algorithm;
        this.decryptKey = decryptKey;
        this.initEncryptCipher();
        this.initDecryptCipher();
    }

    @Override
    public synchronized byte[] decrypt(byte[] ciphertext) throws CryptoException {
        try {
            return this.decryptCipher.doFinal(ciphertext);
        }
        catch (Exception e) {
            try {
                this.initDecryptCipher();
            }
            catch (CryptoException cryptoException) {
                // empty catch block
            }
            throw new CryptoException((BundleUtil.Event)CorePlugin.Event.TEIID10006, CorePlugin.Util.gs(CorePlugin.Event.TEIID10006, e.getClass().getName(), e.getMessage()));
        }
    }

    @Override
    public String decrypt(String ciphertext) throws CryptoException {
        if (ciphertext == null) {
            throw new CryptoException((BundleUtil.Event)CorePlugin.Event.TEIID10007, CorePlugin.Util.gs(CorePlugin.Event.TEIID10007, new Object[0]));
        }
        ciphertext = BasicCryptor.stripEncryptionPrefix(ciphertext);
        byte[] cipherBytes = null;
        try {
            cipherBytes = Base64.decode(ciphertext);
        }
        catch (IllegalArgumentException e) {
            throw new CryptoException((BundleUtil.Event)CorePlugin.Event.TEIID10008, CorePlugin.Util.gs(CorePlugin.Event.TEIID10008, e.getMessage()));
        }
        byte[] cleartext = this.decrypt(cipherBytes);
        return new String(cleartext);
    }

    public static String stripEncryptionPrefix(String ciphertext) {
        if (ciphertext.startsWith(ENCRYPT_PREFIX)) {
            ciphertext = ciphertext.substring(ENCRYPT_PREFIX.length());
        } else if (ciphertext.startsWith(OLD_ENCRYPT_PREFIX)) {
            ciphertext = ciphertext.substring(OLD_ENCRYPT_PREFIX.length());
        }
        return ciphertext;
    }

    protected void initDecryptCipher() throws CryptoException {
        try {
            this.decryptCipher = Cipher.getInstance(this.cipherAlgorithm);
            this.decryptCipher.init(2, this.decryptKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(CorePlugin.Event.TEIID10009, e, CorePlugin.Util.gs(CorePlugin.Event.TEIID10009, this.cipherAlgorithm));
        }
        catch (NoSuchPaddingException e) {
            throw new CryptoException((BundleUtil.Event)CorePlugin.Event.TEIID10010, CorePlugin.Util.gs(CorePlugin.Event.TEIID10010, this.cipherAlgorithm, e.getClass().getName(), e.getMessage()));
        }
        catch (InvalidKeyException e) {
            throw new CryptoException(CorePlugin.Event.TEIID10011, e, CorePlugin.Util.gs(CorePlugin.Event.TEIID10011, e.getClass().getName(), e.getMessage()));
        }
    }

    @Override
    public synchronized Object unsealObject(Object object) throws CryptoException {
        if (!(object instanceof SealedObject)) {
            return object;
        }
        SealedObject so = (SealedObject)object;
        try {
            return so.getObject(this.decryptCipher);
        }
        catch (Exception e) {
            try {
                this.initDecryptCipher();
            }
            catch (CryptoException err) {
                // empty catch block
            }
            throw new CryptoException((BundleUtil.Event)CorePlugin.Event.TEIID10006, CorePlugin.Util.gs(CorePlugin.Event.TEIID10006, e.getClass().getName(), e.getMessage()));
        }
    }

    @Override
    public synchronized byte[] encrypt(byte[] cleartext) throws CryptoException {
        try {
            return this.encryptCipher.doFinal(cleartext);
        }
        catch (Exception e) {
            try {
                this.initEncryptCipher();
            }
            catch (CryptoException cryptoException) {
                // empty catch block
            }
            throw new CryptoException((BundleUtil.Event)CorePlugin.Event.TEIID10013, CorePlugin.Util.gs(CorePlugin.Event.TEIID10013, e.getMessage()));
        }
    }

    @Override
    public String encrypt(String cleartext) throws CryptoException {
        if (cleartext == null) {
            throw new CryptoException((BundleUtil.Event)CorePlugin.Event.TEIID10014, CorePlugin.Util.gs(CorePlugin.Event.TEIID10014, new Object[0]));
        }
        String clearString = new String(cleartext);
        if (clearString.trim().length() == 0 && clearString.length() == 0) {
            throw new CryptoException((BundleUtil.Event)CorePlugin.Event.TEIID10015, CorePlugin.Util.gs(CorePlugin.Event.TEIID10015, new Object[0]));
        }
        byte[] clearBytes = clearString.getBytes();
        byte[] cipherBytes = this.encrypt(clearBytes);
        String encoded = Base64.encodeBytes(cipherBytes);
        return ENCRYPT_PREFIX + encoded;
    }

    protected void initEncryptCipher() throws CryptoException {
        try {
            this.encryptCipher = Cipher.getInstance(this.cipherAlgorithm);
            this.encryptCipher.init(1, this.encryptKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(CorePlugin.Event.TEIID10016, e, CorePlugin.Util.gs(CorePlugin.Event.TEIID10016, this.cipherAlgorithm));
        }
        catch (NoSuchPaddingException e) {
            throw new CryptoException(CorePlugin.Event.TEIID10017, e, CorePlugin.Util.gs(CorePlugin.Event.TEIID10017, this.cipherAlgorithm, e.getMessage()));
        }
        catch (InvalidKeyException e) {
            throw new CryptoException(CorePlugin.Event.TEIID10018, e, CorePlugin.Util.gs(CorePlugin.Event.TEIID10018, e.getMessage()));
        }
    }

    @Override
    public synchronized Object sealObject(Object object) throws CryptoException {
        try {
            return new SealedObject((Serializable)object, this.encryptCipher);
        }
        catch (Exception e) {
            try {
                this.initEncryptCipher();
            }
            catch (CryptoException cryptoException) {
                // empty catch block
            }
            throw new CryptoException((BundleUtil.Event)CorePlugin.Event.TEIID10013, CorePlugin.Util.gs(CorePlugin.Event.TEIID10013, e.getMessage()));
        }
    }
}

