/*
 * Decompiled with CFR 0.152.
 */
package com.http.jar;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.util.resource.ResourceCollection;

public class HttpDotJar {
    private static Option help;
    private static Option start;
    private static Option port;
    private static Option filesBase;
    private static Option welcomeFiles;
    private static Options options;

    public static void main(String[] args) throws Exception {
        GnuParser parser = new GnuParser();
        try {
            CommandLine line = parser.parse(options, args);
            if (!line.hasOption("start") || line.hasOption("help")) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp("http.jar", options);
            } else {
                String[] stringArray;
                ServerBuilder serverBuilder = new ServerBuilder();
                ServerBuilder serverBuilder2 = serverBuilder.withPort(line.hasOption("port") ? line.getOptionValue("port") : "8081").withWelcomeFiles(line.hasOption("welcome.file") ? line.getOptionValue("welcome.file").split(",") : null);
                if (line.hasOption("files.base")) {
                    stringArray = line.getOptionValue("files.base").split(",");
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = ".";
                }
                Server server = serverBuilder2.withFilesBase(stringArray).create();
                server.start();
                server.join();
            }
        }
        catch (ParseException e) {
            System.err.println("Parsing failed.  Reason: " + e.getMessage());
        }
    }

    static {
        OptionBuilder.withDescription("Help information");
        help = OptionBuilder.create("help");
        OptionBuilder.withDescription("Use to start server");
        start = OptionBuilder.create("start");
        OptionBuilder.withLongOpt("port");
        OptionBuilder.withDescription("Run server on PORT. Default is 8082");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName("PORT");
        port = OptionBuilder.create();
        OptionBuilder.withLongOpt("files.base");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("FOLDER1,FOLDER2,...,FOLDERN");
        OptionBuilder.withDescription("Merge all files in all specified FOLDERS. Use current folder by default.");
        filesBase = OptionBuilder.create();
        OptionBuilder.withLongOpt("welcome.file");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("FILE");
        OptionBuilder.withDescription("Use as welcome file");
        welcomeFiles = OptionBuilder.create();
        options = new Options();
        options.addOption(help).addOption(port).addOption(filesBase).addOption(start).addOption(welcomeFiles);
    }

    static class ServerBuilder {
        private Server server = new Server();
        private String[] welcomeFiles;

        public ServerBuilder() {
            this.server.setStopAtShutdown(true);
            this.welcomeFiles = new String[0];
        }

        public ServerBuilder withPort(String port) {
            SelectChannelConnector connector = new SelectChannelConnector();
            connector.setPort(Integer.valueOf(port));
            this.server.addConnector(connector);
            return this;
        }

        public ServerBuilder withWelcomeFiles(String[] welcomeFiles) {
            if (welcomeFiles != null) {
                this.welcomeFiles = welcomeFiles;
            }
            return this;
        }

        public ServerBuilder withFilesBase(String[] filesDirectories) {
            ResourceHandler resourceHandler = new ResourceHandler();
            resourceHandler.setDirectoriesListed(true);
            resourceHandler.setWelcomeFiles(this.welcomeFiles);
            ResourceCollection resourceCollection = new ResourceCollection(filesDirectories);
            resourceHandler.setBaseResource(resourceCollection);
            HandlerList handlers = new HandlerList();
            handlers.setHandlers(new Handler[]{resourceHandler, new DefaultHandler()});
            this.server.setHandler(handlers);
            return this;
        }

        public Server create() {
            return this.server;
        }
    }
}

