/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import com.amazonaws.services.elasticbeanstalk.model.OptionSpecification;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateEnvironmentRequest
extends AmazonWebServiceRequest {
    private String environmentId;
    private String environmentName;
    private String versionLabel;
    private String templateName;
    private String description;
    private List<ConfigurationOptionSetting> optionSettings;
    private List<OptionSpecification> optionsToRemove;

    public String getEnvironmentId() {
        return this.environmentId;
    }

    public void setEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
    }

    public UpdateEnvironmentRequest withEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
        return this;
    }

    public String getEnvironmentName() {
        return this.environmentName;
    }

    public void setEnvironmentName(String environmentName) {
        this.environmentName = environmentName;
    }

    public UpdateEnvironmentRequest withEnvironmentName(String environmentName) {
        this.environmentName = environmentName;
        return this;
    }

    public String getVersionLabel() {
        return this.versionLabel;
    }

    public void setVersionLabel(String versionLabel) {
        this.versionLabel = versionLabel;
    }

    public UpdateEnvironmentRequest withVersionLabel(String versionLabel) {
        this.versionLabel = versionLabel;
        return this;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public UpdateEnvironmentRequest withTemplateName(String templateName) {
        this.templateName = templateName;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public UpdateEnvironmentRequest withDescription(String description) {
        this.description = description;
        return this;
    }

    public List<ConfigurationOptionSetting> getOptionSettings() {
        if (this.optionSettings == null) {
            this.optionSettings = new ArrayList<ConfigurationOptionSetting>();
        }
        return this.optionSettings;
    }

    public void setOptionSettings(Collection<ConfigurationOptionSetting> optionSettings) {
        if (optionSettings == null) {
            this.optionSettings = null;
            return;
        }
        ArrayList<ConfigurationOptionSetting> optionSettingsCopy = new ArrayList<ConfigurationOptionSetting>(optionSettings.size());
        optionSettingsCopy.addAll(optionSettings);
        this.optionSettings = optionSettingsCopy;
    }

    public UpdateEnvironmentRequest withOptionSettings(ConfigurationOptionSetting ... optionSettings) {
        if (this.getOptionSettings() == null) {
            this.setOptionSettings(new ArrayList<ConfigurationOptionSetting>(optionSettings.length));
        }
        for (ConfigurationOptionSetting value : optionSettings) {
            this.getOptionSettings().add(value);
        }
        return this;
    }

    public UpdateEnvironmentRequest withOptionSettings(Collection<ConfigurationOptionSetting> optionSettings) {
        if (optionSettings == null) {
            this.optionSettings = null;
        } else {
            ArrayList<ConfigurationOptionSetting> optionSettingsCopy = new ArrayList<ConfigurationOptionSetting>(optionSettings.size());
            optionSettingsCopy.addAll(optionSettings);
            this.optionSettings = optionSettingsCopy;
        }
        return this;
    }

    public List<OptionSpecification> getOptionsToRemove() {
        if (this.optionsToRemove == null) {
            this.optionsToRemove = new ArrayList<OptionSpecification>();
        }
        return this.optionsToRemove;
    }

    public void setOptionsToRemove(Collection<OptionSpecification> optionsToRemove) {
        if (optionsToRemove == null) {
            this.optionsToRemove = null;
            return;
        }
        ArrayList<OptionSpecification> optionsToRemoveCopy = new ArrayList<OptionSpecification>(optionsToRemove.size());
        optionsToRemoveCopy.addAll(optionsToRemove);
        this.optionsToRemove = optionsToRemoveCopy;
    }

    public UpdateEnvironmentRequest withOptionsToRemove(OptionSpecification ... optionsToRemove) {
        if (this.getOptionsToRemove() == null) {
            this.setOptionsToRemove(new ArrayList<OptionSpecification>(optionsToRemove.length));
        }
        for (OptionSpecification value : optionsToRemove) {
            this.getOptionsToRemove().add(value);
        }
        return this;
    }

    public UpdateEnvironmentRequest withOptionsToRemove(Collection<OptionSpecification> optionsToRemove) {
        if (optionsToRemove == null) {
            this.optionsToRemove = null;
        } else {
            ArrayList<OptionSpecification> optionsToRemoveCopy = new ArrayList<OptionSpecification>(optionsToRemove.size());
            optionsToRemoveCopy.addAll(optionsToRemove);
            this.optionsToRemove = optionsToRemoveCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEnvironmentId() != null) {
            sb.append("EnvironmentId: " + this.getEnvironmentId() + ", ");
        }
        if (this.getEnvironmentName() != null) {
            sb.append("EnvironmentName: " + this.getEnvironmentName() + ", ");
        }
        if (this.getVersionLabel() != null) {
            sb.append("VersionLabel: " + this.getVersionLabel() + ", ");
        }
        if (this.getTemplateName() != null) {
            sb.append("TemplateName: " + this.getTemplateName() + ", ");
        }
        if (this.getDescription() != null) {
            sb.append("Description: " + this.getDescription() + ", ");
        }
        if (this.getOptionSettings() != null) {
            sb.append("OptionSettings: " + this.getOptionSettings() + ", ");
        }
        if (this.getOptionsToRemove() != null) {
            sb.append("OptionsToRemove: " + this.getOptionsToRemove() + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEnvironmentId() == null ? 0 : this.getEnvironmentId().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironmentName() == null ? 0 : this.getEnvironmentName().hashCode());
        hashCode = 31 * hashCode + (this.getVersionLabel() == null ? 0 : this.getVersionLabel().hashCode());
        hashCode = 31 * hashCode + (this.getTemplateName() == null ? 0 : this.getTemplateName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getOptionSettings() == null ? 0 : ((Object)this.getOptionSettings()).hashCode());
        hashCode = 31 * hashCode + (this.getOptionsToRemove() == null ? 0 : ((Object)this.getOptionsToRemove()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEnvironmentRequest)) {
            return false;
        }
        UpdateEnvironmentRequest other = (UpdateEnvironmentRequest)obj;
        if (other.getEnvironmentId() == null ^ this.getEnvironmentId() == null) {
            return false;
        }
        if (other.getEnvironmentId() != null && !other.getEnvironmentId().equals(this.getEnvironmentId())) {
            return false;
        }
        if (other.getEnvironmentName() == null ^ this.getEnvironmentName() == null) {
            return false;
        }
        if (other.getEnvironmentName() != null && !other.getEnvironmentName().equals(this.getEnvironmentName())) {
            return false;
        }
        if (other.getVersionLabel() == null ^ this.getVersionLabel() == null) {
            return false;
        }
        if (other.getVersionLabel() != null && !other.getVersionLabel().equals(this.getVersionLabel())) {
            return false;
        }
        if (other.getTemplateName() == null ^ this.getTemplateName() == null) {
            return false;
        }
        if (other.getTemplateName() != null && !other.getTemplateName().equals(this.getTemplateName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getOptionSettings() == null ^ this.getOptionSettings() == null) {
            return false;
        }
        if (other.getOptionSettings() != null && !((Object)other.getOptionSettings()).equals(this.getOptionSettings())) {
            return false;
        }
        if (other.getOptionsToRemove() == null ^ this.getOptionsToRemove() == null) {
            return false;
        }
        return other.getOptionsToRemove() == null || ((Object)other.getOptionsToRemove()).equals(this.getOptionsToRemove());
    }
}

