/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp.modca;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.fop.render.afp.modca.AbstractNamedAFPObject;
import org.apache.fop.render.afp.modca.InvokeMediumMap;
import org.apache.fop.render.afp.modca.PageObject;
import org.apache.fop.render.afp.modca.TagLogicalElement;

public class PageGroup
extends AbstractNamedAFPObject {
    private List objects = new ArrayList();
    private List tagLogicalElements = new ArrayList();
    private boolean complete = false;

    public PageGroup(String name) {
        super(name);
    }

    public void addPage(PageObject page) {
        if (!this.objects.contains(page)) {
            this.objects.add(page);
        }
    }

    public String getName() {
        return this.name;
    }

    public void createTagLogicalElement(String name, String value) {
        TagLogicalElement tle = new TagLogicalElement(name, value);
        this.tagLogicalElements.add(tle);
    }

    public void createInvokeMediumMap(String name) {
        InvokeMediumMap imm = new InvokeMediumMap(name);
        this.objects.add(imm);
    }

    public void endPageGroup() {
        this.complete = true;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void writeDataStream(OutputStream os) throws IOException {
        this.writeStart(os);
        this.writeObjectList(this.tagLogicalElements, os);
        this.writeObjectList(this.objects, os);
        this.writeEnd(os);
    }

    private void writeStart(OutputStream os) throws IOException {
        byte[] data = new byte[17];
        data[0] = 90;
        data[1] = 0;
        data[2] = 16;
        data[3] = -45;
        data[4] = -88;
        data[5] = -83;
        data[6] = 0;
        data[7] = 0;
        data[8] = 0;
        for (int i = 0; i < this.nameBytes.length; ++i) {
            data[9 + i] = this.nameBytes[i];
        }
        os.write(data);
    }

    private void writeEnd(OutputStream os) throws IOException {
        byte[] data = new byte[17];
        data[0] = 90;
        data[1] = 0;
        data[2] = 16;
        data[3] = -45;
        data[4] = -87;
        data[5] = -83;
        data[6] = 0;
        data[7] = 0;
        data[8] = 0;
        for (int i = 0; i < this.nameBytes.length; ++i) {
            data[9 + i] = this.nameBytes[i];
        }
        os.write(data);
    }
}

