/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;

@Description(name="date_add", value="_FUNC_(start_date, num_days) - Returns the date that is num_days after start_date.", extended="start_date is a string in the format 'yyyy-MM-dd HH:mm:ss' or 'yyyy-MM-dd'. num_days is a number. The time part of start_date is ignored.\nExample:\n   > SELECT _FUNC_('2009-30-07', 1) FROM src LIMIT 1;\n  '2009-31-07'")
public class UDFDateAdd
extends UDF {
    private final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
    private final Calendar calendar = Calendar.getInstance();
    private Text result = new Text();

    public Text evaluate(Text dateString1, IntWritable days) {
        if (dateString1 == null || days == null) {
            return null;
        }
        try {
            this.calendar.setTime(this.formatter.parse(dateString1.toString()));
            this.calendar.add(5, days.get());
            Date newDate = this.calendar.getTime();
            this.result.set(this.formatter.format(newDate));
            return this.result;
        }
        catch (ParseException e) {
            return null;
        }
    }

    public Text evaluate(TimestampWritable t, IntWritable days) {
        if (t == null || days == null) {
            return null;
        }
        this.calendar.setTime(t.getTimestamp());
        this.calendar.add(5, days.get());
        Date newDate = this.calendar.getTime();
        this.result.set(this.formatter.format(newDate));
        return this.result;
    }
}

