/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.core.dbsupport;

import java.util.Set;
import org.unitils.core.dbsupport.DbSupport;
import org.unitils.core.dbsupport.SQLHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Db2DbSupport
extends DbSupport {
    public Db2DbSupport() {
        super("db2");
    }

    @Override
    public Set<String> getTableNames() {
        return this.getSQLHandler().getItemsAsStringSet("select TABNAME from SYSCAT.TABLES where TABSCHEMA = '" + this.getSchemaName() + "' and TYPE = 'T'");
    }

    @Override
    public Set<String> getColumnNames(String tableName) {
        return this.getSQLHandler().getItemsAsStringSet("select COLNAME from SYSCAT.COLUMNS where TABNAME = '" + tableName + "' and TABSCHEMA = '" + this.getSchemaName() + "'");
    }

    @Override
    public Set<String> getViewNames() {
        return this.getSQLHandler().getItemsAsStringSet("select TABNAME from SYSCAT.TABLES where TABSCHEMA = '" + this.getSchemaName() + "' and TYPE = 'V'");
    }

    @Override
    public Set<String> getSequenceNames() {
        return this.getSQLHandler().getItemsAsStringSet("select SEQNAME from SYSCAT.SEQUENCES where SEQTYPE = 'S' AND SEQSCHEMA = '" + this.getSchemaName() + "'");
    }

    @Override
    public Set<String> getTriggerNames() {
        return this.getSQLHandler().getItemsAsStringSet("select TRIGNAME from SYSCAT.TRIGGERS where TRIGSCHEMA = '" + this.getSchemaName() + "'");
    }

    @Override
    public Set<String> getTypeNames() {
        return this.getSQLHandler().getItemsAsStringSet("select TYPENAME from SYSCAT.DATATYPES where TYPESCHEMA = '" + this.getSchemaName() + "'");
    }

    @Override
    public void disableReferentialConstraints() {
        Set<String> tableNames = this.getTableNames();
        for (String tableName : tableNames) {
            this.disableReferentialConstraints(tableName);
        }
    }

    protected void disableReferentialConstraints(String tableName) {
        SQLHandler sqlHandler = this.getSQLHandler();
        Set<String> constraintNames = sqlHandler.getItemsAsStringSet("select CONSTNAME from SYSCAT.TABCONST where TYPE = 'F' and TABNAME = '" + tableName + "' and TABSCHEMA = '" + this.getSchemaName() + "'");
        for (String constraintName : constraintNames) {
            sqlHandler.executeUpdate("alter table " + this.qualified(tableName) + " drop constraint " + this.quoted(constraintName));
        }
    }

    @Override
    public void disableValueConstraints() {
        Set<String> tableNames = this.getTableNames();
        for (String tableName : tableNames) {
            this.disableValueConstraints(tableName);
        }
    }

    protected void disableValueConstraints(String tableName) {
        SQLHandler sqlHandler = this.getSQLHandler();
        Set<String> constraintNames = sqlHandler.getItemsAsStringSet("select CONSTNAME from SYSCAT.TABCONST where TYPE in ('K', 'U') and TABNAME = '" + tableName + "' and TABSCHEMA = '" + this.getSchemaName() + "'");
        for (String constraintName : constraintNames) {
            sqlHandler.executeUpdate("alter table " + this.qualified(tableName) + " drop constraint " + this.quoted(constraintName));
        }
        Set<String> primaryKeyColumnNames = sqlHandler.getItemsAsStringSet("select COLNAME from SYSCAT.COLUMNS where KEYSEQ is not null and TABNAME = '" + tableName + "' and TABSCHEMA = '" + this.getSchemaName() + "'");
        Set<String> notNullColumnNames = sqlHandler.getItemsAsStringSet("select COLNAME from SYSCAT.COLUMNS where NULLS = 'N' and TABNAME = '" + tableName + "' and TABSCHEMA = '" + this.getSchemaName() + "'");
        for (String notNullColumnName : notNullColumnNames) {
            if (primaryKeyColumnNames.contains(notNullColumnName)) continue;
            sqlHandler.executeUpdate("alter table " + this.qualified(tableName) + " alter column " + this.quoted(notNullColumnName) + " drop not null");
            sqlHandler.executeUpdate("call SYSPROC.ADMIN_CMD('REORG TABLE " + this.qualified(tableName) + "')");
        }
    }

    @Override
    public long getSequenceValue(String sequenceName) {
        return this.getSQLHandler().getItemAsLong("select next value for " + this.qualified(sequenceName) + " from SYSIBM.SYSDUMMY1");
    }

    @Override
    public void incrementSequenceToValue(String sequenceName, long newSequenceValue) {
        this.getSQLHandler().executeUpdate("alter sequence " + this.qualified(sequenceName) + " restart with " + newSequenceValue);
    }

    @Override
    public Set<String> getIdentityColumnNames(String tableName) {
        return this.getSQLHandler().getItemsAsStringSet("select COLNAME from SYSCAT.COLUMNS where KEYSEQ is not null and TABNAME = '" + tableName + "' and TABSCHEMA = '" + this.getSchemaName() + "'");
    }

    @Override
    public void incrementIdentityColumnToValue(String tableName, String identityColumnName, long identityValue) {
        this.getSQLHandler().executeUpdate("alter table " + this.qualified(tableName) + " alter column " + this.quoted(identityColumnName) + " restart with " + identityValue);
    }

    @Override
    public boolean supportsSequences() {
        return true;
    }

    @Override
    public boolean supportsTriggers() {
        return true;
    }

    @Override
    public boolean supportsIdentityColumns() {
        return true;
    }

    @Override
    public boolean supportsTypes() {
        return true;
    }
}

