/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.mysql;

import org.mariadb.jdbc.internal.common.DataType;

public class MySQLType
implements DataType {
    private final Type type;

    public MySQLType(Type type) {
        this.type = type;
    }

    @Override
    public int getSqlType() {
        return this.type.getSqlType();
    }

    @Override
    public String getTypeName() {
        return this.type.name();
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public static MySQLType fromServer(byte typeValue) {
        int type = typeValue & 0xFF;
        switch (type) {
            case 0: {
                return new MySQLType(Type.OLDDECIMAL);
            }
            case 1: {
                return new MySQLType(Type.TINYINT);
            }
            case 2: {
                return new MySQLType(Type.SMALLINT);
            }
            case 3: {
                return new MySQLType(Type.INTEGER);
            }
            case 4: {
                return new MySQLType(Type.FLOAT);
            }
            case 5: {
                return new MySQLType(Type.DOUBLE);
            }
            case 6: {
                return new MySQLType(Type.NULL);
            }
            case 7: {
                return new MySQLType(Type.TIMESTAMP);
            }
            case 8: {
                return new MySQLType(Type.BIGINT);
            }
            case 9: {
                return new MySQLType(Type.MEDIUMINT);
            }
            case 10: {
                return new MySQLType(Type.DATE);
            }
            case 11: {
                return new MySQLType(Type.TIME);
            }
            case 12: {
                return new MySQLType(Type.DATETIME);
            }
            case 13: {
                return new MySQLType(Type.YEAR);
            }
            case 14: {
                return new MySQLType(Type.DATE);
            }
            case 15: {
                return new MySQLType(Type.VARCHAR);
            }
            case 16: {
                return new MySQLType(Type.BIT);
            }
            case 246: {
                return new MySQLType(Type.DECIMAL);
            }
            case 247: {
                return new MySQLType(Type.VARCHAR);
            }
            case 248: {
                return new MySQLType(Type.VARCHAR);
            }
            case 249: {
                return new MySQLType(Type.TINYBLOB);
            }
            case 250: {
                return new MySQLType(Type.MEDIUMBLOB);
            }
            case 251: {
                return new MySQLType(Type.LONGBLOB);
            }
            case 252: {
                return new MySQLType(Type.BLOB);
            }
            case 253: {
                return new MySQLType(Type.VARCHAR);
            }
            case 254: {
                return new MySQLType(Type.CHAR);
            }
            case 255: {
                return new MySQLType(Type.BLOB);
            }
        }
        return new MySQLType(Type.VARCHAR);
    }

    public static byte toServer(int javaType) {
        switch (javaType) {
            case -6: {
                return 1;
            }
            case 5: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 6: {
                return 4;
            }
            case 8: {
                return 5;
            }
            case 0: {
                return 6;
            }
            case 93: {
                return 7;
            }
            case -5: {
                return 8;
            }
            case 91: {
                return 10;
            }
            case 92: {
                return 11;
            }
            case 12: {
                return 15;
            }
            case -7: {
                return 16;
            }
            case 16: {
                return 16;
            }
            case 3: {
                return -10;
            }
            case 1: {
                return -2;
            }
        }
        return -1;
    }

    public static enum Type {
        OLDDECIMAL(3),
        TINYINT(5),
        SMALLINT(5),
        INTEGER(4),
        FLOAT(6),
        DOUBLE(8),
        NULL(0),
        TIMESTAMP(93),
        BIGINT(-5),
        MEDIUMINT(4),
        DATETIME(93),
        DATE(91),
        TIME(92),
        YEAR(5),
        BIT(-7),
        VARCHAR(12),
        DECIMAL(3),
        TINYBLOB(-3),
        MEDIUMBLOB(-3),
        LONGBLOB(-4),
        BLOB(-4),
        CLOB(-1),
        CHAR(1);

        private final int sqlType;

        private Type(int sqlType) {
            this.sqlType = sqlType;
        }

        public int getSqlType() {
            return this.sqlType;
        }
    }
}

