/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.mariadb.jdbc.MySQLConnection;
import org.mariadb.jdbc.MySQLXid;
import org.mariadb.jdbc.internal.mysql.MySQLProtocol;

public class MySQLXAResource
implements XAResource {
    MySQLConnection connection;

    XAException mapXAException(SQLException sqle) {
        int XAErrorCode;
        switch (sqle.getErrorCode()) {
            case 1397: {
                XAErrorCode = -4;
                break;
            }
            case 1398: {
                XAErrorCode = -5;
                break;
            }
            case 1399: {
                XAErrorCode = -7;
                break;
            }
            case 1400: {
                XAErrorCode = -9;
                break;
            }
            case 1401: {
                XAErrorCode = -3;
                break;
            }
            case 1402: {
                XAErrorCode = 100;
                break;
            }
            default: {
                XAErrorCode = 0;
            }
        }
        if (XAErrorCode != 0) {
            return new XAException(XAErrorCode);
        }
        return new XAException(sqle.getMessage());
    }

    void execute(String command) throws XAException {
        try {
            this.connection.createStatement().execute(command);
        }
        catch (SQLException sqle) {
            throw this.mapXAException(sqle);
        }
    }

    public MySQLXAResource(MySQLConnection connection) {
        this.connection = connection;
    }

    static String xidToString(Xid xid) {
        StringBuffer sb = new StringBuffer(272);
        sb.append("0x").append(MySQLProtocol.hexdump(xid.getGlobalTransactionId(), 0)).append(",0x").append(MySQLProtocol.hexdump(xid.getBranchQualifier(), 0)).append(",").append(xid.getFormatId());
        return sb.toString();
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        String command = "XA COMMIT " + MySQLXAResource.xidToString(xid);
        if (onePhase) {
            command = String.valueOf(command) + " ONE PHASE";
        }
        this.execute(command);
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        if (flags != 0x4000000 && flags != 0x2000000 && flags != 0x20000000) {
            throw new XAException(-5);
        }
        this.execute("XA END " + MySQLXAResource.xidToString(xid) + " " + MySQLXAResource.flagsToString(flags));
    }

    @Override
    public void forget(Xid xid) throws XAException {
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    @Override
    public boolean isSameRM(XAResource xaResource) throws XAException {
        return false;
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        this.execute("XA PREPARE " + MySQLXAResource.xidToString(xid));
        return 0;
    }

    @Override
    public Xid[] recover(int flags) throws XAException {
        if ((flags & 0x1000000) == 0 && (flags & 0x800000) == 0 && flags != 0) {
            throw new XAException(-5);
        }
        if ((flags & 0x1000000) == 0) {
            return new MySQLXid[0];
        }
        try {
            ResultSet rs = this.connection.createStatement().executeQuery("XA RECOVER");
            ArrayList<MySQLXid> xidList = new ArrayList<MySQLXid>();
            while (rs.next()) {
                int formatId = rs.getInt(1);
                int len1 = rs.getInt(2);
                int len2 = rs.getInt(3);
                byte[] arr = rs.getBytes(4);
                byte[] globalTransactionId = new byte[len1];
                byte[] branchQualifier = new byte[len2];
                System.arraycopy(arr, 0, globalTransactionId, 0, len1);
                System.arraycopy(arr, len1, branchQualifier, 0, len2);
                xidList.add(new MySQLXid(formatId, globalTransactionId, branchQualifier));
            }
            Xid[] xids = new Xid[xidList.size()];
            xidList.toArray(xids);
            return xids;
        }
        catch (SQLException sqle) {
            throw this.mapXAException(sqle);
        }
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        this.execute("XA ROLLBACK " + MySQLXAResource.xidToString(xid));
    }

    @Override
    public boolean setTransactionTimeout(int timeout) throws XAException {
        return false;
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        if (flags != 0x200000 && flags != 0x8000000 && flags != 0) {
            throw new XAException(-5);
        }
        this.execute("XA START " + MySQLXAResource.xidToString(xid) + " " + MySQLXAResource.flagsToString(flags));
    }

    static String flagsToString(int flags) {
        switch (flags) {
            case 0x200000: {
                return "JOIN";
            }
            case 0x40000000: {
                return "ONE PHASE";
            }
            case 0x8000000: {
                return "RESUME";
            }
            case 0x2000000: {
                return "SUSPEND";
            }
        }
        return "";
    }
}

