/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.mariadb.jdbc.MySQLBlob;
import org.mariadb.jdbc.MySQLCallableStatement;
import org.mariadb.jdbc.MySQLClob;
import org.mariadb.jdbc.MySQLDatabaseMetaData;
import org.mariadb.jdbc.MySQLPooledConnection;
import org.mariadb.jdbc.MySQLPreparedStatement;
import org.mariadb.jdbc.MySQLSavepoint;
import org.mariadb.jdbc.MySQLStatement;
import org.mariadb.jdbc.ReplicationConnection;
import org.mariadb.jdbc.internal.SQLExceptionMapper;
import org.mariadb.jdbc.internal.common.BinlogDumpException;
import org.mariadb.jdbc.internal.common.DefaultParameterizedBatchHandlerFactory;
import org.mariadb.jdbc.internal.common.ParameterizedBatchHandlerFactory;
import org.mariadb.jdbc.internal.common.QueryException;
import org.mariadb.jdbc.internal.common.Utils;
import org.mariadb.jdbc.internal.common.packet.RawPacket;
import org.mariadb.jdbc.internal.mysql.MySQLProtocol;

public final class MySQLConnection
implements Connection,
ReplicationConnection {
    private final MySQLProtocol protocol;
    private int savepointCount = 0;
    private final Properties clientInfoProperties;
    private ParameterizedBatchHandlerFactory parameterizedBatchHandlerFactory;
    public MySQLPooledConnection pooledConnection;
    private boolean warningsCleared;
    boolean noBackslashEscapes;
    boolean nullCatalogMeansCurrent = true;

    private MySQLConnection(MySQLProtocol protocol) {
        this.protocol = protocol;
        this.clientInfoProperties = new Properties();
    }

    MySQLProtocol getProtocol() {
        return this.protocol;
    }

    public static MySQLConnection newConnection(MySQLProtocol protocol) throws SQLException {
        MySQLConnection connection = new MySQLConnection(protocol);
        boolean fastConnect = protocol.getInfo().get("fastConnect") != null;
        String sessionVariables = protocol.getInfo().getProperty("sessionVariables");
        if (fastConnect && sessionVariables == null) {
            return connection;
        }
        Statement st = null;
        try {
            String nullCatalogMeansCurrentString;
            st = connection.createStatement();
            if (sessionVariables != null) {
                st.executeUpdate("set session " + sessionVariables);
            }
            if (!fastConnect) {
                ResultSet rs = st.executeQuery("select @@sql_mode");
                rs.next();
                String sqlMode = rs.getString(1);
                if (sqlMode.contains("NO_BACKSLASH_ESCAPES")) {
                    connection.noBackslashEscapes = true;
                }
            }
            if ((nullCatalogMeansCurrentString = protocol.getInfo().getProperty("nullCatalogMeansCurrent")) != null && nullCatalogMeansCurrentString.equals("false")) {
                connection.nullCatalogMeansCurrent = false;
            }
        }
        finally {
            if (st != null) {
                st.close();
            }
        }
        return connection;
    }

    @Override
    public Statement createStatement() throws SQLException {
        return new MySQLStatement(this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        if (this.parameterizedBatchHandlerFactory == null) {
            this.parameterizedBatchHandlerFactory = new DefaultParameterizedBatchHandlerFactory();
        }
        return new MySQLPreparedStatement(this.protocol, this, sql, this.parameterizedBatchHandlerFactory.get(sql, this.protocol));
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return new MySQLCallableStatement(this, sql);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return Utils.nativeSQL(sql, this.noBackslashEscapes);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        Statement stmt = this.createStatement();
        try {
            stmt.executeUpdate("set autocommit=" + (autoCommit ? "1" : "0"));
        }
        finally {
            stmt.close();
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("select @@autocommit");
        rs.next();
        boolean autocommit = rs.getBoolean(1);
        rs.close();
        stmt.close();
        return autocommit;
    }

    @Override
    public void commit() throws SQLException {
        Statement st = this.createStatement();
        try {
            st.execute("COMMIT");
        }
        finally {
            st.close();
        }
    }

    @Override
    public void rollback() throws SQLException {
        Statement st = this.createStatement();
        try {
            st.execute("ROLLBACK");
        }
        finally {
            st.close();
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.pooledConnection != null) {
            if (this.protocol != null && this.protocol.inTransaction()) {
                this.rollback();
            }
            this.pooledConnection.fireConnectionClosed();
            return;
        }
        this.protocol.close();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.protocol.isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new MySQLDatabaseMetaData(this, this.protocol.getUsername(), "jdbc:mysql://" + this.protocol.getHost() + ":" + this.protocol.getPort() + "/" + this.protocol.getDatabase());
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.protocol.setReadonly(readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    public static String quoteIdentifier(String s) {
        return "`" + s.replaceAll("`", "``") + "`";
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        if (catalog == null) {
            throw new SQLException("The catalog name may not be null", "XAE05");
        }
        Statement st = this.createStatement();
        try {
            st.execute("USE " + MySQLConnection.quoteIdentifier(catalog));
            st.close();
        }
        finally {
            st.close();
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        String catalog = null;
        Statement st = null;
        try {
            st = this.createStatement();
            ResultSet rs = st.executeQuery("select database()");
            rs.next();
            catalog = rs.getString(1);
        }
        finally {
            if (st != null) {
                st.close();
            }
        }
        return catalog;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        String query = "SET SESSION TRANSACTION ISOLATION LEVEL";
        switch (level) {
            case 1: {
                query = String.valueOf(query) + " READ UNCOMMITTED";
                break;
            }
            case 2: {
                query = String.valueOf(query) + " READ COMMITTED";
                break;
            }
            case 4: {
                query = String.valueOf(query) + " REPEATABLE READ";
                break;
            }
            case 8: {
                query = String.valueOf(query) + " SERIALIZABLE";
                break;
            }
            default: {
                throw SQLExceptionMapper.getSQLException("Unsupported transaction isolation level");
            }
        }
        Statement st = this.createStatement();
        try {
            st.execute(query);
        }
        finally {
            st.close();
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        Statement stmt = this.createStatement();
        try {
            ResultSet rs = stmt.executeQuery("SELECT @@tx_isolation");
            rs.next();
            String response = rs.getString(1);
            if (response.equals("REPEATABLE-READ")) {
                return 4;
            }
            if (response.equals("READ-UNCOMMITTED")) {
                return 1;
            }
            if (response.equals("READ-COMMITTED")) {
                return 2;
            }
            if (response.equals("SERIALIZABLE")) {
                return 8;
            }
        }
        finally {
            stmt.close();
        }
        throw SQLExceptionMapper.getSQLException("Could not get transaction isolation level");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.warningsCleared || this.isClosed() || !this.protocol.hasWarnings) {
            return null;
        }
        Statement st = null;
        ResultSet rs = null;
        SQLWarning last = null;
        SQLWarning first = null;
        try {
            st = this.createStatement();
            rs = st.executeQuery("show warnings");
            while (rs.next()) {
                int code = rs.getInt(2);
                String message = rs.getString(3);
                SQLWarning w = new SQLWarning(message, SQLExceptionMapper.mapMySQLCodeToSQLState(code), code);
                if (first == null) {
                    first = w;
                    last = w;
                    continue;
                }
                last.setNextWarning(w);
                last = w;
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (st != null) {
                st.close();
            }
        }
        return first;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warningsCleared = true;
    }

    public void reenableWarnings() {
        this.warningsCleared = false;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new MySQLCallableStatement(this, sql);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return null;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Not yet supported");
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        if (holdability != 1) {
            throw SQLExceptionMapper.getFeatureNotSupportedException("Only holding cursors over commit is supported");
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        return 1;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.setSavepoint("unnamed");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        MySQLSavepoint savepoint = new MySQLSavepoint(name, this.savepointCount++);
        Statement st = this.createStatement();
        st.execute("SAVEPOINT " + ((Object)savepoint).toString());
        return savepoint;
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        Statement st = this.createStatement();
        st.execute("ROLLBACK TO SAVEPOINT " + savepoint.toString());
        st.close();
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        Statement st = this.createStatement();
        st.execute("RELEASE SAVEPOINT " + savepoint.toString());
        st.close();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (resultSetConcurrency != 1007) {
            throw SQLExceptionMapper.getFeatureNotSupportedException("Only read-only result sets allowed");
        }
        if (resultSetHoldability != 1) {
            throw SQLExceptionMapper.getFeatureNotSupportedException("Cursors are always kept when sending commit (they are only client-side)");
        }
        return this.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (resultSetConcurrency != 1007) {
            throw SQLExceptionMapper.getFeatureNotSupportedException("Only read-only result sets allowed");
        }
        if (resultSetHoldability != 1) {
            throw SQLExceptionMapper.getFeatureNotSupportedException("Cursors are always kept when sending commit (they are only client-side)");
        }
        return this.prepareStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.prepareCall(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public Clob createClob() throws SQLException {
        return new MySQLClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        return new MySQLBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return new MySQLClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Not supported");
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        try {
            return this.protocol.ping();
        }
        catch (QueryException e) {
            SQLExceptionMapper.throwException(e, this, null);
            return false;
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.clientInfoProperties.setProperty(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        for (String key : properties.stringPropertyNames()) {
            this.clientInfoProperties.setProperty(key, properties.getProperty(key));
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.clientInfoProperties.getProperty(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.clientInfoProperties;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Not yet supported");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Not yet supported");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return iface.cast(this);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    public String getUsername() {
        return this.protocol.getUsername();
    }

    public String getPassword() {
        return this.protocol.getPassword();
    }

    public String getHostname() {
        return this.protocol.getHost();
    }

    public int getPort() {
        return this.protocol.getPort();
    }

    public String getDatabase() {
        return this.protocol.getDatabase();
    }

    @Override
    public List<RawPacket> startBinlogDump(int position, String logfile) throws SQLException {
        try {
            return this.protocol.startBinlogDump(position, logfile);
        }
        catch (BinlogDumpException e) {
            throw SQLExceptionMapper.getSQLException("Could not dump binlog", e);
        }
    }

    public void setBatchQueryHandlerFactory(ParameterizedBatchHandlerFactory batchHandlerFactory) {
        this.parameterizedBatchHandlerFactory = batchHandlerFactory;
    }

    public void setHostFailed() {
        this.protocol.setHostFailed();
    }

    @Override
    public void abort(Executor arg0) throws SQLException {
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return 0;
    }

    @Override
    public String getSchema() throws SQLException {
        return null;
    }

    @Override
    public void setNetworkTimeout(Executor arg0, int arg1) throws SQLException {
    }

    @Override
    public void setSchema(String arg0) throws SQLException {
    }
}

