/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.report;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.surefire.report.AbstractReporter;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterException;

public abstract class AbstractTextReporter
extends AbstractReporter {
    static final String BRIEF = "brief";
    static final String PLAIN = "plain";
    static final String SUMMARY = "summary";
    protected PrintWriter writer;
    private static final String TEST_SET_COMPLETED_PREFIX = "Tests run: ";
    private final String format;
    private List<String> testResults;

    protected AbstractTextReporter(boolean trimStackTrace, String format) {
        super(trimStackTrace);
        this.format = format;
    }

    protected AbstractTextReporter(PrintWriter writer, boolean trimStackTrace, String format) {
        this(trimStackTrace, format);
        this.writer = writer;
    }

    public void setWriter(PrintWriter writer) {
        this.writer = writer;
    }

    public void writeMessage(String message) {
        if (this.writer != null) {
            this.writer.print(message);
            this.writer.flush();
        }
    }

    public void testSucceeded(ReportEntry report) {
        super.testSucceeded(report);
        if (PLAIN.equals(this.format)) {
            this.testResults.add(this.getElapsedTimeSummary(report));
        }
    }

    public void testSkipped(ReportEntry report) {
        super.testSkipped(report);
        if (PLAIN.equals(this.format)) {
            this.testResults.add(report.getName() + " skipped");
        }
    }

    public void testError(ReportEntry report, String stdOut, String stdErr) {
        super.testError(report, stdOut, stdErr);
        this.testResults.add(this.getOutput(report, "ERROR"));
    }

    public void testFailed(ReportEntry report, String stdOut, String stdErr) {
        super.testFailed(report, stdOut, stdErr);
        this.testResults.add(this.getOutput(report, "FAILURE"));
    }

    public void testSetStarting(ReportEntry report) throws ReporterException {
        super.testSetStarting(report);
        this.testResults = new ArrayList<String>();
    }

    public void testSetCompleted(ReportEntry report) throws ReporterException {
        super.testSetCompleted(report);
        this.writeMessage(this.getTestSetSummary(report));
        if (this.format.equals(BRIEF) || this.format.equals(PLAIN)) {
            for (String testResult : this.testResults) {
                this.writeMessage(testResult);
            }
        }
    }

    protected String getTestSetSummary(ReportEntry report) {
        StringBuilder buf = new StringBuilder();
        buf.append(TEST_SET_COMPLETED_PREFIX);
        buf.append(this.completedCount);
        buf.append(", Failures: ");
        buf.append(this.failures);
        buf.append(", Errors: ");
        buf.append(this.errors);
        buf.append(", Skipped: ");
        buf.append(this.skipped);
        buf.append(", Time elapsed: ");
        int elapsed = report.getElapsed() != null ? report.getElapsed() : (int)(System.currentTimeMillis() - this.testSetStartTime);
        buf.append(this.elapsedTimeAsString(elapsed));
        buf.append(" sec");
        if (this.failures > 0 || this.errors > 0) {
            buf.append(" <<< FAILURE!");
        }
        buf.append("\n");
        return buf.toString();
    }

    protected String getElapsedTimeSummary(ReportEntry report) {
        StringBuilder reportContent = new StringBuilder();
        long runTime = this.getActualRunTime(report);
        reportContent.append(report.getName());
        reportContent.append("  Time elapsed: ");
        reportContent.append(this.elapsedTimeAsString(runTime));
        reportContent.append(" sec");
        return reportContent.toString();
    }

    protected String getOutput(ReportEntry report, String msg) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getElapsedTimeSummary(report));
        buf.append("  <<< ").append(msg).append("!").append(NL);
        buf.append(this.getStackTrace(report));
        return buf.toString();
    }

    public void reset() {
        super.reset();
        if (this.writer != null) {
            this.writer.flush();
        }
    }
}

