/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.ssl;

import com.vertica.core.Logger;
import com.vertica.core.PGStream;
import com.vertica.util.GT;
import com.vertica.util.PSQLException;
import com.vertica.util.PSQLState;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.Socket;
import java.util.Properties;
import javax.net.ssl.SSLSocketFactory;

public class MakeSSL {
    public static void convert(PGStream pGStream, Properties properties, Logger logger) throws IOException, PSQLException {
        Object[] objectArray;
        SSLSocketFactory sSLSocketFactory;
        logger.debug("converting regular socket connection to ssl");
        String string = properties.getProperty("sslfactory");
        if (string == null) {
            sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        } else {
            objectArray = new Object[]{properties.getProperty("sslfactoryarg")};
            try {
                Constructor<?> constructor;
                Class<?> clazz = Class.forName(string);
                try {
                    constructor = clazz.getConstructor(String.class);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    constructor = clazz.getConstructor(null);
                    objectArray = null;
                }
                sSLSocketFactory = (SSLSocketFactory)constructor.newInstance(objectArray);
            }
            catch (Exception exception) {
                throw new PSQLException(GT.tr("The SSLSocketFactory class provided {0} could not be instantiated.", string), PSQLState.CONNECTION_FAILURE, (Throwable)exception);
            }
        }
        objectArray = sSLSocketFactory.createSocket(pGStream.getSocket(), pGStream.getHost(), pGStream.getPort(), true);
        pGStream.changeSocket((Socket)objectArray);
    }
}

