/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc3;

import com.vertica.core.BaseConnection;
import com.vertica.jdbc2.TypeInfoCache;
import com.vertica.util.GT;
import com.vertica.util.PSQLException;
import com.vertica.util.PSQLState;
import java.sql.ParameterMetaData;
import java.sql.SQLException;

public class PSQLParameterMetaData
implements ParameterMetaData {
    private final BaseConnection _connection;
    private final int[] _oids;

    public PSQLParameterMetaData(BaseConnection baseConnection, int[] nArray) {
        this._connection = baseConnection;
        this._oids = nArray;
    }

    public String getParameterClassName(int n) throws SQLException {
        this.checkParamIndex(n);
        return this._connection.getJavaClass(this._oids[n - 1]);
    }

    public int getParameterCount() {
        return this._oids.length;
    }

    public int getParameterMode(int n) throws SQLException {
        this.checkParamIndex(n);
        return 1;
    }

    public int getParameterType(int n) throws SQLException {
        this.checkParamIndex(n);
        return this._connection.getSQLType(this._oids[n - 1]);
    }

    public String getParameterTypeName(int n) throws SQLException {
        this.checkParamIndex(n);
        return this._connection.getPGType(this._oids[n - 1]);
    }

    public int getPrecision(int n) throws SQLException {
        this.checkParamIndex(n);
        return 0;
    }

    public int getScale(int n) throws SQLException {
        this.checkParamIndex(n);
        return 0;
    }

    public int isNullable(int n) throws SQLException {
        this.checkParamIndex(n);
        return 2;
    }

    public boolean isSigned(int n) throws SQLException {
        this.checkParamIndex(n);
        return TypeInfoCache.isSigned(this._oids[n - 1]);
    }

    private void checkParamIndex(int n) throws PSQLException {
        if (n < 1 || n > this._oids.length) {
            throw new PSQLException(GT.tr("The parameter index is out of range: {0}, number of parameters: {1}.", new Object[]{new Integer(n), new Integer(this._oids.length)}), PSQLState.INVALID_PARAMETER_VALUE);
        }
    }
}

