/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc2;

import com.vertica.core.BaseConnection;
import com.vertica.util.GT;
import com.vertica.util.PGobject;
import com.vertica.util.PSQLException;
import com.vertica.util.PSQLState;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TypeInfoCache {
    private static final Map _pgNameToSQLType;
    private Map _pgNameToJavaClass;
    private Map _oidToPgName;
    private Map _pgNameToOid;
    private Map _pgNameToPgObject;
    private BaseConnection _conn;
    private PreparedStatement _getOidStatement;
    private PreparedStatement _getNameStatement;
    private static int NAMEDATALEN;
    public static final Object[][] types;

    public TypeInfoCache(BaseConnection baseConnection) {
        this._conn = baseConnection;
        this._oidToPgName = new HashMap();
        this._pgNameToOid = new HashMap();
        this._pgNameToJavaClass = new HashMap();
        this._pgNameToPgObject = new HashMap();
        for (int i = 0; i < types.length; ++i) {
            this._pgNameToJavaClass.put(types[i][0], types[i][3]);
            this._pgNameToOid.put(types[i][0], types[i][1]);
            this._oidToPgName.put(types[i][1], types[i][0]);
            String string = "_" + types[i][0];
            this._pgNameToJavaClass.put(string, "java.sql.Array");
        }
    }

    public synchronized void addDataType(String string, Class clazz) throws SQLException {
        if (!PGobject.class.isAssignableFrom(clazz)) {
            throw new PSQLException(GT.tr("The class {0} does not implement com.vertica.util.PGobject.", clazz.toString()), PSQLState.INVALID_PARAMETER_TYPE);
        }
        this._pgNameToPgObject.put(string, clazz);
        this._pgNameToJavaClass.put(string, clazz.getName());
    }

    public static Iterator getPGTypeNamesWithSQLTypes() {
        return _pgNameToSQLType.keySet().iterator();
    }

    public int getSQLType(int n) throws SQLException {
        return TypeInfoCache.getSQLType(this.getPGType(n));
    }

    public static int getSQLType(String string) {
        Integer n = (Integer)_pgNameToSQLType.get(string);
        if (n != null) {
            return n;
        }
        return 1111;
    }

    public synchronized int getPGType(String string) throws SQLException {
        Integer n = (Integer)this._pgNameToOid.get(string);
        if (n != null) {
            return n;
        }
        throw new PSQLException(GT.tr("No results were returned by the query."), PSQLState.NO_DATA);
    }

    public synchronized String getPGType(int n) throws SQLException {
        if (n == 0) {
            return null;
        }
        String string = (String)this._oidToPgName.get(new Integer(n));
        if (string != null) {
            return string;
        }
        throw new PSQLException(GT.tr("No results were returned by the query."), PSQLState.NO_DATA);
    }

    public synchronized Class getPGobject(String string) {
        return (Class)this._pgNameToPgObject.get(string);
    }

    public synchronized String getJavaClass(int n) throws SQLException {
        String string = this.getPGType(n);
        return (String)this._pgNameToJavaClass.get(string);
    }

    public static int getPrecision(int n, int n2) {
        switch (n) {
            case 6: {
                return 19;
            }
            case 7: {
                return 17;
            }
            case 16: {
                if (n2 == -1) {
                    return -1;
                }
                return n2 - 4 >> 16 & 0xFFFF;
            }
            case 8: 
            case 9: 
            case 17: 
            case 117: {
                if (n2 == -1) {
                    return -1;
                }
                return n2;
            }
            case 1560: {
                return n2;
            }
        }
        return 0;
    }

    public static int getScale(int n, int n2) {
        switch (n) {
            case 7: {
                return 17;
            }
            case 16: {
                if (n2 == -1) {
                    return -1;
                }
                return n2 - 4 & 0x1FFF;
            }
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                if (n2 == -1) {
                    return 6;
                }
                return n2;
            }
            case 14: {
                if (n2 == -1) {
                    return 6;
                }
                return n2 & 0xFFFF;
            }
        }
        return 0;
    }

    public static boolean isCaseSensitive(int n) {
        switch (n) {
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                return false;
            }
        }
        return true;
    }

    public static boolean isSigned(int n) {
        switch (n) {
            case 6: 
            case 7: 
            case 16: {
                return true;
            }
        }
        return false;
    }

    public static int getDisplaySize(int n, int n2) {
        switch (n) {
            case 6: 
            case 26: {
                return 20;
            }
            case 7: {
                return 24;
            }
            case 18: {
                return 1;
            }
            case 5: {
                return 1;
            }
            case 10: {
                return 28;
            }
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                int n3;
                switch (n2) {
                    case -1: {
                        n3 = 7;
                        break;
                    }
                    case 0: {
                        n3 = 0;
                        break;
                    }
                    case 1: {
                        n3 = 3;
                        break;
                    }
                    default: {
                        n3 = n2 + 1;
                    }
                }
                switch (n) {
                    case 11: {
                        return 8 + n3;
                    }
                    case 15: {
                        return 8 + n3 + 6;
                    }
                    case 12: {
                        return 22 + n3;
                    }
                    case 13: {
                        return 22 + n3 + 6;
                    }
                }
            }
            case 14: {
                return 49;
            }
            case 4: 
            case 9: 
            case 17: 
            case 117: {
                if (n2 == -1) {
                    return NAMEDATALEN - 1;
                }
                return n2 - 4;
            }
            case 8: {
                if (n2 == -1) {
                    return NAMEDATALEN - 1;
                }
                if (n2 == -3) {
                    return 1;
                }
                return n2 - 4;
            }
            case 16: {
                if (n2 == -1) {
                    return 131089;
                }
                int n4 = n2 - 4 >> 16 & 0xFFFF;
                int n5 = n2 - 4 & 0x1FFF;
                return 1 + n4 + (n5 != 0 ? 1 : 0);
            }
            case 1560: {
                return n2;
            }
            case 1562: {
                return Integer.MAX_VALUE;
            }
        }
        return Integer.MAX_VALUE;
    }

    public static int getMaximumPrecision(int n) {
        switch (n) {
            case 16: {
                return 1000;
            }
            case 11: 
            case 15: {
                return 6;
            }
            case 12: 
            case 13: 
            case 14: {
                return 6;
            }
            case 8: 
            case 9: 
            case 17: 
            case 117: {
                return 65000;
            }
            case 1560: {
                return 0x5000000;
            }
        }
        return 0;
    }

    public static int getVerticaTypeOid(int n) {
        switch (n) {
            case 0: {
                return 4;
            }
            case 21: 
            case 23: 
            case 26: {
                return 6;
            }
            case 700: {
                return 7;
            }
            case 790: {
                return 16;
            }
        }
        return n;
    }

    static {
        NAMEDATALEN = 64;
        types = new Object[][]{{"bool", new Integer(5), new Integer(-7), "java.lang.Boolean"}, {"int8", new Integer(6), new Integer(-5), "java.lang.Long"}, {"float8", new Integer(7), new Integer(8), "java.lang.Double"}, {"char", new Integer(8), new Integer(1), "java.lang.String"}, {"varchar", new Integer(9), new Integer(12), "java.lang.String"}, {"date", new Integer(10), new Integer(91), "java.sql.Date"}, {"time", new Integer(11), new Integer(92), "java.sql.Time"}, {"timestamp", new Integer(12), new Integer(93), "java.sql.Timestamp"}, {"timestamptz", new Integer(13), new Integer(93), "java.sql.Timestamp"}, {"interval", new Integer(14), new Integer(12), "java.sql.String"}, {"interval", new Integer(114), new Integer(12), "java.sql.String"}, {"timetz", new Integer(15), new Integer(92), "java.sql.Time"}, {"int2", new Integer(21), new Integer(5), "java.lang.Integer"}, {"int4", new Integer(23), new Integer(4), "java.lang.Integer"}, {"numeric", new Integer(16), new Integer(2), "java.math.BigDecimal"}, {"binary", new Integer(117), new Integer(-2), "byte[]"}, {"varbinary", new Integer(17), new Integer(-3), "byte[]"}, {"oid", new Integer(26), new Integer(-5), "java.lang.Long"}, {"unknown", new Integer(4), new Integer(12), "java.lang.String"}};
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        for (int i = 0; i < types.length; ++i) {
            hashMap.put(types[i][0], types[i][2]);
            String string = "_" + types[i][0];
            hashMap.put(string, new Integer(2003));
        }
        _pgNameToSQLType = Collections.unmodifiableMap(hashMap);
    }
}

